/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.util.Log;

class MessageHandler
implements I2PSessionMuxedListener {
    private final ConnectionManager _manager;
    private final I2PAppContext _context;
    private final Log _log;
    private final Set<I2PSocketManager.DisconnectListener> _listeners;
    private final AtomicBoolean _restartPending = new AtomicBoolean();

    public MessageHandler(I2PAppContext ctx, ConnectionManager mgr) {
        this._manager = mgr;
        this._context = ctx;
        this._listeners = new CopyOnWriteArraySet<I2PSocketManager.DisconnectListener>();
        this._log = ctx.logManager().getLog(MessageHandler.class);
        this._context.statManager().createRateStat("stream.packetReceiveFailure", "Number of times we fail to decrypt or otherwise receive a packet sent to us", "Stream", new long[]{60000L, 3600000L, 86400000L});
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
        this.messageAvailable(session, msgId, size, 0, 0, 0);
    }

    public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromPort, int toPort) {
        block10: {
            byte[] data;
            try {
                data = session.receiveMessage(msgId);
            }
            catch (I2PSessionException ise) {
                this._context.statManager().addRateData("stream.packetReceiveFailure", 1L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Error receiving the message", (Throwable)ise);
                }
                return;
            }
            if (data == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received null data on " + session + "\n* Protocol: " + proto + " fromPort: " + fromPort + " toPort: " + toPort);
                }
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Received " + data.length + " bytes on " + session + "\n* " + this._manager + "\n* Protocol: " + proto + " fromPort: " + fromPort + " toPort: " + toPort);
            }
            Packet packet = new Packet(session);
            try {
                packet.readPacket(data, 0, data.length);
                packet.setRemotePort(fromPort);
                packet.setLocalPort(toPort);
                this._manager.getPacketHandler().receivePacket(packet);
            }
            catch (IndexOutOfBoundsException ioobe) {
                this._context.statManager().addRateData("stream.packetReceiveFailure", 1L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Received an invalid packet", (Throwable)ioobe);
                }
            }
            catch (IllegalArgumentException iae) {
                this._context.statManager().addRateData("stream.packetReceiveFailure", 1L);
                if (!this._log.shouldWarn()) break block10;
                this._log.warn("Received an invalid packet", (Throwable)iae);
            }
        }
    }

    public void reportAbuse(I2PSession session, int severity) {
        if (this._log.shouldError()) {
            this._log.error("Abuse reported with severity " + severity);
        }
        this._manager.disconnectAllHard();
    }

    public void disconnected(I2PSession session) {
        if (this._log.shouldWarn()) {
            this._log.warn("I2PSession disconnected");
        }
        this._manager.disconnectAllHard();
        if (this._restartPending.compareAndSet(true, false)) {
            this._manager.getConnectionHandler().setRestartPending();
        } else {
            this._manager.getConnectionHandler().setActive(false);
        }
        for (I2PSocketManager.DisconnectListener lsnr : this._listeners) {
            lsnr.sessionDisconnected();
        }
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        this._restartPending.set(message.contains("restart"));
        if (this._log.shouldWarn()) {
            this._log.warn("Error occurred: " + message, error);
        }
    }

    public void addDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._listeners.add(lsnr);
    }

    public void removeDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._listeners.remove(lsnr);
    }
}

