/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;

public class DatabaseSearchReplyMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 3;
    private Hash _key;
    private final List<Hash> _peerHashes = new ArrayList<Hash>(3);
    private Hash _from;

    public DatabaseSearchReplyMessage(I2PAppContext context) {
        super(context);
    }

    public Hash getSearchKey() {
        return this._key;
    }

    public void setSearchKey(Hash key) {
        if (this._key != null) {
            throw new IllegalStateException();
        }
        this._key = key;
    }

    public int getNumReplies() {
        return this._peerHashes.size();
    }

    public Hash getReply(int index) {
        return this._peerHashes.get(index);
    }

    public void addReply(Hash peer) {
        this._peerHashes.add(peer);
    }

    public Hash getFromHash() {
        return this._from;
    }

    public void setFromHash(Hash from) {
        this._from = from;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 3) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._key = Hash.create(data, curIndex);
        int num = data[curIndex += 32] & 0xFF;
        ++curIndex;
        this._peerHashes.clear();
        for (int i = 0; i < num; ++i) {
            Hash p = Hash.create(data, curIndex);
            curIndex += 32;
            this.addReply(p);
        }
        this._from = Hash.create(data, curIndex);
        curIndex += 32;
    }

    @Override
    protected int calculateWrittenLength() {
        return 33 + this.getNumReplies() * 32 + 32;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._key == null) {
            throw new I2NPMessageException("Key in reply to not specified");
        }
        if (this._from == null) {
            throw new I2NPMessageException("No 'from' address specified!");
        }
        System.arraycopy(this._key.getData(), 0, out, curIndex, 32);
        curIndex += 32;
        out[curIndex++] = (byte)this._peerHashes.size();
        for (int i = 0; i < this.getNumReplies(); ++i) {
            System.arraycopy(this.getReply(i).getData(), 0, out, curIndex, 32);
            curIndex += 32;
        }
        System.arraycopy(this._from.getData(), 0, out, curIndex, 32);
        return curIndex += 32;
    }

    @Override
    public int getType() {
        return 3;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseSearchReplyMessage) {
            DatabaseSearchReplyMessage msg = (DatabaseSearchReplyMessage)object;
            return DataHelper.eq(this._key, msg._key) && DataHelper.eq(this._from, msg._from) && DataHelper.eq(this._peerHashes, msg._peerHashes);
        }
        return false;
    }

    public int hashCode() {
        return DataHelper.hashCode(this._key) + DataHelper.hashCode(this._from) + DataHelper.hashCode(this._peerHashes);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("from [").append(this._from.toBase64().substring(0, 6)).append("]");
        buf.append(" for key [").append(this._key.toBase64().substring(0, 6)).append("]");
        if (this.getNumReplies() > 0) {
            buf.append("\n* Replies (").append(this.getNumReplies()).append("):");
            for (int i = 0; i < this.getNumReplies(); ++i) {
                buf.append(" [").append(this.getReply(i).toBase64().substring(0, 6)).append("]");
            }
        }
        return buf.toString();
    }
}

