/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.OutboundCache;
import net.i2p.router.message.OutboundClientMessageOneShotJob;
import net.i2p.util.Log;

public class ClientMessagePool {
    private final Log _log;
    private final RouterContext _context;
    private final OutboundCache _cache;

    public ClientMessagePool(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientMessagePool.class);
        this._cache = new OutboundCache(this._context);
        OutboundClientMessageOneShotJob.init(this._context);
    }

    public OutboundCache getCache() {
        return this._cache;
    }

    public void shutdown() {
        this._cache.clearAllCaches();
    }

    public void restart() {
        this.shutdown();
    }

    public void add(ClientMessage msg) {
        this.add(msg, false);
    }

    public void add(ClientMessage msg, boolean isDefinitelyRemote) {
        if (!isDefinitelyRemote && (this._context.clientManager().isLocal(msg.getDestination()) || this._context.clientManager().isLocal(msg.getDestinationHash()))) {
            if (this._log.shouldDebug()) {
                this._log.debug("Adding message for local delivery");
            }
            this._context.clientManager().messageReceived(msg);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Adding message for remote delivery");
            }
            OutboundClientMessageOneShotJob j = new OutboundClientMessageOneShotJob(this._context, this._cache, msg);
            j.runJob();
        }
    }
}

