/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.RouterContext;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Log;

public class MessageValidator {
    private final Log _log;
    private final RouterContext _context;
    private DecayingBloomFilter _filter;
    private static final long TIME_MASK = -1024L;

    public MessageValidator(RouterContext context) {
        this._log = context.logManager().getLog(MessageValidator.class);
        this._context = context;
        long[] rates = new long[]{60000L, 3600000L, 86400000L};
        context.statManager().createRateStat("router.duplicateMessageId", "Duplicate messageId received", "Router", rates);
        context.statManager().createRateStat("router.invalidMessageTime", "Message outside valid range received", "Router", rates);
    }

    public String validateMessage(long messageId, long expiration) {
        String msg = this.validateMessage(expiration);
        if (msg != null) {
            return msg;
        }
        boolean isDuplicate = this.noteReception(messageId, expiration);
        if (isDuplicate) {
            if (this._log.shouldInfo()) {
                this._log.info("Rejecting message " + messageId + " duplicate", new Exception("Duplicate origin"));
            }
            this._context.statManager().addRateData("router.duplicateMessageId", 1L);
            return "Duplicate message";
        }
        return null;
    }

    public String validateMessage(long expiration) {
        long now = this._context.clock().now();
        if (now - 90000L >= expiration) {
            if (this._log.shouldInfo()) {
                this._log.info("Rejecting message expired " + (now - expiration) + "ms ago");
            }
            this._context.statManager().addRateData("router.invalidMessageTime", now - expiration);
            return "Expired " + (now - expiration) + "ms ago";
        }
        if (now + 240000L < expiration) {
            if (this._log.shouldInfo()) {
                this._log.info("Rejecting message expiring too far in the future (" + (expiration - now) + "ms)");
            }
            this._context.statManager().addRateData("router.invalidMessageTime", now - expiration);
            return "Expires too far in the future (" + (expiration - now) + "ms)";
        }
        return null;
    }

    private boolean noteReception(long messageId, long messageExpiration) {
        long val = messageId;
        double fp = this._filter.getFalsePositiveRate();
        boolean dup = this._filter.add(val ^= messageExpiration & 0xFFFFFFFFFFFFFC00L);
        if (dup && this._log.shouldWarn()) {
            this._log.warn("Duplicate message [MsgID " + messageId + "] with " + this._filter.getCurrentDuplicateCount() + " other duplicates, " + this._filter.getInsertedCount() + " other entries" + (fp > 0.0 ? ", and a FALSE POSITIVE rate of " + fp : ""));
        }
        return dup;
    }

    public synchronized void startup() {
        this._filter = new DecayingHashSet(this._context, 120000, 8, "RouterMV");
    }

    synchronized void shutdown() {
        this._filter.stopDecaying();
    }
}

