/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.crypto.EncType;
import net.i2p.data.PublicKey;

class NextSessionKey
extends PublicKey {
    private final int _id;
    private final boolean _isReverse;
    private final boolean _isRequest;

    public NextSessionKey(byte[] data, int id, boolean isReverse, boolean isRequest) {
        super(EncType.ECIES_X25519, data);
        this._id = id;
        this._isReverse = isReverse;
        this._isRequest = isRequest;
    }

    public NextSessionKey(int id, boolean isReverse, boolean isRequest) {
        this._id = id;
        this._isReverse = isReverse;
        this._isRequest = isRequest;
    }

    public int getID() {
        return this._id;
    }

    public boolean isReverse() {
        return this._isReverse;
    }

    public boolean isRequest() {
        return this._isRequest;
    }

    @Override
    public int hashCode() {
        int rv = super.hashCode() ^ this._id;
        if (this._isReverse) {
            rv ^= Integer.MIN_VALUE;
        }
        if (this._isRequest) {
            rv ^= 0x40000000;
        }
        return rv;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NextSessionKey)) {
            return false;
        }
        NextSessionKey o = (NextSessionKey)obj;
        return this._id == o._id && this._isReverse == o._isReverse && this._isRequest == o._isRequest && super.equals(o);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("\n* NextSessionKey: ");
        buf.append(super.toString());
        buf.append(" ID: ").append(this._id);
        buf.append(" Reverse? ").append(this._isReverse);
        buf.append(" Request? ").append(this._isRequest);
        return buf.toString();
    }
}

