/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.data.DataHelper;

public class RatchetSessionTag {
    public static final int LENGTH = 8;
    private final long _data;

    public RatchetSessionTag(long val) {
        this._data = val;
    }

    public RatchetSessionTag(byte[] val) {
        if (val.length < 8) {
            throw new IllegalArgumentException();
        }
        this._data = DataHelper.fromLong8(val, 0);
    }

    public byte[] getData() {
        byte[] rv = new byte[8];
        DataHelper.toLong8(rv, 0, this._data);
        return rv;
    }

    public long getLong() {
        return this._data;
    }

    public int length() {
        return 8;
    }

    public String toBase64() {
        StringBuilder buf = new StringBuilder(12);
        for (int i = 58; i > 0; i -= 6) {
            buf.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~".charAt((int)(this._data >> i) & 0x3F));
        }
        buf.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~".charAt((int)(this._data << 2) & 0x3C));
        buf.append('=');
        return buf.toString();
    }

    public int hashCode() {
        return (int)this._data;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RatchetSessionTag)) {
            return false;
        }
        return this._data == ((RatchetSessionTag)obj)._data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(33);
        buf.append("RatchetSessionTag: ");
        buf.append(this.toBase64());
        return buf.toString();
    }
}

