/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.crypto.ratchet.ReplyCallback;
import net.i2p.router.message.CloveSet;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Log;

public class GarlicMessageBuilder {
    static boolean needsTags(RouterContext ctx, PublicKey key, Hash local, int minTagOverride) {
        if (key.getType() == EncType.ECIES_X25519) {
            return false;
        }
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(local);
        if (skm == null) {
            return true;
        }
        SessionKey curKey = skm.getCurrentKey(key);
        if (curKey == null) {
            return true;
        }
        if (minTagOverride > 0) {
            return skm.shouldSendTags(key, curKey, minTagOverride);
        }
        return skm.shouldSendTags(key, curKey);
    }

    private static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        log.error("buildMessage 2 args, using router SKM", new Exception("who did it"));
        return GarlicMessageBuilder.buildMessage(ctx, config, new SessionKey(), new HashSet<SessionTag>(), ctx.sessionKeyManager());
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, SessionKeyManager skm) {
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, skm.getTagsToSend(), skm);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, int numTagsToDeliver, SessionKeyManager skm) {
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, numTagsToDeliver, skm.getLowThreshold(), skm);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, int numTagsToDeliver, int lowTagsThreshold, SessionKeyManager skm) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        PublicKey key = config.getRecipientPublicKey();
        if (key == null) {
            RouterInfo ri = config.getRecipient();
            if (ri == null) {
                throw new IllegalArgumentException("Null recipient specified");
            }
            RouterIdentity ident = ri.getIdentity();
            if (ident == null) {
                throw new IllegalArgumentException("Null recipient.identity specified");
            }
            PublicKey pk = ident.getPublicKey();
            if (pk == null) {
                throw new IllegalArgumentException("Null recipient.identity.publicKey specified");
            }
            key = pk;
        }
        if (key.getType() != EncType.ELGAMAL_2048) {
            throw new IllegalArgumentException();
        }
        if (log.shouldInfo()) {
            log.info("Encrypted with public key to expire on " + new Date(config.getExpiration()));
        }
        SessionKey curKey = skm.getCurrentOrNewKey(key);
        SessionTag curTag = skm.consumeNextAvailableTag(key, curKey);
        if (log.shouldDebug()) {
            int availTags = skm.getAvailableTags(key, curKey);
            log.debug("Available tags for encryption: " + availTags + "; Low threshold: " + lowTagsThreshold);
        }
        if (numTagsToDeliver > 0 && skm.shouldSendTags(key, curKey, lowTagsThreshold)) {
            for (int i = 0; i < numTagsToDeliver; ++i) {
                wrappedTags.add(new SessionTag(true));
            }
            if (log.shouldInfo()) {
                log.info("Too few tags available so we're including " + numTagsToDeliver);
            }
        }
        wrappedKey.setData(curKey.getData());
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedTags, key, curKey, curTag);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, Set<SessionTag> wrappedTags, PublicKey target, SessionKey encryptKey, SessionTag encryptTag) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        if (config == null) {
            throw new IllegalArgumentException("Null config specified");
        }
        GarlicMessage msg = new GarlicMessage(ctx);
        byte[] cloveSet = GarlicMessageBuilder.buildCloveSet(ctx, config);
        byte[] encData = ctx.elGamalAESEngine().encrypt(cloveSet, target, encryptKey, wrappedTags, encryptTag, 128L);
        if (encData == null) {
            if (log.shouldWarn()) {
                log.warn("ElGamal encrypt fail");
            }
            return null;
        }
        msg.setData(encData);
        msg.setMessageExpiration(config.getExpiration());
        long timeFromNow = config.getExpiration() - ctx.clock().now();
        if (timeFromNow < 1000L) {
            if (log.shouldDebug()) {
                log.debug("Building a message expiring in " + timeFromNow + "ms: " + config, new Exception("created by"));
            }
            return null;
        }
        if (log.shouldDebug()) {
            log.debug("Built ElGamal CloveSet (" + config.getCloveCount() + " cloves " + cloveSet.length + " bytes) in " + msg);
        }
        return msg;
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey encryptKey, RatchetSessionTag encryptTag) {
        GarlicMessage msg = new GarlicMessage(ctx);
        CloveSet cloveSet = GarlicMessageBuilder.buildECIESCloveSet(ctx, config);
        byte[] encData = ctx.eciesEngine().encrypt(cloveSet, encryptKey, encryptTag);
        if (encData == null) {
            return null;
        }
        msg.setData(encData);
        msg.setMessageExpiration(config.getExpiration());
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        if (log.shouldDebug()) {
            log.debug("Built ECIES CloveSet (" + config.getCloveCount() + " cloves) in " + msg);
        }
        return msg;
    }

    static GarlicMessage buildECIESMessage(RouterContext ctx, GarlicConfig config, Hash from, Destination to, SessionKeyManager skm, ReplyCallback callback) {
        RatchetSKM rskm;
        PublicKey key = config.getRecipientPublicKey();
        if (key.getType() != EncType.ECIES_X25519) {
            throw new IllegalArgumentException();
        }
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        GarlicMessage msg = new GarlicMessage(ctx);
        CloveSet cloveSet = GarlicMessageBuilder.buildECIESCloveSet(ctx, config);
        LeaseSetKeys lsk = ctx.keyManager().getKeys(from);
        if (lsk == null) {
            if (log.shouldWarn()) {
                log.warn("No LSK for " + from.toBase32());
            }
            return null;
        }
        PrivateKey priv = lsk.getDecryptionKey(EncType.ECIES_X25519);
        if (priv == null) {
            if (log.shouldWarn()) {
                log.warn("No key for " + from.toBase32());
            }
            return null;
        }
        if (skm instanceof RatchetSKM) {
            rskm = (RatchetSKM)skm;
        } else if (skm instanceof MuxedSKM) {
            rskm = ((MuxedSKM)skm).getECSKM();
        } else {
            if (log.shouldWarn()) {
                log.warn("No SKM for " + from.toBase32());
            }
            return null;
        }
        byte[] encData = ctx.eciesEngine().encrypt(cloveSet, key, to, priv, rskm, callback);
        if (encData == null) {
            if (log.shouldWarn()) {
                log.warn("Encrypt fail for " + from.toBase32());
            }
            return null;
        }
        msg.setData(encData);
        msg.setMessageExpiration(config.getExpiration());
        long timeFromNow = config.getExpiration() - ctx.clock().now();
        if (timeFromNow < 1000L) {
            if (log.shouldDebug()) {
                log.debug("Building a message expiring in " + timeFromNow + "ms: " + config, new Exception("created by"));
            }
            return null;
        }
        if (log.shouldDebug()) {
            log.debug("Built ECIES CloveSet (" + config.getCloveCount() + " cloves) in " + msg);
        }
        return msg;
    }

    public static GarlicMessage buildECIESMessage(RouterContext ctx, GarlicConfig config) {
        PublicKey key = config.getRecipientPublicKey();
        if (key.getType() != EncType.ECIES_X25519) {
            throw new IllegalArgumentException();
        }
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        GarlicMessage msg = new GarlicMessage(ctx);
        CloveSet cloveSet = GarlicMessageBuilder.buildECIESCloveSet(ctx, config);
        byte[] encData = ctx.eciesEngine().encrypt(cloveSet, key);
        if (encData == null) {
            if (log.shouldWarn()) {
                log.warn("Encrypt fail for " + config);
            }
            return null;
        }
        msg.setData(encData);
        msg.setMessageExpiration(config.getExpiration());
        long timeFromNow = config.getExpiration() - ctx.clock().now();
        if (timeFromNow < 1000L) {
            if (log.shouldDebug()) {
                log.debug("Building a message expiring in " + timeFromNow + "ms: " + config, new Exception("created by"));
            }
            return null;
        }
        if (log.shouldDebug()) {
            log.debug("Built ECIES CloveSet (" + config.getCloveCount() + " cloves) in " + msg);
        }
        return msg;
    }

    private static byte[] buildCloveSet(RouterContext ctx, GarlicConfig config) {
        ByteArrayStream baos;
        try {
            if (config instanceof PayloadGarlicConfig) {
                byte[] clove = GarlicMessageBuilder.buildClove(ctx, (PayloadGarlicConfig)config);
                baos = new ByteArrayStream(1 + clove.length + 3 + 4 + 8);
                baos.write(1);
                baos.write(clove);
            } else {
                int i;
                byte[][] cloves = new byte[config.getCloveCount()][];
                for (int i2 = 0; i2 < config.getCloveCount(); ++i2) {
                    GarlicConfig c = config.getClove(i2);
                    cloves[i2] = c instanceof PayloadGarlicConfig ? GarlicMessageBuilder.buildClove(ctx, (PayloadGarlicConfig)c) : GarlicMessageBuilder.buildClove(ctx, c);
                }
                int len = 1;
                for (i = 0; i < cloves.length; ++i) {
                    len += cloves[i].length;
                }
                baos = new ByteArrayStream(1 + len + 3 + 4 + 8);
                baos.write((byte)cloves.length);
                for (i = 0; i < cloves.length; ++i) {
                    baos.write(cloves[i]);
                }
            }
            config.getCertificate().writeBytes(baos);
            DataHelper.writeLong(baos, 4, config.getId());
            DataHelper.writeLong(baos, 8, config.getExpiration());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error building the clove set", ioe);
        }
        catch (DataFormatException dfe) {
            throw new IllegalArgumentException("Error building the clove set", dfe);
        }
        return baos.toByteArray();
    }

    private static byte[] buildClove(RouterContext ctx, PayloadGarlicConfig config) {
        GarlicClove clove = new GarlicClove(ctx);
        clove.setData(config.getPayload());
        return GarlicMessageBuilder.buildCommonClove(clove, config);
    }

    private static byte[] buildClove(RouterContext ctx, GarlicConfig config) throws DataFormatException, IOException {
        GarlicClove clove = new GarlicClove(ctx);
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, config);
        if (msg == null) {
            throw new DataFormatException("Unable to build message from clove config");
        }
        clove.setData(msg);
        return GarlicMessageBuilder.buildCommonClove(clove, config);
    }

    private static byte[] buildCommonClove(GarlicClove clove, GarlicConfig config) {
        clove.setCertificate(config.getCertificate());
        clove.setCloveId(config.getId());
        clove.setExpiration(config.getExpiration());
        clove.setInstructions(config.getDeliveryInstructions());
        return clove.toByteArray();
    }

    private static CloveSet buildECIESCloveSet(RouterContext ctx, GarlicConfig config) {
        GarlicClove[] arr;
        if (config instanceof PayloadGarlicConfig) {
            GarlicClove clove = GarlicMessageBuilder.buildECIESClove(ctx, (PayloadGarlicConfig)config);
            arr = new GarlicClove[]{clove};
        } else {
            int cnt = config.getCloveCount();
            arr = new GarlicClove[cnt];
            for (int i = 0; i < cnt; ++i) {
                GarlicConfig c = config.getClove(i);
                if (!(c instanceof PayloadGarlicConfig)) {
                    throw new IllegalArgumentException("Subclove IS NOT a payload garlic clove");
                }
                arr[i] = GarlicMessageBuilder.buildECIESClove(ctx, (PayloadGarlicConfig)c);
            }
        }
        CloveSet rv = new CloveSet(arr, Certificate.NULL_CERT, config.getId(), config.getExpiration());
        return rv;
    }

    private static GarlicClove buildECIESClove(RouterContext ctx, PayloadGarlicConfig config) {
        GarlicClove clove = new GarlicClove(ctx);
        clove.setData(config.getPayload());
        clove.setCertificate(Certificate.NULL_CERT);
        clove.setCloveId(0L);
        clove.setExpiration(config.getExpiration());
        clove.setInstructions(config.getDeliveryInstructions());
        return clove;
    }
}

