/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.util.Log;

public class HandleDatabaseLookupMessageJob
extends JobImpl {
    private final Log _log;
    private final DatabaseLookupMessage _message;
    private boolean _replyKeyConsumed;
    private final Hash _us;
    private final long _msgIDBloomXor;
    private static final int MAX_ROUTERS_RETURNED = 3;
    private static final int CLOSENESS_THRESHOLD = 8;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    public static final long EXPIRE_DELAY = 3600000L;

    public HandleDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash, long msgIDBloomXor) {
        super(ctx);
        this._log = ctx.logManager().getLog(HandleDatabaseLookupMessageJob.class);
        this._message = receivedMessage;
        this._us = ctx.routerHash();
        this._msgIDBloomXor = msgIDBloomXor;
    }

    protected boolean answerAllQueries() {
        return false;
    }

    @Override
    public void runJob() {
        int type;
        Hash fromKey = this._message.getFrom();
        TunnelId toTunnel = this._message.getReplyTunnel();
        Hash searchKey = this._message.getSearchKey();
        if (toTunnel == null && fromKey.equals(this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping NetDb Lookup for [" + searchKey.toBase64().substring(0, 6) + "] with replies to us");
            }
            return;
        }
        if (this.getContext().router().isHidden() && !searchKey.equals(this._us)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Ignoring unexpected NetDb Lookup for our key from [" + fromKey.toBase64().substring(0, 6) + "] while in hidden mode");
            }
            return;
        }
        if (searchKey.equals(Hash.FAKE_HASH)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping NetDb Lookup for fake hash key");
            }
            this.getContext().statManager().addRateData("netDb.DLMAllZeros", 1L);
            return;
        }
        if (this._log.shouldDebug()) {
            if (toTunnel != null) {
                this._log.debug("NetDb Lookup received with replies going to [" + fromKey.toBase64().substring(0, 6) + "] -> [Tunnel " + toTunnel + "]");
            } else {
                this._log.debug("Handling database lookup message for [" + searchKey.toBase64().substring(0, 6) + "] with replies to [" + fromKey.toBase64().substring(0, 6) + "]");
            }
        }
        DatabaseLookupMessage.Type lookupType = this._message.getSearchType();
        DatabaseEntry dbe = this.getContext().netDb().lookupLocally(searchKey);
        int n = type = dbe != null ? dbe.getType() : -1;
        if (DatabaseEntry.isLeaseSet(type) && (lookupType == DatabaseLookupMessage.Type.ANY || lookupType == DatabaseLookupMessage.Type.LS)) {
            LeaseSet ls = (LeaseSet)dbe;
            if (ls.getReceivedAsPublished()) {
                if (this._log.shouldInfo()) {
                    this._log.info("We have the published LeaseSet [" + searchKey.toBase64().substring(0, 6) + "] - answering query");
                }
                this.getContext().statManager().addRateData("netDb.lookupsMatchedReceivedPublished", 1L);
                this.sendData(searchKey, ls, fromKey, toTunnel);
            }
        } else if (type == 0 && lookupType != DatabaseLookupMessage.Type.LS) {
            boolean isFast;
            RouterInfo info = (RouterInfo)dbe;
            String cap = info.getCapabilities();
            String bw = info.getBandwidthTier();
            boolean isReachable = cap.indexOf(82) >= 0;
            boolean bl = isFast = cap != null && isReachable && (bw.equals("O") || bw.equals("P") || bw.equals("X"));
            if (searchKey.equals(this._us)) {
                this.sendData(searchKey, info, fromKey, toTunnel);
            } else if (info.isCurrent(3600000L) && isFast) {
                if (info.isHidden()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Ignoring NetDb Lookup for a hidden peer from [" + fromKey.toBase64().substring(0, 6) + "]");
                    }
                    Set<Hash> us = Collections.singleton(this._us);
                    this.sendClosest(searchKey, us, fromKey, toTunnel);
                } else {
                    if (this._log.shouldDebug()) {
                        this._log.debug("We do have key [" + searchKey.toBase64().substring(0, 6) + "] locally as a router info; sending to [" + fromKey.toBase64().substring(0, 6) + "]");
                    }
                    this.sendData(searchKey, info, fromKey, toTunnel);
                }
            } else if (info.isCurrent(600000L)) {
                if (info.isHidden()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Ignoring NetDb Lookup for a hidden peer from [" + fromKey.toBase64().substring(0, 6) + "]");
                    }
                    Set<Hash> us = Collections.singleton(this._us);
                    this.sendClosest(searchKey, us, fromKey, toTunnel);
                } else {
                    if (this._log.shouldDebug()) {
                        this._log.debug("We do have key [" + searchKey.toBase64().substring(0, 6) + "] locally as a router info; sending to [" + fromKey.toBase64().substring(0, 6) + "]");
                    }
                    this.sendData(searchKey, info, fromKey, toTunnel);
                }
            } else {
                Set<Hash> routerHashSet = this.getNearestRouters(lookupType);
                if (this._log.shouldDebug()) {
                    this._log.debug("Expired [" + searchKey.toBase64().substring(0, 6) + "] locally; sending back " + routerHashSet.size() + " peers to [" + fromKey.toBase64().substring(0, 6) + "]");
                }
                this.sendClosest(searchKey, routerHashSet, fromKey, toTunnel);
            }
        } else {
            Set<Hash> routerHashSet = this.getNearestRouters(lookupType);
            if (this._log.shouldDebug()) {
                this._log.debug("We don't have key [" + searchKey.toBase64().substring(0, 6) + "] locally; sending back " + routerHashSet.size() + " peers to [" + fromKey.toBase64().substring(0, 6) + "]");
            }
            this.sendClosest(searchKey, routerHashSet, fromKey, toTunnel);
        }
    }

    private Set<Hash> getNearestRouters(DatabaseLookupMessage.Type lookupType) {
        Set<Hash> dontInclude = this._message.getDontIncludePeers();
        if (dontInclude == null && lookupType == DatabaseLookupMessage.Type.EXPL) {
            dontInclude = new HashSet<Hash>(2);
            dontInclude.add(this._us);
            dontInclude.add(Hash.FAKE_HASH);
        } else if (dontInclude == null) {
            dontInclude = Collections.singleton(this._us);
        } else if (lookupType == DatabaseLookupMessage.Type.EXPL) {
            dontInclude.add(this._us);
            dontInclude.add(Hash.FAKE_HASH);
        } else {
            dontInclude.add(this._us);
        }
        return this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 3, dontInclude);
    }

    private void sendData(Hash key, DatabaseEntry data, Hash toPeer, TunnelId replyTunnel) {
        if (!key.equals(data.getHash())) {
            this._log.error("Hash mismatch HDLMJ");
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sending data matching key " + key + " to peer " + toPeer + " tunnel " + replyTunnel);
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        if (data.isLeaseSet()) {
            this.getContext().statManager().addRateData("netDb.lookupsMatchedLeaseSet", 1L);
        }
        msg.setEntry(data);
        this.getContext().statManager().addRateData("netDb.lookupsMatched", 1L);
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendClosest(Hash key, Set<Hash> routerHashes, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldDebug()) {
            this._log.debug("Sending " + routerHashes.size() + " of our closest routers to [" + key.toBase64().substring(0, 6) + "] -> [Tunnel " + replyTunnel + "]");
        }
        DatabaseSearchReplyMessage msg = new DatabaseSearchReplyMessage(this.getContext());
        msg.setFromHash(this._us);
        msg.setSearchKey(key);
        int i = 0;
        for (Hash h : routerHashes) {
            msg.addReply(h);
            if (++i < 3) continue;
            break;
        }
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendMessage(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (replyTunnel != null) {
            this.sendThroughTunnel(message, toPeer, replyTunnel);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Sending reply directly to [" + toPeer.toBase64().substring(0, 6) + "]");
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), message, toPeer, 60000, 300, this._msgIDBloomXor);
            send.runJob();
        }
    }

    private void sendThroughTunnel(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (this._us.equals(toPeer)) {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setTunnelId(replyTunnel);
            m.setMessageExpiration(message.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(m);
        } else {
            SessionKey replyKey;
            if (!this._replyKeyConsumed && (replyKey = this._message.getReplyKey()) != null) {
                SessionTag tag = this._message.getReplyTag();
                if (tag != null) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Sending AES reply to [" + toPeer.toBase64().substring(0, 6) + "] \n* Key: " + replyKey + " \n* Session Tag: " + tag);
                    }
                    message = MessageWrapper.wrap(this.getContext(), message, replyKey, tag);
                } else {
                    RatchetSessionTag rtag = this._message.getRatchetReplyTag();
                    if (this._log.shouldInfo()) {
                        this._log.info("Sending AEAD reply to [" + toPeer.toBase64().substring(0, 6) + "] \n* Key: " + replyKey + " \n* Session Tag (ratchet): " + rtag);
                    }
                    message = MessageWrapper.wrap(this.getContext(), message, replyKey, rtag);
                }
                if (message == null) {
                    this._log.error("DbLookupMessage reply -> Encryption error");
                    return;
                }
                this._replyKeyConsumed = true;
            }
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setMessageExpiration(message.getMessageExpiration());
            m.setTunnelId(replyTunnel);
            SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), m, toPeer, 10000, 300, this._msgIDBloomXor);
            j.runJob();
        }
    }

    @Override
    public String getName() {
        return "Handle Database Lookup Message";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

