/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataFormatException;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class PublishLocalRouterInfoJob
extends JobImpl {
    private final Log _log;
    private static final long MIN_PUBLISH_DELAY = 540000L;
    private static final long PUBLISH_DELAY = 2580000L;
    private static final long FIRST_TIME_DELAY = 90000L;
    private volatile boolean _notFirstTime;
    private final AtomicInteger _runCount = new AtomicInteger();

    public PublishLocalRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(PublishLocalRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Publish Local RouterInfo";
    }

    @Override
    public void runJob() {
        long now;
        if (!this.getContext().commSystem().isRunning()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Attempted to publish local RouterInfo before comm system started, retrying...");
            }
            this.requeue(100L);
            return;
        }
        long last = this.getContext().netDb().getLastRouterInfoPublishTime();
        if (last + 540000L > (now = this.getContext().clock().now())) {
            long delay = this.getDelay();
            this.requeue(last + delay - now);
            return;
        }
        RouterInfo oldRI = this.getContext().router().getRouterInfo();
        if (this._log.shouldDebug()) {
            this._log.debug("Old RouterInfo contains " + oldRI.getAddresses().size() + " addresses and " + oldRI.getOptionsMap().size() + " options");
        }
        try {
            ArrayList<RouterAddress> oldAddrs = new ArrayList<RouterAddress>(oldRI.getAddresses());
            List<RouterAddress> newAddrs = this.getContext().commSystem().createAddresses();
            int count = this._runCount.incrementAndGet();
            RouterInfo ri = new RouterInfo(oldRI);
            if (this._notFirstTime && count % 4 != 0 && oldAddrs.size() == newAddrs.size()) {
                boolean different;
                String newcaps = this.getContext().router().getCapabilities();
                boolean bl = different = !oldRI.getCapabilities().equals(newcaps);
                if (!different) {
                    AddrComparator comp = new AddrComparator();
                    Collections.sort(oldAddrs, comp);
                    Collections.sort(newAddrs, comp);
                    for (int i = 0; i < oldAddrs.size(); ++i) {
                        if (((RouterAddress)oldAddrs.get(i)).deepEquals(newAddrs.get(i))) continue;
                        different = true;
                        break;
                    }
                    if (!different) {
                        if (this._log.shouldInfo()) {
                            this._log.info("Not republishing early because costs, caps and addresses are the same");
                        }
                        this.requeue(this.getDelay());
                        return;
                    }
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Republishing early because addresses or costs or caps have changed - Old Caps: " + oldRI.getCapabilities() + "; New Caps: " + newcaps + "\nOLD:\n" + oldAddrs + "\nNEW:\n" + newAddrs);
                }
            }
            ri.setPublished(this.getContext().clock().now());
            Properties stats = this.getContext().statPublisher().publishStatistics();
            ri.setOptions(stats);
            ri.setAddresses(newAddrs);
            SigningPrivateKey key = this.getContext().keyManager().getSigningPrivateKey();
            if (key == null) {
                this._log.log(50, "Internal error - signing private key not known; rescheduling publish for 30s");
                this.requeue(30000L);
                return;
            }
            ri.sign(key);
            this.getContext().router().setRouterInfo(ri);
            if (this._log.shouldInfo()) {
                this._log.info("Newly updated RouterInfo is published with " + stats.size() + "/" + ri.getOptionsMap().size() + " options\n* Published: " + new Date(ri.getPublished()));
            }
            try {
                this.getContext().netDb().publish(ri);
            }
            catch (IllegalArgumentException iae) {
                this._log.log(50, "Error publishing our identity - corrupt? Restart required", iae);
                this.getContext().router().rebuildNewIdentity();
            }
        }
        catch (DataFormatException dfe) {
            this._log.error("Error signing the updated local router info!", dfe);
        }
        if (this._notFirstTime) {
            this.requeue(this.getDelay());
        } else {
            this.requeue(90000L);
            this._notFirstTime = true;
        }
    }

    private long getDelay() {
        long rv = 1935000L + this.getContext().random().nextLong(645000L);
        return rv /= 4L;
    }

    private static class AddrComparator
    implements Comparator<RouterAddress>,
    Serializable {
        private AddrComparator() {
        }

        @Override
        public int compare(RouterAddress l, RouterAddress r) {
            int c = l.getTransportStyle().compareTo(r.getTransportStyle());
            if (c != 0) {
                return c;
            }
            String lh = l.getHost();
            String rh = r.getHost();
            if (lh == null) {
                return rh == null ? 0 : -1;
            }
            if (rh == null) {
                return 1;
            }
            return lh.compareTo(rh);
        }
    }
}

