/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Map;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class ExpireRoutersJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 900000L;
    private static final int LIMIT_ROUTERS = SystemVersion.isSlow() ? 4000 : 8000;

    public ExpireRoutersJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireRoutersJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Expire Routers";
    }

    @Override
    public void runJob() {
        if (this.getContext().commSystem().getStatus() != CommSystemFacade.Status.DISCONNECTED && this._facade.getAllRouters().size() > 1000) {
            int removed = this.expireKeys();
            if (this._log.shouldInfo()) {
                if (removed == 1) {
                    this._log.info("Deleted " + removed + " expired RouterInfo file from NetDb");
                } else if (removed > 1) {
                    this._log.info("Deleted " + removed + " expired RouterInfo files from NetDb");
                } else if (this._log.shouldDebug() && this._facade.getKnownRouters() > 2000) {
                    this._log.debug("No expired RouterInfo files found - next check in 3m");
                } else if (this._log.shouldDebug()) {
                    this._log.debug("No expired RouterInfo files found - next check in 15m");
                }
            }
        }
        if (this.getContext().netDb().getKnownRouters() > 2000) {
            this.requeue(180000L);
        } else {
            this.requeue(900000L);
        }
    }

    private int expireKeys() {
        Set<Map.Entry<Hash, DatabaseEntry>> entries = this._facade.getDataStore().getMapEntries();
        int count = entries.size();
        if (count < 500 || this.getContext().commSystem().getStatus() == CommSystemFacade.Status.DISCONNECTED || this.getContext().jobQueue().getMaxLag() > 150L || this.getContext().throttle().getMessageDelay() > 1000L) {
            return 0;
        }
        RouterKeyGenerator gen = this.getContext().routerKeyGenerator();
        long now = this.getContext().clock().now();
        long cutoff = now - 1800000L;
        boolean almostMidnight = gen.getTimeTillMidnight() < 900000L;
        Hash us = this.getContext().routerHash();
        boolean isFF = this._facade.floodfillEnabled();
        byte[] ourRKey = isFF ? us.getData() : null;
        int pdrop = Math.max(10, Math.min(80, 128 * count / LIMIT_ROUTERS - 128));
        int removed = 0;
        if (this._log.shouldLog(20)) {
            this._log.info("Expiring routers, count = " + count + " drop probability " + (count > LIMIT_ROUTERS ? pdrop * 100 / 128 : 0) + '%');
        }
        for (Map.Entry<Hash, DatabaseEntry> entry : entries) {
            DatabaseEntry e = entry.getValue();
            if (e.getType() != 0) {
                --count;
                continue;
            }
            Hash key = entry.getKey();
            if (key.equals(us) || this.getContext().commSystem().isEstablished(key)) continue;
            if (count > LIMIT_ROUTERS) {
                byte[] rkey;
                int distance;
                if (e.getDate() >= cutoff || isFF && ((distance = (((rkey = gen.getRoutingKey(key).getData())[0] ^ ourRKey[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF) < 256 || almostMidnight && (distance = (((rkey = gen.getNextRoutingKey(key).getData())[0] ^ ourRKey[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF) < 256) || this.getContext().random().nextInt(128) >= pdrop) continue;
                this._facade.dropAfterLookupFailed(key);
                ++removed;
                continue;
            }
            try {
                if (this._facade.validate((RouterInfo)e) == null) continue;
                this._facade.dropAfterLookupFailed(key);
                ++removed;
            }
            catch (IllegalArgumentException iae) {
                this._facade.dropAfterLookupFailed(key);
                ++removed;
            }
        }
        return removed;
    }
}

