/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class HandleFloodfillDatabaseStoreMessageJob
extends JobImpl {
    private final Log _log;
    private final DatabaseStoreMessage _message;
    private final RouterIdentity _from;
    private Hash _fromHash;
    private final FloodfillNetworkDatabaseFacade _facade;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    private static final int LIMIT_ROUTERS = SystemVersion.isSlow() ? 2000 : 5000;
    private final long _msgIDBloomXor;

    public HandleFloodfillDatabaseStoreMessageJob(RouterContext ctx, DatabaseStoreMessage receivedMessage, RouterIdentity from, Hash fromHash, FloodfillNetworkDatabaseFacade facade, long msgIDBloomXor) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
        this._facade = facade;
        this._msgIDBloomXor = msgIDBloomXor;
    }

    @Override
    public void runJob() {
        DatabaseEntry entry;
        Hash key;
        boolean wasNew;
        boolean dontBlamePeer;
        String invalidMessage;
        long recvBegin;
        block138: {
            boolean isBanned;
            recvBegin = System.currentTimeMillis();
            invalidMessage = null;
            dontBlamePeer = false;
            wasNew = false;
            RouterInfo prevNetDb = null;
            key = this._message.getKey();
            entry = this._message.getEntry();
            int type = entry.getType();
            long now = this.getContext().clock().now();
            boolean bl = isBanned = this.getContext().banlist().isBanlistedForever(key) || this.getContext().banlist().isBanlisted(key) || this.getContext().banlist().isBanlistedHostile(key);
            if (DatabaseEntry.isLeaseSet(type)) {
                this.getContext().statManager().addRateData("netDb.storeLeaseSetHandled", 1L);
                if (this._log.shouldDebug()) {
                    this._log.debug("[DbId: " + this._facade + "] Handling NetDbStore of LeaseSet" + this._message);
                }
                try {
                    LeaseSet ls = (LeaseSet)entry;
                    if (!ls.getReceivedAsReply()) {
                        ls.setReceivedAsPublished();
                    }
                    if (this._facade.isClientDb() && this.getContext().netDbSegmentor().clientNetDB(ls.getHash()).equals(this._facade)) {
                        this.getContext().statManager().addRateData("netDb.storeLocalLeaseSetToLocalClient", 1L, 0L);
                        dontBlamePeer = true;
                        throw new IllegalArgumentException("Peer attempted to store LOCAL LeaseSet [" + key.toBase32().substring(0, 6) + "](DbId: " + this._facade + ")");
                    }
                    LeaseSet match = this._facade.store(key, ls);
                    if (match == null) {
                        wasNew = true;
                        break block138;
                    }
                    if (match.getEarliestLeaseDate() < ls.getEarliestLeaseDate()) {
                        wasNew = true;
                        break block138;
                    }
                    if (type != 1 && match.getType() != 1) {
                        LeaseSet2 ls2 = (LeaseSet2)ls;
                        LeaseSet2 match2 = (LeaseSet2)match;
                        wasNew = match2.getPublished() < ls2.getPublished();
                        break block138;
                    }
                    wasNew = false;
                }
                catch (UnsupportedCryptoException uce) {
                    if (this._log.shouldError()) {
                        this._log.error("Unsupported Encryption: " + uce.getMessage());
                    }
                    invalidMessage = uce.getMessage();
                    dontBlamePeer = true;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (type == 0) {
                RouterInfo ri = (RouterInfo)entry;
                if (this._log.shouldDebug()) {
                    this._log.debug("[DbId: " + this._facade + "] Starting handling of dbStore of RouterInfo " + this._message);
                }
                String cap = ri.getCapabilities();
                boolean isFF = cap.contains("f");
                this.getContext().statManager().addRateData("netDb.storeRouterInfoHandled", 1L);
                if (this._fromHash == null && this._from != null) {
                    this._fromHash = this._from.getHash();
                }
                boolean isUs = this.getContext().routerHash().equals(key);
                if (!key.equals(this._fromHash) && !isUs) {
                    if (this._message.getReceivedAsReply()) {
                        ri.setReceivedAsReply();
                        if (this._message.getReplyToken() > 0L) {
                            ri.setReceivedAsPublished();
                        }
                    } else {
                        ri.setReceivedAsPublished();
                    }
                }
                if (this._log.shouldInfo()) {
                    String req = (this._message.getReplyToken() > 0L ? " reply req." : "") + (this._fromHash == null && ri.getReceivedAsPublished() ? " unsolicited" : "");
                    if (this._fromHash == null) {
                        this._log.info("[DbId: " + this._facade + "] Handling NetDbStore of " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] \n* Published " + DataHelper.formatTime(ri.getPublished()) + req);
                    } else if (this._fromHash.equals(key)) {
                        this._log.info("[DbId: " + this._facade + "] Handling NetDbStore of " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] \n* Published " + DataHelper.formatTime(ri.getPublished()) + " from that router" + req);
                    } else {
                        this._log.info("[DbId: " + this._facade + "] Handling NetDbStore of " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] \n* Published " + DataHelper.formatTime(ri.getPublished()) + " from: [" + this._fromHash.toBase64().substring(0, 6) + "] " + req);
                    }
                }
                try {
                    if (isUs) {
                        dontBlamePeer = true;
                        throw new IllegalArgumentException("Router [" + key.toBase64().substring(0, 6) + "] attempted to store our RouterInfo");
                    }
                    if (this._facade.isClientDb() && this._log.shouldWarn()) {
                        this._log.warn("Handling RouterInfo [" + key.toBase64().substring(0, 6) + "] store request in client NetDb context of router");
                    }
                    boolean shouldStore = true;
                    if (ri.getReceivedAsPublished()) {
                        prevNetDb = (RouterInfo)this._facade.lookupLocallyWithoutValidation(key);
                        boolean isUnreachable = cap.indexOf(82) < 0;
                        boolean isSlow = cap.contains("K") || cap.contains("L") || cap.contains("M") || cap.contains("N");
                        String MIN_VERSION = "0.9.60";
                        String v = ri.getVersion();
                        boolean noSSU = true;
                        boolean isOld = VersionComparator.comp(v, MIN_VERSION) < 0;
                        String country = "unknown";
                        boolean noCountry = true;
                        long uptime = this.getContext().router().getUptime();
                        boolean notFrom = !key.equals(this._fromHash);
                        for (RouterAddress ra : ri.getAddresses()) {
                            if (!ra.getTransportStyle().equals("SSU") && !ra.getTransportStyle().equals("SSU2")) continue;
                            noSSU = false;
                            break;
                        }
                        if ((country = this.getContext().commSystem().getCountry(key)) != null && country != "unknown") {
                            noCountry = false;
                        }
                        if (isBanned) {
                            shouldStore = false;
                            wasNew = false;
                            if (this._log.shouldWarn()) {
                                this._log.warn("Dropping unsolicited NetDbStore of banned " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "]" + (isFF && noSSU ? " -> SSU transport disabled" : ""));
                            }
                        } else if (noCountry && uptime > 90000L) {
                            shouldStore = false;
                            wasNew = false;
                            if (this._log.shouldWarn()) {
                                this._log.warn("Dropping unsolicited NetDbStore of " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> Address not resolvable via GeoIP");
                            }
                        } else if (isFF && noSSU || isFF && isUnreachable) {
                            shouldStore = false;
                            wasNew = false;
                            if (noSSU) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of " + cap + " Floodfill [" + key.toBase64().substring(0, 6) + "] -> SSU transport disabled");
                                }
                                this.getContext().banlist().banlistRouter(key, " <b>\u279c</b> Floodfill with SSU disabled", null, null, now + 14400000L);
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of " + cap + " Floodfill [" + key.toBase64().substring(0, 6) + "] and banning for 4h -> SSU transport disabled");
                                }
                            } else {
                                shouldStore = false;
                                wasNew = false;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of " + cap + " Floodfill [" + key.toBase64().substring(0, 6) + "] -> Unreachable");
                                }
                                this.getContext().banlist().banlistRouter(key, " <b>\u279c</b> Floodfill is unreachable / firewalled", null, null, now + 14400000L);
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of " + cap + " Floodfill [" + key.toBase64().substring(0, 6) + "] and banning for 4h -> Unreachable");
                                }
                            }
                        } else if (prevNetDb == null) {
                            int count;
                            if (isUnreachable && isOld) {
                                shouldStore = false;
                                wasNew = false;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> " + v);
                                }
                            } else if (isUnreachable && isSlow) {
                                shouldStore = false;
                                wasNew = false;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> Unreachable and slow");
                                }
                            } else if (isUnreachable) {
                                shouldStore = false;
                                wasNew = false;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> Unreachable");
                                }
                            } else if (isOld && isSlow) {
                                shouldStore = false;
                                wasNew = false;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> Slow (" + v + ")");
                                }
                            }
                            if ((count = this._facade.getDataStore().size()) > LIMIT_ROUTERS) {
                                if (this._facade.floodfillEnabled()) {
                                    byte[] ourRKey;
                                    RouterKeyGenerator gen = this.getContext().routerKeyGenerator();
                                    byte[] rkey = gen.getRoutingKey(key).getData();
                                    int distance = ((rkey[0] ^ (ourRKey = this.getContext().routerHash().getData())[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF;
                                    if (distance >= 256) {
                                        long until = gen.getTimeTillMidnight();
                                        if (until > 2700000L) {
                                            int pdrop = Math.min(110, 128 * count / LIMIT_ROUTERS - 128);
                                            if (isUnreachable || isOld || noSSU) {
                                                pdrop *= 8;
                                            } else if (notFrom) {
                                                pdrop *= 10;
                                            }
                                            if (pdrop > 0 && (pdrop >= 128 || this.getContext().random().nextInt(128) < pdrop)) {
                                                if (this._log.shouldWarn()) {
                                                    this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] with distance " + distance + " -> Drop probability: " + pdrop * 100 / 128 + "%");
                                                }
                                                shouldStore = false;
                                                if (this._message.getReplyToken() > 0L) {
                                                    wasNew = true;
                                                }
                                            }
                                        } else {
                                            rkey = gen.getNextRoutingKey(key).getData();
                                            distance = ((rkey[0] ^ (ourRKey = gen.getNextRoutingKey(this.getContext().routerHash()).getData())[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF;
                                            if (distance >= 256) {
                                                int pdrop = Math.min(110, 128 * count / LIMIT_ROUTERS - 128);
                                                if (isUnreachable || isOld || noSSU) {
                                                    pdrop *= 8;
                                                } else if (notFrom) {
                                                    pdrop *= 10;
                                                }
                                                if (pdrop > 0 && (pdrop >= 128 || this.getContext().random().nextInt(128) < pdrop)) {
                                                    if (this._log.shouldWarn()) {
                                                        this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] with distance " + distance);
                                                    }
                                                    shouldStore = false;
                                                    if (this._message.getReplyToken() > 0L) {
                                                        wasNew = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (shouldStore && this._log.shouldDebug()) {
                                        this._log.debug("[DbId: " + this._facade + "] Allowing unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] with distance " + distance);
                                    }
                                } else {
                                    if (isFF && noSSU || isFF && isUnreachable) {
                                        shouldStore = false;
                                        if (this._log.shouldWarn()) {
                                            if (isFF && noSSU) {
                                                this._log.warn("Dropping unsolicited NetDbStore of new Floodfill [" + key.toBase64().substring(0, 6) + "] -> SSU transport disabled");
                                            } else {
                                                this._log.warn("Dropping unsolicited NetDbStore of new " + cap + " Floodfill [" + key.toBase64().substring(0, 6) + "] -> Unreachable");
                                            }
                                        }
                                    }
                                    if (isUnreachable && isOld) {
                                        shouldStore = false;
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> Unreachable (" + v + ")");
                                        }
                                    }
                                    int pdrop = 128 * count / LIMIT_ROUTERS - 128;
                                    if (isUnreachable || isOld || noSSU) {
                                        pdrop *= 8;
                                    } else if (notFrom) {
                                        pdrop *= 10;
                                    }
                                    if (pdrop > 0 && (pdrop >= 128 || this.getContext().random().nextInt(128) < pdrop)) {
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("Dropping unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] -> Drop probability: " + pdrop * 100 / 128 + "%");
                                        }
                                        shouldStore = false;
                                    }
                                }
                            }
                            if (shouldStore && this._log.shouldWarn()) {
                                this._log.warn("Handling unsolicited NetDbStore of new " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "]");
                            }
                        } else if (prevNetDb.getPublished() >= ri.getPublished()) {
                            shouldStore = false;
                        } else {
                            if (this._log.shouldInfo()) {
                                this._log.info("[DbId: " + this._facade + "] Newer RouterInfo [" + key.toBase64().substring(0, 6) + "] encountered in DbStore Message) with a newer published date (" + ri.getPublished() + ") than our local copy (" + prevNetDb.getPublished() + ")");
                            }
                            if (!ri.getIdentity().getPublicKey().equals(prevNetDb.getIdentity().getPublicKey())) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] and banning for 8h -> Inconsistent public keys");
                                }
                                this.getContext().banlist().banlistRouter(key, " <b>\u279c</b> Inconsistent public keys", null, null, now + 28800000L);
                                shouldStore = false;
                            } else if (!ri.getIdentity().getSigningPublicKey().equals(prevNetDb.getIdentity().getSigningPublicKey())) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping unsolicited NetDbStore of " + cap + (isFF ? " Floodfill" : " Router") + " [" + key.toBase64().substring(0, 6) + "] and banning for 8h -> Inconsistent signing keys");
                                }
                                this.getContext().banlist().banlistRouter(key, " <b>\u279c</b> Inconsistent signing keys", null, null, now + 28800000L);
                                shouldStore = false;
                            }
                        }
                    }
                    if (shouldStore) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("[DbId: " + this._facade + "] Storing RI with the context NetDb " + key.toBase64());
                        }
                        prevNetDb = this._facade.store(key, ri);
                        if (this._facade.isClientDb() && this._log.shouldWarn()) {
                            this._log.warn("[DbId: " + this._facade + "] Storing RI to client NetDb (this is rare, should have been handled by IBMD) " + key.toBase64());
                        }
                        boolean bl2 = wasNew = null == prevNetDb || prevNetDb.getPublished() < ri.getPublished();
                    }
                    if (wasNew) {
                        boolean forever = this.getContext().banlist().isBanlistedForever(key);
                        if (forever || isBanned) {
                            wasNew = false;
                            shouldStore = false;
                        }
                        if (prevNetDb == null) {
                            if (!forever && this.getContext().blocklist().isBlocklisted(ri)) {
                                if (this._log.shouldInfo()) {
                                    this._log.warn("Blocklisting new peer [" + key.toBase64().substring(0, 6) + "] \n" + ri);
                                } else if (this._log.shouldWarn()) {
                                    this._log.warn("Blocklisting new peer [" + key.toBase64().substring(0, 6) + "]");
                                }
                                wasNew = false;
                                shouldStore = false;
                            }
                        } else if (!forever) {
                            Collection<RouterAddress> oldAddr = prevNetDb.getAddresses();
                            Collection<RouterAddress> newAddr = ri.getAddresses();
                            if (!newAddr.equals(oldAddr) && this.getContext().blocklist().isBlocklisted(ri)) {
                                if (this._log.shouldInfo()) {
                                    this._log.warn("New address received, blocklisting old peer [" + key.toBase64().substring(0, 6) + "] \n" + ri);
                                } else if (this._log.shouldWarn()) {
                                    this._log.warn("New address received, blocklisting old peer [" + key.toBase64().substring(0, 6) + "]");
                                }
                                wasNew = false;
                                shouldStore = false;
                            }
                        }
                    }
                    if (shouldStore && ri.getCapabilities().indexOf(82) >= 0) {
                        this.getContext().profileManager().heardAbout(key);
                    }
                }
                catch (UnsupportedCryptoException uce) {
                    invalidMessage = uce.getMessage();
                    dontBlamePeer = true;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else {
                if (this._log.shouldError()) {
                    this._log.error("[DbId: " + this._facade + "] Invalid DbStoreMessage data type - " + entry.getType() + ": " + this._message);
                }
                return;
            }
        }
        long recvEnd = System.currentTimeMillis();
        this.getContext().statManager().addRateData("netDb.storeRecvTime", recvEnd - recvBegin);
        if (this._message.getReplyToken() > 0L) {
            this.sendAck(key);
        }
        long ackEnd = System.currentTimeMillis();
        if (this._from != null) {
            this._fromHash = this._from.getHash();
        }
        if (this._fromHash != null) {
            if (invalidMessage == null || dontBlamePeer) {
                this.getContext().profileManager().dbStoreReceived(this._fromHash, wasNew);
                this.getContext().statManager().addRateData("netDb.storeHandled", ackEnd - recvEnd);
            } else if (invalidMessage.contains("published over")) {
                dontBlamePeer = true;
                if (this._log.shouldWarn()) {
                    this._log.warn("Received STALE RouterInfo from [" + this._fromHash.toBase64().substring(0, 6) + "] \n* " + invalidMessage);
                }
            } else if (this._log.shouldDebug()) {
                this._log.warn("Received INVALID data packet from [" + this._fromHash.toBase64().substring(0, 6) + "] \n* " + invalidMessage + this._from);
            } else if (this._log.shouldWarn()) {
                this._log.warn("Received INVALID data packet from [" + this._fromHash.toBase64().substring(0, 6) + "] \n* " + invalidMessage);
            }
        } else if (invalidMessage != null && !dontBlamePeer && this._log.shouldWarn()) {
            if (invalidMessage.contains("published over")) {
                this._log.warn("Received STALE RouterInfo from [unknown] \n* " + invalidMessage);
            } else {
                this._log.warn("Received INVALID data packet from [unknown] \n* " + invalidMessage);
            }
        }
        if (invalidMessage == null && this._facade.floodfillEnabled() && this._message.getReplyToken() > 0L) {
            if (wasNew) {
                if (this._facade.shouldThrottleFlood(key)) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Too many recent stores, not flooding key: " + key);
                    }
                    this.getContext().statManager().addRateData("netDb.floodThrottled", 1L);
                    return;
                }
                long floodBegin = System.currentTimeMillis();
                this._facade.flood(entry);
                long floodEnd = System.currentTimeMillis();
                this.getContext().statManager().addRateData("netDb.storeFloodNew", floodEnd - floodBegin, 60000L);
            } else {
                this.getContext().statManager().addRateData("netDb.storeFloodOld", 1L);
            }
        }
    }

    private void sendAck(Hash storedKey) {
        boolean isEstab;
        DatabaseStoreMessage msg2;
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setMessageId(this._message.getReplyToken());
        msg.setArrival(this.getContext().clock().now() - (long)this.getContext().random().nextInt(3000));
        TunnelId replyTunnel = this._message.getReplyTunnel();
        if (this._facade.floodfillEnabled() || storedKey.equals(this.getContext().routerHash())) {
            msg2 = null;
        } else {
            msg2 = new DatabaseStoreMessage(this.getContext());
            RouterInfo me = this.getContext().router().getRouterInfo();
            msg2.setEntry(me);
            if (this._fromHash != null && this._from != null && this._log.shouldWarn()) {
                this._log.warn("Received a DbStoreMessage with Reply token, but we're not a Floodfill\n* From: " + this._from + "\n* From Hash: " + this._fromHash + "\n* Message: " + this._message, new Exception());
            }
        }
        Hash toPeer = this._message.getReplyGateway();
        boolean toUs = this.getContext().routerHash().equals(toPeer);
        if (toUs && replyTunnel != null) {
            TunnelGatewayMessage tgm = new TunnelGatewayMessage(this.getContext());
            tgm.setMessage(msg);
            tgm.setTunnelId(replyTunnel);
            tgm.setMessageExpiration(msg.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(tgm);
            if (msg2 != null) {
                TunnelGatewayMessage tgm2 = new TunnelGatewayMessage(this.getContext());
                tgm2.setMessage(msg2);
                tgm2.setTunnelId(replyTunnel);
                tgm2.setMessageExpiration(msg.getMessageExpiration());
                this.getContext().tunnelDispatcher().dispatch(tgm2);
            }
            return;
        }
        if (toUs) {
            if (this._facade.isClientDb()) {
                this._log.error("[DbId: " + this._facade + "] Error! SendMessageDirectJob (toUs) attempted in Client NetDb! \n* Message: " + msg);
                return;
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), msg, toPeer, 60000, 300, this._msgIDBloomXor);
            send.runJob();
            if (msg2 != null) {
                SendMessageDirectJob send2 = new SendMessageDirectJob(this.getContext(), msg2, toPeer, 60000, 300, this._msgIDBloomXor);
                send2.runJob();
            }
            return;
        }
        DatabaseEntry entry = this._message.getEntry();
        int type = entry.getType();
        boolean bl = isEstab = (type == 0 || replyTunnel == null) && this.getContext().commSystem().isEstablished(toPeer);
        if (isEstab && !this._facade.isClientDb()) {
            FastI2NPMessageImpl out1 = msg;
            FastI2NPMessageImpl out2 = msg2;
            if (replyTunnel != null) {
                TunnelGatewayMessage tgm = new TunnelGatewayMessage(this.getContext());
                tgm.setMessage(msg);
                tgm.setTunnelId(replyTunnel);
                tgm.setMessageExpiration(msg.getMessageExpiration());
                out1 = tgm;
                if (out2 != null) {
                    TunnelGatewayMessage tgm2 = new TunnelGatewayMessage(this.getContext());
                    tgm2.setMessage(msg2);
                    tgm2.setTunnelId(replyTunnel);
                    tgm2.setMessageExpiration(msg.getMessageExpiration());
                    out2 = tgm2;
                }
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), out1, toPeer, 60000, 300, this._msgIDBloomXor);
            send.runJob();
            if (msg2 != null) {
                SendMessageDirectJob send2 = new SendMessageDirectJob(this.getContext(), out2, toPeer, 60000, 300, this._msgIDBloomXor);
                send2.runJob();
            }
            return;
        }
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(toPeer);
        if (outTunnel == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No Outbound tunnel could be found");
            }
            return;
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), replyTunnel, toPeer);
        if (msg2 != null) {
            this.getContext().tunnelDispatcher().dispatchOutbound(msg2, outTunnel.getSendTunnelId(0), replyTunnel, toPeer);
        }
    }

    @Override
    public String getName() {
        return "Handle Floodfill DbStoreMessage";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

