/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchMessageSelector;
import net.i2p.router.networkdb.kademlia.SearchReplyJob;
import net.i2p.router.networkdb.kademlia.SearchState;
import net.i2p.router.networkdb.kademlia.SearchUpdateReplyFoundJob;
import net.i2p.util.Log;

class SearchJob
extends JobImpl {
    protected final Log _log;
    protected final KademliaNetworkDatabaseFacade _facade;
    private final SearchState _state;
    private final Job _onSuccess;
    private final Job _onFailure;
    private final long _expiration;
    private final long _timeoutMs;
    private final boolean _keepStats;
    private final boolean _isLease;
    private Job _pendingRequeueJob;
    private final PeerSelector _peerSelector;
    private final List<Search> _deferredSearches;
    private boolean _deferredCleared;
    private long _startedOn;
    private boolean _floodfillPeersExhausted;
    private int _floodfillSearchesOutstanding;
    private final long _msgIDBloomXor;
    private static int SEARCH_BREDTH = 5;
    static final int MAX_CLOSEST = 12;
    private static final int PER_PEER_TIMEOUT = 4000;
    private static final long RESEND_TIMEOUT = 8000L;
    private static final long REQUEUE_DELAY = 1500L;
    private static final boolean DEFAULT_FLOODFILL_ONLY = true;
    static final int PER_FLOODFILL_PEER_TIMEOUT = 5000;
    static final long MIN_TIMEOUT = 3000L;
    private static int MAX_PEERS_QUERIED = 64;
    private static final int MAX_LEASE_RESEND = 10;
    private static final boolean SHOULD_RESEND_ROUTERINFO = false;

    public SearchJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, Job onSuccess, Job onFailure, long timeoutMs, boolean keepStats, boolean isLease, long msgIDBloomXor) {
        super(context);
        if (key == null || key.getData() == null) {
            throw new IllegalArgumentException("Search for null key?");
        }
        this._log = this.getContext().logManager().getLog(this.getClass());
        this._facade = facade;
        this._state = new SearchState(this.getContext(), key);
        this._onSuccess = onSuccess;
        this._onFailure = onFailure;
        this._timeoutMs = timeoutMs;
        this._keepStats = keepStats;
        this._isLease = isLease;
        this._deferredSearches = new ArrayList<Search>(0);
        this._peerSelector = facade.getPeerSelector();
        this._startedOn = -1L;
        this._expiration = this.getContext().clock().now() + timeoutMs;
        this._msgIDBloomXor = msgIDBloomXor;
        this.getContext().statManager().addRateData("netDb.searchCount", 1L);
    }

    @Override
    public void runJob() {
        if (this._startedOn <= 0L) {
            this._startedOn = this.getContext().clock().now();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[Job " + this.getJobId() + "] [DbId: " + this._facade + "] Searching for [" + this._state.getTarget().toBase64().substring(0, 6) + "]");
        }
        this.searchNext();
    }

    protected SearchState getState() {
        return this._state;
    }

    protected KademliaNetworkDatabaseFacade getFacade() {
        return this._facade;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public long getTimeoutMs() {
        return this._timeoutMs;
    }

    static boolean onlyQueryFloodfillPeers(RouterContext ctx) {
        String forceExplore = ctx.getProperty("router.exploreWhenFloodfill");
        if (ctx.netDb().floodfillEnabled() || forceExplore == "true") {
            return false;
        }
        return ctx.getProperty("netDb.floodfillOnly", true);
    }

    protected int getPerPeerTimeoutMs(Hash peer) {
        int timeout = 0;
        timeout = this._floodfillPeersExhausted && this._floodfillSearchesOutstanding <= 0 ? this._facade.getPeerTimeout(peer) : 5000;
        long now = this.getContext().clock().now();
        if (now + (long)timeout > this._expiration) {
            return (int)Math.max(this._expiration - now, 3000L);
        }
        return timeout;
    }

    protected int getPerPeerTimeoutMs() {
        if (this._floodfillPeersExhausted && this._floodfillSearchesOutstanding <= 0) {
            return 4000;
        }
        return 5000;
    }

    protected void searchNext() {
        if (this._state.completed()) {
            if (this._log.shouldDebug()) {
                this._log.debug("[Job " + this.getJobId() + "] Exploratory Search already completed");
            }
            return;
        }
        if (this._state.isAborted()) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Exploratory Search aborted");
            }
            this._state.complete();
            this.fail();
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.info("[Job " + this.getJobId() + "]" + this._state);
        }
        if (this.isLocal()) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Key found locally");
            }
            this._state.complete();
            this.succeed();
        } else if (this.isExpired()) {
            if (this._log.shouldDebug()) {
                this._log.debug("[Job " + this.getJobId() + "] Search for [" + this._state.getTarget().toBase64().substring(0, 6) + "] expired");
            }
            this._state.complete();
            this.fail();
        } else if (this._state.getAttempted().size() > MAX_PEERS_QUERIED) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Too many peers queried (more than " + MAX_PEERS_QUERIED + ")");
            }
            this._state.complete();
            this.fail();
        } else {
            this.continueSearch();
        }
    }

    private boolean isLocal() {
        return this._facade.getDataStore().isKnown(this._state.getTarget());
    }

    private boolean isExpired() {
        return this.getContext().clock().now() >= this._expiration;
    }

    protected int getBredth() {
        if (this._isLease) {
            return SEARCH_BREDTH * 3 / 2;
        }
        return SEARCH_BREDTH;
    }

    protected void continueSearch() {
        int toCheck;
        if (this._state.completed()) {
            if (this._log.shouldDebug()) {
                this._log.debug("[Job " + this.getJobId() + "] Search already completed", new Exception("already completed"));
            }
            return;
        }
        if (this.getContext().jobQueue().getMaxLag() > 750L || this.getContext().throttle().getMessageDelay() > 1000L) {
            SEARCH_BREDTH -= 3;
            if (this._log.shouldDebug()) {
                this._log.debug("[Job " + this.getJobId() + "] Reducing number of parallel peer searches to " + this.getBredth() + " - router under load");
            }
        }
        if ((toCheck = this.getBredth() - this._state.getPending().size()) <= 0) {
            if (this._log.shouldInfo()) {
                this._log.info("[Job " + this.getJobId() + "] Too many searches pending -> throttling (pending: " + this._state.getPending().size() + ", max: " + this.getBredth() + ")");
            }
            this.requeuePending();
            return;
        }
        int sent = 0;
        Set<Hash> attempted = this._state.getAttempted();
        while (sent <= 0) {
            boolean onlyFloodfill = true;
            if (this._floodfillPeersExhausted && onlyFloodfill && this._state.getPending().isEmpty()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("No non-Floodfill peers left, and no more search queries pending. Searched: " + this._state.getAttempted().size() + " Failed: " + this._state.getFailed().size());
                }
                this.fail();
                return;
            }
            List<Hash> closestHashes = this.getClosestRouters(this._state.getTarget(), toCheck, attempted);
            if (closestHashes == null || closestHashes.isEmpty()) {
                if (this._state.getPending().isEmpty()) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[Job " + this.getJobId() + "] No peers left, and no search queries pending! Already searched: " + this._state.getAttempted().size() + " Failed: " + this._state.getFailed().size());
                    }
                    this.fail();
                } else {
                    if (this._log.shouldInfo()) {
                        this._log.info("[Job " + this.getJobId() + "] No peers left, but search queries still pending!\n* Pending: " + this._state.getPending().size() + "\n* Queried: " + this._state.getAttempted().size() + "\n* Failed: " + this._state.getFailed().size());
                    }
                    this.requeuePending();
                }
                return;
            }
            attempted.addAll(closestHashes);
            for (Hash peer : closestHashes) {
                DatabaseEntry ds = this._facade.getDataStore().get(peer);
                if (ds == null) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[DbId: " + this._facade + "] Next closest peer [" + peer.toBase64().substring(0, 6) + "] was only recently referred to us, sending a search for them");
                    }
                    this.getContext().netDb().lookupRouterInfo(peer, null, null, this._timeoutMs);
                    continue;
                }
                if (ds.getType() != 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Error selecting closest hash that wasn't a router! " + peer + " : " + ds.getClass().getName());
                    }
                    this._state.replyTimeout(peer);
                    continue;
                }
                RouterInfo ri = (RouterInfo)ds;
                if (!FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                    this._floodfillPeersExhausted = true;
                    if (onlyFloodfill) continue;
                }
                if (ri.isHidden()) continue;
                this._state.addPending(peer);
                this.sendSearch((RouterInfo)ds);
                ++sent;
            }
        }
    }

    private void requeuePending() {
        long perPeerTimeout = this.getPerPeerTimeoutMs() / 2;
        if (perPeerTimeout < 1500L) {
            this.requeuePending(perPeerTimeout);
        } else {
            this.requeuePending(1500L);
        }
    }

    private void requeuePending(long ms) {
        if (this._pendingRequeueJob == null) {
            this._pendingRequeueJob = new RequeuePending(this.getContext());
        }
        long now = this.getContext().clock().now();
        if (this._pendingRequeueJob.getTiming().getStartAfter() < now) {
            this._pendingRequeueJob.getTiming().setStartAfter(now + ms);
        }
        this.getContext().jobQueue().addJob(this._pendingRequeueJob);
    }

    private List<Hash> getClosestRouters(Hash key, int numClosest, Set<Hash> alreadyChecked) {
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(key);
        if (this._log.shouldDebug()) {
            this._log.debug("[Job " + this.getJobId() + "] Checked current routing key [" + rkey.toBase64().substring(0, 6) + "] for [" + key.toBase64().substring(0, 6) + "]");
        }
        return this._peerSelector.selectNearestExplicit(rkey, numClosest, alreadyChecked, this._facade.getKBuckets());
    }

    protected void sendSearch(RouterInfo router) {
        if (router.getIdentity().equals(this.getContext().router().getRouterInfo().getIdentity())) {
            if (this._log.shouldError()) {
                this._log.error("[Job " + this.getJobId() + "] Don't send search to ourselves - why did we try?");
            }
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.info("[Job " + this.getJobId() + "] [DbId: " + this._facade + "] Search for [" + this._state.getTarget().toBase64().substring(0, 6) + "] sent to [" + router.getIdentity().getHash().toBase64().substring(0, 6) + "] - " + this.getPerPeerTimeoutMs(router.getIdentity().calculateHash()) / 1000 + "s timeout");
        }
        this.getContext().statManager().addRateData("netDb.searchMessageCount", 1L);
        if (this._isLease || !this.getContext().commSystem().isEstablished(router.getIdentity().calculateHash())) {
            this.sendLeaseSearch(router);
        } else {
            this.sendRouterSearch(router);
        }
    }

    protected void sendLeaseSearch(RouterInfo router) {
        Hash to = router.getIdentity().getHash();
        TunnelInfo inTunnel = this.getContext().tunnelManager().selectInboundExploratoryTunnel(to);
        if (inTunnel == null) {
            this._log.warn("No Inbound tunnels available to receive search replies!");
            this.getContext().jobQueue().addJob(new FailedJob(this.getContext(), router));
            return;
        }
        TunnelId inTunnelId = inTunnel.getReceiveTunnelId(0);
        int timeout = this.getPerPeerTimeoutMs(to);
        long expiration = this.getContext().clock().now() + (long)timeout;
        I2NPMessage msg = this.buildMessage(inTunnelId, inTunnel.getPeer(0), expiration, router);
        if (msg == null) {
            this.getContext().jobQueue().addJob(new FailedJob(this.getContext(), router));
            return;
        }
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(to);
        if (outTunnel == null) {
            this._log.warn("No Outbound tunnels available to send search through!");
            this.getContext().jobQueue().addJob(new FailedJob(this.getContext(), router));
            return;
        }
        TunnelId outTunnelId = outTunnel.getSendTunnelId(0);
        if (this._log.shouldDebug()) {
            this._log.debug("[Job " + this.getJobId() + "] [DbId: " + this._facade + "] Sending search to [" + to.toBase64().substring(0, 6) + "] for [" + this.getState().getTarget().toBase64().substring(0, 6) + "]\n* Replies: through [" + inTunnel.getPeer(0).toBase64().substring(0, 6) + "] via [Tunnel " + inTunnelId + "]");
        }
        SearchMessageSelector sel = new SearchMessageSelector(this.getContext(), router, this._expiration, this._state);
        SearchUpdateReplyFoundJob reply = new SearchUpdateReplyFoundJob(this.getContext(), router, this._state, this._facade, this, outTunnel, inTunnel);
        if (FloodfillNetworkDatabaseFacade.isFloodfill(router)) {
            ++this._floodfillSearchesOutstanding;
        }
        this.getContext().messageRegistry().registerPending(sel, reply, new FailedJob(this.getContext(), router));
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnelId, to);
    }

    protected void sendRouterSearch(RouterInfo router) {
        Hash to = router.getIdentity().getHash();
        int timeout = this._facade.getPeerTimeout(to);
        long expiration = this.getContext().clock().now() + (long)timeout;
        I2NPMessage msg = this.buildMessage(null, to, expiration, router);
        if (msg == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Failed to create DatabaseLookupMessage to: " + router);
            }
            this.getContext().jobQueue().addJob(new FailedJob(this.getContext(), router));
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[Job " + this.getJobId() + "] Sending router search directly to [" + to.toBase64().substring(0, 6) + "] for [" + this._state.getTarget().toBase64().substring(0, 6) + "]");
        }
        SearchMessageSelector sel = new SearchMessageSelector(this.getContext(), router, this._expiration, this._state);
        SearchUpdateReplyFoundJob reply = new SearchUpdateReplyFoundJob(this.getContext(), router, this._state, this._facade, this);
        if (this._facade.isClientDb()) {
            this._log.error("[DbId: " + this._facade + "] Error! SendMessageDirectJob attempted in Client NetDb! \n* Message: " + msg, new Exception("backtrace..."));
            return;
        }
        SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), msg, to, reply, new FailedJob(this.getContext(), router), sel, timeout, 455, this._msgIDBloomXor);
        if (FloodfillNetworkDatabaseFacade.isFloodfill(router)) {
            ++this._floodfillSearchesOutstanding;
        }
        j.runJob();
    }

    protected I2NPMessage buildMessage(TunnelId replyTunnelId, Hash replyGateway, long expiration, RouterInfo peer) {
        throw new UnsupportedOperationException("See ExploreJob");
    }

    void replyFound(DatabaseSearchReplyMessage message, Hash peer) {
        long duration = this._state.replyFound(peer);
        if (this._log.shouldLog(10)) {
            this._log.debug("[Job " + this.getJobId() + "] [DbId: " + this._facade + "] Starting Search ReplyJob to peer " + peer + " with DSRM " + message);
        }
        this.getContext().jobQueue().addJob(new SearchReplyJob(this.getContext(), this, message, peer, duration));
    }

    protected void newPeersFound(int numNewPeers) {
    }

    private void succeed() {
        if (this._log.shouldInfo()) {
            this._log.info("[Job " + this.getJobId() + "] Successful search for [" + this._state.getTarget().toBase64().substring(0, 6) + "] after " + this._state.getAttempted().size() + " peers queried");
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[Job " + this.getJobId() + "] " + this._state);
        }
        if (this._keepStats) {
            long time = this.getContext().clock().now() - this._state.getWhenStarted();
            this.getContext().statManager().addRateData("netDb.successTime", time);
            this.getContext().statManager().addRateData("netDb.successPeers", this._state.getAttempted().size(), time);
        }
        if (this._onSuccess != null) {
            this.getContext().jobQueue().addJob(this._onSuccess);
        }
        this._facade.searchComplete(this._state.getTarget());
        this.handleDeferred(true);
        this.resend();
    }

    private void resend() {
        LeaseSet ds = this._facade.lookupLeaseSetLocally(this._state.getTarget());
        if (ds != null) {
            Set<Hash> sendTo = this._state.getRepliedPeers();
            sendTo.addAll(this._state.getPending());
            int numSent = 0;
            for (Hash peer : sendTo) {
                RouterInfo peerInfo = this.getContext().netDb().lookupRouterInfoLocally(peer);
                if (peerInfo == null) continue;
                if (this.resend(peerInfo, ds)) {
                    ++numSent;
                }
                if (numSent < 10) continue;
                break;
            }
            this.getContext().statManager().addRateData("netDb.republishQuantity", numSent, numSent);
        }
    }

    private boolean resend(RouterInfo toPeer, LeaseSet ls) {
        Hash to = toPeer.getIdentity().getHash();
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setEntry(ls);
        msg.setMessageExpiration(this.getContext().clock().now() + 8000L);
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(to);
        if (outTunnel != null) {
            if (this._log.shouldInfo()) {
                this._log.info("Resending LeaseSet to " + to + " through " + outTunnel + ": " + msg);
            }
            this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), null, to);
            return true;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Unable to resend a LeaseSet - no Outbound Exploratory tunnels");
        }
        return false;
    }

    protected void fail() {
        if (this.isLocal()) {
            if (this._log.shouldError()) {
                this._log.error("[Job " + this.getJobId() + "] Why did we fail if the target is local? [" + this._state.getTarget().toBase64().substring(0, 6) + "]", new Exception("failure cause"));
            }
            this.succeed();
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.info("[Job " + this.getJobId() + "] Search for [" + this._state.getTarget().toBase64().substring(0, 6) + "] failed");
        }
        long time = this.getContext().clock().now() - this._state.getWhenStarted();
        int attempted = this._state.getAttempted().size();
        this.getContext().statManager().addRateData("netDb.failedAttemptedPeers", attempted, time);
        if (this._keepStats) {
            this.getContext().statManager().addRateData("netDb.failedTime", time);
        }
        if (this._onFailure != null) {
            this.getContext().jobQueue().addJob(this._onFailure);
        }
        this._facade.searchComplete(this._state.getTarget());
        this.handleDeferred(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDeferred(Job onFind, Job onFail, long expiration, boolean isLease) {
        Search search = new Search(onFind, onFail, expiration, isLease);
        boolean ok = true;
        int deferred = 0;
        List<Search> list = this._deferredSearches;
        synchronized (list) {
            if (this._deferredCleared) {
                ok = false;
            } else {
                this._deferredSearches.add(search);
            }
            deferred = this._deferredSearches.size();
        }
        if (!ok) {
            if (this._log.shouldWarn()) {
                this._log.warn("Race deferred before searchCompleting?  our onFind=" + this._onSuccess + " new one: " + onFind);
            }
            this._facade.searchComplete(this._state.getTarget());
            this._facade.search(this._state.getTarget(), onFind, onFail, expiration - this.getContext().clock().now(), isLease);
            return 0;
        }
        return deferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeferred(boolean success) {
        ArrayList<Search> deferred = null;
        List<Search> list = this._deferredSearches;
        synchronized (list) {
            if (!this._deferredSearches.isEmpty()) {
                deferred = new ArrayList<Search>(this._deferredSearches);
                this._deferredSearches.clear();
            }
            this._deferredCleared = true;
        }
        if (deferred != null) {
            long now = this.getContext().clock().now();
            for (int i = 0; i < deferred.size(); ++i) {
                Search cur = (Search)deferred.get(i);
                if (cur.getExpiration() < now) {
                    this.getContext().jobQueue().addJob(cur.getOnFail());
                    continue;
                }
                if (success) {
                    this.getContext().jobQueue().addJob(cur.getOnFind());
                    continue;
                }
                this.getContext().jobQueue().addJob(cur.getOnFail());
            }
        }
    }

    @Override
    public String getName() {
        return "Start Kademlia NetDb Search";
    }

    @Override
    public String toString() {
        return super.toString() + " started " + DataHelper.formatDuration(this.getContext().clock().now() - this._startedOn) + " ago";
    }

    boolean wasAttempted(Hash peer) {
        return this._state.wasAttempted(peer);
    }

    long timeoutMs() {
        return this._timeoutMs;
    }

    boolean add(Hash peer) {
        boolean rv = this._facade.getKBuckets().add(peer);
        if (rv) {
            if (this._log.shouldDebug()) {
                this._log.debug("[Job " + this.getJobId() + "] Queueing up search for next time: [" + peer.toBase64().substring(0, 6) + "]");
            }
            Set<Hash> s = Collections.singleton(peer);
            this._facade.queueForExploration(s);
        }
        return rv;
    }

    void decrementOutstandingFloodfillSearches() {
        --this._floodfillSearchesOutstanding;
    }

    private static class Search {
        private final Job _onFind;
        private final Job _onFail;
        private final long _expiration;
        private final boolean _isLease;

        public Search(Job onFind, Job onFail, long expiration, boolean isLease) {
            this._onFind = onFind;
            this._onFail = onFail;
            this._expiration = expiration;
            this._isLease = isLease;
        }

        public Job getOnFind() {
            return this._onFind;
        }

        public Job getOnFail() {
            return this._onFail;
        }

        public long getExpiration() {
            return this._expiration;
        }
    }

    protected class FailedJob
    extends JobImpl {
        private Hash _peer;
        private boolean _isFloodfill;
        private boolean _penalizePeer;
        private long _sentOn;

        public FailedJob(RouterContext enclosingContext, RouterInfo peer) {
            this(enclosingContext, peer, true);
        }

        public FailedJob(RouterContext enclosingContext, RouterInfo peer, boolean penalizePeer) {
            super(enclosingContext);
            this._penalizePeer = penalizePeer;
            this._peer = peer.getIdentity().getHash();
            this._sentOn = enclosingContext.clock().now();
            this._isFloodfill = FloodfillNetworkDatabaseFacade.isFloodfill(peer);
        }

        @Override
        public void runJob() {
            if (this._isFloodfill) {
                SearchJob.this._floodfillSearchesOutstanding--;
            }
            if (SearchJob.this._state.completed()) {
                return;
            }
            SearchJob.this._state.replyTimeout(this._peer);
            if (this._penalizePeer) {
                if (SearchJob.this._log.shouldInfo()) {
                    SearchJob.this._log.info("[Job " + this.getJobId() + "] Penalizing [" + this._peer.toBase64().substring(0, 6) + "] for search timeout after " + (this.getContext().clock().now() - this._sentOn) + "ms");
                }
                this.getContext().profileManager().dbLookupFailed(this._peer);
            } else if (SearchJob.this._log.shouldInfo()) {
                SearchJob.this._log.info("[Job " + this.getJobId() + "] NOT (!!) penalizing [" + this._peer.toBase64().substring(0, 6) + "] for search timeout");
            }
            this.getContext().statManager().addRateData("netDb.failedPeers", 1L);
            SearchJob.this.searchNext();
        }

        @Override
        public String getName() {
            return "Timeout Kademlia Search";
        }
    }

    private class RequeuePending
    extends JobImpl {
        public RequeuePending(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public String getName() {
            return "Requeue Search with Pending";
        }

        @Override
        public void runJob() {
            SearchJob.this.searchNext();
        }
    }
}

