/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SingleSearchJob;
import net.i2p.util.SystemVersion;

class SingleLookupJob
extends JobImpl {
    private final DatabaseSearchReplyMessage _dsrm;
    public static final int MAX_TO_FOLLOW = SystemVersion.isSlow() || SystemVersion.getCPULoad() > 90 && SystemVersion.getCPULoadAvg() > 90 ? 6 : 12;

    public SingleLookupJob(RouterContext ctx, DatabaseSearchReplyMessage dsrm) {
        super(ctx);
        this._dsrm = dsrm;
    }

    @Override
    public void runJob() {
        Hash from = this._dsrm.getFromHash();
        int limit = Math.min(this._dsrm.getNumReplies(), MAX_TO_FOLLOW);
        for (int i = 0; i < limit; ++i) {
            Hash peer = this._dsrm.getReply(i);
            if (peer.equals(this.getContext().routerHash()) || peer.equals(from)) continue;
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, from));
                continue;
            }
            if (ri.getPublished() >= this.getContext().clock().now() - 3600000L && FloodfillNetworkDatabaseFacade.isFloodfill(ri)) continue;
            this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, peer));
        }
    }

    @Override
    public String getName() {
        return "Process DbStoreReplyMsg";
    }
}

