/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.crypto.SipHashInline;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.ClientManagerFacade;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.InverseCapacityComparator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.router.peermanager.SpeedComparator;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.router.util.RandomIterator;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

public class ProfileOrganizer {
    private final Log _log;
    private final RouterContext _context;
    private final Map<Hash, PeerProfile> _fastPeers;
    private final Map<Hash, PeerProfile> _highCapacityPeers;
    private final Map<Hash, PeerProfile> _wellIntegratedPeers;
    private final Map<Hash, PeerProfile> _notFailingPeers;
    private final List<Hash> _notFailingPeersList;
    private Hash _us;
    private final ProfilePersistenceHelper _persistenceHelper;
    private Set<PeerProfile> _strictCapacityOrder;
    private double _thresholdSpeedValue;
    private double _thresholdCapacityValue;
    private double _thresholdIntegrationValue;
    private final InverseCapacityComparator _comp;
    public static final String PROP_MINIMUM_FAST_PEERS = "profileOrganizer.minFastPeers";
    public static final int DEFAULT_MINIMUM_FAST_PEERS = 200;
    private static final int DEFAULT_MAXIMUM_FAST_PEERS = 300;
    private static final int ABSOLUTE_MAX_FAST_PEERS = 350;
    public static final String PROP_MINIMUM_HIGH_CAPACITY_PEERS = "profileOrganizer.minHighCapacityPeers";
    public static final int DEFAULT_MINIMUM_HIGH_CAPACITY_PEERS = 300;
    private static final int ABSOLUTE_MAX_HIGHCAP_PEERS = 400;
    private static final long[] RATES = new long[]{60000L, 300000L, 600000L, 1800000L, 3600000L, 86400000L};
    private final ReentrantReadWriteLock _reorganizeLock = new ReentrantReadWriteLock(false);
    private static final int MAX_BAD_REPLIES_PER_HOUR = 30;
    private static final long MIN_EXPIRE_TIME = 259200000L;
    private static final long MAX_EXPIRE_TIME = -1875767296L;
    private static final long ADJUST_EXPIRE_TIME = 180000L;
    private static final int ENOUGH_PROFILES = 3000;
    private long _currentExpireTime = -1875767296L;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.UK));

    public ProfileOrganizer(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ProfileOrganizer.class);
        this._comp = new InverseCapacityComparator();
        this._fastPeers = new HashMap<Hash, PeerProfile>(512);
        this._highCapacityPeers = new HashMap<Hash, PeerProfile>(512);
        this._wellIntegratedPeers = new HashMap<Hash, PeerProfile>(512);
        this._notFailingPeers = new HashMap<Hash, PeerProfile>(4096);
        this._notFailingPeersList = new ArrayList<Hash>(4096);
        this._strictCapacityOrder = new TreeSet<PeerProfile>(this._comp);
        this._persistenceHelper = new ProfilePersistenceHelper(this._context);
        this._context.statManager().createRequiredRateStat("peer.profileSortTime", "Time to sort peers (ms)", "Peers", RATES);
        this._context.statManager().createRateStat("peer.profileCoalesceTime", "Time to coalesce peer stats (ms)", "Peers", RATES);
        this._context.statManager().createRateStat("peer.profileThresholdTime", "Time to determine tier thresholds (ms)", "Peers", RATES);
        this._context.statManager().createRateStat("peer.profilePlaceTime", "Time to sort peers into tiers (ms)", "Peers", RATES);
        this._context.statManager().createRateStat("peer.profileReorgTime", "Time to reorganize peers (ms)", "Peers", RATES);
        this._context.statManager().createRequiredRateStat("peer.failedLookupRate", "NetDb Lookup failure rate", "Peers", RATES);
    }

    private void getReadLock() {
        this._reorganizeLock.readLock().lock();
    }

    private boolean tryReadLock() {
        return this._reorganizeLock.readLock().tryLock();
    }

    private void releaseReadLock() {
        this._reorganizeLock.readLock().unlock();
    }

    private boolean tryWriteLock() {
        return this._reorganizeLock.writeLock().tryLock();
    }

    private boolean getWriteLock() {
        try {
            boolean rv = this._reorganizeLock.writeLock().tryLock(3000L, TimeUnit.MILLISECONDS);
            if (!rv && this._log.shouldWarn()) {
                this._log.warn("No lock, size is: " + this._reorganizeLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void releaseWriteLock() {
        this._reorganizeLock.writeLock().unlock();
    }

    public void setUs(Hash us) {
        this._us = us;
    }

    public Hash getUs() {
        return this._us;
    }

    public double getSpeedThreshold() {
        return this._thresholdSpeedValue;
    }

    public double getCapacityThreshold() {
        return this._thresholdCapacityValue;
    }

    public double getIntegrationThreshold() {
        return this._thresholdIntegrationValue;
    }

    public PeerProfile getProfile(Hash peer) {
        if (peer != null && peer.equals(this._us)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Retrieved our own profile for the Profile Manager");
            }
            return null;
        }
        this.getReadLock();
        try {
            PeerProfile peerProfile = this.locked_getProfile(peer);
            return peerProfile;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public PeerProfile getProfileNonblocking(Hash peer) {
        if (peer != null && peer.equals(this._us)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Retrieved our own profile for the Profile Manager");
            }
            return null;
        }
        if (this.tryReadLock()) {
            try {
                PeerProfile peerProfile = this.locked_getProfile(peer);
                return peerProfile;
            }
            finally {
                this.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerProfile getOrCreateProfileNonblocking(Hash peer) {
        PeerProfile rv;
        if (peer != null && peer.equals(this._us)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Retrieved our own profile for the Profile Manager");
            }
            return null;
        }
        RouterInfo peerInfo = this._context.netDb().lookupRouterInfoLocally(peer);
        String bw = null;
        String cap = null;
        String version = "0.8";
        boolean noSSU = true;
        boolean isFF = false;
        boolean reachable = true;
        if (peerInfo != null) {
            RouterAddress ra;
            bw = peerInfo.getBandwidthTier();
            cap = peerInfo.getCapabilities();
            version = peerInfo.getVersion();
            reachable = cap.indexOf(82) >= 0;
            isFF = cap.contains("f");
            Iterator<RouterAddress> iterator = peerInfo.getAddresses().iterator();
            if (iterator.hasNext() && ((ra = iterator.next()).getTransportStyle().equals("SSU") || ra.getTransportStyle().equals("SSU2"))) {
                noSSU = false;
            }
        }
        PeerProfile prof = this.getProfile(peer);
        if (peerInfo != null) {
            if (cap != null && (!reachable || bw != null && (bw.equals("K") || bw.equals("L") || bw.equals("M") || bw.equals("N")))) {
                if (this._log.shouldInfo()) {
                    this._log.info("Not creating profile for [" + peer.toBase64().substring(0, 6) + "] -> K, L, M, N or Unreachable");
                }
                return null;
            }
            if (isFF && noSSU) {
                if (this._log.shouldInfo()) {
                    this._log.info("Not creating profile for [" + peer.toBase64().substring(0, 6) + "] -> Floodfill with SSU disabled");
                }
                return null;
            }
            if (VersionComparator.comp(version, "0.9.60") < 0) {
                if (this._log.shouldInfo()) {
                    this._log.info("Not creating profile for [" + peer.toBase64().substring(0, 6) + "] -> Older than 0.9.60");
                }
                return null;
            }
        }
        if (!this.tryReadLock()) {
            return null;
        }
        try {
            rv = this.locked_getProfile(peer);
        }
        finally {
            this.releaseReadLock();
        }
        if (rv != null) {
            return rv;
        }
        rv = new PeerProfile(this._context, peer);
        rv.setLastHeardAbout(rv.getFirstHeardAbout());
        rv.coalesceStats();
        if (!this.tryWriteLock()) {
            return null;
        }
        try {
            PeerProfile old = this.locked_getProfile(peer);
            if (old != null) {
                PeerProfile peerProfile = old;
                return peerProfile;
            }
            this._notFailingPeers.put(peer, rv);
            this._notFailingPeersList.add(peer);
            int minHighCap = this._context.getProperty(PROP_MINIMUM_HIGH_CAPACITY_PEERS, 300);
            int minFast = this._context.getProperty(PROP_MINIMUM_FAST_PEERS, 200);
            if (!(peerInfo == null || cap == null || !reachable || bw.equals("K") && bw.equals("L") && bw.equals("M") && bw.equals("N"))) {
                if (this._thresholdCapacityValue <= (double)rv.getCapacityValue() && this.isSelectable(peer) && this.countHighCapacityPeers() < this.getMaximumHighCapPeers()) {
                    this._highCapacityPeers.put(peer, rv);
                }
                if (this.countFastPeers() < minFast) {
                    this._fastPeers.put(peer, rv);
                }
                this._strictCapacityOrder.add(rv);
                if (this.countHighCapacityPeers() < minHighCap) {
                    this._highCapacityPeers.put(peer, rv);
                }
            } else if (this._highCapacityPeers.remove(peer) != null) {
                this._highCapacityPeers.remove(peer, rv);
            }
        }
        finally {
            this.releaseWriteLock();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerProfile addProfile(PeerProfile profile) {
        boolean isSlow;
        if (profile == null) {
            return null;
        }
        Hash peer = profile.getPeer();
        RouterInfo peerInfo = this._context.netDb().lookupRouterInfoLocally(peer);
        String bw = "K";
        String cap = "";
        String version = "0.8";
        boolean noSSU = true;
        boolean isFF = false;
        boolean reachable = true;
        RouterInfo us = this._context.netDb().lookupRouterInfoLocally(this._context.routerHash());
        boolean isUs = us != null && us.equals(this._context.routerHash());
        PeerProfile prof = this.getProfile(peer);
        if (peerInfo != null) {
            RouterAddress ra;
            Iterator<RouterAddress> iterator;
            bw = peerInfo.getBandwidthTier();
            cap = peerInfo.getCapabilities();
            version = peerInfo.getVersion();
            if (cap != null && !cap.equals("") && !isUs) {
                reachable = cap.indexOf(82) >= 0;
                isFF = cap.contains("f");
            }
            if ((iterator = peerInfo.getAddresses().iterator()).hasNext() && ((ra = iterator.next()).getTransportStyle().equals("SSU") || ra.getTransportStyle().equals("SSU2"))) {
                noSSU = false;
            }
        }
        boolean bl = isSlow = cap != null && !cap.equals("") && bw.equals("K") || bw.equals("L") || bw.equals("M") || bw.equals("N") || !reachable;
        if (peer != null && peer.equals(this._us)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Added our own profile to Profile Manager");
            }
            return null;
        }
        if (peer != null && isSlow) {
            if (this._log.shouldInfo()) {
                this._log.info("Not creating profile for [" + peer.toBase64().substring(0, 6) + "] -> K, L, M, N or Unreachable");
            }
            return null;
        }
        if (peer != null && isFF && noSSU) {
            if (this._log.shouldInfo()) {
                this._log.info("Not creating profile for [" + peer.toBase64().substring(0, 6) + "] -> Floodfill with SSU disabled");
            }
            return null;
        }
        if (peer != null && VersionComparator.comp(version, "0.9.60") < 0) {
            if (this._log.shouldInfo()) {
                this._log.info("Not creating profile for [" + peer.toBase64().substring(0, 6) + "] -> Older than 0.9.60");
            }
            return null;
        }
        if (this._log.shouldInfo()) {
            this._log.info("New profile created for [" + peer.toBase64().substring(0, 6) + "]");
        }
        PeerProfile old = this.getProfile(peer);
        profile.coalesceStats();
        if (!this.getWriteLock()) {
            return old;
        }
        try {
            this._notFailingPeers.put(peer, profile);
            if (old == null) {
                this._notFailingPeersList.add(peer);
            }
            if (prof != null && (isSlow || isFF && noSSU || isFF && !reachable)) {
                prof.setCapacityBonus(-30);
                this._highCapacityPeers.remove(peer, profile);
                if (this._log.shouldInfo()) {
                    if (isFF && !reachable) {
                        this._log.info("[" + peer.toBase64().substring(0, 6) + "] evicted from high cap group -> Unreachable/firewalled Floodfill");
                    } else if (isFF && noSSU) {
                        this._log.info("[" + peer.toBase64().substring(0, 6) + "] evicted from high cap group -> Floodfill with SSU disabled ");
                    } else if (isSlow) {
                        this._log.info("[" + peer.toBase64().substring(0, 6) + "] evicted from high cap group -> K, L, M, N or Unreachable");
                    }
                }
            }
            if (this._thresholdCapacityValue <= (double)profile.getCapacityValue() && this.isSelectable(peer) && this._highCapacityPeers.size() < this.getMaximumHighCapPeers() && peerInfo != null && cap != null && reachable && !isSlow && (!isFF || !noSSU)) {
                this._highCapacityPeers.put(peer, profile);
            }
            this._strictCapacityOrder.add(profile);
        }
        finally {
            this.releaseWriteLock();
        }
        return old;
    }

    private int count(Map<Hash, PeerProfile> m) {
        this.getReadLock();
        try {
            int n = m.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public int countFastPeers() {
        return this.count(this._fastPeers);
    }

    public int countHighCapacityPeers() {
        return this.count(this._highCapacityPeers);
    }

    @Deprecated
    public int countWellIntegratedPeers() {
        return this.count(this._wellIntegratedPeers);
    }

    public int countNotFailingPeers() {
        return this.count(this._notFailingPeers);
    }

    @Deprecated
    public int countFailingPeers() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeers() {
        int activePeers = 0;
        long hideBefore = this._context.clock().now() - 1200000L;
        this.getReadLock();
        try {
            for (PeerProfile profile : this._notFailingPeers.values()) {
                if (profile.getLastSendSuccessful() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastHeardFrom() < hideBefore) continue;
                ++activePeers;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return activePeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeersInLastHour() {
        int activePeers = 0;
        long hideBefore = this._context.clock().now() - 3600000L;
        this.getReadLock();
        try {
            for (PeerProfile profile : this._notFailingPeers.values()) {
                if (profile.getIsActive(3600000L)) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastSendSuccessful() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastSendFailed() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastHeardFrom() < hideBefore) continue;
                ++activePeers;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return activePeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isX(Map<Hash, PeerProfile> m, Hash peer) {
        this.getReadLock();
        try {
            boolean bl = m.containsKey(peer);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isFast(Hash peer) {
        return this.isX(this._fastPeers, peer);
    }

    public boolean isHighCapacity(Hash peer) {
        return this.isX(this._highCapacityPeers, peer);
    }

    public boolean isWellIntegrated(Hash peer) {
        return this.isX(this._wellIntegratedPeers, peer);
    }

    @Deprecated
    public boolean isFailing(Hash peer) {
        return false;
    }

    void clearProfiles() {
        if (!this.getWriteLock()) {
            return;
        }
        try {
            this._fastPeers.clear();
            this._highCapacityPeers.clear();
            this._notFailingPeers.clear();
            this._notFailingPeersList.clear();
            this._wellIntegratedPeers.clear();
            this._strictCapacityOrder.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public boolean peerSendsBadReplies(Hash peer) {
        PeerProfile profile = this.getProfile(peer);
        if (profile != null && profile.getIsExpandedDB()) {
            RateStat invalidReplyRateStat = profile.getDBHistory().getInvalidReplyRate();
            Rate invalidReplyRate = invalidReplyRateStat.getRate(3600000L);
            RateStat failedLookupRateStat = profile.getDBHistory().getFailedLookupRate();
            Rate failedLookupRate = failedLookupRateStat.getRate(3600000L);
            if (invalidReplyRate.getCurrentTotalValue() > 30.0 || invalidReplyRate.getLastTotalValue() > 30.0 || failedLookupRate.getCurrentTotalValue() > 30.0 || failedLookupRate.getLastTotalValue() > 30.0) {
                return true;
            }
        }
        return false;
    }

    public boolean exportProfile(Hash profile, OutputStream out) throws IOException {
        boolean rv;
        PeerProfile prof = this.getProfile(profile);
        boolean bl = rv = prof != null;
        if (rv) {
            this._persistenceHelper.writeProfile(prof, out);
        }
        return rv;
    }

    public void selectFastPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectFastPeers(howMany, exclude, matches, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFastPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        this.getReadLock();
        try {
            this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, mask, ipSet);
        }
        finally {
            this.releaseReadLock();
        }
        if (matches.size() < howMany) {
            if (this._log.shouldDebug()) {
                if (howMany != 1) {
                    this._log.debug("Need " + howMany + " Fast peers for tunnel build; " + matches.size() + " found - selecting remainder from High Capacity tier");
                } else {
                    this._log.debug("Need " + howMany + " Fast peer for tunnel build; " + matches.size() + " found - selecting remainder from High Capacity tier");
                }
            }
            this.selectHighCapacityPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            if (howMany != 1) {
                this._log.debug(howMany + " Fast peers selected for tunnel build");
            } else {
                this._log.debug(howMany + " Fast peer selected for tunnel build");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFastPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, SessionKey randomKey, Slice subTierMode, int mask, MaskedIPSet ipSet) {
        this.getReadLock();
        try {
            int sz;
            if (subTierMode != Slice.SLICE_ALL && ((sz = this._fastPeers.size()) < 6 || subTierMode.mask >= 3 && sz < 12)) {
                subTierMode = Slice.SLICE_ALL;
            }
            if (subTierMode != Slice.SLICE_ALL) {
                this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, randomKey, subTierMode, mask, ipSet);
            } else {
                this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, mask, ipSet);
            }
        }
        finally {
            this.releaseReadLock();
        }
        if (matches.size() < howMany) {
            if (this._log.shouldDebug()) {
                this._log.debug("Need " + howMany + " Fast peers for tunnel build; " + matches.size() + " found - selecting remainder from High Capacity peers");
            }
            this.selectHighCapacityPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug(howMany + " Fast peers selected for tunnel build");
        }
    }

    public void selectHighCapacityPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectHighCapacityPeers(howMany, exclude, matches, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectHighCapacityPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        this.getReadLock();
        try {
            this.locked_selectPeers(this._highCapacityPeers, howMany, exclude, matches, mask, ipSet);
        }
        finally {
            this.releaseReadLock();
        }
        if (matches.size() < howMany) {
            if (this._log.shouldDebug()) {
                this._log.debug("Need " + howMany + " High Capacity peers for tunnel build; " + matches.size() + " found - selecting remainder from non-failing peers");
            }
            this.selectNotFailingPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug(howMany + " High Capacity peers selected for tunnel build");
        }
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectNotFailingPeers(howMany, exclude, matches, false, 0, null);
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        this.selectNotFailingPeers(howMany, exclude, matches, false, mask, ipSet);
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing) {
        this.selectNotFailingPeers(howMany, exclude, matches, onlyNotFailing, 0, null);
    }

    public void selectNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing, int mask, MaskedIPSet ipSet) {
        if (matches.size() < howMany) {
            this.selectAllNotFailingPeers(howMany, exclude, matches, onlyNotFailing, mask);
        }
    }

    public void selectActiveNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
        this.selectActiveNotFailingPeers(howMany, exclude, matches, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectActiveNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        if (matches.size() < howMany) {
            List<Hash> connected = this._context.commSystem().getEstablished();
            if (connected != null && connected.isEmpty()) {
                return;
            }
            this.getReadLock();
            try {
                this.locked_selectActive(connected, howMany, exclude, matches, mask, ipSet);
            }
            finally {
                this.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectActiveNotFailingPeers2(int howMany, Set<Hash> exclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        List<Hash> connected;
        if (matches.size() < howMany && (connected = this._context.commSystem().getEstablished()) != null && !connected.isEmpty()) {
            this.getReadLock();
            try {
                this.locked_selectActive(connected, howMany, exclude, matches, mask, ipSet);
            }
            finally {
                this.releaseReadLock();
            }
        }
        if (matches.size() < howMany) {
            if (this._log.shouldDebug()) {
                this._log.debug("Need " + howMany + "  active, not failing peers for tunnel build; " + matches.size() + " found - selecting remainder from most reliable failing peers");
            }
            this.selectNotFailingPeers(howMany, exclude, matches, mask, ipSet);
        } else if (this._log.shouldDebug()) {
            this._log.debug(howMany + " not failing peers selected for tunnel build");
        }
    }

    public void selectAllNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing) {
        this.selectAllNotFailingPeers(howMany, exclude, matches, onlyNotFailing, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAllNotFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches, boolean onlyNotFailing, int mask) {
        if (matches.size() < howMany) {
            int orig = matches.size();
            int needed = howMany - orig;
            ArrayList<Hash> selected = new ArrayList<Hash>(needed);
            this.getReadLock();
            try {
                RandomIterator<Hash> iter = new RandomIterator<Hash>(this._notFailingPeersList);
                while (selected.size() < needed && iter.hasNext()) {
                    Hash cur = (Hash)iter.next();
                    if (matches.contains(cur) || exclude != null && exclude.contains(cur)) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("Current [" + cur.toBase64().substring(0, 6) + "] Matched? " + matches.contains(cur));
                        buf.append("\n* Excluded " + exclude.size() + ": ");
                        for (Hash h : exclude) {
                            buf.append("[").append(h.toBase64().substring(0, 6)).append("]");
                            buf.append(" ");
                        }
                        if (!this._log.shouldDebug()) continue;
                        this._log.debug("Current [" + cur.toBase64().substring(0, 6) + "] Matched? " + matches.contains(cur) + " - Excluded: " + exclude.size() + " peers");
                        continue;
                    }
                    if (onlyNotFailing && this._highCapacityPeers.containsKey(cur)) continue;
                    if (this.isSelectable(cur)) {
                        selected.add(cur);
                        continue;
                    }
                    if (!this._log.shouldDebug()) continue;
                    this._log.debug("Not selectable for tunnel build: [" + cur.toBase64().substring(0, 6) + "]");
                }
            }
            finally {
                this.releaseReadLock();
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Selecting all Not Failing peers - Strict? " + onlyNotFailing + "\n* Found " + selected.size() + " new peers: ");
            for (Hash h : selected) {
                buf.append("[").append(h.toBase64().substring(0, 6)).append("]");
                buf.append(" ");
            }
            buf.append("\n* All: " + this._notFailingPeersList.size() + "; Strict: " + this._strictCapacityOrder.size());
            if (this._log.shouldDebug()) {
                this._log.debug(buf.toString());
            }
            matches.addAll(selected);
        }
        if (matches.size() < howMany) {
            if (this._log.shouldDebug()) {
                this._log.debug("Need " + howMany + " Not Failing peers for tunnel build; " + matches.size() + " found - selecting remainder from most reliable Failing peers");
            }
            this.selectFailingPeers(howMany, exclude, matches);
        } else if (this._log.shouldDebug()) {
            this._log.debug(howMany + " Not Failing peers selected for tunnel build");
        }
    }

    @Deprecated
    private void selectFailingPeers(int howMany, Set<Hash> exclude, Set<Hash> matches) {
    }

    public Set<Hash> selectAllPeers() {
        this.getReadLock();
        try {
            HashSet<Hash> allPeers = new HashSet<Hash>(this._notFailingPeers.size() + this._highCapacityPeers.size() + this._fastPeers.size());
            allPeers.addAll(this._notFailingPeers.keySet());
            allPeers.addAll(this._highCapacityPeers.keySet());
            allPeers.addAll(this._fastPeers.keySet());
            HashSet<Hash> hashSet = allPeers;
            return hashSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    void reorganize() {
        this.reorganize(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reorganize(boolean shouldCoalesce, boolean shouldDecay) {
        long sortTime = 0L;
        int coalesceTime = 0;
        long thresholdTime = 0L;
        long placeTime = 0L;
        int profileCount = 0;
        int expiredCount = 0;
        Router r = this._context.router();
        long uptime = r != null ? r.getUptime() : 0L;
        long expireOlderThan = 604800000L;
        if (uptime > 3600000L) {
            this._currentExpireTime = this.countNotFailingPeers() > 3000 ? Math.max(this._currentExpireTime - 180000L, 259200000L) : Math.min(this._currentExpireTime + 180000L, -1875767296L);
            expireOlderThan = this._context.clock().now() - this._currentExpireTime;
        }
        if (shouldCoalesce) {
            this.getReadLock();
            try {
                long coalesceStart = System.currentTimeMillis();
                for (PeerProfile prof : this._strictCapacityOrder) {
                    if (expireOlderThan > 0L && prof.getLastSendSuccessful() <= expireOlderThan) continue;
                    prof.coalesceOnly(shouldDecay);
                }
                coalesceTime = (int)(System.currentTimeMillis() - coalesceStart);
            }
            finally {
                this.releaseReadLock();
            }
        }
        if (!this.getWriteLock()) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Set<PeerProfile> allPeers = this._strictCapacityOrder;
            TreeSet<PeerProfile> reordered = new TreeSet<PeerProfile>(this._comp);
            long sortStart = System.currentTimeMillis();
            for (PeerProfile prof : this._strictCapacityOrder) {
                if (expireOlderThan > 0L && prof.getLastSendSuccessful() <= expireOlderThan) {
                    ++expiredCount;
                    continue;
                }
                prof.updateValues();
                reordered.add(prof);
                ++profileCount;
            }
            sortTime = System.currentTimeMillis() - sortStart;
            this._strictCapacityOrder = reordered;
            long thresholdStart = System.currentTimeMillis();
            this.locked_calculateThresholds(allPeers);
            thresholdTime = System.currentTimeMillis() - thresholdStart;
            this._fastPeers.clear();
            this._highCapacityPeers.clear();
            this._notFailingPeers.clear();
            this._notFailingPeersList.clear();
            this._wellIntegratedPeers.clear();
            long placeStart = System.currentTimeMillis();
            for (PeerProfile profile : this._strictCapacityOrder) {
                this.locked_placeProfile(profile);
            }
            this.locked_demoteHighCapAsNecessary();
            this.locked_promoteFastAsNecessary();
            this.locked_demoteFastAsNecessary();
            placeTime = System.currentTimeMillis() - placeStart;
        }
        finally {
            this.releaseWriteLock();
        }
        if (this._log.shouldInfo()) {
            this._log.info("Profiles reorganized: " + expiredCount + " expired \n* Averages: [Integration: " + this._thresholdIntegrationValue + "] [Capacity: " + this._thresholdCapacityValue + "] [Speed: " + this._thresholdSpeedValue + "]");
        }
        long total = System.currentTimeMillis() - start;
        this._context.statManager().addRateData("peer.profileSortTime", sortTime, profileCount);
        this._context.statManager().addRateData("peer.profileCoalesceTime", coalesceTime, profileCount);
        this._context.statManager().addRateData("peer.profileThresholdTime", thresholdTime, profileCount);
        this._context.statManager().addRateData("peer.profilePlaceTime", placeTime, profileCount);
        this._context.statManager().addRateData("peer.profileReorgTime", total, profileCount);
    }

    private void locked_promoteFastAsNecessary() {
        int minFastPeers = this.getMinimumFastPeers();
        int numToPromote = minFastPeers - this._fastPeers.size();
        if (numToPromote > 0) {
            if (this._log.shouldInfo()) {
                this._log.info("Need to explicitly promote " + numToPromote + " peers to Fast group");
            }
            long now = this._context.clock().now();
            for (PeerProfile cur : this._strictCapacityOrder) {
                if (this._fastPeers.containsKey(cur.getPeer()) || !this.isSelectable(cur.getPeer()) || !cur.getIsActive(now)) continue;
                if (this._log.shouldDebug()) {
                    this._log.debug("Promoting [" + cur.getPeer().toBase64().substring(0, 6) + "] to Fast group");
                }
                this._fastPeers.put(cur.getPeer(), cur);
                if (--numToPromote > 0) continue;
                break;
            }
        }
    }

    private void locked_demoteFastAsNecessary() {
        int maxFastPeers = this.getMaximumFastPeers();
        int numToDemote = this._fastPeers.size() - maxFastPeers;
        if (numToDemote > 0) {
            if (this._log.shouldInfo()) {
                this._log.info("Need to explicitly demote " + numToDemote + " peers from Fast group");
            }
            TreeSet<PeerProfile> sorted = new TreeSet<PeerProfile>(new SpeedComparator());
            sorted.addAll(this._fastPeers.values());
            Iterator iter = sorted.iterator();
            for (int i = 0; i < numToDemote && iter.hasNext(); ++i) {
                this._fastPeers.remove(((PeerProfile)iter.next()).getPeer());
            }
        }
    }

    private void locked_demoteHighCapAsNecessary() {
        int maxHighCapPeers = this.getMaximumHighCapPeers();
        NetworkDatabaseFacade netDb = this._context.netDb();
        int numToDemote = this._highCapacityPeers.size() - maxHighCapPeers;
        if (numToDemote > 0) {
            Iterator<PeerProfile> iter = this._strictCapacityOrder.iterator();
            int i = 0;
            while (iter.hasNext() && i < maxHighCapPeers) {
                if (!this._highCapacityPeers.containsKey(iter.next().getPeer())) continue;
                ++i;
            }
            i = 0;
            while (iter.hasNext() && i < numToDemote) {
                Hash h = iter.next().getPeer();
                if (this._highCapacityPeers.remove(h) == null) continue;
                this._fastPeers.remove(h);
                ++i;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Demoted " + numToDemote + " peers from High Capacity group; new size is " + this._highCapacityPeers.size() + " peers");
            }
        }
    }

    private void locked_calculateThresholds(Set<PeerProfile> allPeers) {
        double totalCapacity = 0.0;
        double totalIntegration = 0.0;
        TreeSet<PeerProfile> reordered = new TreeSet<PeerProfile>(this._comp);
        long now = this._context.clock().now();
        for (PeerProfile profile : allPeers) {
            if (this._us.equals(profile.getPeer())) continue;
            if (profile.wasUnreachable()) {
                if (!this._log.shouldInfo()) continue;
                this._log.info("Excluding [" + profile.getPeer().toBase64().substring(0, 6) + "] from fast/highcap groups -> Unreachable");
                continue;
            }
            if (profile.getPeer() == null) continue;
            RouterInfo peerInfo = this._context.netDb().lookupRouterInfoLocally(profile.getPeer());
            String bw = "K";
            if (peerInfo != null && peerInfo.getBandwidthTier() != null) {
                bw = peerInfo.getBandwidthTier();
            }
            if (peerInfo != null && (bw.equals("K") || bw.equals("L") || bw.equals("M"))) {
                if (!this._log.shouldInfo()) continue;
                this._log.info("Excluding [" + profile.getPeer().toBase64().substring(0, 6) + "] from fast/highcap groups -> K, L or M tier");
                continue;
            }
            if (!profile.getIsActive(now)) continue;
            totalCapacity += (double)profile.getCapacityValue();
            totalIntegration += (double)profile.getIntegrationValue();
            reordered.add(profile);
        }
        this.locked_calculateCapacityThreshold(totalCapacity, reordered);
        this.locked_calculateSpeedThreshold(reordered);
        this._thresholdIntegrationValue = totalIntegration > 0.0 ? 1.0 * ProfileOrganizer.avg(totalIntegration, reordered.size()) : 1.0;
    }

    private void locked_calculateCapacityThreshold(double totalCapacity, Set<PeerProfile> reordered) {
        int numNotFailing = reordered.size();
        double meanCapacity = ProfileOrganizer.avg(totalCapacity, numNotFailing);
        int minHighCapacityPeers = this.getMinimumHighCapacityPeers();
        int numExceedingMean = 0;
        double thresholdAtMedian = 0.0;
        double thresholdAtMinHighCap = 0.0;
        double thresholdAtLowest = 5.0;
        int cur = 0;
        for (PeerProfile profile : reordered) {
            double val = profile.getCapacityValue();
            if (val > meanCapacity) {
                ++numExceedingMean;
            }
            if (cur == reordered.size() / 2) {
                thresholdAtMedian = val;
            }
            if (cur == minHighCapacityPeers - 1) {
                thresholdAtMinHighCap = val;
            }
            if (cur == reordered.size() - 1) {
                thresholdAtLowest = val;
            }
            ++cur;
        }
        if (numExceedingMean >= minHighCapacityPeers) {
            if (this._log.shouldInfo()) {
                this._log.info("Our average capacity (" + meanCapacity + ") is good and includes " + numExceedingMean + " peer profiles");
            }
            this._thresholdCapacityValue = meanCapacity;
        } else if (meanCapacity > thresholdAtMedian && reordered.size() / 2 > minHighCapacityPeers) {
            if (this._log.shouldInfo()) {
                this._log.info("Our average capacity (" + meanCapacity + ") is greater than the median, so we've satisified the threshold (" + thresholdAtMinHighCap + ") to get the min High Capacity peers");
            }
            this._thresholdCapacityValue = thresholdAtMinHighCap;
        } else if (reordered.size() / 2 >= minHighCapacityPeers) {
            if (this._log.shouldInfo()) {
                this._log.info("Our average capacity (" + meanCapacity + ") is skewed under the median, so we're using the median threshold " + thresholdAtMedian);
            }
            this._thresholdCapacityValue = thresholdAtMedian;
        } else {
            if (this._log.shouldInfo()) {
                this._log.info("Our average capacity (" + meanCapacity + ") is good but we don't have enough peers (" + numExceedingMean + " required)");
            }
            this._thresholdCapacityValue = Math.max(thresholdAtMinHighCap, thresholdAtLowest);
        }
        if (this._thresholdCapacityValue <= 5.0) {
            this._thresholdCapacityValue = 5.0001;
        }
    }

    private void locked_calculateSpeedThreshold(Set<PeerProfile> reordered) {
        this.locked_calculateSpeedThresholdMean(reordered);
    }

    private void locked_calculateSpeedThresholdMean(Set<PeerProfile> reordered) {
        double total = 0.0;
        int count = 0;
        int maxHighCapPeers = this.getMaximumHighCapPeers();
        int minHighCapPeers = this.getMinimumHighCapacityPeers();
        int maxFastPeers = this.getMaximumFastPeers();
        for (PeerProfile profile : reordered) {
            if (!((double)profile.getCapacityValue() >= this._thresholdCapacityValue)) break;
            total += (double)profile.getSpeedValue();
            int speedBonus = profile.getSpeedBonus();
            if (speedBonus >= 9999999) {
                total -= 9999999.0;
            }
            if (count++ <= minHighCapPeers / 2 * 3) continue;
            break;
        }
        if (count > 0) {
            this._thresholdSpeedValue = total / (double)count / 7.0 * 5.0;
        }
        if (this._log.shouldInfo()) {
            this._log.info("Threshold value for speed: " + this._thresholdSpeedValue + " (calculated from " + count + " profiles)");
        }
    }

    private static final double avg(double total, double quantity) {
        if (total > 0.0 && quantity > 0.0) {
            return total / quantity;
        }
        return 0.0;
    }

    private PeerProfile locked_getProfile(Hash peer) {
        PeerProfile cur = this._notFailingPeers.get(peer);
        return cur;
    }

    private void locked_selectPeers(Map<Hash, PeerProfile> peers, int howMany, Set<Hash> toExclude, Set<Hash> matches) {
        this.locked_selectPeers(peers, howMany, toExclude, matches, 0, null);
    }

    private void locked_selectPeers(Map<Hash, PeerProfile> peers, int howMany, Set<Hash> toExclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        ArrayList<Hash> all = new ArrayList<Hash>(peers.keySet());
        RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
        while (matches.size() < howMany && iter.hasNext()) {
            Hash peer = (Hash)iter.next();
            if (toExclude != null && toExclude.contains(peer) || matches.contains(peer) || this._us != null && this._us.equals(peer)) continue;
            boolean ok = this.isSelectable(peer);
            if (ok) {
                boolean bl = ok = mask <= 0 || this.notRestricted(peer, ipSet, mask);
                if (!ok && this._log.shouldWarn()) {
                    this._log.warn("IP address restriction prevents [" + peer.toBase64().substring(0, 6) + "] from joining " + matches);
                }
            } else if (toExclude != null) {
                toExclude.add(peer);
            }
            if (ok) {
                matches.add(peer);
                continue;
            }
            matches.remove(peer);
        }
    }

    private void locked_selectActive(List<Hash> connected, int howMany, Set<Hash> toExclude, Set<Hash> matches, int mask, MaskedIPSet ipSet) {
        RandomIterator<Hash> iter = new RandomIterator<Hash>(connected);
        while (matches.size() < howMany && iter.hasNext()) {
            Hash peer = (Hash)iter.next();
            if (toExclude != null && toExclude.contains(peer) || matches.contains(peer) || this._us.equals(peer)) continue;
            boolean ok = this.isSelectable(peer);
            if (ok) {
                boolean bl = ok = mask <= 0 || this.notRestricted(peer, ipSet, mask);
                if (!ok && this._log.shouldWarn()) {
                    this._log.warn("IP restriction prevents " + peer + " from joining " + matches);
                }
            } else if (toExclude != null) {
                toExclude.add(peer);
            }
            if (!ok) continue;
            matches.add(peer);
        }
    }

    private boolean notRestricted(Hash peer, MaskedIPSet IPSet, int mask) {
        MaskedIPSet peerIPs = new MaskedIPSet(this._context, peer, mask);
        if (IPSet.containsAny(peerIPs)) {
            return false;
        }
        IPSet.addAll(peerIPs);
        return true;
    }

    private void locked_selectPeers(Map<Hash, PeerProfile> peers, int howMany, Set<Hash> toExclude, Set<Hash> matches, SessionKey randomKey, Slice subTierMode, int mask, MaskedIPSet ipSet) {
        ArrayList<Hash> all = new ArrayList<Hash>(peers.keySet());
        byte[] rk = randomKey.getData();
        long k0 = DataHelper.fromLong8(rk, 0);
        long k1 = DataHelper.fromLong8(rk, 8);
        RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
        while (matches.size() < howMany && iter.hasNext()) {
            int subTier;
            Hash peer = (Hash)iter.next();
            if (toExclude != null && toExclude.contains(peer) || matches.contains(peer) || this._us.equals(peer) || ((subTier = this.getSubTier(peer, k0, k1)) & subTierMode.mask) != subTierMode.val) continue;
            boolean ok = this.isSelectable(peer);
            if (ok) {
                boolean bl = ok = mask <= 0 || this.notRestricted(peer, ipSet, mask);
                if (!ok && this._log.shouldWarn()) {
                    this._log.warn("IP address restriction prevents [" + peer.toBase64().substring(0, 6) + "] from joining " + matches);
                }
            } else if (toExclude != null) {
                toExclude.add(peer);
            }
            if (ok) {
                matches.add(peer);
                continue;
            }
            matches.remove(peer);
        }
    }

    private int getSubTier(Hash peer, long k0, long k1) {
        return (int)SipHashInline.hash24(k0, k1, peer.getData()) & 3;
    }

    public boolean isSelectable(Hash peer) {
        NetworkDatabaseFacade netDb = this._context.netDb();
        if (netDb == null) {
            return true;
        }
        if (this._context.router() == null) {
            return true;
        }
        if (this._context.banlist() != null && this._context.banlist().isBanlisted(peer)) {
            if (this._log.shouldDebug()) {
                this._log.debug("[" + peer.toBase64().substring(0, 6) + "] is banlisted; not using it to build tunnels");
            }
            return false;
        }
        RouterInfo info = (RouterInfo)this._context.netDb().lookupLocallyWithoutValidation(peer);
        if (null != info) {
            String tier = DataHelper.stripHTML(info.getBandwidthTier());
            if (info.isHidden()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[" + peer.toBase64().substring(0, 6) + "] is marked as hidden; not using it to build tunnels");
                }
                return false;
            }
            boolean exclude = TunnelPeerSelector.shouldExclude(this._context, info);
            return !exclude;
        }
        return false;
    }

    private void locked_placeProfile(PeerProfile profile) {
        Hash peer = profile.getPeer();
        int minHighCap = this._context.getProperty(PROP_MINIMUM_HIGH_CAPACITY_PEERS, 300);
        this._fastPeers.remove(peer);
        this._highCapacityPeers.remove(peer);
        this._wellIntegratedPeers.remove(peer);
        this._notFailingPeers.put(peer, profile);
        this._notFailingPeersList.add(peer);
        if (this._thresholdCapacityValue <= (double)profile.getCapacityValue() && this.isSelectable(peer) && (this._context.commSystem() == null || !this._context.commSystem().isInStrictCountry(peer))) {
            this._highCapacityPeers.put(peer, profile);
            if (this._log.shouldDebug()) {
                this._log.debug("Promoting [" + peer.toBase64().substring(0, 6) + "] to High Capacity group");
            }
            if (this._thresholdSpeedValue <= (double)profile.getSpeedValue()) {
                if (!profile.getIsActive()) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Not promoting  [" + peer.toBase64().substring(0, 6) + "] to Fast group (inactive)");
                    }
                } else {
                    this._fastPeers.put(peer, profile);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Promoting [" + peer.toBase64().substring(0, 6) + "] to Fast group");
                    }
                }
            }
        } else if (this.countHighCapacityPeers() < minHighCap && this.isSelectable(peer) && !this._context.commSystem().isInStrictCountry(peer)) {
            this._highCapacityPeers.put(peer, profile);
        }
        if (this._thresholdIntegrationValue <= (double)profile.getIntegrationValue()) {
            this._wellIntegratedPeers.put(peer, profile);
            if (this._log.shouldDebug()) {
                this._log.debug("Promoting [" + peer.toBase64().substring(0, 6) + "] to Integrated group");
            }
        }
    }

    private boolean shouldDrop(PeerProfile profile) {
        return false;
    }

    protected int getMinimumFastPeers() {
        ClientManagerFacade cm = this._context.clientManager();
        if (cm == null) {
            return 300;
        }
        int known = this._context.netDb().getKnownRouters();
        int def = Math.max(300, 10 * cm.listClients().size() + 200 - 2);
        if (known > 3000) {
            return this._context.getProperty(PROP_MINIMUM_FAST_PEERS, Math.min(known / 30, 300));
        }
        return this._context.getProperty(PROP_MINIMUM_FAST_PEERS, 200);
    }

    protected int getMaximumFastPeers() {
        int known = this._context.netDb().getKnownRouters();
        if (known > 3000) {
            return known / 20;
        }
        return 350;
    }

    protected int getMaximumHighCapPeers() {
        int known = this._context.netDb().getKnownRouters();
        if (known > 3000) {
            return Math.min(known / 10, 400);
        }
        return 400;
    }

    protected int getMinimumHighCapacityPeers() {
        int known = this._context.netDb().getKnownRouters();
        if (known > 3000) {
            return this._context.getProperty(PROP_MINIMUM_HIGH_CAPACITY_PEERS, Math.max(known / 15, 300));
        }
        return this._context.getProperty(PROP_MINIMUM_HIGH_CAPACITY_PEERS, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: profileorganizer file.txt.gz [file2.txt.gz] ...");
            System.exit(1);
        }
        RouterContext ctx = new RouterContext(null);
        ProfileOrganizer organizer = new ProfileOrganizer(ctx);
        organizer.setUs(Hash.FAKE_HASH);
        ProfilePersistenceHelper helper = new ProfilePersistenceHelper(ctx);
        for (int i = 0; i < args.length; ++i) {
            PeerProfile profile = helper.readProfile(new File(args[i]), 0L);
            if (profile == null) {
                System.err.println("Could not load profile " + args[i]);
                continue;
            }
            organizer.addProfile(profile);
        }
        organizer.reorganize();
        DecimalFormat fmt = new DecimalFormat("0000.0");
        long now = ctx.clock().now();
        for (Hash peer : organizer.selectAllPeers()) {
            PeerProfile profile = organizer.getProfile(peer);
            if (!profile.getIsActive(now)) {
                System.out.println("Peer " + peer.toBase64().substring(0, 4) + " [" + (organizer.isFast(peer) ? "IF+R" : (organizer.isHighCapacity(peer) ? "IR  " : (organizer.isFailing(peer) ? "IX  " : "I   "))) + "]:  Speed:\t" + fmt.format(profile.getSpeedValue()) + " Capacity:\t" + fmt.format(profile.getCapacityValue()) + " Integration:\t" + fmt.format(profile.getIntegrationValue()) + " Active?\t" + profile.getIsActive(now));
                continue;
            }
            System.out.println("Peer " + peer.toBase64().substring(0, 4) + " [" + (organizer.isFast(peer) ? "F+R " : (organizer.isHighCapacity(peer) ? "R   " : (organizer.isFailing(peer) ? "X   " : "    "))) + "]:  Speed:\t" + fmt.format(profile.getSpeedValue()) + " Capacity:\t" + fmt.format(profile.getCapacityValue()) + " Integration:\t" + fmt.format(profile.getIntegrationValue()) + " Active?\t" + profile.getIsActive(now));
        }
        System.out.println("Thresholds:");
        System.out.println("Speed:       " + ProfileOrganizer.num(organizer.getSpeedThreshold()) + " (" + organizer.countFastPeers() + " fast peers)");
        System.out.println("Capacity:    " + ProfileOrganizer.num(organizer.getCapacityThreshold()) + " (" + organizer.countHighCapacityPeers() + " reliable peers)");
    }

    public static enum Slice {
        SLICE_ALL(0, 0),
        SLICE_0_1(2, 0),
        SLICE_2_3(2, 2),
        SLICE_0(3, 0),
        SLICE_1(3, 1),
        SLICE_2(3, 2),
        SLICE_3(3, 3);

        final int mask;
        final int val;

        private Slice(int mask, int val) {
            this.mask = mask;
            this.val = val;
        }
    }
}

