/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.TunnelHistory;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

class ProfilePersistenceHelper {
    private final Log _log;
    private final RouterContext _context;
    public static final String PROP_PEER_PROFILE_DIR = "router.profileDir";
    public static final String DEFAULT_PEER_PROFILE_DIR = "peerProfiles";
    private static final String NL = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private static final String HR = "# ----------------------------------------------------------------------------------------";
    private static final String PREFIX = "profile-";
    private static final String SUFFIX = ".txt.gz";
    private static final String UNCOMPRESSED_SUFFIX = ".txt";
    private static final String OLD_SUFFIX = ".dat";
    private static final int MIN_NAME_LENGTH = "profile-".length() + 44 + ".dat".length();
    private static final String DIR_PREFIX = "p";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final int LIMIT_PROFILES = SystemVersion.isSlow() ? 1000 : 4000;
    private final File _profileDir;
    private Hash _us;

    public ProfilePersistenceHelper(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ProfilePersistenceHelper.class);
        String dir = this._context.getProperty(PROP_PEER_PROFILE_DIR, DEFAULT_PEER_PROFILE_DIR);
        this._profileDir = new SecureDirectory(this._context.getRouterDir(), dir);
        if (!this._profileDir.exists()) {
            this._profileDir.mkdirs();
        }
        for (int j = 0; j < B64.length(); ++j) {
            SecureDirectory subdir = new SecureDirectory(this._profileDir, DIR_PREFIX + B64.charAt(j));
            if (subdir.exists()) continue;
            ((File)subdir).mkdir();
        }
    }

    public void setUs(Hash routerIdentHash) {
        this._us = routerIdentHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeProfile(PeerProfile profile) {
        File f = this.pickFile(profile);
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new GZIPOutputStream(new SecureFileOutputStream(f)));
            this.writeProfile(profile, fos, false);
        }
        catch (IOException ioe) {
            this._log.error("Error writing profile to " + f);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void writeProfile(PeerProfile profile, OutputStream out) throws IOException {
        this.writeProfile(profile, out, true);
    }

    public void writeProfile(PeerProfile profile, OutputStream out, boolean addComments) throws IOException {
        String groups = null;
        if (!this._context.profileOrganizer().isHighCapacity(profile.getPeer())) {
            groups = "Standard";
        } else {
            groups = this._context.profileOrganizer().isFast(profile.getPeer()) ? "Fast, High Capacity" : "High Capacity";
            if (this._context.profileOrganizer().isWellIntegrated(profile.getPeer())) {
                groups = groups + ", Integrated";
            }
        }
        StringBuilder buf = new StringBuilder(512);
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(profile.getPeer());
        int speed = Math.round(profile.getSpeedValue());
        int integration = Math.round(profile.getIntegrationValue());
        int capacity = Math.round(profile.getCapacityValue());
        if (addComments) {
            buf.append(HR).append(NL);
            buf.append("# Profile for peer: ").append(profile.getPeer().toBase64()).append(NL);
            if (this._us != null) {
                buf.append("# as calculated by ").append(this._us.toBase64()).append(NL);
            }
            buf.append(HR).append(NL);
            buf.append("#").append(TAB).append("Version:").append(TAB);
            if (info != null) {
                String version = DataHelper.stripHTML(info.getVersion());
                buf.append(version);
            }
            buf.append(NL);
            buf.append("#").append(TAB).append("Signature:").append(TAB);
            if (info != null) {
                buf.append(DataHelper.stripHTML(info.getIdentity().getSigningPublicKey().getType().toString()));
            }
            buf.append(NL);
            buf.append("#").append(TAB).append("Capabilities:").append(TAB);
            if (info != null) {
                buf.append(DataHelper.stripHTML(info.getCapabilities()).toUpperCase().replace("XO", "X").replace("PO", "P"));
            }
            buf.append(NL);
            buf.append("#").append(TAB).append("Speed:").append(TAB).append(TAB).append(speed).append(" Bps").append(NL);
            buf.append("#").append(TAB).append("Capacity:").append(TAB).append(capacity).append(" tunnels/hour").append(NL);
            buf.append("#").append(TAB).append("Integration:").append(TAB).append(integration).append(" peers").append(NL);
            buf.append("#").append(TAB).append("Groups:").append(TAB).append(groups).append(NL);
            buf.append(HR).append(NL).append(NL);
        }
        if (profile.getSpeedBonus() != 0) {
            ProfilePersistenceHelper.add(buf, addComments, "speedBonus", profile.getSpeedBonus(), "Manual Speed Score adjustment: " + profile.getSpeedBonus());
        }
        if (profile.getCapacityBonus() != 0) {
            ProfilePersistenceHelper.add(buf, addComments, "capacityBonus", profile.getCapacityBonus(), "Manual Capacity Score adjustment: " + profile.getCapacityBonus());
        }
        if (profile.getIntegrationBonus() != 0) {
            ProfilePersistenceHelper.add(buf, addComments, "integrationBonus", profile.getIntegrationBonus(), "Manual Integration Score adjustment: " + profile.getIntegrationBonus());
        }
        ProfilePersistenceHelper.addDate(buf, addComments, "firstHeardAbout", profile.getFirstHeardAbout(), "First reference to peer received:");
        ProfilePersistenceHelper.addDate(buf, addComments, "lastHeardAbout", profile.getLastHeardAbout(), "Last reference to peer received:");
        if (profile.getLastHeardFrom() != 0L) {
            ProfilePersistenceHelper.addDate(buf, addComments, "lastHeardFrom", profile.getLastHeardFrom(), "Last message from peer received:");
        }
        if (profile.getLastSendSuccessful() != 0L) {
            ProfilePersistenceHelper.addDate(buf, addComments, "lastSentToSuccessfully", profile.getLastSendSuccessful(), "Last successful message sent to peer:");
        }
        if (profile.getLastSendFailed() != 0L) {
            ProfilePersistenceHelper.addDate(buf, addComments, "lastFailedSend", profile.getLastSendFailed(), "Last failed message to sent peer:");
        }
        if (profile.getTunnelTestTimeAverage() != 0.0f) {
            ProfilePersistenceHelper.add(buf, addComments, "tunnelTestTimeAverage", (long)profile.getTunnelTestTimeAverage(), "Average peer response time: " + (long)profile.getTunnelTestTimeAverage());
        }
        ProfilePersistenceHelper.add(buf, addComments, "tunnelPeakThroughput", (long)profile.getPeakThroughputKBps(), "Tunnel Peak throughput: " + (long)profile.getPeakThroughputKBps() + "KB/s");
        ProfilePersistenceHelper.add(buf, addComments, "tunnelPeakTunnelThroughput", (long)profile.getPeakTunnelThroughputKBps(), "Tunnel Peak Tunnel throughput: " + (long)profile.getPeakTunnelThroughputKBps() + "KB/s");
        ProfilePersistenceHelper.add(buf, addComments, "tunnelPeakTunnel1mThroughput", (long)profile.getPeakTunnel1mThroughputKBps(), "Tunnel Peak Tunnel throughput for 1 minute: " + (long)profile.getPeakTunnel1mThroughputKBps() + "KB/s");
        if (addComments) {
            buf.append(NL);
        }
        out.write(buf.toString().getBytes("UTF-8"));
        if (profile.getIsExpanded()) {
            profile.getTunnelHistory().store(out, addComments);
            profile.getTunnelCreateResponseTime().store(out, "tunnelCreateResponseTime", addComments);
            profile.getTunnelTestResponseTime().store(out, "tunnelTestResponseTime", addComments);
            if (profile.getPeerTestResponseTime() != null) {
                profile.getPeerTestResponseTime().store(out, "peerTestResponseTime", addComments);
            }
        }
        if (profile.getIsExpandedDB()) {
            profile.getDBHistory().store(out, addComments);
            profile.getDbIntroduction().store(out, "dbIntroduction", addComments);
            profile.getDbResponseTime().store(out, "dbResponseTime", addComments);
        }
    }

    private static void addDate(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            String when = val > 0L ? new Date(val).toString() : "Never";
            ProfilePersistenceHelper.add(buf, true, name, val, description + ' ' + when);
        } else {
            ProfilePersistenceHelper.add(buf, false, name, val, description);
        }
    }

    private static void add(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            buf.append("# ").append(description).append(NL);
        } else {
            buf.append(name).append('=').append(val).append(NL);
        }
    }

    public List<PeerProfile> readProfiles() {
        long start = System.currentTimeMillis();
        long down = this._context.router().getEstimatedDowntime();
        long cutoff = down < 1296000000L ? start - down - 604800000L : start - 259200000L;
        List<File> files = this.selectFiles();
        if (files.size() > LIMIT_PROFILES) {
            Collections.shuffle(files, this._context.random());
        }
        ArrayList<PeerProfile> profiles = new ArrayList<PeerProfile>(Math.min(LIMIT_PROFILES, files.size()));
        int count = 0;
        for (File f : files) {
            if (count >= LIMIT_PROFILES) {
                f.delete();
                continue;
            }
            PeerProfile profile = this.readProfile(f, cutoff);
            if (profile == null) continue;
            profiles.add(profile);
            ++count;
        }
        long duration = System.currentTimeMillis() - start;
        if (this._log.shouldInfo()) {
            this._log.info("Loaded " + count + " peer profiles in " + duration + "ms");
        }
        return profiles;
    }

    private List<File> selectFiles() {
        ProfileFilter filter = new ProfileFilter();
        File[] files = this._profileDir.listFiles(filter);
        if (files != null && files.length > 0) {
            this.migrate(files);
        }
        ArrayList<File> rv = new ArrayList<File>(1024);
        for (int j = 0; j < B64.length(); ++j) {
            File subdir = new File(this._profileDir, DIR_PREFIX + B64.charAt(j));
            files = subdir.listFiles(filter);
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                rv.add(files[i]);
            }
        }
        return rv;
    }

    private void migrate(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File from = files[i];
            if (!from.isFile()) continue;
            File dir = new File(this._profileDir, DIR_PREFIX + from.getName().charAt(PREFIX.length()));
            File to = new File(dir, from.getName());
            FileUtil.rename(from, to);
        }
    }

    public int deleteOldProfiles(long age) {
        long cutoff = System.currentTimeMillis() - age;
        List<File> files = this.selectFiles();
        int i = 0;
        for (File f : files) {
            if (!f.isFile() || f.lastModified() >= cutoff) continue;
            ++i;
            f.delete();
        }
        if (this._log.shouldWarn() && i > 0) {
            this._log.warn("Deleted " + i + " STALE peer profiles");
        }
        return i;
    }

    public PeerProfile readProfile(File file, long cutoff) {
        if (file.lastModified() < cutoff) {
            if (this._log.shouldWarn()) {
                this._log.warn("Not deleting STALE peer profile " + file.getName() + " -> Will expire when read at startup");
            }
            return null;
        }
        Hash peer = this.getHash(file.getName());
        try {
            if (peer == null) {
                if (this._log.shouldError()) {
                    this._log.error("Peer profile: " + file.getName() + " is not a valid hash");
                }
                file.delete();
                return null;
            }
            PeerProfile profile = new PeerProfile(this._context, peer);
            Properties props = new Properties();
            this.loadProps(props, file);
            long lastSentToSuccessfully = ProfilePersistenceHelper.getLong(props, "lastSentToSuccessfully");
            long lastHeardFrom = ProfilePersistenceHelper.getLong(props, "lastHeardFrom");
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(profile.getPeer());
            String caps = "";
            if (info == null) {
                file.delete();
                return null;
            }
            caps = DataHelper.stripHTML(info.getCapabilities());
            if (lastSentToSuccessfully <= cutoff && lastHeardFrom <= cutoff) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Dropping STALE profile: " + file.getName());
                }
                file.delete();
                return null;
            }
            if (caps.contains("K") || caps.contains("L") || caps.contains("M") || caps.contains("N") || caps.contains("U") || !caps.contains("R")) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Dropping uninteresting profile: " + file.getName());
                }
                file.delete();
                return null;
            }
            if (file.getName().endsWith(OLD_SUFFIX)) {
                String newName = file.getAbsolutePath();
                boolean success = file.renameTo(new File(newName = newName.substring(0, newName.length() - OLD_SUFFIX.length()) + SUFFIX));
                if (!success) {
                    file.delete();
                }
            }
            profile.setCapacityBonus((int)ProfilePersistenceHelper.getLong(props, "capacityBonus"));
            profile.setIntegrationBonus((int)ProfilePersistenceHelper.getLong(props, "integrationBonus"));
            profile.setSpeedBonus((int)ProfilePersistenceHelper.getLong(props, "speedBonus"));
            long fh = ProfilePersistenceHelper.getLong(props, "firstHeardAbout");
            if (fh <= 0L) {
                fh = file.lastModified();
            }
            profile.setFirstHeardAbout(fh);
            long lh = ProfilePersistenceHelper.getLong(props, "lastHeardAbout");
            if (lh <= 0L) {
                lh = fh;
            }
            profile.setLastHeardAbout(lh);
            profile.setLastSendSuccessful(ProfilePersistenceHelper.getLong(props, "lastSentToSuccessfully"));
            profile.setLastSendFailed(ProfilePersistenceHelper.getLong(props, "lastFailedSend"));
            profile.setLastHeardFrom(ProfilePersistenceHelper.getLong(props, "lastHeardFrom"));
            profile.setTunnelTestTimeAverage(ProfilePersistenceHelper.getFloat(props, "tunnelTestTimeAverage"));
            profile.setPeakThroughputKBps(ProfilePersistenceHelper.getFloat(props, "tunnelPeakThroughput"));
            profile.setPeakTunnelThroughputKBps(ProfilePersistenceHelper.getFloat(props, "tunnelPeakTunnelThroughput"));
            profile.setPeakTunnel1mThroughputKBps(ProfilePersistenceHelper.getFloat(props, "tunnelPeakTunnel1mThroughput"));
            profile.getTunnelHistory().load(props);
            if (!(ProfilePersistenceHelper.getLong(props, "dbHistory.lastLookupSuccessful") <= 0L && ProfilePersistenceHelper.getLong(props, "dbHistory.lastLookupFailed") <= 0L && ProfilePersistenceHelper.getLong(props, "dbHistory.lastStoreSuccessful") <= 0L && (ProfilePersistenceHelper.getLong(props, "dbHistory.lastStoreFailed") <= 0L || caps.contains("K") && caps.contains("L") && caps.contains("M") && caps.contains("N") && caps.contains("U")))) {
                profile.expandDBProfile();
                profile.getDBHistory().load(props);
                profile.getDbIntroduction().load(props, "dbIntroduction", true);
                profile.getDbResponseTime().load(props, "dbResponseTime", true);
            }
            if (!caps.contains("K") || !caps.contains("L") || !caps.contains("M") || !caps.contains("N") || !caps.contains("U") && caps.contains("R")) {
                profile.getTunnelCreateResponseTime().load(props, "tunnelCreateResponseTime", true);
                profile.getTunnelTestResponseTime().load(props, "tunnelTestResponseTime", true);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Loaded profile for [" + peer.toBase64().substring(0, 6) + "] from " + file.getName());
            }
            this.fixupFirstHeardAbout(profile);
            return profile;
        }
        catch (Exception e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error loading properties from " + file.getAbsolutePath(), e);
            }
            file.delete();
            return null;
        }
    }

    private void fixupFirstHeardAbout(PeerProfile p) {
        TunnelHistory th;
        long min = Long.MAX_VALUE;
        long t = p.getLastHeardAbout();
        if (t > 0L && t < min) {
            min = t;
        }
        if ((t = p.getLastSendSuccessful()) > 0L && t < min) {
            min = t;
        }
        if ((t = p.getLastSendFailed()) > 0L && t < min) {
            min = t;
        }
        if ((t = p.getLastHeardFrom()) > 0L && t < min) {
            min = t;
        }
        if ((th = p.getTunnelHistory()) != null) {
            t = th.getLastAgreedTo();
            if (t > 0L && t < min) {
                min = t;
            }
            if ((t = th.getLastRejectedCritical()) > 0L && t < min) {
                min = t;
            }
            if ((t = th.getLastRejectedBandwidth()) > 0L && t < min) {
                min = t;
            }
            if ((t = th.getLastRejectedTransient()) > 0L && t < min) {
                min = t;
            }
            if ((t = th.getLastRejectedProbabalistic()) > 0L && t < min) {
                min = t;
            }
            if ((t = th.getLastFailed()) > 0L && t < min) {
                min = t;
            }
        }
        long fha = p.getFirstHeardAbout();
        if (min > 0L && min < Long.MAX_VALUE && (fha <= 0L || min < fha)) {
            p.setFirstHeardAbout(min);
            if (this._log.shouldDebug()) {
                this._log.debug("Fixed FirstHeardAbout time for [" + p.getPeer().toBase64().substring(0, 6) + "] to " + new Date(min));
            }
        }
    }

    static long getLong(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static final float getFloat(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Float.parseFloat(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(Properties props, File file) throws IOException {
        InputStream fin = null;
        try {
            fin = new BufferedInputStream(new FileInputStream(file), 1);
            fin.mark(1);
            int c = fin.read();
            fin.reset();
            if (c == 35) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Loading " + file.getName());
                }
                DataHelper.loadProps(props, fin);
            } else {
                if (this._log.shouldDebug()) {
                    this._log.debug("Loading " + file.getName());
                }
                DataHelper.loadProps(props, new GZIPInputStream(fin));
            }
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private Hash getHash(String name) {
        if (name.length() < PREFIX.length() + 44) {
            return null;
        }
        String key = name.substring(PREFIX.length());
        key = key.substring(0, 44);
        try {
            byte[] b = Base64.decode(key);
            if (b == null) {
                return null;
            }
            Hash h = Hash.create(b);
            return h;
        }
        catch (RuntimeException dfe) {
            this._log.warn("Invalid Base64 [" + key + "]", dfe);
            return null;
        }
    }

    private File pickFile(PeerProfile profile) {
        String hash = profile.getPeer().toBase64();
        File dir = new File(this._profileDir, DIR_PREFIX + hash.charAt(0));
        return new File(dir, PREFIX + hash + SUFFIX);
    }

    private static class ProfileFilter
    implements FilenameFilter {
        private ProfileFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.startsWith(ProfilePersistenceHelper.PREFIX) && filename.length() >= MIN_NAME_LENGTH && (filename.endsWith(ProfilePersistenceHelper.SUFFIX) || filename.endsWith(ProfilePersistenceHelper.OLD_SUFFIX) || filename.endsWith(ProfilePersistenceHelper.UNCOMPRESSED_SUFFIX));
        }
    }
}

