/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.data.DataHelper;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

public class CoalesceStatsEvent
implements SimpleTimer.TimedEvent {
    private final RouterContext _ctx;
    private final long _maxMemory;
    private static final long LOW_MEMORY_THRESHOLD = 0x500000L;

    public CoalesceStatsEvent(RouterContext ctx) {
        this._ctx = ctx;
        StatManager sm = ctx.statManager();
        sm.createRequiredRateStat("bw.receiveBps", CoalesceStatsEvent._x("Message receive rate (B/s)"), "Router", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("bw.sendBps", CoalesceStatsEvent._x("Message send rate (B/s)"), "Router", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("bw.sendRate", CoalesceStatsEvent._x("Low-level send rate (B/s)"), "Router", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("bw.recvRate", CoalesceStatsEvent._x("Low-level receive rate (B/s)"), "Router", new long[]{60000L, 300000L, 3600000L});
        sm.createRequiredRateStat("router.knownPeers", CoalesceStatsEvent._x("Total peers in our NetDb"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.activePeers", CoalesceStatsEvent._x("Peers active in the last minute"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.highCapacityPeers", CoalesceStatsEvent._x("Known high capacity peers"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.activeSendPeers", CoalesceStatsEvent._x("Peers sent to in the last minute"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.fastPeers", CoalesceStatsEvent._x("Known fast peers"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.integratedPeers", CoalesceStatsEvent._x("Known integrated (floodfill) peers"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.bannedPeers", CoalesceStatsEvent._x("Total peers in our banlist"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.unreachablePeers", CoalesceStatsEvent._x("Peers without a published IP address"), "Router", new long[]{60000L});
        sm.createRateStat("router.tunnelBacklog", CoalesceStatsEvent._x("Size of tunnel acceptor backlog"), "Tunnels", new long[]{60000L, 3600000L});
        sm.createRateStat("clock.skew", CoalesceStatsEvent._x("Clock step adjustment (ms)"), "Router", new long[]{60000L, 10800000L, 86400000L});
        this._maxMemory = Runtime.getRuntime().maxMemory();
        String legend = "";
        if (this._maxMemory < Long.MAX_VALUE) {
            legend = legend + "Maximum allocated to the JVM is " + DataHelper.formatSize(this._maxMemory) + 'B';
        }
        sm.createRequiredRateStat("router.memoryUsed", legend, "Router", new long[]{60000L});
        sm.createRequiredRateStat("router.cpuLoad", CoalesceStatsEvent._x("CPU load average of the JVM"), "Router", new long[]{60000L});
        sm.createRequiredRateStat("tunnel.tunnelBuildSuccessAvg", CoalesceStatsEvent._x("Average tunnel build success %"), "Tunnels", new long[]{60000L, 600000L, 3600000L, 86400000L});
    }

    @Override
    public void timeReached() {
        Rate rate;
        RateStat sendRate;
        Rate rate2;
        StatManager sm = this._ctx.statManager();
        int known = this._ctx.netDb().getKnownRouters() - 1;
        sm.addRateData("router.knownPeers", known, 60000L);
        int active = this._ctx.commSystem().countActivePeers();
        sm.addRateData("router.activePeers", active, 60000L);
        int activeSend = this._ctx.commSystem().countActiveSendPeers();
        sm.addRateData("router.activeSendPeers", activeSend, 60000L);
        int fast = this._ctx.profileOrganizer().countFastPeers();
        sm.addRateData("router.fastPeers", fast, 60000L);
        int highCap = this._ctx.profileOrganizer().countHighCapacityPeers();
        sm.addRateData("router.highCapacityPeers", highCap, 60000L);
        int integrated = this._ctx.peerManager().getPeersByCapability('f').size();
        sm.addRateData("router.integratedPeers", integrated, 60000L);
        int banned = this._ctx.banlist().getRouterCount();
        sm.addRateData("router.bannedPeers", banned, 60000L);
        int unreachable = this._ctx.peerManager().getPeersByCapability('U').size();
        sm.addRateData("router.unreachablePeers", unreachable, 60000L);
        sm.addRateData("bw.sendRate", (long)this._ctx.bandwidthLimiter().getSendBps());
        sm.addRateData("bw.recvRate", (long)this._ctx.bandwidthLimiter().getReceiveBps());
        sm.addRateData("router.tunnelBacklog", this._ctx.tunnelManager().getInboundBuildQueueSize(), 60000L);
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        sm.addRateData("router.memoryUsed", used);
        if (this._maxMemory - used < 0x500000L) {
            Router.clearCaches();
        }
        sm.addRateData("router.cpuLoad", SystemVersion.getCPULoad());
        sm.addRateData("tunnel.tunnelBuildSuccessAvg", SystemVersion.getTunnelBuildSuccess());
        this._ctx.tunnelDispatcher().updateParticipatingStats(50000);
        sm.coalesceStats();
        RateStat receiveRate = sm.getRate("transport.receiveMessageSize");
        if (receiveRate != null && (rate2 = receiveRate.getRate(60000L)) != null) {
            double bytes = rate2.getLastTotalValue();
            double bps = bytes * 1000.0 / (double)rate2.getPeriod();
            sm.addRateData("bw.receiveBps", (long)bps, 60000L);
        }
        if ((sendRate = sm.getRate("transport.sendMessageSize")) != null && (rate = sendRate.getRate(60000L)) != null) {
            double bytes = rate.getLastTotalValue();
            double bps = bytes * 1000.0 / (double)rate.getPeriod();
            sm.addRateData("bw.sendBps", (long)bps, 60000L);
        }
    }

    private static final String _x(String s) {
        return s;
    }
}

