/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class ReadConfigJob
extends JobImpl {
    private static final long DELAY = 60000L;
    private volatile long _lastRead;
    private static final String PROP_ADVANCED = "routerconsole.advanced";

    public ReadConfigJob(RouterContext ctx) {
        super(ctx);
        this._lastRead = ctx.clock().now();
    }

    public boolean isAdvanced() {
        return this.getContext().getBooleanProperty(PROP_ADVANCED);
    }

    @Override
    public String getName() {
        return "Read Router Configuration";
    }

    @Override
    public void runJob() {
        File configFile = new File(this.getContext().router().getConfigFilename());
        if (this.shouldReread(configFile)) {
            this.getContext().router().readConfig();
            this._lastRead = this.getContext().clock().now();
            Log log = this.getContext().logManager().getLog(ReadConfigJob.class);
            if (log.shouldDebug()) {
                log.debug("Reloaded " + configFile);
            }
        }
        if (!this.isAdvanced()) {
            this.requeue(60000L);
        } else {
            this.requeue(90000L);
        }
    }

    private boolean shouldReread(File configFile) {
        return configFile.lastModified() > this._lastRead;
    }
}

