/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.data.DataHelper;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class Republish
implements SimpleTimer.TimedEvent {
    private final RouterContext _context;

    public Republish(RouterContext ctx) {
        this._context = ctx;
    }

    @Override
    public void timeReached() {
        RouterInfo ri = null;
        try {
            ri = this._context.router().getRouterInfo();
            if (ri != null) {
                this._context.netDb().publish(ri);
            }
        }
        catch (IllegalArgumentException iae) {
            long published;
            long now;
            long diff;
            Log log = this._context.logManager().getLog(Router.class);
            if (ri != null && (diff = Math.abs((now = this._context.clock().now()) - (published = ri.getDate()))) > 60000L) {
                log.logAlways(30, "Large clock shift detected (" + DataHelper.formatDuration(diff) + "), rebuilding local RouterInfo...");
                this._context.router().rebuildRouterInfo();
                return;
            }
            log.log(50, "Local RouterInfo is invalid - rebuilding a new identity...", iae);
            this._context.router().rebuildNewIdentity();
        }
    }
}

