/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.router.Router;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class Restarter
implements Runnable {
    private final RouterContext _context;

    public Restarter(RouterContext ctx) {
        this._context = ctx;
    }

    @Override
    public void run() {
        Long start = System.currentTimeMillis();
        this._context.router().eventLog().addEvent("softRestart");
        Log log = this._context.logManager().getLog(Router.class);
        log.error("Performing a soft restart...");
        log.logAlways(30, "Stopping the Client Manager...");
        try {
            this._context.clientManager().shutdown("Router restart");
        }
        catch (Throwable t) {
            log.log(50, "Error stopping the client manager", t);
        }
        log.logAlways(30, "Stopping the Comm system...");
        this._context.bandwidthLimiter().reinitialize();
        try {
            this._context.messageRegistry().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the message registry", t);
        }
        try {
            this._context.commSystem().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the comm system", t);
        }
        log.logAlways(30, "Stopping the Tunnel Manager...");
        try {
            this._context.tunnelManager().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the tunnel manager", t);
        }
        log.logAlways(30, "Restarted the tunnel manager");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException t) {
            // empty catch block
        }
        this._context.router().setEstimatedDowntime(System.currentTimeMillis() - start);
        log.logAlways(30, "Restarting the client manager...");
        try {
            this._context.clientMessagePool().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the CMP", t);
        }
        try {
            this._context.clientManager().startup();
        }
        catch (Throwable t) {
            log.log(50, "Error starting the client manager", t);
        }
        this._context.router().setIsAlive();
        this._context.router().rebuildRouterInfo();
        log.logAlways(30, "Restart complete");
        ((RouterClock)this._context.clock()).addShiftListener(this._context.router());
    }
}

