/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.util.Log;
import net.i2p.util.SyntheticREDQueue;
import net.i2p.util.SystemVersion;

public class FIFOBandwidthRefiller
implements Runnable {
    private final Log _log;
    private final RouterContext _context;
    private final FIFOBandwidthLimiter _limiter;
    private volatile SyntheticREDQueue _partBWE;
    private int _inboundKBytesPerSecond;
    private int _outboundKBytesPerSecond;
    private int _inboundBurstKBytesPerSecond;
    private int _outboundBurstKBytesPerSecond;
    private long _lastRefillTime;
    private long _lastCheckConfigTime;
    private long _configCheckPeriodMs = 60000L;
    private volatile boolean _isRunning;
    public static final String PROP_INBOUND_BANDWIDTH = "i2np.bandwidth.inboundKBytesPerSecond";
    public static final String PROP_OUTBOUND_BANDWIDTH = "i2np.bandwidth.outboundKBytesPerSecond";
    public static final String PROP_INBOUND_BURST_BANDWIDTH = "i2np.bandwidth.inboundBurstKBytesPerSecond";
    public static final String PROP_OUTBOUND_BURST_BANDWIDTH = "i2np.bandwidth.outboundBurstKBytesPerSecond";
    public static final String PROP_INBOUND_BANDWIDTH_PEAK = "i2np.bandwidth.inboundBurstKBytes";
    public static final String PROP_OUTBOUND_BANDWIDTH_PEAK = "i2np.bandwidth.outboundBurstKBytes";
    public static final int DEFAULT_INBOUND_BANDWIDTH = 1024;
    public static final int DEFAULT_OUTBOUND_BANDWIDTH = 128;
    public static final int DEFAULT_INBOUND_BURST_BANDWIDTH = 1024;
    public static final int DEFAULT_OUTBOUND_BURST_BANDWIDTH = 128;
    public static final int DEFAULT_BURST_SECONDS = 60;
    public static final int MIN_INBOUND_BANDWIDTH = 32;
    public static final int MIN_OUTBOUND_BANDWIDTH = 32;
    public static final int MIN_INBOUND_BANDWIDTH_PEAK = 32;
    public static final int MIN_OUTBOUND_BANDWIDTH_PEAK = 32;
    public static final int MAX_OUTBOUND_BANDWIDTH = SystemVersion.isSlow() || SystemVersion.getCores() == 1 ? 16384 : (SystemVersion.getCores() < 3 || SystemVersion.getMaxMemory() < 0x40000000L ? 32768 : (SystemVersion.getCores() < 6 || SystemVersion.getMaxMemory() < -1073741824L ? 65536 : (SystemVersion.getCores() >= 8 && SystemVersion.getMaxMemory() >= 0L ? 262144 : 131072)));
    private static final float MAX_SHARE_PERCENTAGE = 0.9f;
    private static final float SHARE_LIMIT_FACTOR = 0.95f;
    private static final long REPLENISH_FREQUENCY = SystemVersion.isSlow() || SystemVersion.getCPULoad() > 80 ? 100L : 20L;

    FIFOBandwidthRefiller(RouterContext context, FIFOBandwidthLimiter limiter) {
        this._limiter = limiter;
        this._context = context;
        this._log = context.logManager().getLog(FIFOBandwidthRefiller.class);
        this._context.statManager().createRateStat("bwLimiter.participatingBandwidthQueue", "Participating tunnel queue (bytes)", "BandwidthLimiter", new long[]{60000L, 300000L, 3600000L});
        this.reinitialize();
        this._isRunning = true;
    }

    synchronized void shutdown() {
        this._isRunning = false;
    }

    @Override
    public void run() {
        this._lastRefillTime = this._limiter.now();
        ArrayList<FIFOBandwidthLimiter.Request> buffer = new ArrayList<FIFOBandwidthLimiter.Request>(2);
        int i = 0;
        while (this._isRunning) {
            boolean updated;
            long now = this._limiter.now();
            if (now >= this._lastCheckConfigTime + this._configCheckPeriodMs) {
                this.checkConfig();
                this._lastCheckConfigTime = now = this._limiter.now();
            }
            if ((i = (int)((byte)(i + 1))) == 0) {
                this.updateParticipating(now);
            }
            if (updated = this.updateQueues(buffer, now)) {
                this._lastRefillTime = now;
            }
            try {
                Thread.sleep(REPLENISH_FREQUENCY);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void reinitialize() {
        this._lastRefillTime = this._limiter.now();
        this.checkConfig();
        this._lastCheckConfigTime = this._lastRefillTime;
    }

    private boolean updateQueues(List<FIFOBandwidthLimiter.Request> buffer, long now) {
        long numMs = now - this._lastRefillTime;
        if (this._log.shouldDebug()) {
            this._log.debug("Updating bandwidth after " + numMs + "ms\n* Status: " + this._limiter.getStatus().toString() + " Rate in: " + this._inboundKBytesPerSecond + "KB/s; Rate out: " + this._outboundKBytesPerSecond + "KB/s");
        }
        if (numMs >= REPLENISH_FREQUENCY * 50L || numMs <= 0L) {
            numMs = REPLENISH_FREQUENCY;
        }
        if (numMs >= REPLENISH_FREQUENCY) {
            long inboundToAdd = (long)(1024 * this._inboundKBytesPerSecond) * numMs / 1000L;
            long outboundToAdd = (long)(1024 * this._outboundKBytesPerSecond) * numMs / 1000L;
            if (inboundToAdd < 0L) {
                inboundToAdd = 0L;
            }
            if (outboundToAdd < 0L) {
                outboundToAdd = 0L;
            }
            long maxBurstIn = (long)((this._inboundBurstKBytesPerSecond - this._inboundKBytesPerSecond) * 1024) * numMs / 1000L;
            long maxBurstOut = (long)((this._outboundBurstKBytesPerSecond - this._outboundKBytesPerSecond) * 1024) * numMs / 1000L;
            this._limiter.refillBandwidthQueues(buffer, inboundToAdd, outboundToAdd, maxBurstIn, maxBurstOut);
            return true;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Refresh delay too fast (" + numMs + "ms)");
        }
        return false;
    }

    private int getShareBandwidth() {
        int maxKBps = Math.min(this._inboundKBytesPerSecond, this._outboundKBytesPerSecond);
        float share = Math.min((float)this._context.router().getSharePercentage(), 0.9f);
        return (int)((float)maxKBps * share * 1024.0f * 0.95f);
    }

    private void checkConfig() {
        this.updateInboundRate();
        this.updateOutboundRate();
        this.updateInboundBurstRate();
        this.updateOutboundBurstRate();
        this.updateInboundPeak();
        this.updateOutboundPeak();
        int maxBps = this.getShareBandwidth();
        if (this._partBWE == null || maxBps != this._partBWE.getMaxBandwidth()) {
            this._partBWE = new SyntheticREDQueue(this._context, maxBps);
        }
    }

    private void updateInboundRate() {
        int in = this._context.getProperty(PROP_INBOUND_BANDWIDTH, 1024);
        if (in != this._inboundKBytesPerSecond) {
            this._inboundKBytesPerSecond = in <= 0 || in > 32 ? in : 32;
            if (this._log.shouldDebug()) {
                this._log.debug("Updating Inbound rate to " + this._inboundKBytesPerSecond + " KB/s");
            }
        }
        if (this._inboundKBytesPerSecond <= 0) {
            this._inboundKBytesPerSecond = 1024;
        }
    }

    private void updateOutboundRate() {
        int out = this._context.getProperty(PROP_OUTBOUND_BANDWIDTH, 128);
        if (out != this._outboundKBytesPerSecond) {
            this._outboundKBytesPerSecond = out >= MAX_OUTBOUND_BANDWIDTH ? MAX_OUTBOUND_BANDWIDTH : (out <= 0 || out >= 32 ? out : 32);
            if (this._log.shouldDebug()) {
                this._log.debug("Updating Outbound rate to " + this._outboundKBytesPerSecond + " KB/s");
            }
        }
        if (this._outboundKBytesPerSecond <= 0) {
            this._outboundKBytesPerSecond = 128;
        }
    }

    private void updateInboundBurstRate() {
        int in = this._context.getProperty(PROP_INBOUND_BURST_BANDWIDTH, 1024);
        if (in != this._inboundBurstKBytesPerSecond) {
            this._inboundBurstKBytesPerSecond = in <= 0 || in >= this._inboundKBytesPerSecond ? in : this._inboundKBytesPerSecond;
            if (this._log.shouldDebug()) {
                this._log.debug("Updating Inbound burst rate to " + this._inboundBurstKBytesPerSecond + " KB/s");
            }
        }
        if (this._inboundBurstKBytesPerSecond <= 0) {
            this._inboundBurstKBytesPerSecond = 1024;
        }
        if (this._inboundBurstKBytesPerSecond < this._inboundKBytesPerSecond) {
            this._inboundBurstKBytesPerSecond = this._inboundKBytesPerSecond;
        }
        this._limiter.setInboundBurstKBps(this._inboundBurstKBytesPerSecond);
    }

    private void updateOutboundBurstRate() {
        int out = this._context.getProperty(PROP_OUTBOUND_BURST_BANDWIDTH, 128);
        if (out != this._outboundBurstKBytesPerSecond) {
            this._outboundBurstKBytesPerSecond = out <= 0 || out >= this._outboundKBytesPerSecond ? out : this._outboundKBytesPerSecond;
            if (this._log.shouldDebug()) {
                this._log.debug("Updating Outbound burst rate to " + this._outboundBurstKBytesPerSecond + " KB/s");
            }
        }
        if (this._outboundBurstKBytesPerSecond <= 0) {
            this._outboundBurstKBytesPerSecond = 128;
        }
        if (this._outboundBurstKBytesPerSecond < this._outboundKBytesPerSecond) {
            this._outboundBurstKBytesPerSecond = this._outboundKBytesPerSecond;
        }
        this._limiter.setOutboundBurstKBps(this._outboundBurstKBytesPerSecond);
    }

    private void updateInboundPeak() {
        int in = this._context.getProperty(PROP_INBOUND_BANDWIDTH_PEAK, 60 * this._inboundBurstKBytesPerSecond);
        if (in != this._limiter.getInboundBurstBytes()) {
            if (in >= 32) {
                if (in < this._inboundBurstKBytesPerSecond) {
                    this._limiter.setInboundBurstBytes(this._inboundBurstKBytesPerSecond * 1024);
                } else {
                    this._limiter.setInboundBurstBytes(in * 1024);
                }
            } else if (32 < this._inboundBurstKBytesPerSecond) {
                this._limiter.setInboundBurstBytes(this._inboundBurstKBytesPerSecond * 1024);
            } else {
                this._limiter.setInboundBurstBytes(32768);
            }
        }
    }

    private void updateOutboundPeak() {
        int in = this._context.getProperty(PROP_OUTBOUND_BANDWIDTH_PEAK, 60 * this._outboundBurstKBytesPerSecond);
        if (in != this._limiter.getOutboundBurstBytes()) {
            if (in >= 32) {
                if (in < this._outboundBurstKBytesPerSecond) {
                    this._limiter.setOutboundBurstBytes(this._outboundBurstKBytesPerSecond * 1024);
                } else {
                    this._limiter.setOutboundBurstBytes(in * 1024);
                }
            } else if (32 < this._outboundBurstKBytesPerSecond) {
                this._limiter.setOutboundBurstBytes(this._outboundBurstKBytesPerSecond * 1024);
            } else {
                this._limiter.setOutboundBurstBytes(32768);
            }
        }
    }

    int getOutboundKBytesPerSecond() {
        return this._outboundKBytesPerSecond;
    }

    int getInboundKBytesPerSecond() {
        return this._inboundKBytesPerSecond;
    }

    int getOutboundBurstKBytesPerSecond() {
        return this._outboundBurstKBytesPerSecond;
    }

    int getInboundBurstKBytesPerSecond() {
        return this._inboundBurstKBytesPerSecond;
    }

    boolean incrementParticipatingMessageBytes(int size, float factor) {
        return this._partBWE.offer(size, factor);
    }

    int getCurrentParticipatingBandwidth() {
        return (int)(this._partBWE.getBandwidthEstimate() * 1000.0f);
    }

    private void updateParticipating(long now) {
        this._context.statManager().addRateData("tunnel.participating OutBps", this.getCurrentParticipatingBandwidth());
        if (this._context.getBooleanProperty("stat.full")) {
            this._context.statManager().addRateData("bwLimiter.participatingBandwidthQueue", (long)this._partBWE.getQueueSizeEstimate());
        }
    }
}

