/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.HandshakeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.ntcp.EstablishBase;
import net.i2p.router.transport.ntcp.NTCP2Options;
import net.i2p.router.transport.ntcp.NTCP2Payload;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.ntcp.OutboundNTCP2State;
import net.i2p.util.Addresses;
import net.i2p.util.ByteCache;
import net.i2p.util.HexDump;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

class InboundEstablishState
extends EstablishBase
implements NTCP2Payload.PayloadCallback {
    private byte[] _curEncrypted;
    private int _aliceIdentSize;
    private RouterIdentity _aliceIdent;
    private final ByteArrayOutputStream _sz_aliceIdent_tsA_padding_aliceSig;
    private int _sz_aliceIdent_tsA_padding_aliceSigSize;
    private boolean _released;
    private HandshakeState _handshakeState;
    private int _padlen1;
    private int _msg3p2len;
    private int _msg3p2FailReason = -1;
    private ByteArray _msg3tmp;
    private NTCP2Options _hisPadding;
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_DATA_READ_BUFS = 64;
    private static final ByteCache _dataReadBufs = ByteCache.getInstance(64, 8192);
    private static final int PADDING1_MAX = 223;
    private static final int PADDING1_FAIL_MAX = 128;
    private static final int PADDING2_MAX = 64;
    private static final int RI_MIN = 439;
    private static final int MSG3P2_MIN = 459;
    private static final int MSG3P2_MAX = 6000;
    private static final Set<EstablishBase.State> STATES_NTCP2 = EnumSet.of(EstablishBase.State.IB_NTCP2_INIT, new EstablishBase.State[]{EstablishBase.State.IB_NTCP2_GOT_X, EstablishBase.State.IB_NTCP2_GOT_PADDING, EstablishBase.State.IB_NTCP2_SENT_Y, EstablishBase.State.IB_NTCP2_GOT_RI, EstablishBase.State.IB_NTCP2_READ_RANDOM});

    public InboundEstablishState(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        super(ctx, transport, con);
        this._state = EstablishBase.State.IB_INIT;
        this._sz_aliceIdent_tsA_padding_aliceSig = new ByteArrayOutputStream(512);
        this._prevEncrypted = SimpleByteCache.acquire(16);
        this._curEncrypted = SimpleByteCache.acquire(16);
    }

    @Override
    public synchronized void receive(ByteBuffer src) {
        super.receive(src);
        if (!src.hasRemaining()) {
            return;
        }
        this.receiveInbound(src);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    private void receiveInbound(ByteBuffer src) {
        if (STATES_NTCP2.contains((Object)this._state)) {
            this.receiveInboundNTCP2(src);
            return;
        }
        if (this._state == EstablishBase.State.IB_INIT && src.hasRemaining()) {
            int remaining = src.remaining();
            if (remaining + this._received < 64) {
                src.get(this._X, this._received, remaining);
                this._received += remaining;
                if (this._log.shouldWarn()) {
                    this._log.warn("Short buffer got " + remaining + " total now " + this._received + " on " + this);
                }
                return;
            }
            this._con.setVersion(2);
            this.changeState(EstablishBase.State.IB_NTCP2_INIT);
            this.receiveInboundNTCP2(src);
            return;
        }
    }

    private boolean verifyInbound(Hash aliceHash) {
        boolean skewOK;
        byte[] ip = this._con.getRemoteIP();
        if (this._context.banlist().isBanlistedForever(aliceHash)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Inbound connection from " + (this._context.banlist().isBanlistedForever(aliceHash) ? "permanently" : "") + " banlisted peer at " + Addresses.toString(ip) + " [" + aliceHash.toBase64().substring(0, 6) + "]");
            }
            if (ip != null) {
                this._context.blocklist().add(ip);
            }
            if (this.getVersion() < 2) {
                this.fail("Banlisting incompatible Router [" + aliceHash.toBase64().substring(0, 6) + "] -> No NTCP2 support");
            } else if (this._log.shouldInfo()) {
                this._log.info("Router is banlisted " + (this._context.banlist().isBanlistedForever(aliceHash) ? "forever" : "") + " [" + aliceHash.toBase64().substring(0, 6) + "]");
            }
            this._msg3p2FailReason = 17;
            return false;
        }
        if (this._context.banlist().isBanlistedHostile(aliceHash) || this._context.banlist().isBanlisted(aliceHash)) {
            this._context.commSystem().mayDisconnect(aliceHash);
            boolean isHostile = this._context.banlist().isBanlistedHostile(aliceHash);
            if (this._log.shouldInfo()) {
                this._log.info("Router [" + aliceHash.toBase64().substring(0, 6) + "] is temp banned" + (isHostile ? " and tagged as hostile" : "") + ", not validating");
            }
            return false;
        }
        if (ip != null) {
            this._transport.setIP(aliceHash, ip);
        }
        if (this._log.shouldDebug()) {
            this._log.debug(this.prefix() + "verification successful for " + this._con);
        }
        long rtt = this._context.clock().now() - this._con.getCreated();
        this._peerSkew -= (rtt / 2L + 500L) / 1000L;
        long diff = 1000L * Math.abs(this._peerSkew);
        boolean bl = skewOK = diff < 60000L;
        if (skewOK && !this._context.clock().getUpdatedSuccessfully()) {
            this._context.clock().setOffset(1000L * (0L - this._peerSkew), true);
            this._peerSkew = 0L;
            if (diff != 0L) {
                this._log.logAlways(30, "NTP failure, NTCP adjusted clock by " + DataHelper.formatDuration(diff) + " -> Source Router [" + aliceHash.toBase64().substring(0, 6) + "]");
            }
        } else {
            if (!skewOK) {
                this._context.banlist().banlistRouter(DataHelper.formatDuration(diff), aliceHash, " <b>\u279c</b> " + InboundEstablishState._x("Excessive clock skew ({0})"));
                this._transport.setLastBadSkew(this._peerSkew);
                if (this._log.shouldWarn()) {
                    this._log.warn("Excessive clock skew (" + diff + "ms) from [" + aliceHash.toBase64().substring(0, 6) + "]");
                }
                this._msg3p2FailReason = 7;
                return false;
            }
            if (this._log.shouldDebug()) {
                this._log.debug(this.prefix() + "Clock skew (" + diff + "ms) from [" + aliceHash.toBase64().substring(0, 6) + "]");
            }
        }
        return true;
    }

    private boolean verifyInboundNetworkID(RouterInfo alice) {
        boolean rv;
        int aliceID = alice.getNetworkId();
        boolean bl = rv = aliceID == this._context.router().getNetworkID();
        if (!rv) {
            byte[] ip;
            Hash aliceHash = alice.getHash();
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Inbound connection (wrong network identifier): " + aliceID + " [" + aliceHash + "]");
            }
            if ((ip = this._con.getRemoteIP()) != null) {
                this._context.blocklist().add(ip);
            }
            this._transport.markUnreachable(aliceHash);
            this._msg3p2FailReason = 17;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void receiveInboundNTCP2(ByteBuffer src) {
        int toGet;
        if (this._state == EstablishBase.State.IB_NTCP2_INIT && src.hasRemaining()) {
            int v;
            toGet = Math.min(src.remaining(), 64 - this._received);
            src.get(this._X, this._received, toGet);
            this._received += toGet;
            if (this._received < 64) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Short buffer got " + toGet + " total now " + this._received);
                }
                return;
            }
            this.changeState(EstablishBase.State.IB_NTCP2_GOT_X);
            this._received = 0;
            if (!this._transport.isHXHIValid(this._X)) {
                this._context.statManager().addRateData("ntcp.replayHXxorBIH", 1L);
                this.fail("\n* Replay Message 1: eX = " + Base64.encode(this._X, 0, 32));
                return;
            }
            Hash h = this._context.routerHash();
            SessionKey bobHash = new SessionKey(h.getData());
            System.arraycopy(this._X, 16, this._prevEncrypted, 0, 16);
            this._context.aes().decrypt(this._X, 0, this._X, 0, bobHash, this._transport.getNTCP2StaticIV(), 32);
            if (DataHelper.eqCT(this._X, 0, OutboundNTCP2State.ZEROKEY, 0, 32)) {
                this.fail("BAD Establishment handshake message #1: X = 0");
                return;
            }
            if ((this._X[31] & 0x80) != 0) {
                this.fail("BAD PK message #1");
                return;
            }
            try {
                this._handshakeState = new HandshakeState("XK", 2, this._transport.getXDHFactory());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException("bad proto", gse);
            }
            this._handshakeState.getLocalKeyPair().setKeys(this._transport.getNTCP2StaticPrivkey(), 0, this._transport.getNTCP2StaticPubkey(), 0);
            byte[] options = new byte[16];
            try {
                this._handshakeState.start();
                if (this._log.shouldDebug()) {
                    this._log.debug("After start: " + this._handshakeState.toString());
                }
                this._handshakeState.readMessage(this._X, 0, 64, options, 0);
            }
            catch (GeneralSecurityException gse) {
                boolean gseNotNull = gse.getMessage() != null && gse.getMessage() != "null";
                this._padlen1 = this._context.random().nextInt(128) - src.remaining();
                if (this._padlen1 > 0) {
                    if (this._log.shouldDebug()) {
                        this._log.warn("BAD Establishment handshake message #1 \n* X = " + Base64.encode(this._X, 0, 32) + " with " + src.remaining() + " more bytes, waiting for " + this._padlen1 + " more bytes", gse);
                    } else if (this._log.shouldWarn()) {
                        this._log.warn("BAD Establishment handshake message #1 \n* X = " + Base64.encode(this._X, 0, 32) + " with " + src.remaining() + " more bytes, waiting for " + this._padlen1 + " more bytes" + (gseNotNull ? "\n* General Security Exception: " + gse.getMessage() : ""));
                    }
                    this.changeState(EstablishBase.State.IB_NTCP2_READ_RANDOM);
                } else {
                    this.fail("\n* BAD Establishment handshake message #1: X = " + Base64.encode(this._X, 0, 32) + " remaining = " + src.remaining(), gse);
                }
                return;
            }
            catch (RuntimeException re) {
                this.fail("\n* BAD Establishment handshake message #1: X = " + Base64.encode(this._X, 0, 32), re);
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("After Establishment handshake message #1: " + this._handshakeState.toString());
            }
            if ((v = options[1] & 0xFF) != 2) {
                this.fail("BAD version: " + v);
                return;
            }
            v = options[0] & 0xFF;
            if (v != 0 && v != this._context.router().getNetworkID()) {
                byte[] ip = this._con.getRemoteIP();
                if (ip != null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Dropping Inbound connection (Wrong network identifier): " + Addresses.toString(ip));
                    }
                    this._context.blocklist().add(ip);
                }
                this.fail("BAD NetworkId: " + v);
                return;
            }
            this._padlen1 = (int)DataHelper.fromLong(options, 2, 2);
            this._msg3p2len = (int)DataHelper.fromLong(options, 4, 2);
            long tsA = DataHelper.fromLong(options, 8, 4);
            long now = this._context.clock().now();
            this._peerSkew = (now - tsA * 1000L + 500L) / 1000L;
            if (this._peerSkew > 60L || this._peerSkew < -60L) {
                long diff = 1000L * Math.abs(this._peerSkew);
                this._context.statManager().addRateData("ntcp.invalidInboundSkew", diff);
                this._transport.setLastBadSkew(this._peerSkew);
                if (this._log.shouldWarn()) {
                    this._log.warn("Clock Skew: " + this._peerSkew + "ms on " + this);
                }
            }
            if (this._msg3p2len < 459 || this._msg3p2len > 6000) {
                this.fail("BAD Establishment handshake message #3 (part 2) -> Length: " + this._msg3p2len + " bytes)");
                return;
            }
            if (this._padlen1 <= 0) {
                this.changeState(EstablishBase.State.IB_NTCP2_GOT_PADDING);
                if (src.hasRemaining()) {
                    this.fail("Extra data (" + src.remaining() + " bytes) after Establishment handshake message #1");
                } else {
                    this.prepareOutbound2();
                }
                return;
            }
        }
        if (this._state == EstablishBase.State.IB_NTCP2_READ_RANDOM && src.hasRemaining()) {
            this._received += src.remaining();
            if (this._received < this._padlen1) {
                if (this._log.shouldWarn()) {
                    this._log.warn("BAD Establishment handshake message #1: Received " + src.remaining() + " more bytes, waiting for " + (this._padlen1 - this._received) + " more bytes");
                }
            } else {
                this.fail("BAD Establishment handshake message #1: Failure with " + src.remaining() + " more bytes remaining");
            }
            return;
        }
        if (this._state == EstablishBase.State.IB_NTCP2_GOT_X && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), this._padlen1 - this._received);
            src.get(this._X, this._received, toGet);
            this._received += toGet;
            if (this._received < this._padlen1) {
                return;
            }
            this.changeState(EstablishBase.State.IB_NTCP2_GOT_PADDING);
            this._handshakeState.mixHash(this._X, 0, this._padlen1);
            if (this._log.shouldDebug()) {
                this._log.debug("After mixhash padding " + this._padlen1 + " Establishment handshake message #1: " + this._handshakeState.toString());
            }
            this._received = 0;
            if (src.hasRemaining()) {
                this.fail("Extra data after Establishment handshake message #1: " + src.remaining());
            } else {
                this.prepareOutbound2();
            }
            return;
        }
        if (this._state == EstablishBase.State.IB_NTCP2_SENT_Y && src.hasRemaining()) {
            int msg3tot = 48 + this._msg3p2len;
            if (this._msg3tmp == null) {
                this._msg3tmp = (ByteArray)_dataReadBufs.acquire();
            }
            byte[] tmp = this._msg3tmp.getData();
            int toGet2 = Math.min(src.remaining(), msg3tot - this._received);
            src.get(tmp, this._received, toGet2);
            this._received += toGet2;
            if (this._received < msg3tot) {
                return;
            }
            this.changeState(EstablishBase.State.IB_NTCP2_GOT_RI);
            this._received = 0;
            ByteArray ptmp = (ByteArray)_dataReadBufs.acquire();
            byte[] payload = ptmp.getData();
            try {
                this._handshakeState.readMessage(tmp, 0, msg3tot, payload, 0);
            }
            catch (GeneralSecurityException gse) {
                _dataReadBufs.release(ptmp, false);
                this.fail("BAD Establishment handshake message #3, part 1 is:\n" + HexDump.dump(tmp, 0, 48), gse);
                return;
            }
            catch (RuntimeException re) {
                _dataReadBufs.release(ptmp, false);
                this.fail("BAD Establishment handshake message #3", re);
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("After Establishment handshake message #3: " + this._handshakeState.toString());
            }
            try {
                NTCP2Payload.processPayload(this._context, this, payload, 0, this._msg3p2len - 16, true);
            }
            catch (IOException ioe) {
                if (this._log.shouldInfo()) {
                    this._log.info("BAD Establishment handshake message #3 payload \n* IO Error:" + ioe.getMessage());
                }
                if (this._msg3p2FailReason < 0) {
                    this._msg3p2FailReason = 9;
                }
            }
            catch (DataFormatException dfe) {
                if (this._log.shouldInfo()) {
                    this._log.info("BAD Establishment handshake message #3 payload \n* Data Format Exception: " + dfe.getMessage());
                }
                if (this._msg3p2FailReason < 0) {
                    this._msg3p2FailReason = 15;
                    byte[] ip = this._con.getRemoteIP();
                    if (ip != null) {
                        this._context.blocklist().add(ip);
                    }
                }
                this._context.statManager().addRateData("ntcp.invalidInboundSignature", 1L);
            }
            catch (I2NPMessageException ime) {
                if (this._log.shouldInfo()) {
                    this._log.info("BAD Establishment handshake message #3 payload \n* I2NP Message Exception: " + ime.getMessage());
                }
                if (this._msg3p2FailReason < 0) {
                    this._msg3p2FailReason = 0;
                }
            }
            finally {
                _dataReadBufs.release(ptmp, false);
            }
            this.setDataPhase(src);
        }
    }

    private synchronized void prepareOutbound2() {
        int padlen2 = this._context.random().nextInt(64);
        byte[] tmp = new byte[64 + padlen2];
        DataHelper.toLong(tmp, 34, 2, padlen2);
        long now = (this._context.clock().now() + 500L) / 1000L;
        DataHelper.toLong(tmp, 40, 4, now);
        try {
            this._handshakeState.writeMessage(tmp, 0, tmp, 32, 16);
        }
        catch (GeneralSecurityException gse) {
            boolean gseNotNull;
            boolean bl = gseNotNull = gse.getMessage() != null && gse.getMessage() != "null";
            if (!this._log.shouldWarn()) {
                this._log.warn("BAD Outbound Establishment handshake message #2 \n* General Security Exception: " + gse.getMessage());
            }
            this.fail("BAD Establishment handshake message #2 out", gse);
            return;
        }
        catch (RuntimeException re) {
            if (!this._log.shouldWarn()) {
                this._log.error("BAD Outbound Establishment handshake message #2 \n* Runtime Exception: " + re.getMessage());
            }
            this.fail("BAD Establishment handshake message #2 out", re);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After Establishment handshake message #2: " + this._handshakeState.toString());
        }
        Hash h = this._context.routerHash();
        SessionKey bobHash = new SessionKey(h.getData());
        this._context.aes().encrypt(tmp, 0, tmp, 0, bobHash, this._prevEncrypted, 32);
        if (padlen2 > 0) {
            this._context.random().nextBytes(tmp, 64, padlen2);
            this._handshakeState.mixHash(tmp, 64, padlen2);
            if (this._log.shouldDebug()) {
                this._log.debug("After mixhash padding " + padlen2 + " Establishment handshake message #2: " + this._handshakeState.toString());
            }
        }
        this.changeState(EstablishBase.State.IB_NTCP2_SENT_Y);
        this._con.wantsWrite(tmp);
    }

    private synchronized void setDataPhase(ByteBuffer buf) {
        CipherStatePair ckp = this._handshakeState.split();
        CipherState rcvr = ckp.getReceiver();
        CipherState sender = ckp.getSender();
        byte[][] sipkeys = OutboundNTCP2State.generateSipHashKeys(this._context, this._handshakeState);
        byte[] sip_ab = sipkeys[0];
        byte[] sip_ba = sipkeys[1];
        if (this._msg3p2FailReason >= 0) {
            if (this._log.shouldInfo()) {
                this._log.warn("Establishment handshake message #3 (part 2) failure -> " + InboundEstablishState.parseReason(this._msg3p2FailReason) + "\n* For: " + this);
            } else if (this._log.shouldWarn() && !InboundEstablishState.parseReason(this._msg3p2FailReason).contains("banned")) {
                this._log.warn("Establishment handshake message #3 (part 2) failure -> " + InboundEstablishState.parseReason(this._msg3p2FailReason) + "\n* For: " + this);
            }
            this._con.failInboundEstablishment(sender, sip_ba, this._msg3p2FailReason);
            this.changeState(EstablishBase.State.CORRUPT);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Finished Establishment for " + this + "\n* Generated SipHash key for A -> B: " + Base64.encode(sip_ab) + "\n* Generated SipHash key for B -> A: " + Base64.encode(sip_ba));
            }
            this._con.finishInboundEstablishment(sender, rcvr, sip_ba, sip_ab, this._peerSkew, this._hisPadding);
            this.changeState(EstablishBase.State.VERIFIED);
            if (buf.hasRemaining()) {
                if (this._log.shouldInfo()) {
                    this._log.info("Extra data (" + buf.remaining() + " bytes) on " + this);
                }
                this._con.recvEncryptedI2NP(buf);
            }
        }
        this.releaseBufs(true);
        this._handshakeState.destroy();
        Arrays.fill(sip_ab, (byte)0);
        Arrays.fill(sip_ba, (byte)0);
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) throws DataFormatException {
        boolean isOld;
        List<RouterAddress> addrs = ri.getTargetAddresses("NTCP", "NTCP2");
        if (addrs.isEmpty()) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("No NTCP address in RouterInfo: " + ri);
        }
        String s = null;
        String mismatchMessage = null;
        byte[] realIP = this._con.getRemoteIP();
        for (RouterAddress addr : addrs) {
            byte[] infoIP;
            String v = addr.getOption("v");
            if (v == null || !v.equals(NTCPTransport.NTCP2_VERSION) && !v.startsWith(NTCPTransport.NTCP2_VERSION_ALT)) continue;
            if (s == null) {
                s = addr.getOption("s");
            }
            if (realIP == null || (infoIP = addr.getIP()) == null || infoIP.length != realIP.length || (infoIP.length == 16 ? (infoIP[0] & 0xFE) == 2 || DataHelper.eq(realIP, 0, infoIP, 0, 8) : DataHelper.eq(realIP, infoIP))) continue;
            mismatchMessage = "IP address mismatch -> Actual IP: " + Addresses.toString(realIP) + "; RI publishes: ";
        }
        if (s == null) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("No s in RouterInfo: " + ri);
        }
        byte[] sb = Base64.decode(s);
        if (sb == null || sb.length != 32) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("BAD s in RouterInfo: " + ri);
        }
        byte[] nb = new byte[32];
        this._handshakeState.getRemotePublicKey().getPublicKey(nb, 0);
        if (!DataHelper.eqCT(sb, 0, nb, 0, 32)) {
            this._msg3p2FailReason = 16;
            throw new DataFormatException("s mismatch in RouterInfo: " + ri);
        }
        this._aliceIdent = ri.getIdentity();
        Hash h = this._aliceIdent.calculateHash();
        boolean ok = this.verifyInbound(h);
        if (!ok) {
            throw new DataFormatException("NTCP2 verifyInbound() fail");
        }
        boolean isBanned = this._context.banlist().isBanlisted(h);
        if (mismatchMessage != null) {
            this._context.banlist().banlistRouter(h, " <b>\u279c</b> Invalid NTCP address", null, null, this._context.clock().now() + 14400000L);
            this._context.commSystem().forceDisconnect(h);
            if (this._log.shouldWarn() && !isBanned) {
                this._log.warn("Banning for 4h and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> Invalid NTCP address");
            }
            this._msg3p2FailReason = 17;
            throw new DataFormatException(mismatchMessage + ri);
        }
        String cap = ri.getCapabilities();
        String bw = ri.getBandwidthTier();
        boolean reachable = cap != null && cap.indexOf(82) >= 0;
        boolean unreachable = cap != null && cap.indexOf(85) >= 0;
        boolean isSlow = cap != null && !cap.equals("") && bw.equals("K") || bw.equals("L") || bw.equals("M") || bw.equals("N");
        String version = ri.getVersion();
        boolean bl = isOld = VersionComparator.comp(version, "0.9.61") < 0;
        if (!reachable && isSlow && isOld) {
            this._context.banlist().banlistRouter(h, " <b>\u279c</b> Old and slow (" + version + " / " + bw + "U)", null, null, this._context.clock().now() + 14400000L);
            this._msg3p2FailReason = 17;
            if (this._log.shouldWarn() && !isBanned) {
                this._log.warn("Banning for 4h and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> " + version + " / " + bw + (unreachable ? "U" : ""));
            }
            this._context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            throw new DataFormatException("Old and slow: " + h);
        }
        if (reachable && unreachable) {
            this._context.banlist().banlistRouter(h, " <b>\u279c</b> Invalid published capabilities (RU)", null, null, this._context.clock().now() + 86400000L);
            this._msg3p2FailReason = 17;
            if (this._log.shouldWarn() && !isBanned) {
                this._log.warn("Banning for 24h and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> Publishing both R and U caps");
            }
            this._context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            throw new DataFormatException("Invalid caps (RU): " + h);
        }
        try {
            RouterInfo old = this._context.netDb().store(h, ri);
            if (flood && !ri.equals(old)) {
                FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
                if (fndf.floodConditional(ri)) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Flooded RouterInfo [" + h.toBase64().substring(0, 6) + "]");
                    }
                } else if (this._log.shouldInfo()) {
                    this._log.info("Flood request declined for RouterInfo [" + h.toBase64().substring(0, 6) + "]");
                }
            }
        }
        catch (IllegalArgumentException iae) {
            ok = this.verifyInboundNetworkID(ri);
            if (!ok) {
                throw new DataFormatException("NTCP2 network ID mismatch");
            }
            if (this._msg3p2FailReason <= 0) {
                this._msg3p2FailReason = 13;
            }
            throw new DataFormatException("RouterInfo store fail: " + ri, iae);
        }
        this._con.setRemotePeer(this._aliceIdent);
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
        NTCP2Options hisPadding = NTCP2Options.fromByteArray(options);
        if (hisPadding == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received options length " + options.length + " on: " + this);
            }
            return;
        }
        this._hisPadding = hisPadding;
    }

    @Override
    public void gotPadding(int paddingLength, int frameLength) {
    }

    @Override
    public void gotTermination(int reason, long lastReceived) {
    }

    @Override
    public void gotUnknown(int type, int len) {
    }

    @Override
    public void gotDateTime(long time) {
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
    }

    @Override
    protected synchronized void fail(String reason, Exception e, boolean bySkew) {
        super.fail(reason, e, bySkew);
        if (this._handshakeState != null) {
            if (this._log.shouldDebug()) {
                this._log.warn("State at Handshake failure: " + this._handshakeState.toString());
            }
            this._handshakeState.destroy();
        }
    }

    @Override
    protected void releaseBufs(boolean isVerified) {
        if (this._released) {
            return;
        }
        this._released = true;
        super.releaseBufs(isVerified);
        if (!isVerified) {
            SimpleByteCache.release(this._curEncrypted);
        }
        Arrays.fill(this._X, (byte)0);
        SimpleByteCache.release(this._X);
        if (this._msg3tmp != null) {
            _dataReadBufs.release(this._msg3tmp, false);
            this._msg3tmp = null;
        }
    }

    public static String parseReason(int reasonCode) {
        switch (reasonCode) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Termination";
            }
            case 2: {
                return "Timeout";
            }
            case 3: {
                return "Shutdown";
            }
            case 4: {
                return "AEAD error";
            }
            case 5: {
                return "Options error";
            }
            case 6: {
                return "Signature type error";
            }
            case 7: {
                return "Excessive clock skew";
            }
            case 8: {
                return "Padding error";
            }
            case 9: {
                return "Framing error";
            }
            case 10: {
                return "Payload error";
            }
            case 11: {
                return "Message #1 error";
            }
            case 12: {
                return "Message #2 error";
            }
            case 13: {
                return "Message #3 error";
            }
            case 14: {
                return "Frame Timeout";
            }
            case 15: {
                return "Signature error";
            }
            case 16: {
                return "S Mismatch";
            }
            case 17: {
                return "Router is banned";
            }
            case 18: {
                return "Token error";
            }
            case 19: {
                return "Limit reached";
            }
            case 20: {
                return "Incompatible Version";
            }
            case 21: {
                return "BAD Netid";
            }
            case 22: {
                return "Replaced connection";
            }
        }
        return "Unknown error";
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            InboundEstablishState.this._context.commSystem().forceDisconnect(this.h);
        }
    }
}

