/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class InboundEstablishState {
    protected final RouterContext _context;
    protected final Log _log;
    private byte[] _receivedX;
    protected byte[] _bobIP;
    protected final int _bobPort;
    private final DHSessionKeyBuilder _keyBuilder;
    private byte[] _sentY;
    protected final byte[] _aliceIP;
    protected final int _alicePort;
    protected long _sentRelayTag;
    private long _sentSignedOnTime;
    private SessionKey _sessionKey;
    private SessionKey _macKey;
    private Signature _sentSignature;
    private byte[][] _receivedIdentity;
    private long _receivedSignedOnTime;
    private byte[] _receivedSignature;
    private boolean _verificationAttempted;
    protected RouterIdentity _receivedUnconfirmedIdentity;
    protected RouterIdentity _receivedConfirmedIdentity;
    protected final long _establishBegin;
    protected long _lastSend;
    protected long _nextSend;
    protected final RemoteHostId _remoteHostId;
    protected InboundState _currentState;
    private final Queue<OutNetMessage> _queuedMessages;
    protected int _createdSentCount;
    protected boolean _introductionRequested;
    protected int _rtt;
    protected static final long RETRANSMIT_DELAY = SystemVersion.isSlow() ? 1000L : 750L;
    protected static final long MAX_DELAY = EstablishmentManager.MAX_IB_ESTABLISH_TIME;

    public InboundEstablishState(RouterContext ctx, byte[] remoteIP, int remotePort, int localPort, DHSessionKeyBuilder dh, UDPPacketReader.SessionRequestReader req) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundEstablishState.class);
        this._aliceIP = remoteIP;
        this._alicePort = remotePort;
        this._remoteHostId = new RemoteHostId(this._aliceIP, this._alicePort);
        this._bobPort = localPort;
        this._currentState = InboundState.IB_STATE_UNKNOWN;
        this._establishBegin = ctx.clock().now();
        this._keyBuilder = dh;
        this._queuedMessages = new LinkedBlockingQueue<OutNetMessage>();
        this._introductionRequested = true;
        this.receiveSessionRequest(req);
    }

    protected InboundEstablishState(RouterContext ctx, InetSocketAddress addr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._aliceIP = addr.getAddress().getAddress();
        this._alicePort = addr.getPort();
        this._remoteHostId = new RemoteHostId(this._aliceIP, this._alicePort);
        this._bobPort = 0;
        this._currentState = InboundState.IB_STATE_UNKNOWN;
        this._establishBegin = ctx.clock().now();
        this._keyBuilder = null;
        this._queuedMessages = new LinkedBlockingQueue<OutNetMessage>();
    }

    public int getVersion() {
        return 1;
    }

    public synchronized InboundState getState() {
        return this._currentState;
    }

    public synchronized boolean isComplete() {
        return this._currentState == InboundState.IB_STATE_COMPLETE || this._currentState == InboundState.IB_STATE_FAILED;
    }

    public synchronized void complete() {
        this._currentState = InboundState.IB_STATE_COMPLETE;
    }

    public void addMessage(OutNetMessage msg) {
        if (!this._queuedMessages.contains(msg)) {
            this._queuedMessages.offer(msg);
        } else if (this._log.shouldWarn()) {
            this._log.warn("attempt to add duplicate msg to queue: " + msg);
        }
    }

    public OutNetMessage getNextQueuedMessage() {
        return this._queuedMessages.poll();
    }

    public synchronized void receiveSessionRequest(UDPPacketReader.SessionRequestReader req) {
        if (this._receivedX == null) {
            this._receivedX = new byte[256];
        }
        req.readX(this._receivedX, 0);
        if (this._bobIP == null) {
            this._bobIP = new byte[req.readIPSize()];
        }
        req.readIP(this._bobIP, 0);
        byte[] ext = req.readExtendedOptions();
        if (ext != null && ext.length >= 2) {
            boolean bl = this._introductionRequested = (ext[1] & 1) != 0;
            if (this._log.shouldInfo()) {
                this._log.info("Received SessionRequest with extended options; need intro? " + this._introductionRequested + ' ' + this);
            }
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Received SessionRequest, BobIP = " + Addresses.toString(this._bobIP));
        }
        if (this._currentState == InboundState.IB_STATE_UNKNOWN) {
            this._currentState = InboundState.IB_STATE_REQUEST_RECEIVED;
        }
        this.packetReceived();
    }

    public synchronized boolean sessionRequestReceived() {
        return this._receivedX != null;
    }

    public synchronized byte[] getReceivedX() {
        return this._receivedX;
    }

    public synchronized byte[] getReceivedOurIP() {
        return this._bobIP;
    }

    public synchronized boolean isIntroductionRequested() {
        return this._introductionRequested;
    }

    public synchronized void generateSessionKey() throws DHSessionKeyBuilder.InvalidPublicParameterException {
        if (this._sessionKey != null) {
            return;
        }
        try {
            this._keyBuilder.setPeerPublicValue(this._receivedX);
        }
        catch (IllegalStateException ise) {
            throw new DHSessionKeyBuilder.InvalidPublicParameterException("reused keys?", ise);
        }
        this._sessionKey = this._keyBuilder.getSessionKey();
        ByteArray extra = this._keyBuilder.getExtraBytes();
        this._macKey = new SessionKey(new byte[32]);
        System.arraycopy(extra.getData(), 0, this._macKey.getData(), 0, 32);
        if (this._log.shouldDebug()) {
            this._log.debug("Established inbound keys. Cipher: " + Base64.encode(this._sessionKey.getData()) + " mac: " + Base64.encode(this._macKey.getData()));
        }
    }

    public synchronized SessionKey getCipherKey() {
        return this._sessionKey;
    }

    public synchronized SessionKey getMACKey() {
        return this._macKey;
    }

    public byte[] getSentIP() {
        return this._aliceIP;
    }

    public int getSentPort() {
        return this._alicePort;
    }

    public synchronized byte[] getSentY() {
        if (this._sentY == null) {
            this._sentY = this._keyBuilder.getMyPublicValueBytes();
        }
        return this._sentY;
    }

    public synchronized void fail() {
        this._currentState = InboundState.IB_STATE_FAILED;
    }

    public synchronized long getSentRelayTag() {
        return this._sentRelayTag;
    }

    public synchronized void setSentRelayTag(long tag) {
        this._sentRelayTag = tag;
    }

    public synchronized long getSentSignedOnTime() {
        return this._sentSignedOnTime;
    }

    public synchronized void prepareSessionCreated() {
        if (this._sentSignature == null) {
            this.signSessionCreated();
        }
    }

    public synchronized Signature getSentSignature() {
        return this._sentSignature;
    }

    private void signSessionCreated() {
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        this._sentSignedOnTime = this._context.clock().now() / 1000L;
        int off = 0;
        System.arraycopy(this._receivedX, 0, signed, off, this._receivedX.length);
        this.getSentY();
        System.arraycopy(this._sentY, 0, signed, off += this._receivedX.length, this._sentY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._sentY.length, this._aliceIP.length);
        DataHelper.toLong(signed, off += this._aliceIP.length, 2, this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong(signed, off += this._bobIP.length, 2, this._bobPort);
        DataHelper.toLong(signed, off += 2, 4, this._sentRelayTag);
        DataHelper.toLong(signed, off += 4, 4, this._sentSignedOnTime);
        this._sentSignature = this._context.dsa().sign(signed, this._context.keyManager().getSigningPrivateKey());
        if (this._log.shouldDebug()) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Signing SessionCreated:");
            buf.append(" Alice: ").append(Addresses.toString(this._aliceIP, this._alicePort));
            buf.append(" Bob: ").append(Addresses.toString(this._bobIP, this._bobPort));
            buf.append(" RelayTag: ").append(this._sentRelayTag);
            buf.append(" SignedOn: ").append(this._sentSignedOnTime);
            buf.append(" Signature: ").append(Base64.encode(this._sentSignature.getData()));
            this._log.debug(buf.toString());
        }
    }

    public synchronized void createdPacketSent() {
        this._lastSend = this._context.clock().now();
        long delay = this._createdSentCount == 0 ? RETRANSMIT_DELAY : Math.min(RETRANSMIT_DELAY << this._createdSentCount, MAX_DELAY);
        ++this._createdSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._currentState == InboundState.IB_STATE_UNKNOWN || this._currentState == InboundState.IB_STATE_REQUEST_RECEIVED) {
            this._currentState = InboundState.IB_STATE_CREATED_SENT;
        }
    }

    public long getLifetime() {
        return this.getLifetime(this._context.clock().now());
    }

    public long getLifetime(long now) {
        return now - this._establishBegin;
    }

    public long getEstablishBeginTime() {
        return this._establishBegin;
    }

    public synchronized long getNextSendTime() {
        return this._nextSend;
    }

    synchronized int getRTT() {
        return this._rtt;
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    public synchronized void receiveSessionConfirmed(UDPPacketReader.SessionConfirmedReader conf) {
        int cur;
        if (this._receivedIdentity == null) {
            this._receivedIdentity = new byte[conf.readTotalFragmentNum()][];
        }
        if ((cur = conf.readCurrentFragmentNum()) >= this._receivedIdentity.length) {
            this.fail();
            this.packetReceived();
            return;
        }
        if (this._receivedIdentity[cur] == null) {
            byte[] fragment = new byte[conf.readCurrentFragmentSize()];
            conf.readFragmentData(fragment, 0);
            this._receivedIdentity[cur] = fragment;
        }
        if (cur == this._receivedIdentity.length - 1) {
            this._receivedSignedOnTime = conf.readFinalFragmentSignedOnTime();
            this.buildIdentity();
            if (this._receivedUnconfirmedIdentity != null) {
                SigType type = this._receivedUnconfirmedIdentity.getSigningPublicKey().getType();
                if (type != null) {
                    int sigLen = type.getSigLen();
                    if (this._receivedSignature == null) {
                        this._receivedSignature = new byte[sigLen];
                    }
                    conf.readFinalSignature(this._receivedSignature, 0, sigLen);
                } else {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Unsupported Signature type from: " + this.toString());
                    }
                    this._context.banlist().banlistRouterForever(this._receivedUnconfirmedIdentity.calculateHash(), " <b>\u279c</b> Unsupported Signature type");
                    this.fail();
                }
                Hash h = this._receivedUnconfirmedIdentity.calculateHash();
                if (this._context.banlist().isBanlistedForever(h)) {
                    if (this.getConfirmedIdentity() != null) {
                        this._context.blocklist().add(this._aliceIP);
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Router is banned: " + h.toBase64() + " on " + this);
                    }
                    this.fail();
                }
            } else {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad ident from: " + this.toString());
                }
                this.fail();
            }
        }
        if (this._currentState == InboundState.IB_STATE_UNKNOWN || this._currentState == InboundState.IB_STATE_REQUEST_RECEIVED || this._currentState == InboundState.IB_STATE_CREATED_SENT) {
            this._currentState = this.confirmedFullyReceived() ? InboundState.IB_STATE_CONFIRMED_COMPLETELY : InboundState.IB_STATE_CONFIRMED_PARTIALLY;
        }
        if (this._createdSentCount == 1) {
            this._rtt = (int)(this._context.clock().now() - this._lastSend);
        }
        this.packetReceived();
    }

    protected boolean confirmedFullyReceived() {
        if (this._receivedIdentity != null) {
            for (int i = 0; i < this._receivedIdentity.length; ++i) {
                if (this._receivedIdentity[i] != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized RouterIdentity getConfirmedIdentity() {
        if (!this._verificationAttempted) {
            this.verifyIdentity();
            this._verificationAttempted = true;
        }
        return this._receivedConfirmedIdentity;
    }

    private void buildIdentity() {
        block9: {
            byte[] ident;
            if (this._receivedUnconfirmedIdentity != null) {
                return;
            }
            int frags = this._receivedIdentity.length;
            if (frags > 1) {
                int identSize = 0;
                for (int i = 0; i < this._receivedIdentity.length; ++i) {
                    identSize += this._receivedIdentity[i].length;
                }
                ident = new byte[identSize];
                int off = 0;
                for (int i = 0; i < this._receivedIdentity.length; ++i) {
                    int len = this._receivedIdentity[i].length;
                    System.arraycopy(this._receivedIdentity[i], 0, ident, off, len);
                    off += len;
                }
            } else {
                ident = this._receivedIdentity[0];
            }
            ByteArrayInputStream in = new ByteArrayInputStream(ident);
            RouterIdentity peer = new RouterIdentity();
            try {
                peer.readBytes(in);
                this._receivedUnconfirmedIdentity = peer;
            }
            catch (DataFormatException dfe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Improperly formatted yet fully received ident", dfe);
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldWarn()) break block9;
                this._log.warn("Improperly formatted yet fully received ident", ioe);
            }
        }
    }

    private void verifyIdentity() {
        if (this._receivedUnconfirmedIdentity == null) {
            return;
        }
        if (this._receivedSignature == null) {
            return;
        }
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        int off = 0;
        System.arraycopy(this._receivedX, 0, signed, off, this._receivedX.length);
        this.getSentY();
        System.arraycopy(this._sentY, 0, signed, off += this._receivedX.length, this._sentY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._sentY.length, this._aliceIP.length);
        DataHelper.toLong(signed, off += this._aliceIP.length, 2, this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong(signed, off += this._bobIP.length, 2, this._bobPort);
        DataHelper.toLong(signed, off += 2, 4, this._sentRelayTag);
        DataHelper.toLong(signed, off += 4, 4, this._receivedSignedOnTime);
        Signature sig = new Signature(this._receivedUnconfirmedIdentity.getSigType(), this._receivedSignature);
        boolean ok = this._context.dsa().verifySignature(sig, signed, this._receivedUnconfirmedIdentity.getSigningPublicKey());
        if (ok) {
            this._receivedConfirmedIdentity = this._receivedUnconfirmedIdentity;
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Signature failed from " + this._receivedUnconfirmedIdentity + "\non: " + this);
            }
            this._context.blocklist().add(this._aliceIP);
        }
    }

    protected void packetReceived() {
        this._nextSend = this._context.clock().now();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("InboundEstablishState ");
        buf.append(Addresses.toString(this._aliceIP, this._alicePort));
        buf.append("\n* Lifetime: ").append(DataHelper.formatDuration(this.getLifetime()));
        if (this._sentRelayTag > 0L) {
            buf.append("; RelayTag: ").append(this._sentRelayTag);
        }
        buf.append(" -> ").append((Object)this._currentState);
        return buf.toString();
    }

    public static enum InboundState {
        IB_STATE_UNKNOWN,
        IB_STATE_REQUEST_RECEIVED,
        IB_STATE_CREATED_SENT,
        IB_STATE_CONFIRMED_PARTIALLY,
        IB_STATE_CONFIRMED_COMPLETELY,
        IB_STATE_FAILED,
        IB_STATE_COMPLETE,
        IB_STATE_TOKEN_REQUEST_RECEIVED,
        IB_STATE_REQUEST_BAD_TOKEN_RECEIVED,
        IB_STATE_RETRY_SENT;

    }
}

