/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.MessageQueue;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class OutboundRefiller
implements Runnable {
    private RouterContext _context;
    private Log _log;
    private OutboundMessageFragments _fragments;
    private MessageQueue _messages;
    private boolean _alive;

    public OutboundRefiller(RouterContext ctx, OutboundMessageFragments fragments, MessageQueue messages) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundRefiller.class);
        this._fragments = fragments;
        this._messages = messages;
        this._context.statManager().createRateStat("udp.timeToActive", "Message lifetime until it reaches the outbound fragment queue", "Transport [UDP]", UDPTransport.RATES);
    }

    public void startup() {
        this._alive = true;
        I2PThread t = new I2PThread(this, "UDP outbound refiller", true);
        t.setPriority(10);
        t.start();
    }

    public void shutdown() {
        this._alive = false;
    }

    @Override
    public void run() {
        while (this._alive) {
            boolean wantMore;
            if (this._log.shouldDebug()) {
                this._log.debug("Check the fragments to see if we can add more...");
            }
            if (wantMore = this._fragments.waitForMoreAllowed()) {
                OutNetMessage msg;
                if (this._log.shouldDebug()) {
                    this._log.debug("Want more fragments...");
                }
                if ((msg = this._messages.getNext(-1L)) != null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("New message found to fragments: " + msg);
                    }
                    this._context.statManager().addRateData("udp.timeToActive", msg.getLifetime(), msg.getLifetime());
                    this._fragments.add(msg);
                    continue;
                }
                if (!this._log.shouldDebug()) continue;
                this._log.debug("No message found to fragment");
                continue;
            }
            if (!this._log.shouldWarn()) continue;
            this._log.warn("No more fragments allowed, looping");
        }
    }
}

