/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.CipherState;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Bitfield;
import net.i2p.router.transport.udp.SSU2Header;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Sender;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PeerStateDestroyed
implements SSU2Payload.PayloadCallback,
SSU2Sender {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final RemoteHostId _remoteHostId;
    private final int _mtu;
    private final long _sendConnID;
    private final long _rcvConnID;
    private final AtomicInteger _packetNumber;
    private final CipherState _sendCha;
    private final CipherState _rcvCha;
    private final byte[] _sendHeaderEncryptKey1;
    private final byte[] _rcvHeaderEncryptKey1;
    private final byte[] _sendHeaderEncryptKey2;
    private final byte[] _rcvHeaderEncryptKey2;
    private final SSU2Bitfield _receivedMessages;
    private final ACKTimer _ackTimer;
    private final KillTimer _killTimer;
    private final long _destroyedOn;
    protected volatile long _wantACKSendSince;
    private volatile int _destroyReason;
    private static final long MAX_LIFETIME = 120000L;
    private static final long TERMINATION_RETX_TIME = 7000L;

    public PeerStateDestroyed(RouterContext ctx, UDPTransport transport, PeerState2 peer) {
        this._context = ctx;
        this._transport = transport;
        this._log = ctx.logManager().getLog(PeerStateDestroyed.class);
        this._remoteHostId = peer.getRemoteHostId();
        this._mtu = peer.getMTU();
        this._packetNumber = new AtomicInteger((int)peer.getNextPacketNumberNoThrow());
        this._sendConnID = peer.getSendConnID();
        this._rcvConnID = peer.getRcvConnID();
        this._sendCha = peer.getSendCipher();
        this._rcvCha = peer.getRcvCipher();
        this._sendHeaderEncryptKey1 = peer.getSendHeaderEncryptKey1();
        this._rcvHeaderEncryptKey1 = peer.getRcvHeaderEncryptKey1();
        this._sendHeaderEncryptKey2 = peer.getSendHeaderEncryptKey2();
        this._rcvHeaderEncryptKey2 = peer.getRcvHeaderEncryptKey2();
        this._receivedMessages = peer.getReceivedMessages();
        this._destroyReason = peer.getDestroyReason();
        this._destroyedOn = this._context.clock().now();
        this._ackTimer = new ACKTimer();
        if (this._destroyReason != 1) {
            this._ackTimer.schedule(7000L);
        }
        this._killTimer = new KillTimer();
        this._killTimer.schedule(120000L);
    }

    public PeerStateDestroyed(RouterContext ctx, UDPTransport transport, RemoteHostId id, long sendID, long rcvID, CipherState sendCha, CipherState rcvCha, byte[] sendKey1, byte[] sendKey2, byte[] rcvKey2, int reason) {
        this._context = ctx;
        this._transport = transport;
        this._log = ctx.logManager().getLog(PeerStateDestroyed.class);
        this._remoteHostId = id;
        this._mtu = 1280;
        this._packetNumber = new AtomicInteger();
        this._sendConnID = sendID;
        this._rcvConnID = rcvID;
        this._sendCha = sendCha;
        this._rcvCha = rcvCha;
        this._sendHeaderEncryptKey1 = sendKey1;
        this._rcvHeaderEncryptKey1 = this._transport.getSSU2StaticIntroKey();
        this._sendHeaderEncryptKey2 = sendKey2;
        this._rcvHeaderEncryptKey2 = rcvKey2;
        this._receivedMessages = new SSU2Bitfield(256, 0L);
        this._receivedMessages.set(0L);
        this._destroyReason = reason;
        this._destroyedOn = this._context.clock().now();
        this._ackTimer = new ACKTimer();
        this._killTimer = new KillTimer();
        this._killTimer.schedule(120000L);
    }

    public void kill() {
        this._ackTimer.cancel();
        this._killTimer.cancel();
        this._sendCha.destroy();
        this._rcvCha.destroy();
    }

    @Override
    public RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    @Override
    public boolean isIPv6() {
        return this._remoteHostId.getIP().length == 16;
    }

    @Override
    public InetAddress getRemoteIPAddress() {
        try {
            return InetAddress.getByAddress(this._remoteHostId.getIP());
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    @Override
    public int getRemotePort() {
        return this._remoteHostId.getPort();
    }

    @Override
    public int getMTU() {
        return this._mtu;
    }

    @Override
    public long getNextPacketNumber() {
        return this._packetNumber.getAndIncrement();
    }

    @Override
    public long getSendConnID() {
        return this._sendConnID;
    }

    @Override
    public CipherState getSendCipher() {
        return this._sendCha;
    }

    @Override
    public byte[] getSendHeaderEncryptKey1() {
        return this._sendHeaderEncryptKey1;
    }

    @Override
    public byte[] getSendHeaderEncryptKey2() {
        return this._sendHeaderEncryptKey2;
    }

    @Override
    public void setDestroyReason(int reason) {
    }

    @Override
    public SSU2Bitfield getReceivedMessages() {
        return this._receivedMessages;
    }

    @Override
    public SSU2Bitfield getAckedMessages() {
        return null;
    }

    @Override
    public void fragmentsSent(long pktNum, int length, List<PacketBuilder.Fragment> fragments) {
    }

    @Override
    public byte getFlags() {
        return 0;
    }

    long getRcvConnID() {
        return this._rcvConnID;
    }

    private synchronized void messagePartiallyReceived() {
        long now;
        if (this._wantACKSendSince <= 0L && this._destroyedOn - (now = this._context.clock().now()) < 120000L) {
            this._wantACKSendSince = now;
            this._ackTimer.schedule();
        }
    }

    void receivePacket(UDPPacket packet) {
        this.receivePacket(packet.getRemoteHost(), packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePacket(RemoteHostId from, UDPPacket packet) {
        block13: {
            if (!from.equals(this._remoteHostId) && this._log.shouldWarn()) {
                this._log.warn("Inbound packet from [" + from + "] on " + this);
            }
            DatagramPacket dpacket = packet.getPacket();
            byte[] data = dpacket.getData();
            int off = dpacket.getOffset();
            int len = dpacket.getLength();
            try {
                SSU2Header.Header header = SSU2Header.trialDecryptShortHeader(packet, this._rcvHeaderEncryptKey1, this._rcvHeaderEncryptKey2);
                if (header == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Inbound packet too short (" + len + " bytes) on " + this);
                    }
                    return;
                }
                if (header.getDestConnID() != this._rcvConnID) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("BAD " + len + "byte Destination ConnectionID " + header + " on " + this);
                    }
                    return;
                }
                if (header.getType() != 6) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("BAD " + len + " byte data packet (Type: " + header.getType() + ") on " + this);
                    }
                    return;
                }
                long n = header.getPacketNumber();
                SSU2Header.acceptTrialDecrypt(packet, header);
                CipherState cipherState = this._rcvCha;
                synchronized (cipherState) {
                    this._rcvCha.setNonce(n);
                    this._rcvCha.decryptWithAd(header.data, data, off + 16, data, off + 16, len - 16);
                }
                int payloadLen = len - 32;
                if (this._log.shouldDebug()) {
                    this._log.debug("New " + len + " byte packet [#" + n + "] received on " + this);
                }
                SSU2Payload.processPayload(this._context, this, data, off + 16, payloadLen, false, from);
            }
            catch (Exception e) {
                if (!this._log.shouldWarn()) break block13;
                this._log.warn("BAD encrypted packet on: " + this, e);
            }
        }
    }

    @Override
    public void gotDateTime(long time) {
    }

    @Override
    public void gotOptions(byte[] options, boolean isHandshake) {
    }

    @Override
    public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received RouterInfo block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received RouterInfo FRAGMENT block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotAddress(byte[] ip, int port) {
    }

    @Override
    public void gotRelayTagRequest() {
    }

    @Override
    public void gotRelayTag(long tag) {
    }

    @Override
    public void gotRelayRequest(byte[] data) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received RELAY block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotRelayResponse(int status, byte[] data) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received RELAY block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotRelayIntro(Hash aliceHash, byte[] data) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received RELAY block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received PEER TEST block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotToken(long token, long expires) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received TOKEN: " + token + " expires " + DataHelper.formatTime(expires) + " on " + this);
        }
        this._transport.getEstablisher().addOutboundToken(this._remoteHostId, token, expires);
    }

    @Override
    public void gotI2NP(I2NPMessage msg) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received I2NP block: " + msg + " on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received FRAGMENT block on " + this);
        }
        this.messagePartiallyReceived();
    }

    @Override
    public void gotACK(long ackThru, int acks, byte[] ranges) {
    }

    @Override
    public void gotTermination(int reason, long count) {
        if (this._log.shouldInfo()) {
            this._log.info("Received TERMINATION block -> Reason: " + reason + " (Our reason: " + this._destroyReason + ") on " + this);
        }
        if (reason == 1) {
            this._wantACKSendSince = this._context.clock().now() + 9999999L;
            this._ackTimer.cancel();
            this._killTimer.reschedule(15000L);
        } else {
            this._destroyReason = 1;
            this.messagePartiallyReceived();
        }
    }

    @Override
    public void gotPathChallenge(RemoteHostId from, byte[] data) {
    }

    @Override
    public void gotPathResponse(RemoteHostId from, byte[] data) {
    }

    public String toString() {
        return "peer destroyed " + DataHelper.formatDuration(this._context.clock().now() - this._destroyedOn) + " ago: " + this._remoteHostId;
    }

    private class KillTimer
    extends SimpleTimer2.TimedEvent {
        public KillTimer() {
            super(PeerStateDestroyed.this._context.simpleTimer2());
        }

        @Override
        public void timeReached() {
            PeerStateDestroyed.this._ackTimer.cancel();
            PeerStateDestroyed.this._transport.removeRecentlyClosed(PeerStateDestroyed.this);
            PeerStateDestroyed.this._sendCha.destroy();
            PeerStateDestroyed.this._rcvCha.destroy();
        }
    }

    private class ACKTimer
    extends SimpleTimer2.TimedEvent {
        private long _delay;

        public ACKTimer() {
            super(PeerStateDestroyed.this._context.simpleTimer2());
            this._delay = 7000L;
        }

        public void schedule() {
            this.reschedule(250L, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            PeerStateDestroyed peerStateDestroyed = PeerStateDestroyed.this;
            synchronized (peerStateDestroyed) {
                if (PeerStateDestroyed.this._wantACKSendSince <= 0L && PeerStateDestroyed.this._destroyReason == 1) {
                    return;
                }
                PeerStateDestroyed.this._wantACKSendSince = 0L;
            }
            try {
                UDPPacket pkt = PeerStateDestroyed.this._transport.getBuilder2().buildSessionDestroyPacket(PeerStateDestroyed.this._destroyReason, PeerStateDestroyed.this);
                if (PeerStateDestroyed.this._log.shouldDebug()) {
                    PeerStateDestroyed.this._log.debug("Sending TERMINATION reason " + PeerStateDestroyed.this._destroyReason + " to " + PeerStateDestroyed.this);
                }
                PeerStateDestroyed.this._transport.send(pkt);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (PeerStateDestroyed.this._destroyReason != 1) {
                this._delay *= 2L;
                this.reschedule(this._delay);
            }
        }
    }
}

