/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;

class PeerTestState {
    private final long _testNonce;
    private final Role _ourRole;
    private final boolean _isIPv6;
    private PeerState2 _alice;
    private InetAddress _aliceIP;
    private int _alicePort;
    private final PeerState _bob;
    private InetAddress _charlieIP;
    private int _charliePort;
    private InetAddress _aliceIPFromCharlie;
    private int _alicePortFromCharlie;
    private SessionKey _aliceIntroKey;
    private SessionKey _aliceCipherKey;
    private SessionKey _aliceMACKey;
    private SessionKey _charlieIntroKey;
    private Hash _aliceHash;
    private Hash _charlieHash;
    private byte[] _testData;
    private final List<Hash> _previousCharlies;
    private final long _beginTime;
    private long _lastSendTime;
    private long _receiveAliceTime;
    private long _receiveBobTime;
    private long _receiveCharlieTime;
    private long _sendAliceTime;
    private long _sendCharlieTime;
    private int _status;
    private final AtomicInteger _packetsRelayed = new AtomicInteger();

    public PeerTestState(Role role, PeerState bob, boolean isIPv6, long nonce, long now) {
        this._ourRole = role;
        this._bob = bob;
        this._isIPv6 = isIPv6;
        this._testNonce = nonce;
        this._beginTime = now;
        this._previousCharlies = role == Role.BOB ? new ArrayList(8) : null;
    }

    public long getNonce() {
        return this._testNonce;
    }

    public Role getOurRole() {
        return this._ourRole;
    }

    public PeerState getBob() {
        return this._bob;
    }

    public boolean isIPv6() {
        return this._isIPv6;
    }

    public InetAddress getAliceIP() {
        return this._aliceIP;
    }

    public PeerState2 getAlice() {
        return this._alice;
    }

    public void setAlice(PeerState2 alice) {
        this._alice = alice;
    }

    public void setAlice(InetAddress ip, int port, Hash hash) {
        this._aliceIP = ip;
        this._alicePort = port;
        this._aliceHash = hash;
    }

    public InetAddress getBobIP() {
        return this._bob.getRemoteIPAddress();
    }

    public InetAddress getCharlieIP() {
        return this._charlieIP;
    }

    public Hash getCharlieHash() {
        return this._charlieHash;
    }

    public void setCharlie(InetAddress ip, int port, Hash hash) {
        this._charlieIP = ip;
        this._charliePort = port;
        if (this._charlieHash != null && this._previousCharlies != null && !this._charlieHash.equals(hash)) {
            this._previousCharlies.add(this._charlieHash);
        }
        this._charlieHash = hash;
    }

    public List<Hash> getPreviousCharlies() {
        return this._previousCharlies;
    }

    public InetAddress getAliceIPFromCharlie() {
        return this._aliceIPFromCharlie;
    }

    public void setAliceIPFromCharlie(InetAddress ip) {
        this._aliceIPFromCharlie = ip;
    }

    public int getAlicePort() {
        return this._alicePort;
    }

    public int getBobPort() {
        return this._bob.getRemotePort();
    }

    public int getCharliePort() {
        return this._charliePort;
    }

    public void setCharliePort(int charliePort) {
        this._charliePort = charliePort;
    }

    public int getAlicePortFromCharlie() {
        return this._alicePortFromCharlie;
    }

    public void setAlicePortFromCharlie(int alicePortFromCharlie) {
        this._alicePortFromCharlie = alicePortFromCharlie;
    }

    public SessionKey getAliceIntroKey() {
        return this._aliceIntroKey;
    }

    public void setAliceIntroKey(SessionKey key) {
        this._aliceIntroKey = key;
    }

    public SessionKey getAliceCipherKey() {
        return this._aliceCipherKey;
    }

    public SessionKey getAliceMACKey() {
        return this._aliceMACKey;
    }

    public void setAliceKeys(SessionKey ck, SessionKey mk) {
        this._aliceCipherKey = ck;
        this._aliceMACKey = mk;
    }

    public SessionKey getCharlieIntroKey() {
        return this._charlieIntroKey;
    }

    public void setCharlieIntroKey(SessionKey key) {
        this._charlieIntroKey = key;
    }

    public SessionKey getBobCipherKey() {
        return this._bob.getCurrentCipherKey();
    }

    public SessionKey getBobMACKey() {
        return this._bob.getCurrentMACKey();
    }

    public long getBeginTime() {
        return this._beginTime;
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public long getReceiveAliceTime() {
        return this._receiveAliceTime;
    }

    public void setReceiveAliceTime(long when) {
        this._receiveAliceTime = when;
    }

    public long getReceiveBobTime() {
        return this._receiveBobTime;
    }

    public void setReceiveBobTime(long when) {
        this._receiveBobTime = when;
    }

    public long getReceiveCharlieTime() {
        return this._receiveCharlieTime;
    }

    public void setReceiveCharlieTime(long when) {
        this._receiveCharlieTime = when;
    }

    public long getSendAliceTime() {
        return this._sendAliceTime;
    }

    public void setSendAliceTime(long when) {
        this._sendAliceTime = when;
    }

    public long getSendCharlieTime() {
        return this._sendCharlieTime;
    }

    public void setSendCharlieTime(long when) {
        this._sendCharlieTime = when;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public byte[] getTestData() {
        return this._testData;
    }

    public void setTestData(byte[] data) {
        this._testData = data;
    }

    public int incrementPacketsRelayed() {
        return this._packetsRelayed.incrementAndGet();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("\n* PeerTest ").append(this._testNonce).append(this._isIPv6 ? " [IPv6]" : " [IPv4]").append(" started ").append(DataHelper.formatTime(this._beginTime)).append(" as ").append(this._ourRole.toString());
        if (this._aliceIP != null) {
            buf.append(" [Alice: ");
            if (this._ourRole == Role.ALICE) {
                buf.append(" LOCAL: ");
            }
            buf.append(this._aliceIP).append(':').append(this._alicePort).append("]");
            if (this._aliceHash != null) {
                buf.append(' ').append(this._aliceHash.toBase64().substring(0, 6));
            }
        }
        if (this._aliceIPFromCharlie != null) {
            buf.append(" [from Charlie: ").append(this._aliceIPFromCharlie).append(':').append(this._alicePortFromCharlie).append("]");
        }
        if (this._bob != null) {
            buf.append(" [Bob: ").append(this._bob.toString()).append("]");
        } else {
            buf.append(" [Bob: LOCAL]");
        }
        if (this._charlieIP != null) {
            buf.append(" [Charlie: ");
            if (this._ourRole == Role.CHARLIE) {
                buf.append("LOCAL]");
            } else {
                buf.append(this._charlieIP).append(':').append(this._charliePort).append("]");
            }
            if (this._charlieHash != null) {
                buf.append(' ').append(this._charlieHash.toBase64().substring(0, 6));
            }
            if (this._previousCharlies != null && !this._previousCharlies.isEmpty()) {
                buf.append(" previous: ").append(this._previousCharlies);
            }
        }
        if (this._lastSendTime > 0L) {
            buf.append("\n* Last send after ").append(this._lastSendTime - this._beginTime);
        }
        if (this._sendAliceTime > 0L) {
            buf.append("; Last send to Alice ").append(DataHelper.formatTime(this._sendAliceTime));
        }
        if (this._receiveAliceTime > 0L) {
            buf.append("; Received from Alice after ").append(this._receiveAliceTime - this._beginTime);
        }
        if (this._receiveBobTime > 0L) {
            buf.append("; Received from Bob after ").append(this._receiveBobTime - this._beginTime);
        }
        if (this._sendCharlieTime > 0L) {
            buf.append("; Last send to Charlie ").append(DataHelper.formatTime(this._sendCharlieTime));
        }
        if (this._receiveCharlieTime > 0L) {
            buf.append("; Received from Charlie after ").append(this._receiveCharlieTime - this._beginTime);
        }
        buf.append("; Packets relayed: ").append(this._packetsRelayed.get());
        return buf.toString();
    }

    public static enum Role {
        ALICE,
        BOB,
        CHARLIE;

    }
}

