/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramPacket;
import net.i2p.crypto.ChaCha20;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPPacket;

final class SSU2Header {
    public static final byte[] HEADER_PROT_DATA = new byte[8];
    public static final byte[] CHACHA_IV_0 = new byte[12];

    private SSU2Header() {
    }

    public static Header trialDecryptHandshakeHeader(UDPPacket packet, byte[] key1, byte[] key2) {
        DatagramPacket pkt = packet.getPacket();
        if (pkt.getLength() < SSU2Util.MIN_HANDSHAKE_DATA_LEN) {
            return null;
        }
        Header header = new Header(SSU2Util.SESSION_HEADER_SIZE);
        SSU2Header.decryptHandshakeHeader(pkt, key1, key2, header);
        return header;
    }

    public static Header trialDecryptLongHeader(UDPPacket packet, byte[] key1, byte[] key2) {
        DatagramPacket pkt = packet.getPacket();
        if (pkt.getLength() < 56) {
            return null;
        }
        Header header = new Header(32);
        SSU2Header.decryptLongHeader(pkt, key1, key2, header);
        return header;
    }

    public static Header trialDecryptShortHeader(UDPPacket packet, byte[] key1, byte[] key2) {
        DatagramPacket pkt = packet.getPacket();
        if (pkt.getLength() < 40) {
            return null;
        }
        Header header = new Header(16);
        SSU2Header.decryptShortHeader(pkt, key1, key2, header);
        return header;
    }

    public static long decryptDestConnID(DatagramPacket pkt, byte[] key1) {
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] xor = new byte[8];
        ChaCha20.decrypt(key1, data, off + len - 24, HEADER_PROT_DATA, 0, xor, 0, 8);
        for (int i = 0; i < 8; ++i) {
            int n = i;
            xor[n] = (byte)(xor[n] ^ data[i + off + 0]);
        }
        return DataHelper.fromLong8(xor, 0);
    }

    public static void acceptTrialDecrypt(UDPPacket packet, Header header) {
        DatagramPacket pkt = packet.getPacket();
        int off = pkt.getOffset();
        byte[] data = pkt.getData();
        System.arraycopy(header.data, 0, data, off, header.data.length);
    }

    private static void decryptHandshakeHeader(DatagramPacket pkt, byte[] key1, byte[] key2, Header header) {
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        SSU2Header.decryptShortHeader(pkt, key1, key2, header);
        ChaCha20.decrypt(key2, CHACHA_IV_0, data, off + 16, header.data, 16, SSU2Util.KEY_LEN + 32 - 16);
    }

    private static void decryptLongHeader(DatagramPacket pkt, byte[] key1, byte[] key2, Header header) {
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        SSU2Header.decryptShortHeader(pkt, key1, key2, header);
        ChaCha20.decrypt(key2, CHACHA_IV_0, data, off + 16, header.data, 16, 16);
    }

    private static void decryptShortHeader(DatagramPacket pkt, byte[] key1, byte[] key2, Header header) {
        int i;
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] xor = new byte[8];
        ChaCha20.decrypt(key1, data, off + len - 24, HEADER_PROT_DATA, 0, xor, 0, 8);
        for (i = 0; i < 8; ++i) {
            header.data[i + 0] = (byte)(data[i + off + 0] ^ xor[i]);
        }
        ChaCha20.decrypt(key2, data, off + len - 12, HEADER_PROT_DATA, 0, xor, 0, 8);
        for (i = 0; i < 8; ++i) {
            header.data[i + 8] = (byte)(data[i + off + 8] ^ xor[i]);
        }
    }

    public static void encryptHandshakeHeader(UDPPacket packet, byte[] key1, byte[] key2) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        SSU2Header.encryptShortHeader(packet, key1, key2);
        ChaCha20.encrypt(key2, CHACHA_IV_0, data, off + 16, data, off + 16, SSU2Util.KEY_LEN + 32 - 16);
    }

    public static void encryptLongHeader(UDPPacket packet, byte[] key1, byte[] key2) {
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        SSU2Header.encryptShortHeader(packet, key1, key2);
        ChaCha20.encrypt(key2, CHACHA_IV_0, data, off + 16, data, off + 16, 16);
    }

    public static void encryptShortHeader(UDPPacket packet, byte[] key1, byte[] key2) {
        int i;
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] xor = new byte[8];
        ChaCha20.encrypt(key1, data, off + len - 24, HEADER_PROT_DATA, 0, xor, 0, 8);
        for (i = 0; i < 8; ++i) {
            int n = i + off + 0;
            data[n] = (byte)(data[n] ^ xor[i]);
        }
        ChaCha20.encrypt(key2, data, off + len - 12, HEADER_PROT_DATA, 0, xor, 0, 8);
        for (i = 0; i < 8; ++i) {
            int n = i + off + 8;
            data[n] = (byte)(data[n] ^ xor[i]);
        }
    }

    public static class Header {
        public final byte[] data;

        public Header(int len) {
            this.data = new byte[len];
        }

        public long getDestConnID() {
            return DataHelper.fromLong8(this.data, 0);
        }

        public long getPacketNumber() {
            return DataHelper.fromLong(this.data, 8, 4);
        }

        public int getType() {
            return this.data[12] & 0xFF;
        }

        public int getShortHeaderFlags() {
            return (int)DataHelper.fromLong(this.data, 13, 3);
        }

        public int getVersion() {
            return this.data[13] & 0xFF;
        }

        public int getNetID() {
            return this.data[14] & 0xFF;
        }

        public int getHandshakeHeaderFlags() {
            return this.data[15] & 0xFF;
        }

        public long getSrcConnID() {
            return DataHelper.fromLong8(this.data, 16);
        }

        public long getToken() {
            return DataHelper.fromLong8(this.data, 24);
        }

        public byte[] getEphemeralKey() {
            byte[] rv = new byte[SSU2Util.KEY_LEN];
            System.arraycopy(this.data, 32, rv, 0, SSU2Util.KEY_LEN);
            return rv;
        }

        public String toString() {
            if (this.data.length >= SSU2Util.SESSION_HEADER_SIZE) {
                return "Handshake header: DestID: " + this.getDestConnID() + "; Packet number: " + this.getPacketNumber() + "; Type: " + this.getType() + "; Version: " + this.getVersion() + "; NetID: " + this.getNetID() + "; SourceID: " + this.getSrcConnID() + "\n* Token: " + this.getToken() + "; Key: " + Base64.encode(this.getEphemeralKey());
            }
            if (this.data.length >= 32) {
                return "Long header: DestID: " + this.getDestConnID() + "; Packet number: " + this.getPacketNumber() + "; Type: " + this.getType() + "; Version: " + this.getVersion() + "; NetID: " + this.getNetID() + "; SourceID: " + this.getSrcConnID() + "\n* Token: " + this.getToken();
            }
            return "Short header: DestID: " + this.getDestConnID() + "; Packet number: " + this.getPacketNumber() + "; Type: " + this.getType() + "; Flags: " + this.getShortHeaderFlags();
        }
    }
}

