/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SocketListener;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class UDPReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final DatagramSocket _socket;
    private String _name;
    private volatile boolean _keepRunning;
    private final Runner _runner;
    private final UDPTransport _transport;
    private final PacketHandler _handler;
    private final SocketListener _endpoint;
    private static final boolean _isAndroid = SystemVersion.isAndroid();
    private static final long MAX_QUEUE_PERIOD = SystemVersion.isSlow() ? 200L : 50L;

    public UDPReceiver(RouterContext ctx, UDPTransport transport, DatagramSocket socket, String name, SocketListener lsnr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPReceiver.class);
        this._name = name;
        this._socket = socket;
        this._transport = transport;
        this._endpoint = lsnr;
        this._handler = transport.getPacketHandler();
        if (this._handler == null) {
            throw new IllegalStateException();
        }
        this._runner = new Runner();
        this._context.statManager().createRateStat("udp.receiveHolePunch", "How often we receive a NAT hole punch", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignorePacketFromDroplist", "Packet lifetime for those dropped on the drop list", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveFailsafe", "limiter stuck?", "Transport [UDP]", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._keepRunning = true;
        I2PThread t = new I2PThread(this._runner, this._name, true);
        t.setPriority(10);
        t.start();
    }

    public synchronized void shutdown() {
        this._keepRunning = false;
    }

    private int receive(UDPPacket packet) {
        return this.doReceive(packet);
    }

    private final int doReceive(UDPPacket packet) {
        RemoteHostId from;
        if (!this._keepRunning) {
            return 0;
        }
        if (this._log.shouldInfo()) {
            this._log.info("Received UDP packet" + packet);
        }
        if (this._transport.isInDropList(from = packet.getRemoteHost())) {
            if (this._log.shouldInfo()) {
                this._log.info("Ignoring UDP packet from the drop-listed peer: " + from);
            }
            this._context.statManager().addRateData("udp.ignorePacketFromDroplist", packet.getLifetime());
            packet.release();
            return 0;
        }
        if (Arrays.equals(from.getIP(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping (spoofed?) UDP packet from ourselves");
            }
            packet.release();
            return 0;
        }
        try {
            this._handler.queueReceived(packet);
        }
        catch (InterruptedException ie) {
            packet.release();
            this._keepRunning = false;
        }
        return 0;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            while (UDPReceiver.this._keepRunning) {
                UDPPacket packet = UDPPacket.acquire(UDPReceiver.this._context, true);
                DatagramPacket dpacket = packet.getPacket();
                if (_isAndroid) {
                    dpacket.setLength(1572);
                }
                while (!UDPReceiver.this._context.throttle().acceptNetworkMessage()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    UDPReceiver.this._socket.receive(dpacket);
                    int size = dpacket.getLength();
                    if (UDPReceiver.this._log.shouldInfo()) {
                        UDPReceiver.this._log.info("After blocking socket.receive, UDP packet is " + size + " bytes on " + System.identityHashCode(packet));
                    }
                    packet.resetBegin();
                    if (size >= 1572) {
                        throw new IOException("UDP packet too large! Truncated and dropped from: " + packet.getRemoteHost());
                    }
                    if (UDPReceiver.this._context.commSystem().isDummy()) {
                        packet.release();
                        continue;
                    }
                    if (size >= 40) {
                        FIFOBandwidthLimiter.Request req = UDPReceiver.this._context.bandwidthLimiter().requestInbound(size, "UDP receiver");
                        int waitCount = 0;
                        while (req.getPendingRequested() > 0 && waitCount++ < 5) {
                            req.waitForNextAllocation();
                        }
                        if (waitCount >= 5) {
                            req.abort();
                            UDPReceiver.this._context.statManager().addRateData("udp.receiveFailsafe", 1L);
                        }
                        UDPReceiver.this.receive(packet);
                        continue;
                    }
                    if (UDPReceiver.this._log.shouldWarn()) {
                        String ipAddress = dpacket.getAddress().toString().replace("/", "");
                        UDPReceiver.this._log.warn("Dropping short " + size + " byte UDP packet from " + ipAddress + ":" + dpacket.getPort());
                    }
                    packet.release();
                }
                catch (IOException ioe) {
                    if (UDPReceiver.this._log.shouldDebug()) {
                        UDPReceiver.this._log.debug("Error receiving UDP packet", ioe);
                    } else if (UDPReceiver.this._log.shouldWarn()) {
                        UDPReceiver.this._log.warn("Error receiving UDP packet: " + ioe.getMessage());
                    }
                    packet.release();
                    if (UDPReceiver.this._socket.isClosed()) {
                        if (!UDPReceiver.this._keepRunning) continue;
                        UDPReceiver.this._keepRunning = false;
                        UDPReceiver.this._endpoint.fail();
                        continue;
                    }
                    if (!UDPReceiver.this._keepRunning) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (UDPReceiver.this._log.shouldWarn()) {
                UDPReceiver.this._log.warn("Stopped receiving UDP packets on: " + UDPReceiver.this._endpoint);
            }
        }
    }
}

