/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.data.ByteArray;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.TrivialPreprocessor;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.SystemVersion;

class BatchedPreprocessor
extends TrivialPreprocessor {
    private long _pendingSince;
    private final String _name;
    private static final boolean DEBUG = false;
    private static final int FULL_SIZE = 1003;
    static long DEFAULT_DELAY = SystemVersion.isSlow() ? 100L : 50L;
    private static final int FORCE_BATCH_FLUSH = 5;
    private static final int FULL_ENOUGH_SIZE = 802;

    public BatchedPreprocessor(RouterContext ctx, String name) {
        super(ctx);
        this._name = name;
    }

    protected long getSendDelay() {
        return DEFAULT_DELAY;
    }

    @Override
    public long getDelayAmount() {
        return this.getDelayAmount(true);
    }

    private long getDelayAmount(boolean shouldStat) {
        long rv = -1L;
        long defaultAmount = this.getSendDelay();
        if (this._pendingSince > 0L) {
            rv = this._pendingSince + defaultAmount - this._context.clock().now();
        }
        if (rv > defaultAmount) {
            rv = defaultAmount;
        }
        if (shouldStat) {
            this._context.statManager().addRateData("tunnel.batchDelayAmount", rv);
        }
        return rv;
    }

    @Override
    public boolean preprocessQueue(List<PendingGatewayMessage> pending, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        long start;
        StringBuilder timingBuf;
        if (this._log.shouldInfo()) {
            this.display(0L, pending, "Starting batching preprocessor...");
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Preprocessing queue with " + pending.size() + " messages to send");
            timingBuf = new StringBuilder(128);
            timingBuf.append("Preprocessing queue with " + pending.size() + " messages to send");
            start = System.currentTimeMillis();
        } else {
            timingBuf = null;
            start = 0L;
        }
        int batchCount = 0;
        int beforeLooping = pending.size();
        while (!pending.isEmpty()) {
            int allocated = 0;
            long beforePendingLoop = timingBuf != null ? System.currentTimeMillis() : 0L;
            for (int i = 0; i < pending.size(); ++i) {
                long pendingStart = timingBuf != null ? System.currentTimeMillis() : 0L;
                PendingGatewayMessage msg = pending.get(i);
                int instructionsSize = BatchedPreprocessor.getInstructionsSize(msg);
                instructionsSize += BatchedPreprocessor.getInstructionAugmentationSize(msg, allocated, instructionsSize);
                int curWanted = msg.getData().length - msg.getOffset() + instructionsSize;
                if (this._log.shouldDebug()) {
                    this._log.debug("Pending " + i + "/" + pending.size() + " [MsgID " + msg.getMessageId() + "] CurWanted: " + curWanted + "; InstructionSize: " + instructionsSize + "; Allocated: " + allocated);
                }
                if ((allocated += curWanted) >= 1003) {
                    if (allocated - curWanted + instructionsSize >= 1003) {
                        msg = pending.get(--i);
                        allocated -= curWanted;
                        if (this._log.shouldDebug()) {
                            this._log.debug("Pushback of " + curWanted + " (message " + (i + 1) + " in " + pending + ")");
                        }
                    }
                    if (this._pendingSince > 0L) {
                        long waited = this._context.clock().now() - this._pendingSince;
                        this._context.statManager().addRateData("tunnel.batchDelaySent", pending.size(), waited);
                    }
                    long beforeSend = timingBuf != null ? System.currentTimeMillis() : 0L;
                    this._pendingSince = 0L;
                    this.send(pending, 0, i, sender, rec);
                    this._context.statManager().addRateData("tunnel.batchFullFragments", 1L);
                    long afterSend = timingBuf != null ? System.currentTimeMillis() : 0L;
                    if (this._log.shouldInfo()) {
                        this.display(allocated, pending, "Sent the message with " + (i + 1) + " fragments");
                    }
                    for (int j = 0; j < i; ++j) {
                        PendingGatewayMessage cur = pending.remove(0);
                        if (cur.getOffset() < cur.getData().length) {
                            throw new IllegalArgumentException("i=" + i + " j=" + j + " off=" + cur.getOffset() + " len=" + cur.getData().length + " alloc=" + allocated);
                        }
                        if (timingBuf != null) {
                            timingBuf.append(" sent " + cur);
                        }
                        this._context.statManager().addRateData("tunnel.batchFragmentation", cur.getFragmentNumber() + 1);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), cur.getData().length);
                    }
                    if (msg.getOffset() >= msg.getData().length) {
                        PendingGatewayMessage cur = pending.remove(0);
                        if (timingBuf != null) {
                            timingBuf.append(" sent perfect fit " + cur).append(".");
                        }
                        this._context.statManager().addRateData("tunnel.batchFragmentation", cur.getFragmentNumber() + 1);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), cur.getData().length);
                    }
                    if (i > 0) {
                        this._context.statManager().addRateData("tunnel.batchMultipleCount", i + 1);
                    }
                    allocated = 0;
                    ++batchCount;
                    if (timingBuf == null) break;
                    long pendingEnd = System.currentTimeMillis();
                    timingBuf.append("\n* After sending " + (i + 1) + "/" + pending.size() + " in " + (afterSend - beforeSend) + "; After: " + (beforeSend - pendingStart) + "; Since: " + (beforeSend - beforePendingLoop) + "/" + (beforeSend - start) + " Pending current: " + (pendingEnd - pendingStart));
                    break;
                }
                if (timingBuf == null) continue;
                timingBuf.append("\n* After pending loop: " + (System.currentTimeMillis() - beforePendingLoop));
            }
            if (this._log.shouldInfo()) {
                this.display(allocated, pending, "After looping to clear: " + (beforeLooping - pending.size()));
            }
            long afterDisplayed = timingBuf != null ? System.currentTimeMillis() : 0L;
            if (allocated > 0) {
                if (pending.size() > 5 || this._pendingSince > 0L && this.getDelayAmount() <= 0L || allocated >= 802) {
                    PendingGatewayMessage cur;
                    if (pending.size() > 1) {
                        this._context.statManager().addRateData("tunnel.batchMultipleCount", pending.size());
                    }
                    this._context.statManager().addRateData("tunnel.batchDelaySent", pending.size(), 0L);
                    this.send(pending, 0, pending.size() - 1, sender, rec);
                    this._context.statManager().addRateData("tunnel.batchSmallFragments", 1003 - allocated);
                    int beforeSize = pending.size();
                    for (int i = 0; i < beforeSize && (cur = pending.get(0)).getOffset() >= cur.getData().length; ++i) {
                        pending.remove(0);
                        this._context.statManager().addRateData("tunnel.batchFragmentation", cur.getFragmentNumber() + 1);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), cur.getData().length);
                    }
                    if (!pending.isEmpty()) {
                        this._pendingSince = this._context.clock().now();
                        this._context.statManager().addRateData("tunnel.batchFlushRemaining", pending.size(), beforeSize);
                        if (this._log.shouldInfo()) {
                            this.display(allocated, pending, "\n* Flushed pending messages in buffer, some remain...");
                        }
                        if (timingBuf != null) {
                            long now = System.currentTimeMillis();
                            timingBuf.append("\n* Flushed messages in buffer, some remain (displayed to now: " + (now - afterDisplayed) + ")");
                            timingBuf.append(" Total time: " + (now - start));
                            this._log.debug(timingBuf.toString());
                        }
                        return true;
                    }
                    long delayAmount = 0L;
                    if (this._pendingSince > 0L) {
                        delayAmount = this._context.clock().now() - this._pendingSince;
                        this._pendingSince = 0L;
                    }
                    if (batchCount > 1) {
                        this._context.statManager().addRateData("tunnel.batchCount", batchCount);
                    }
                    if (this._log.shouldInfo()) {
                        this.display(allocated, pending, "Flushed messages: " + beforeSize + ", none remaining after " + delayAmount + "ms");
                    }
                    if (timingBuf != null) {
                        long now = System.currentTimeMillis();
                        timingBuf.append(" Flushed all messages in buffer, none remain (displayed to now: " + (now - afterDisplayed) + ")");
                        timingBuf.append(" Total time: " + (now - start));
                        this._log.debug(timingBuf.toString());
                    }
                    return false;
                }
                this._context.statManager().addRateData("tunnel.batchDelay", pending.size());
                if (this._pendingSince <= 0L) {
                    this._pendingSince = this._context.clock().now();
                }
                if (batchCount > 1) {
                    this._context.statManager().addRateData("tunnel.batchCount", batchCount);
                }
                if (this._log.shouldInfo()) {
                    this.display(allocated, pending, "Not flushing pending messages in buffer (too early)");
                }
                if (timingBuf != null) {
                    long now = System.currentTimeMillis();
                    timingBuf.append(" Not flushing (displayed to now: " + (now - afterDisplayed) + ")");
                    timingBuf.append(" Total time: " + (now - start) + "ms");
                    this._log.debug(timingBuf.toString());
                }
                return true;
            }
            if (timingBuf == null) continue;
            timingBuf.append("; Continuing to loop...");
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sent everything on the list (pending: " + pending.size() + ")");
        }
        if (timingBuf != null) {
            timingBuf.append("; Total time: " + (System.currentTimeMillis() - start) + "ms");
        }
        if (timingBuf != null) {
            this._log.debug(timingBuf.toString());
        }
        return false;
    }

    private void display(long allocated, List<PendingGatewayMessage> pending, String title) {
        if (this._log.shouldInfo()) {
            long highestDelay = 0L;
            StringBuilder buf = new StringBuilder(128);
            buf.append(this._name).append(": ");
            buf.append(title);
            buf.append("\n* Allocated: ").append(allocated);
            buf.append("; Pending: ").append(pending.size());
            if (this._pendingSince > 0L) {
                buf.append("; Delay: ").append(this.getDelayAmount(false));
            }
            for (int i = 0; i < pending.size(); ++i) {
                PendingGatewayMessage curPending = pending.get(i);
                buf.append("; [").append(i).append("] - ");
                buf.append(curPending.getOffset()).append('/').append(curPending.getData().length).append('/');
                buf.append(curPending.getLifetime());
                if (curPending.getLifetime() <= highestDelay) continue;
                highestDelay = curPending.getLifetime();
            }
            this._log.info(buf.toString());
        }
    }

    protected void send(List<PendingGatewayMessage> pending, int startAt, int sendThrough, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        if (this._log.shouldDebug()) {
            this._log.debug("Sending " + startAt + ":" + sendThrough + " out of " + pending);
        }
        byte[] preprocessed = ((ByteArray)_dataCache.acquire()).getData();
        int offset = 0;
        if ((offset = this.writeFragments(pending, startAt, sendThrough, preprocessed, offset)) <= 0) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("uh? written offset is ").append(offset);
            buf.append(" for ").append(startAt).append(" through ").append(sendThrough);
            for (int i = startAt; i <= sendThrough; ++i) {
                buf.append(" ").append(pending.get(i).toString());
            }
            this._log.log(50, buf.toString());
            return;
        }
        try {
            this.preprocess(preprocessed, offset);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (this._log.shouldError()) {
                this._log.error("Error preprocessing the messages:\n* Offset: " + offset + "; Start: " + startAt + "; Through: " + sendThrough + "; Pending: " + pending.size() + "; Preproc: " + preprocessed.length);
            }
            return;
        }
        long msgId = sender.sendPreprocessed(preprocessed, rec);
        if (this._log.shouldDebug()) {
            this._log.debug("Sent " + startAt + ":" + sendThrough + " out of " + pending + " messages in [MsgID " + msgId + "]");
        }
    }

    private int writeFragments(List<PendingGatewayMessage> pending, int startAt, int sendThrough, byte[] target, int offset) {
        for (int i = startAt; i <= sendThrough; ++i) {
            PendingGatewayMessage msg = pending.get(i);
            int prevOffset = offset;
            if (msg.getOffset() == 0) {
                offset = this.writeFirstFragment(msg, target, offset);
                if (!this._log.shouldDebug()) continue;
                this._log.debug("[MsgID " + msg.getMessageId() + "] Writing fragment 0:\n* Ending at offset: " + offset + " (prev offset: " + prevOffset + "); Leaving " + (msg.getData().length - msg.getOffset()) + " bytes for later");
                continue;
            }
            offset = this.writeSubsequentFragment(msg, target, offset);
            if (!this._log.shouldDebug()) continue;
            int frag = msg.getFragmentNumber();
            int later = msg.getData().length - msg.getOffset();
            if (later > 0) {
                --frag;
            }
            if (!this._log.shouldDebug()) continue;
            this._log.debug("[MsgID " + msg.getMessageId() + "] Writing fragment " + frag + ":\n* Ending at offset: " + offset + " (prev offset: " + prevOffset + "); Leaving " + later + " bytes for later");
        }
        return offset;
    }
}

