/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.ArraySet;
import net.i2p.util.SystemVersion;

class ExploratoryPeerSelector
extends TunnelPeerSelector {
    private static final int MIN_NONFAILING_PCT = 30;
    private static final int MIN_ACTIVE_PEERS_STARTUP = 10;
    private static final int MIN_ACTIVE_PEERS = 20;

    public ExploratoryPeerSelector(RouterContext context) {
        super(context);
    }

    @Override
    public List<Hash> selectPeers(TunnelPoolSettings settings) {
        int length = this.getLength(settings);
        if (length < 0) {
            if (this.log.shouldDebug()) {
                this.log.debug("Tunnel length requested is zero: " + settings);
            }
            return null;
        }
        boolean isInbound = settings.isInbound();
        Set<Hash> exclude = this.getExclude(isInbound, true);
        exclude.add(this.ctx.routerHash());
        boolean nonzero = length > 0;
        boolean exploreHighCap = nonzero && this.shouldPickHighCap();
        boolean v6Only = nonzero && this.isIPv6Only();
        boolean ntcpDisabled = nonzero && this.isNTCPDisabled();
        boolean ssuDisabled = nonzero && this.isSSUDisabled();
        boolean checkClosestHop = v6Only || ntcpDisabled || ssuDisabled;
        boolean hidden = nonzero && (this.ctx.router().isHidden() || this.ctx.router().getRouterInfo().getAddressCount() <= 0 || !this.ctx.commSystem().haveInboundCapacity(95));
        boolean hiddenInbound = hidden && isInbound;
        boolean hiddenOutbound = hidden && !isInbound;
        boolean lowOutbound = nonzero && !isInbound && !this.ctx.commSystem().haveHighOutboundCapacity();
        int ipRestriction = this.ctx.getBooleanProperty("i2np.allowLocal") || length <= 1 ? 0 : settings.getIPRestriction();
        MaskedIPSet ipSet = ipRestriction > 0 ? new MaskedIPSet(16) : null;
        Hash closestHop = null;
        if (v6Only || hiddenInbound || lowOutbound) {
            Set<Hash> closestExclude = checkClosestHop ? this.getClosestHopExclude(isInbound, exclude) : exclude;
            ArraySet<Hash> closest = new ArraySet<Hash>(1);
            if (hiddenInbound || lowOutbound) {
                if (this.log.shouldInfo()) {
                    this.log.info("ExploratoryPeerSelector : SelectAllNonFailingPeers closest " + (isInbound ? "Inbound " : "Outbound ") + closestExclude);
                }
                this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, closestExclude, closest, ipRestriction, ipSet);
                if (closest.isEmpty()) {
                    if (hiddenInbound) {
                        if (this.log.shouldWarn()) {
                            this.log.warn("ExploratoryPeerSelector : SelectAllNonFailingPeers (hidden) closest Inbound -> No active peers found, returning null");
                        }
                        return null;
                    }
                    if (this.log.shouldInfo()) {
                        this.log.info("ExploratoryPeerSelector : SelectFastPeersclosest " + (isInbound ? "Inbound " : "Outbound ") + closestExclude);
                    }
                    this.ctx.profileOrganizer().selectFastPeers(1, closestExclude, closest, ipRestriction, ipSet);
                }
            } else if (exploreHighCap) {
                if (this.log.shouldInfo()) {
                    this.log.info("ExploratoryPeerSelector : SelectHighCapPeers closest " + (isInbound ? "Inbound " : "Outbound ") + closestExclude);
                }
                this.ctx.profileOrganizer().selectHighCapacityPeers(1, closestExclude, closest, ipRestriction, ipSet);
            } else {
                if (this.log.shouldInfo()) {
                    this.log.info("ExploratoryPeerSelector : SelectNonFailingPeers closest " + (isInbound ? "Inbound " : "Outbound ") + closestExclude);
                }
                this.ctx.profileOrganizer().selectNotFailingPeers(1, closestExclude, closest, false, ipRestriction, ipSet);
            }
            if (!closest.isEmpty()) {
                closestHop = closest.get(0);
                exclude.add(closestHop);
                --length;
            }
        }
        Hash furthestHop = null;
        if (hiddenOutbound && length > 0) {
            TunnelManagerFacade tmf = this.ctx.tunnelManager();
            TunnelPool tp = tmf.getInboundExploratoryPool();
            TunnelPoolSettings tps = tp.getSettings();
            int len = tps.getLength();
            boolean pickFurthest = true;
            if (len > 0 && tps.getLengthOverride() != 0 && len + tps.getLengthVariance() > 0) {
                for (TunnelInfo ti : tp.listTunnels()) {
                    if (ti.getLength() <= 1) continue;
                    pickFurthest = false;
                    break;
                }
            }
            if (pickFurthest) {
                ArraySet<Hash> furthest = new ArraySet<Hash>(1);
                if (this.log.shouldInfo()) {
                    this.log.info("ExploratoryPeerSelector : SelectAllNonFailingPeers OBEP exclude " + exclude);
                }
                this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, exclude, furthest, ipRestriction, ipSet);
                if (furthest.isEmpty()) {
                    if (this.log.shouldInfo()) {
                        this.log.info("ExploratoryPeerSelector : SelectFastPeersOBEP exclude " + exclude);
                    }
                    this.ctx.profileOrganizer().selectFastPeers(1, exclude, furthest, ipRestriction, ipSet);
                }
                if (!furthest.isEmpty()) {
                    furthestHop = furthest.get(0);
                    exclude.add(furthestHop);
                    this.ctx.commSystem().exemptIncoming(furthestHop);
                    --length;
                }
            }
        }
        ArrayList<Hash> rv = new ArrayList<Hash>(length + 3);
        if (length > 0) {
            ArraySet<Hash> matches = new ArraySet<Hash>(length);
            if (exploreHighCap) {
                if (this.log.shouldInfo()) {
                    this.log.info("ExploratoryPeerSelector : SelectHighCapPeers " + length + (isInbound ? " Inbound " : " Outbound ") + exclude);
                }
                this.ctx.profileOrganizer().selectHighCapacityPeers(length, exclude, matches, ipRestriction, ipSet);
            } else {
                if (length > 2) {
                    this.ctx.profileOrganizer().selectHighCapacityPeers(length - 2, exclude, matches);
                }
                if (this.log.shouldInfo()) {
                    this.log.info("ExploratoryPeerSelector : SelectNonFailingPeers " + length + (isInbound ? " Inbound " : " Outbound ") + exclude);
                }
                this.ctx.profileOrganizer().selectNotFailingPeers(length, exclude, matches, false, ipRestriction, ipSet);
            }
            matches.remove(this.ctx.routerHash());
            rv.addAll(matches);
        }
        if (this.log.shouldInfo()) {
            this.log.info("ExploratoryPeerSelector " + length + (isInbound ? " Inbound " : " Outbound ") + "final: " + exclude);
        }
        if (rv.size() > 1) {
            this.orderPeers(rv, settings.getRandomKey());
        }
        if (closestHop != null) {
            if (isInbound) {
                rv.add(0, closestHop);
            } else {
                rv.add(closestHop);
            }
            ++length;
        }
        if (furthestHop != null) {
            if (isInbound) {
                rv.add(furthestHop);
            } else {
                rv.add(0, furthestHop);
            }
            ++length;
        }
        if (isInbound) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        if (rv.size() > 1 && !this.checkTunnel(isInbound, true, rv)) {
            rv = null;
        }
        if (isInbound && rv != null && rv.size() > 1) {
            this.ctx.commSystem().exemptIncoming(rv.get(1));
        }
        return rv;
    }

    private boolean shouldPickHighCap() {
        int failPct;
        if (this.ctx.getBooleanProperty("router.exploreHighCapacity") || this.ctx.getProperty("router.exploreHighCapacity") != null && !this.ctx.getProperty("router.exploreHighCapacity").equals("false")) {
            return true;
        }
        int active = this.ctx.commSystem().countActivePeers();
        if (active < 10) {
            return false;
        }
        long uptime = this.ctx.router().getUptime();
        if (uptime <= (long)(SystemVersion.isAndroid() ? 900000 : 300000)) {
            return true;
        }
        if (uptime <= 3660000L && this.ctx.router().getEstimatedDowntime() > 259200000L) {
            return true;
        }
        if (this.ctx.router().gracefulShutdownInProgress()) {
            return true;
        }
        if (active < 20) {
            return false;
        }
        if (uptime <= 660000L) {
            failPct = 70;
        } else {
            if (active > 500 || this.ctx.netDb().floodfillEnabled()) {
                return false;
            }
            failPct = this.getExploratoryFailPercentage();
            if (failPct > 70) {
                failPct = 70;
            }
        }
        return failPct >= this.ctx.random().nextInt(100);
    }

    private int getExploratoryFailPercentage() {
        int c = this.getFailPercentage("Client");
        int e = this.getFailPercentage("Exploratory");
        if (e <= c || e <= 25) {
            return 0;
        }
        if (c >= 70 || e >= 75) {
            return 70;
        }
        return 100 * (e - c) / (100 - c);
    }

    private int getFailPercentage(String t) {
        String pfx = "tunnel.build" + t;
        int timeout = this.getEvents(pfx + "Expire", 600000L);
        int reject = this.getEvents(pfx + "Reject", 600000L);
        int accept = this.getEvents(pfx + "Success", 600000L);
        if (accept + reject + timeout <= 0) {
            return 0;
        }
        double pct = (double)(reject + timeout) / (double)(accept + reject + timeout);
        return (int)(100.0 * pct);
    }

    private int getEvents(String stat, long period) {
        RateStat rs = this.ctx.statManager().getRate(stat);
        if (rs == null) {
            return 0;
        }
        Rate r = rs.getRate(period);
        if (r == null) {
            return 0;
        }
        return (int)r.computeAverages().getTotalEventCount();
    }
}

