/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class ParticipatingThrottler {
    private final RouterContext context;
    private final ObjectCounter<Hash> counter;
    private final Log _log;
    private static boolean isSlow = SystemVersion.isSlow();
    private static boolean isQuadCore = SystemVersion.getCores() >= 4;
    private static boolean isHexaCore;
    private static final boolean DEFAULT_SHOULD_THROTTLE = true;
    private static final String PROP_SHOULD_THROTTLE = "router.enableTransitThrottle";
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";
    private static final int LIFETIME_PORTION = 3;
    private static final int MIN_LIMIT;
    private static final int MAX_LIMIT;
    private static final int PERCENT_LIMIT = 4;
    private static final long CLEAN_TIME = 220000L;

    ParticipatingThrottler(RouterContext ctx) {
        this.context = ctx;
        this.counter = new ObjectCounter();
        this._log = ctx.logManager().getLog(ParticipatingThrottler.class);
        ctx.simpleTimer2().addPeriodicEvent(new Cleaner(), 220000L);
    }

    Result shouldThrottle(Hash h) {
        Result rv;
        RouterInfo ri = this.context.netDb().lookupRouterInfoLocally(h);
        Hash us = this.context.routerHash();
        String caps = ri != null ? ri.getCapabilities() : "";
        boolean isUs = ri != null && us.equals(ri.getIdentity().getHash());
        boolean isUnreachable = ri != null && !isUs && caps != "" && caps.indexOf(85) >= 0;
        boolean isLowShare = ri != null && !isUs && (caps.indexOf(75) >= 0 || caps.indexOf(76) >= 0 || caps.indexOf(77) >= 0 || caps.indexOf(78) >= 0);
        boolean isFast = ri != null && !isUs && caps != "" && (caps.indexOf(79) >= 0 || caps.indexOf(80) >= 0 || caps.indexOf(88) >= 0);
        boolean isLU = ri != null && !isUs && isUnreachable && (caps.indexOf(75) >= 0 || caps.indexOf(76) >= 0);
        byte[] padding = ri != null ? ri.getIdentity().getPadding() : null;
        boolean isCompressible = padding != null && padding.length >= 64 && DataHelper.eq(padding, 0, padding, 32, 32);
        int numTunnels = this.context.tunnelManager().getParticipatingCount();
        int limit = isUnreachable || isLowShare ? Math.min(MIN_LIMIT, Math.max(MAX_LIMIT / 12, numTunnels * 0 / 100)) : (isSlow ? Math.min(MIN_LIMIT, Math.max(MAX_LIMIT / 5, numTunnels * 0 / 100)) : (!isQuadCore ? Math.min(MIN_LIMIT * 3 / 2, Math.max(MAX_LIMIT / 4, numTunnels * 1 / 100)) : (SystemVersion.getCores() >= 8 && SystemVersion.getMaxMemory() >= Integer.MIN_VALUE || isFast ? Math.min(MIN_LIMIT * 3, Math.max(MAX_LIMIT / 2, numTunnels * 2 / 100)) : Math.min(MIN_LIMIT * 2, Math.max(MAX_LIMIT / 3, numTunnels * 1 / 100)))));
        int count = this.counter.increment(h);
        int bantime = 1800000;
        int period = bantime / 60 / 1000;
        boolean shouldThrottle = this.context.getProperty(PROP_SHOULD_THROTTLE, true);
        boolean shouldDisconnect = this.context.getProperty(PROP_SHOULD_DISCONNECT, false);
        String v = ri != null ? (ri.getVersion() != null ? ri.getVersion() : "0.0.0") : "NoRI";
        String MIN_VERSION = "0.9.61";
        if (v.equals("0.0.0")) {
            if (shouldDisconnect) {
                this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            }
            rv = Result.DROP;
            if (this._log.shouldWarn()) {
                this._log.warn("Banning " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "] for " + period + "m -> No router version in RouterInfo");
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> No version in RouterInfo", null, null, this.context.clock().now() + (long)bantime);
        } else if (VersionComparator.comp(v, "0.9.57") < 0 && isCompressible) {
            this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            rv = Result.DROP;
            if (this._log.shouldWarn()) {
                this._log.warn("Banning " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "] for 4h -> Compressible RouterInfo / " + v);
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> Compressible RouterInfo &amp; older than 0.9.57", null, null, this.context.clock().now() + 57600000L);
        } else if (VersionComparator.comp(v, MIN_VERSION) < 0 && isLU) {
            if (shouldDisconnect) {
                this.context.commSystem().forceDisconnect(h);
                if (this._log.shouldWarn()) {
                    this._log.warn("Banning for " + period * 4 + "m and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> " + v + (caps != "" ? " / " + caps : ""));
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for " + period * 16 + "m -> " + v + (caps != "" ? " / " + caps : ""));
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> LU and older than current version", null, null, this.context.clock().now() + (long)(bantime * 4));
            rv = Result.DROP;
        } else if (VersionComparator.comp(v, MIN_VERSION) < 0 && isLowShare) {
            if (shouldDisconnect) {
                this.context.commSystem().forceDisconnect(h);
                if (this._log.shouldWarn()) {
                    this._log.warn("Ignoring tunnel request and immediately disconnecting from Router [" + h.toBase64().substring(0, 6) + "] -> " + v + (caps != "" ? " / " + caps : ""));
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Ignoring tunnel request from Router [" + h.toBase64().substring(0, 6) + "] -> " + v + (caps != "" ? " / " + caps : ""));
            }
            rv = Result.DROP;
        } else if (VersionComparator.comp(v, MIN_VERSION) < 0 && isUnreachable) {
            this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            rv = Result.DROP;
            if (this._log.shouldWarn()) {
                this._log.warn("Ignoring tunnel request from Router [" + h.toBase64().substring(0, 6) + "] -> " + v + (caps != "" ? " / " + caps : ""));
            }
        }
        if (count > limit && shouldThrottle) {
            if (isFast && !isUnreachable && count > limit * 11 / 9) {
                if (count == limit * 11 / 9 + 1) {
                    this.context.banlist().banlistRouter(h, " <b>\u279c</b> Excessive tunnel requests", null, null, this.context.clock().now() + (long)bantime);
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning fast " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "] for " + period + "m\n* Excessive tunnel requests -> Count/limit: " + count + "/" + limit * 11 / 9 + " in " + 220 + "s");
                    }
                } else {
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
                    if (this._log.shouldInfo()) {
                        this._log.info("Ignoring tunnel requests from temp banned " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "]\n* Count/limit: " + count + "/" + limit * 11 / 9 + " in " + 220 + "s");
                    }
                }
                rv = Result.DROP;
            } else if (!isLowShare && !isUnreachable && count > limit * 10 / 9) {
                if (count == limit * 10 / 9 + 1) {
                    this.context.banlist().banlistRouter(h, " <b>\u279c</b> Excessive tunnel requests", null, null, this.context.clock().now() + (long)bantime);
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning mid-tier " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "] for " + period + "m\n* Excessive tunnel requests -> Count/limit: " + count + "/" + limit * 10 / 9 + " in " + 220 + "s");
                    }
                } else if (this._log.shouldInfo()) {
                    this._log.info("Ignoring tunnel requests from temp banned " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "]\n* Count/limit: " + count + "/" + limit * 10 / 9 + " in " + 220 + "s");
                }
                rv = Result.DROP;
            } else if ((isLowShare || isUnreachable) && count > limit * 7 / 3) {
                if (count == limit * 7 / 3 + 1) {
                    this.context.banlist().banlistRouter(h, " <b>\u279c</b> Excessive tunnel requests", null, null, this.context.clock().now() + (long)bantime);
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning slow or unreachable " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "] for " + period + "m\n* Excessive tunnel requests -> Count/limit: " + count + "/" + limit * 7 / 3 + " in " + 220 + "s");
                    }
                } else {
                    this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
                    if (this._log.shouldInfo()) {
                        this._log.info("Ignoring tunnel requests from temp banned " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "]\n* Count/limit: " + count + "/" + limit * 7 / 3 + " in " + 220 + "s");
                    }
                }
                rv = Result.DROP;
            } else {
                rv = Result.REJECT;
                if (this._log.shouldWarn()) {
                    this._log.warn("Rejecting tunnel requests from " + (caps != null ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "] \n* High number of requests -> Count/limit: " + count + "/" + limit + " in " + 220 + "s");
                }
            }
        } else {
            rv = Result.ACCEPT;
            if (this._log.shouldDebug()) {
                this._log.debug("Accepting tunnel request from " + (caps != "" ? caps : "") + " Router [" + h.toBase64().substring(0, 6) + "]\n* Count: " + count + " in " + 220 + "s");
            }
        }
        return rv;
    }

    static {
        boolean bl = isHexaCore = SystemVersion.getCores() >= 6;
        MIN_LIMIT = (isSlow ? 20 : (isHexaCore ? 60 : 40)) / 3;
        MAX_LIMIT = (isSlow ? 100 : (isHexaCore ? 500 : 400)) / 3;
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            ParticipatingThrottler.this.context.commSystem().forceDisconnect(this.h);
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            ParticipatingThrottler.this.counter.clear();
        }
    }

    public static enum Result {
        ACCEPT,
        REJECT,
        DROP;

    }
}

