/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.irc;

import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.Base32;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.irc.EventReceiver;
import net.i2p.i2ptunnel.irc.I2PTunnelDCCClient;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class DCCClientManager
extends EventReceiver {
    private final I2PSocketManager sockMgr;
    private final EventDispatcher _dispatch;
    private final Logging l;
    private final I2PTunnel _tunnel;
    private final Log _log;
    private final ConcurrentHashMap<Integer, I2PTunnelDCCClient> _incoming;
    private final ConcurrentHashMap<Integer, I2PTunnelDCCClient> _active;
    private final ConcurrentHashMap<Integer, I2PTunnelDCCClient> _complete;
    private static long _id;
    private static final int MAX_INCOMING_PENDING = 10;
    private static final int MAX_INCOMING_ACTIVE = 10;

    public DCCClientManager(I2PSocketManager sktMgr, Logging logging, EventDispatcher dispatch, I2PTunnel tunnel) {
        this.sockMgr = sktMgr;
        this.l = logging;
        this._dispatch = dispatch;
        this._tunnel = tunnel;
        this._log = tunnel.getContext().logManager().getLog(DCCClientManager.class);
        this._incoming = new ConcurrentHashMap(8);
        this._active = new ConcurrentHashMap(8);
        this._complete = new ConcurrentHashMap(8);
    }

    public boolean close(boolean forced) {
        for (I2PTunnelDCCClient c : this._incoming.values()) {
            c.stop();
        }
        this._incoming.clear();
        for (I2PTunnelDCCClient c : this._active.values()) {
            c.stop();
        }
        this._active.clear();
        this._complete.clear();
        return true;
    }

    public int newIncoming(String b32, int port, String type) {
        return this.newIncoming(b32, port, type, 0);
    }

    private int newIncoming(String b32, int port, String type, int localPort) {
        if ((b32 = b32.toLowerCase(Locale.US)).length() != 60 || !b32.endsWith(".b32.i2p")) {
            return -1;
        }
        byte[] dec = Base32.decode(b32.substring(0, 52));
        if (dec == null || dec.length != 32) {
            return -1;
        }
        this.expireInbound();
        if (this._incoming.size() >= 10 || this._active.size() >= 10) {
            this._log.error("Too many incoming DCC, max is 10/10 pending/active");
            return -1;
        }
        try {
            I2PTunnelDCCClient cTunnel = new I2PTunnelDCCClient(b32, localPort, port, this.l, this.sockMgr, this._dispatch, this._tunnel, ++_id);
            cTunnel.attachEventDispatcher(this);
            cTunnel.startRunning();
            int lport = cTunnel.getLocalPort();
            if (this._log.shouldWarn()) {
                this._log.warn("Opened client tunnel at port " + lport + " pointing to " + b32 + ':' + port);
            }
            this._incoming.put(lport, cTunnel);
            return lport;
        }
        catch (IllegalArgumentException uhe) {
            this.l.log("Could not find listen host to bind to [" + this._tunnel.host + "]");
            this._log.error("Error finding host to bind", uhe);
            return -1;
        }
    }

    public int resumeOutgoing(int port) {
        Integer lport = port;
        I2PTunnelDCCClient tun = this._complete.get(lport);
        if (tun == null && (tun = this._active.get(lport)) == null) {
            tun = this._incoming.get(lport);
        }
        if (tun != null) {
            tun.stop();
            return tun.getLocalPort();
        }
        return -1;
    }

    public int acceptIncoming(int port) {
        for (I2PTunnelDCCClient tun : this._complete.values()) {
            if (tun.getRemotePort() != port) continue;
            return this.newIncoming(tun.getDest(), port, "ACCEPT", tun.getLocalPort());
        }
        for (I2PTunnelDCCClient tun : this._active.values()) {
            if (tun.getRemotePort() != port) continue;
            return this.newIncoming(tun.getDest(), port, "ACCEPT", tun.getLocalPort());
        }
        for (I2PTunnelDCCClient tun : this._incoming.values()) {
            if (tun.getRemotePort() != port) continue;
            tun.stop();
            return this.newIncoming(tun.getDest(), port, "ACCEPT", tun.getLocalPort());
        }
        return -1;
    }

    @Override
    public void notifyEvent(String eventName, Object args) {
        if (eventName.equals("connectionStarted")) {
            try {
                I2PTunnelDCCClient client = (I2PTunnelDCCClient)args;
                this.connStarted(client);
            }
            catch (ClassCastException client) {}
        } else if (eventName.equals("connectionStopped")) {
            try {
                Integer port = (Integer)args;
                this.connStopped(port);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void connStarted(I2PTunnelDCCClient client) {
        Integer lport = client.getLocalPort();
        I2PTunnelDCCClient c = this._incoming.remove(lport);
        if (c != null) {
            this._active.put(lport, client);
            if (this._log.shouldWarn()) {
                this._log.warn("Added client tunnel for port " + lport + " pending count now: " + this._incoming.size() + " active count now: " + this._active.size() + " complete count now: " + this._complete.size());
            }
        }
    }

    private void connStopped(Integer lport) {
        I2PTunnelDCCClient tun = this._incoming.remove(lport);
        if (tun != null) {
            this._complete.put(lport, tun);
        }
        if ((tun = this._active.remove(lport)) != null) {
            this._complete.put(lport, tun);
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Removed client tunnel for port " + lport + " pending count now: " + this._incoming.size() + " active count now: " + this._active.size() + " complete count now: " + this._complete.size());
        }
    }

    private void expireInbound() {
        I2PTunnelDCCClient c;
        Iterator<I2PTunnelDCCClient> iter = this._incoming.values().iterator();
        while (iter.hasNext()) {
            c = iter.next();
            if (c.getExpires() >= this._tunnel.getContext().clock().now()) continue;
            iter.remove();
            c.stop();
        }
        iter = this._complete.values().iterator();
        while (iter.hasNext()) {
            c = iter.next();
            if (c.getExpires() >= this._tunnel.getContext().clock().now()) continue;
            iter.remove();
            c.stop();
        }
    }
}

