/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.XML;
import org.cybergarage.xml.parser.JaxpParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLParser
extends JaxpParser {
    private final Log _log;
    public static final String TEXT_NAME = "#text";

    public XMLParser(I2PAppContext ctx) {
        this._log = ctx.logManager().getLog(XMLParser.class);
    }

    @Override
    public org.cybergarage.xml.Node parse(org.cybergarage.xml.Node parentNode, Node domNode, int rank) {
        Node child;
        int arrrsLen;
        short domNodeType = domNode.getNodeType();
        String domNodeName = domNode.getNodeName();
        String domNodeValue = domNode.getNodeValue();
        NamedNodeMap attrs = domNode.getAttributes();
        int n = arrrsLen = attrs != null ? attrs.getLength() : 0;
        if (this._log.shouldDebug()) {
            String val = domNodeValue != null ? " = \"" + domNodeValue.replace("\n", "\\n").replace("\r", "\\r") + '\"' : "";
            this._log.debug("[" + rank + "] ELEM : \"" + domNodeName + '\"' + val + " type = " + domNodeType + " with " + arrrsLen + " attrs");
        }
        if (domNodeType == 3) {
            if (domNodeValue.replaceAll("[ \t\r\n]", "").length() == 0) {
                return parentNode;
            }
            if (!parentNode.hasNodes()) {
                parentNode.addValue(domNodeValue);
                return parentNode;
            }
        } else if (domNodeType != 1) {
            return parentNode;
        }
        org.cybergarage.xml.Node node = new org.cybergarage.xml.Node();
        node.setName(domNodeName);
        node.setValue(domNodeValue);
        if (parentNode != null) {
            String oldValue = parentNode.getValue();
            if (oldValue != null && oldValue.length() > 0) {
                parentNode.setValue("");
                org.cybergarage.xml.Node text = new org.cybergarage.xml.Node();
                text.setName(TEXT_NAME);
                text.setValue(oldValue);
                parentNode.addNode(text);
                if (this._log.shouldDebug()) {
                    this._log.debug("Converted value to node");
                }
            }
            parentNode.addNode(node);
        }
        if (domNodeType == 3) {
            return parentNode;
        }
        if (attrs != null) {
            for (int n2 = 0; n2 < arrrsLen; ++n2) {
                Node attr = attrs.item(n2);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                node.setAttribute(attrName, attrValue);
            }
        }
        if ((child = domNode.getFirstChild()) == null) {
            node.setValue("");
            return node;
        }
        do {
            this.parse(node, child, rank + 1);
        } while ((child = child.getNextSibling()) != null);
        return node;
    }

    public static void toString(StringBuilder buf, org.cybergarage.xml.Node node) {
        XMLParser.output(buf, node, 0);
    }

    private static void output(StringBuilder buf, org.cybergarage.xml.Node node, int indentLevel) {
        String name = node.getName();
        String value = XML.escapeXMLChars(node.getValue());
        if (name.equals(TEXT_NAME)) {
            buf.append(value);
            return;
        }
        buf.append('<').append(name);
        int nAttributes = node.getNAttributes();
        for (int n = 0; n < nAttributes; ++n) {
            Attribute attr = node.getAttribute(n);
            buf.append(' ').append(attr.getName()).append("=\"").append(XML.escapeXMLChars(attr.getValue())).append('\"');
        }
        if (node.hasNodes()) {
            buf.append('>');
            int nChildNodes = node.getNNodes();
            for (int n = 0; n < nChildNodes; ++n) {
                org.cybergarage.xml.Node cnode = node.getNode(n);
                XMLParser.output(buf, cnode, indentLevel + 1);
            }
            buf.append("</").append(name).append('>');
        } else if (value == null || value.length() == 0) {
            buf.append(" />");
        } else {
            buf.append('>').append(value).append("</").append(name).append('>');
        }
    }
}

