/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.ndt;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ResourceBundle;

public class NDTUtils {
    public static String prtdbl(double paramDblToFormat) {
        String str = null;
        if (paramDblToFormat == 0.0) {
            return "0";
        }
        str = Double.toString(paramDblToFormat);
        int i = str.indexOf(".");
        if ((i += 3) > str.length()) {
            --i;
        }
        if (i > str.length()) {
            --i;
        }
        return str.substring(0, i);
    }

    public static String prttxt(int paramIntVal, ResourceBundle paramResBundObj) {
        String strNameTxt = null;
        switch (paramIntVal) {
            case -1: {
                strNameTxt = paramResBundObj.getString("systemFault");
                break;
            }
            case 0: {
                strNameTxt = paramResBundObj.getString("rtt");
                break;
            }
            case 1: {
                strNameTxt = paramResBundObj.getString("dialup2");
                break;
            }
            case 2: {
                strNameTxt = "T1";
                break;
            }
            case 3: {
                strNameTxt = "Ethernet";
                break;
            }
            case 4: {
                strNameTxt = "T3";
                break;
            }
            case 5: {
                strNameTxt = "FastE";
                break;
            }
            case 6: {
                strNameTxt = "OC-12";
                break;
            }
            case 7: {
                strNameTxt = "GigE";
                break;
            }
            case 8: {
                strNameTxt = "OC-48";
                break;
            }
            case 9: {
                strNameTxt = "10 Gig";
            }
        }
        return strNameTxt;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !NDTUtils.isEmpty(str);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

