/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SU3File;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.TrustedPluginKeys;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.Messages;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFile;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class PluginUpdateRunner
extends UpdateRunner {
    private String _appName;
    private final String _appDisplayName;
    private final String _oldVersion;
    private final URI _uri;
    private final String _xpi2pURL;
    private boolean _updated;
    private String _errMsg = "";
    private static final String XPI2P = "app.xpi2p";
    private static final String ZIP = "app.xpi2p.zip";
    public static final String PLUGIN_DIR = "plugins";
    private static final String PROP_ALLOW_NEW_KEYS = "routerconsole.allowUntrustedPlugins";

    public PluginUpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris, String appName, String oldVersion) {
        super(ctx, mgr, UpdateType.PLUGIN, uris);
        if (uris.isEmpty()) {
            throw new IllegalArgumentException("uri cannot be empty");
        }
        this._uri = uris.get(0);
        this._xpi2pURL = this._uri.toString();
        this._appName = appName;
        String appDisplayName = appName;
        try {
            Long.parseLong(appName);
            String s = this._uri.getPath();
            if (s != null) {
                String slc;
                int p = s.lastIndexOf(47);
                if (p >= 0) {
                    s = s.substring(p + 1);
                }
                if ((slc = s.toLowerCase(Locale.US)).endsWith(".su3")) {
                    s = s.substring(0, s.length() - 4);
                } else if (slc.endsWith(".xpi2p")) {
                    s = s.substring(0, s.length() - 6);
                }
                if (s.length() > 0) {
                    appDisplayName = s;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._appDisplayName = appDisplayName;
        this._oldVersion = oldVersion;
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    @Override
    public String getID() {
        return this._appName;
    }

    @Override
    protected void update() {
        this._updated = false;
        if (this._xpi2pURL.startsWith("file:") || this._method == UpdateMethod.FILE) {
            String xpi2pfile = this._uri.getPath();
            if (xpi2pfile == null || xpi2pfile.length() == 0) {
                this.statusDone("<b>" + this._t("Bad URL {0}", this._xpi2pURL) + "</b>");
            } else {
                long alreadyTransferred = new File(xpi2pfile).getAbsoluteFile().length();
                if (FileUtil.copy(new File(xpi2pfile).getAbsolutePath(), this._updateFile, true, false)) {
                    this.updateStatus("<b>" + this._t("Attempting to install from file {0}", this._xpi2pURL) + "</b>");
                    this.transferComplete(alreadyTransferred, alreadyTransferred, 0L, this._xpi2pURL, this._updateFile, false);
                } else {
                    this.statusDone("<b>" + this._t("Failed to install from file {0}, copy failed.", this._xpi2pURL) + "</b>");
                }
            }
        } else {
            boolean shouldProxy = true;
            String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
            int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
            if (shouldProxy && proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
                String msg = this._t("HTTP client proxy tunnel must be running");
                if (this._log.shouldWarn()) {
                    this._log.warn(msg);
                }
                this.statusDone("<b>" + msg + "</b>");
                this._mgr.notifyTaskFailed(this, msg, null);
                return;
            }
            this.updateStatus("<b>" + this._t("Downloading plugin from {0}", this._xpi2pURL).replace("http://", "") + "</b>");
            try {
                this._get = shouldProxy ? new EepGet((I2PAppContext)this._context, proxyHost, proxyPort, 10, this._updateFile, this._xpi2pURL, false) : new EepGet(this._context, 1, this._updateFile, this._xpi2pURL, false);
                this._get.addStatusListener(this);
                this._get.fetch(55000L, -1L, shouldProxy ? 300000L : 60000L);
            }
            catch (Throwable t) {
                this._log.error("Error downloading plugin", t);
            }
        }
        if (this._updated) {
            this._mgr.notifyComplete(this, this._newVersion, null);
            this._mgr.notifyComplete(this, this._errMsg);
        } else {
            this._mgr.notifyTaskFailed(this, this._errMsg, null);
        }
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        long d = (long)currentWrite + bytesTransferred;
        String status = "<b>" + this._t("Downloading plugin") + ": " + this._appDisplayName + "</b>";
        this._mgr.notifyProgress(this, status, d, d + bytesRemaining);
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        boolean isSU3;
        if (!this._xpi2pURL.startsWith("file:") && this._method != UpdateMethod.FILE) {
            this.updateStatus("<b>" + this._t("Plugin downloaded") + ": " + this._appDisplayName + "</b>");
        }
        File f = new File(this._updateFile);
        SecureDirectory appDir = new SecureDirectory(this._context.getConfigDir(), PLUGIN_DIR);
        if (!appDir.exists() && !((File)appDir).mkdir()) {
            f.delete();
            this.statusDone("<b>" + this._t("Cannot create plugin directory {0}", appDir.getAbsolutePath()) + "</b>");
            return;
        }
        try {
            isSU3 = PluginUpdateRunner.isSU3File(f);
        }
        catch (IOException ioe) {
            f.delete();
            this.statusDone("<b>" + ioe + "</b>");
            return;
        }
        if (isSU3) {
            this.processSU3(f, appDir, url);
        } else {
            this.processSUD(f, appDir, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSU3File(File f) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            for (int i = 0; i < "I2Psu3".length(); ++i) {
                if (fis.read() == "I2Psu3".charAt(i)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processSUD(File f, File appDir, String url) {
        SigningPublicKey spk;
        TrustedUpdate up = new TrustedUpdate(this._context);
        File to = new File(this._context.getTempDir(), "tmp" + this._context.random().nextInt() + ZIP);
        String err = up.migrateFile(f, to);
        if (err != null) {
            this.statusDone("<b>" + err + ' ' + this._t("from {0}", url) + " </b>");
            f.delete();
            to.delete();
            return;
        }
        Properties props = this.getPluginConfig(f, to, url);
        if (props == null) {
            return;
        }
        String pubkey = props.getProperty("key");
        String signer = DataHelper.stripHTML(props.getProperty("signer"));
        if (pubkey == null || signer == null || pubkey.length() != 172 || signer.length() <= 0) {
            f.delete();
            to.delete();
            this.statusDone("<b>" + this._t("Plugin from {0} contains an invalid key", url) + "</b>");
            return;
        }
        try {
            spk = new SigningPublicKey(pubkey);
        }
        catch (DataFormatException dfe) {
            f.delete();
            to.delete();
            this.statusDone("<b>" + this._t("Plugin from {0} contains an invalid key", url) + "</b>");
            return;
        }
        Map<String, String> existingKeys = PluginStarter.getPluginKeys(this._context);
        for (Map.Entry<String, String> entry : existingKeys.entrySet()) {
            up.addKey(entry.getKey(), entry.getValue());
        }
        Map<String, String> trustedKeys = TrustedPluginKeys.getKeys();
        for (Map.Entry<String, String> entry : trustedKeys.entrySet()) {
            up.addKey(entry.getKey(), entry.getValue());
        }
        if (up.haveKey(pubkey)) {
            boolean bl = up.verify(f, spk);
            String string = up.getKeys().get(spk);
            if (!bl || !signer.equals(string) && !"".equals(string)) {
                f.delete();
                to.delete();
                if (string == null) {
                    this._log.error("Failed to verify plugin signature, corrupt plugin or bad signature, signed by: " + signer);
                } else {
                    this._log.error("Plugin signer \"" + signer + "\" does not match existing signer in plugin.config file \"" + string + "\"");
                }
                this.statusDone("<b>" + this._t("Plugin signature verification of {0} failed", url) + "</b>");
                return;
            }
        } else if (this._context.getBooleanProperty(PROP_ALLOW_NEW_KEYS)) {
            if (!up.addKey(pubkey, signer)) {
                f.delete();
                to.delete();
                this._log.error("Bad key or key mismatch - Failed to add plugin key \"" + pubkey + "\" for plugin signer \"" + signer + "\"");
                this.statusDone("<b>" + this._t("Plugin signature verification of {0} failed", url) + "</b>");
                return;
            }
            String string = up.verifyAndGetSigner(f);
            if (!signer.equals(string)) {
                f.delete();
                to.delete();
                if (string == null) {
                    this._log.error("Failed to verify plugin signature, corrupt plugin or bad signature, signed by: " + signer);
                } else {
                    this._log.error("Plugin signer \"" + signer + "\" does not match new signer in plugin.config file \"" + string + "\"");
                }
                this.statusDone("<b>" + this._t("Plugin signature verification of {0} failed", url) + "</b>");
                return;
            }
        } else {
            f.delete();
            to.delete();
            this._log.error("Untrusted plugin key \"" + pubkey + "\" for plugin signer \"" + signer + "\"");
            this.statusDone("<b>" + this._t("Plugin not installed - signer is untrusted") + "</b>");
            return;
        }
        String string = TrustedUpdate.getVersionString(f);
        f.delete();
        this.processFinal(to, appDir, url, props, string, pubkey, signer);
    }

    private void processSU3(File f, File appDir, String url) {
        String signingKeyName;
        String sudVersion;
        SU3File su3 = new SU3File(this._context, f);
        File to = new File(this._context.getTempDir(), "tmp" + this._context.random().nextInt() + ZIP);
        try {
            su3.verifyAndMigrate(to);
            if (su3.getFileType() != 0) {
                throw new IOException("bad file type");
            }
            if (su3.getContentType() != 2) {
                throw new IOException("bad content type");
            }
            sudVersion = su3.getVersionString();
            signingKeyName = su3.getSignerString();
        }
        catch (IOException ioe) {
            this.statusDone("<b>" + ioe + ' ' + this._t("from {0}", url) + " </b>");
            f.delete();
            to.delete();
            return;
        }
        Properties props = this.getPluginConfig(f, to, url);
        if (props == null) {
            return;
        }
        String signer = props.getProperty("signer");
        if (signer == null || signer.length() <= 0) {
            f.delete();
            to.delete();
            this.statusDone("<b>" + this._t("Plugin from {0} contains an invalid key", url) + "</b>");
            return;
        }
        if (!signer.equals(signingKeyName)) {
            f.delete();
            to.delete();
            if (signingKeyName == null) {
                this._log.error("Failed to verify plugin signature, corrupt plugin or bad signature, signed by: " + signer);
            } else {
                this._log.error("Plugin signer \"" + signer + "\" does not match new signer in plugin.config file \"" + signingKeyName + "\"");
            }
            this.statusDone("<b>" + this._t("Plugin signature verification of {0} failed", url) + "</b>");
            return;
        }
        this.processFinal(to, appDir, url, props, sudVersion, null, signer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPluginConfig(File f, File to, String url) {
        File tempDir = new File(this._context.getTempDir(), "tmp" + this._context.random().nextInt() + "-unzip");
        if (!FileUtil.extractZip(to, tempDir, 40)) {
            f.delete();
            to.delete();
            FileUtil.rmdir(tempDir, false);
            String msg = this._t("Plugin from {0} is corrupt", url);
            if (!FileUtil.isPack200Supported()) {
                msg = msg + " (or requires Pack200 which is unsupported in this JVM)";
            }
            this.statusDone("<b>" + msg + "</b>");
            return null;
        }
        File installProps = new File(tempDir, "plugin.config");
        OrderedProperties props = new OrderedProperties();
        try {
            DataHelper.loadProps((Properties)props, installProps);
        }
        catch (IOException ioe) {
            f.delete();
            to.delete();
            this.statusDone("<b>" + this._t("Plugin from {0} does not contain the required configuration file", url) + "</b>");
            Properties properties = null;
            return properties;
        }
        finally {
            FileUtil.rmdir(tempDir, false);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFinal(File to, File appDir, String url, Properties props, String sudVersion, String pubkey, String signer) {
        boolean update = false;
        String appName = props.getProperty("name");
        String version = props.getProperty("version");
        if (appName == null || version == null || appName.length() <= 0 || version.length() <= 0 || appName.indexOf(60) >= 0 || appName.indexOf(62) >= 0 || version.indexOf(60) >= 0 || version.indexOf(62) >= 0 || appName.startsWith(".") || appName.indexOf(47) >= 0 || appName.indexOf(92) >= 0) {
            to.delete();
            this.statusDone("<b>" + this._t("Plugin from {0} has invalid name or version", url).replace("http://", "") + "</b>");
            return;
        }
        if (!version.equals(sudVersion)) {
            to.delete();
            this.statusDone("<b>" + this._t("Plugin {0} has mismatched versions", appName) + "</b>");
            return;
        }
        this._appName = appName;
        this._newVersion = version;
        String minVersion = PluginStarter.stripHTML(props, "min-i2p-version");
        if (minVersion != null && VersionComparator.comp("2.9.0", minVersion) < 0) {
            to.delete();
            this.statusDone("<b>" + this._t("This plugin requires I2P version {0} or higher", minVersion) + "</b>");
            return;
        }
        minVersion = PluginStarter.stripHTML(props, "min-java-version");
        if (minVersion != null && !SystemVersion.isJava(minVersion)) {
            to.delete();
            this.statusDone("<b>" + this._t("This plugin requires Java version {0} or higher", minVersion) + "</b>");
            return;
        }
        boolean wasRunning = false;
        SecureDirectory destDir = new SecureDirectory(appDir, appName);
        if (destDir.exists()) {
            if (Boolean.parseBoolean(props.getProperty("install-only"))) {
                to.delete();
                this.statusDone("<b>" + this._t("Downloaded plugin is for new installs only, but the plugin is already installed", url) + "</b>");
                return;
            }
            File oldPropFile = new File(destDir, "plugin.config");
            OrderedProperties oldProps = new OrderedProperties();
            try {
                DataHelper.loadProps((Properties)oldProps, oldPropFile);
            }
            catch (IOException ioe) {
                to.delete();
                this.statusDone("<b>" + this._t("Installed plugin does not contain the required configuration file", url) + "</b>");
                return;
            }
            String oldPubkey = oldProps.getProperty("key");
            String oldKeyName = oldProps.getProperty("signer");
            String oldAppName = oldProps.getProperty("name");
            if (pubkey != null && !pubkey.equals(oldPubkey) || !signer.equals(oldKeyName) || !appName.equals(oldAppName)) {
                to.delete();
                this.statusDone("<b>" + this._t("Signature of downloaded plugin does not match installed plugin") + "</b>");
                return;
            }
            String oldVersion = oldProps.getProperty("version");
            if (oldVersion == null || VersionComparator.comp(oldVersion, version) >= 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Downloaded plugin version {0} is not newer than installed plugin", version).replace("Downloaded plugin version", "") + "</b>");
                return;
            }
            minVersion = PluginStarter.stripHTML(props, "min-installed-version");
            if (minVersion != null && VersionComparator.comp(minVersion, oldVersion) > 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin update requires installed plugin version {0} or higher", minVersion) + "</b>");
                return;
            }
            String maxVersion = PluginStarter.stripHTML(props, "max-installed-version");
            if (maxVersion != null && VersionComparator.comp(maxVersion, oldVersion) < 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin update requires installed plugin version {0} or lower", maxVersion) + "</b>");
                return;
            }
            oldVersion = RouterConsoleRunner.jettyVersion();
            minVersion = PluginStarter.stripHTML(props, "min-jetty-version");
            if (minVersion != null && VersionComparator.comp(minVersion, oldVersion) > 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin requires Jetty version {0} or higher", minVersion) + "</b>");
                return;
            }
            String blacklistVersion = PluginStarter.jetty9Blacklist.get(appName);
            if (blacklistVersion != null && VersionComparator.comp(version, blacklistVersion) <= 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin requires Jetty version {0} or lower", "8.9999") + "</b>");
                return;
            }
            if (SystemVersion.isJava9() && (blacklistVersion = PluginStarter.java9Blacklist.get(appName)) != null && VersionComparator.comp(version, blacklistVersion) <= 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin requires Java version {0} or lower", "8.9999") + "</b>");
                return;
            }
            maxVersion = PluginStarter.stripHTML(props, "max-jetty-version");
            if (maxVersion != null && VersionComparator.comp(maxVersion, oldVersion) < 0) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin requires Jetty version {0} or lower", maxVersion) + "</b>");
                return;
            }
            if (Boolean.parseBoolean(props.getProperty("router-restart-required"))) {
                try {
                    if (!FileUtil.copy(to, new SecureFile(new SecureFile(appDir.getCanonicalPath() + "/" + appName + "/" + ZIP).getCanonicalPath()), true, true)) {
                        to.delete();
                        this.statusDone("<b>" + this._t("Cannot copy plugin to directory {0}", destDir.getAbsolutePath()) + "</b>");
                        return;
                    }
                }
                catch (Throwable t) {
                    to.delete();
                    this._log.error("Error copying plugin {0}", t);
                    return;
                }
                to.delete();
                this.statusDone("<b>" + this._t("Plugin will be installed on next restart.") + ' ' + appName + ' ' + version + "</b>");
                return;
            }
            if (PluginStarter.isPluginRunning(appName, this._context)) {
                wasRunning = true;
                try {
                    if (PluginStarter.stopPlugin(this._context, appName)) {
                        // empty if block
                    }
                }
                catch (Throwable e) {
                    this._log.error("Error stopping plugin " + appName, e);
                }
            }
            update = true;
        } else {
            if (Boolean.parseBoolean(props.getProperty("update-only"))) {
                to.delete();
                this.statusDone("<b>" + this._t("Plugin is for upgrades only, but the plugin is not installed") + ". " + appName + ' ' + version + "</b>");
                return;
            }
            if (!((File)destDir).mkdir()) {
                to.delete();
                this.statusDone("<b>" + this._t("Cannot create plugin directory {0}", destDir.getAbsolutePath()) + "</b>");
                return;
            }
        }
        if (!FileUtil.extractZip(to, destDir, 30)) {
            to.delete();
            this.statusDone("<b>" + this._t("Failed to install plugin in {0}", destDir.getAbsolutePath()) + "</b>");
            return;
        }
        this._updated = true;
        to.delete();
        if (Boolean.parseBoolean(props.getProperty("dont-start-at-install"))) {
            this.statusDone("<b>" + this._t("Plugin {0} installed", appName + ' ' + version) + "</b>");
            if (update) return;
            Properties pluginProps = PluginStarter.pluginProperties();
            pluginProps.setProperty("plugin." + appName + ".startOnLoad", "false");
            PluginStarter.storePluginProperties(pluginProps);
            return;
        }
        if (!wasRunning && !PluginStarter.isPluginEnabled(appName)) {
            this.statusDone("<b>" + this._t("Plugin {0} installed", appName + ' ' + version) + "</b>");
            return;
        }
        try {
            if (!PluginStarter.startPlugin(this._context, appName)) {
                this.statusDone("<b>" + this._t("Plugin {0} installed but failed to start, check logs", appName + ' ' + version) + "</b>");
                return;
            }
            String linkName = PluginStarter.stripHTML(props, "consoleLinkName_" + Messages.getLanguage(this._context));
            if (linkName == null) {
                linkName = PluginStarter.stripHTML(props, "consoleLinkName");
            }
            String linkURL = PluginStarter.stripHTML(props, "consoleLinkURL");
            String link = linkName != null && linkURL != null ? "<a target=_blank href=\"" + linkURL + "\"/>" + linkName + ' ' + version + "</a>" : appName + ' ' + version;
            this.statusDone("<b>" + this._t("Plugin {0} installed and started", link) + "</b>");
            return;
        }
        catch (Throwable e) {
            this.statusDone("<b>" + this._t("Plugin {0} installed but failed to start", appName + ' ' + version) + ": " + e + "</b>");
            this._log.error("Error starting plugin " + appName + ' ' + version, e);
            return;
        }
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        File f = new File(this._updateFile);
        f.delete();
        this.statusDone("<b>" + this._t("Failed to download plugin from {0}", url) + "</b>");
    }

    private void statusDone(String msg) {
        this._errMsg = msg;
        this.updateStatus(msg);
    }
}

