/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import eu.bengreen.data.utility.LargestTriangleThreeBucketsTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.imageio.stream.ImageInputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.GraphGenerator;
import net.i2p.router.web.GraphListener;
import net.i2p.router.web.Messages;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.rrd4j.core.RrdException;
import org.rrd4j.data.Variable;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;
import org.rrd4j.graph.SVGImageWorker;

class GraphRenderer {
    private final Log _log;
    private final GraphListener _listener;
    private final I2PAppContext _context;
    private static final String PROP_THEME_NAME = "routerconsole.theme";
    private static final String DEFAULT_THEME = "dark";
    private static final Color WHITE = new Color(255, 255, 255);
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Color CANVAS_COLOR_DARK = new Color(0, 0, 0);
    private static final Color BACK_COLOR = new Color(255, 255, 255);
    private static final Color BACK_COLOR_DARK = new Color(0, 0, 0, 192);
    private static final Color SHADEA_COLOR = new Color(255, 255, 255);
    private static final Color SHADEA_COLOR_DARK = new Color(0, 0, 0);
    private static final Color SHADEB_COLOR = new Color(255, 255, 255);
    private static final Color SHADEB_COLOR_DARK = new Color(0, 0, 0);
    private static final Color GRID_COLOR = new Color(80, 80, 80, 50);
    private static final Color GRID_COLOR_DARK = new Color(244, 244, 190, 50);
    private static final Color GRID_COLOR_DARK2 = new Color(244, 244, 190, 30);
    private static final Color GRID_COLOR_MIDNIGHT = new Color(201, 206, 255, 50);
    private static final Color GRID_COLOR_HIDDEN = new Color(0, 0, 0, 0);
    private static final Color MGRID_COLOR = new Color(255, 91, 91, 110);
    private static final Color MGRID_COLOR_DARK = new Color(200, 200, 0, 50);
    private static final Color MGRID_COLOR_MIDNIGHT = new Color(240, 32, 192, 110);
    private static final Color FONT_COLOR = new Color(51, 51, 63);
    private static final Color FONT_COLOR_DARK = new Color(244, 244, 190);
    private static final Color FONT_COLOR_MIDNIGHT = new Color(201, 206, 255);
    private static final Color AXIS_COLOR_DARK = new Color(244, 244, 190, 200);
    private static final Color AXIS_COLOR_MIDNIGHT = new Color(201, 206, 255, 200);
    private static final Color FRAME_COLOR = new Color(0, 0, 0, 0);
    private static final Color FRAME_COLOR_DARK = new Color(0, 0, 0, 0);
    private static final Color AREA_COLOR = new Color(100, 160, 200, 200);
    private static final Color AREA_COLOR_DARK = new Color(0, 72, 8, 220);
    private static final Color AREA_COLOR_MIDNIGHT = new Color(0, 72, 160, 200);
    private static final Color AREA_COLOR_NEUTRAL = new Color(128, 128, 128, 128);
    private static final Color LINE_COLOR = new Color(0, 30, 110, 255);
    private static final Color LINE_COLOR_DARK = new Color(100, 200, 160);
    private static final Color LINE_COLOR_MIDNIGHT = new Color(128, 180, 212);
    private static final Color ARROW_COLOR_DARK = new Color(0, 0, 0, 0);
    private static final Color RESTART_BAR_COLOR = new Color(223, 13, 13, 255);
    private static final Color RESTART_BAR_COLOR_DARK = new Color(220, 16, 48, 220);
    private static final boolean IS_WIN = SystemVersion.isWindows();
    String DEFAULT_FONT_NAME = IS_WIN ? "Lucida Console" : "Monospaced";
    String DEFAULT_TITLE_FONT_NAME = "Dialog";
    String DEFAULT_LEGEND_FONT_NAME = "Dialog";
    private static final String PROP_FONT_MONO = "routerconsole.graphFont.unit";
    private static final String PROP_FONT_LEGEND = "routerconsole.graphFont.legend";
    private static final String PROP_FONT_TITLE = "routerconsole.graphFont.title";
    private static final int SIZE_MONO = 10;
    private static final int SIZE_LEGEND = 11;
    private static final int SIZE_TITLE = 12;
    private static final long[] RATES = new long[]{60000L, 3600000L};
    private static final Stroke GRID_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
    String[] sysfonts = this.e.getAvailableFontFamilyNames();
    List<String> fontlist = Arrays.asList(this.sysfonts);

    public GraphRenderer(I2PAppContext ctx, GraphListener lsnr) {
        this._log = ctx.logManager().getLog(GraphRenderer.class);
        this._listener = lsnr;
        this._context = ctx;
        ctx.statManager().createRateStat("graph.renderTime", "Time to render graphs (ms)", "Router", RATES);
    }

    @Deprecated
    public static synchronized void render(I2PAppContext ctx, OutputStream out, String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void render(OutputStream out) throws IOException {
        this.render(out, 400, 100, false, false, false, false, -1, 0, false);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit) throws IOException {
        this.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, endp, showCredit, null, null);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit, GraphListener lsnr2, String titleOverride) throws IOException {
        long begin = System.currentTimeMillis();
        long end = Math.min(this._listener.now(), begin - 75000L);
        long period = this._listener.getRate().getPeriod();
        if (endp > 0) {
            end -= period * (long)endp;
        }
        if (periodCount <= 0 || periodCount > this._listener.getRows()) {
            periodCount = this._listener.getRows();
        }
        long start = end - period * (long)periodCount;
        ImageInputStream ios = null;
        String theme = this._context.getProperty(PROP_THEME_NAME, DEFAULT_THEME);
        try {
            Color RESTART_COLOR;
            String numberFormat;
            String descr;
            String plotName;
            String name;
            String lang;
            RrdGraphDef def = new RrdGraphDef(start / 1000L, end / 1000L);
            if (periodCount >= 10080) {
                def.setDownsampler(new LargestTriangleThreeBucketsTime(100));
            } else if (periodCount >= 2880) {
                def.setDownsampler(new LargestTriangleThreeBucketsTime(200));
            } else if (periodCount >= 1440) {
                def.setDownsampler(new LargestTriangleThreeBucketsTime(500));
            }
            if (width == 250 && height == 50 && hideTitle && hideLegend && hideGrid || width == 2000 && height == 160 && hideTitle && hideLegend && hideGrid) {
                def.setColor(ElementsNames.xaxis, (Paint)TRANSPARENT);
                def.setColor(ElementsNames.yaxis, (Paint)TRANSPARENT);
                def.setColor(ElementsNames.frame, (Paint)TRANSPARENT);
            } else if (theme.equals("midnight")) {
                def.setColor(ElementsNames.font, (Paint)FONT_COLOR_MIDNIGHT);
                def.setColor(ElementsNames.xaxis, (Paint)AXIS_COLOR_MIDNIGHT);
                def.setColor(ElementsNames.yaxis, (Paint)AXIS_COLOR_MIDNIGHT);
            } else if (theme.equals(DEFAULT_THEME)) {
                def.setColor(ElementsNames.font, (Paint)FONT_COLOR_DARK);
                def.setColor(ElementsNames.xaxis, (Paint)AXIS_COLOR_DARK);
                def.setColor(ElementsNames.yaxis, (Paint)AXIS_COLOR_DARK);
            }
            if (theme.equals("midnight") || theme.equals(DEFAULT_THEME)) {
                def.setColor(ElementsNames.back, (Paint)BACK_COLOR_DARK);
                def.setColor(ElementsNames.canvas, (Paint)TRANSPARENT);
            } else {
                def.setColor(ElementsNames.back, (Paint)BACK_COLOR);
            }
            if (theme.equals("midnight") || theme.equals(DEFAULT_THEME)) {
                def.setColor(ElementsNames.shadea, (Paint)TRANSPARENT);
                def.setColor(ElementsNames.shadeb, (Paint)TRANSPARENT);
                if (theme.equals(DEFAULT_THEME)) {
                    def.setColor(ElementsNames.grid, (Paint)GRID_COLOR_DARK2);
                    def.setColor(ElementsNames.mgrid, (Paint)MGRID_COLOR_DARK);
                } else if (theme.equals("midnight")) {
                    def.setColor(ElementsNames.grid, (Paint)GRID_COLOR_MIDNIGHT);
                    def.setColor(ElementsNames.mgrid, (Paint)MGRID_COLOR_MIDNIGHT);
                }
                def.setColor(ElementsNames.frame, (Paint)FRAME_COLOR_DARK);
                def.setColor(ElementsNames.arrow, (Paint)ARROW_COLOR_DARK);
            } else {
                def.setColor(ElementsNames.shadea, (Paint)SHADEA_COLOR);
                def.setColor(ElementsNames.shadeb, (Paint)SHADEB_COLOR);
                def.setColor(ElementsNames.grid, (Paint)GRID_COLOR);
                def.setColor(ElementsNames.mgrid, (Paint)MGRID_COLOR);
                def.setColor(ElementsNames.font, (Paint)FONT_COLOR);
                def.setColor(ElementsNames.frame, (Paint)FRAME_COLOR);
            }
            if (width < 400 || height < 200 || periodCount < 120) {
                def.setColor(ElementsNames.grid, (Paint)GRID_COLOR_HIDDEN);
                if (theme.equals("midnight")) {
                    def.setColor(ElementsNames.mgrid, (Paint)GRID_COLOR_MIDNIGHT);
                } else if (theme.equals(DEFAULT_THEME)) {
                    def.setColor(ElementsNames.mgrid, (Paint)GRID_COLOR_DARK);
                } else {
                    def.setColor(ElementsNames.mgrid, (Paint)GRID_COLOR);
                }
            }
            if ((lang = Messages.getLanguage(this._context)) == null) {
                lang = "en";
            }
            int smallSize = 10;
            int legendSize = 11;
            int largeSize = 12;
            if ("ar".equals(lang) || "ja".equals(lang) || "zh".equals(lang) && !IS_WIN) {
                smallSize += 2;
                legendSize += 2;
                largeSize += 3;
            } else if (width >= 800) {
                ++smallSize;
                ++legendSize;
                largeSize += 2;
            }
            if ("zh".equals(Messages.getLanguage(this._context))) {
                this.DEFAULT_TITLE_FONT_NAME = this.fontlist.contains("Noto Sans SC") ? "Noto Sans SC" : (this.fontlist.contains("Noto Sans CJK SC") ? "Noto Sans CJK SC" : (this.fontlist.contains("Source Han Sans SC") ? "Source Han Sans SC" : "Dialog"));
                if (this.fontlist.contains("Noto Sans Mono SC")) {
                    this.DEFAULT_FONT_NAME = "Noto Sans Mono SC";
                    this.DEFAULT_LEGEND_FONT_NAME = "Noto Sans Mono SC";
                } else if (this.fontlist.contains("Noto Sans Mono CJK SC")) {
                    this.DEFAULT_FONT_NAME = "Noto Sans Mono CJK SC";
                    this.DEFAULT_LEGEND_FONT_NAME = "Noto Sans Mono CJK SC";
                } else {
                    this.DEFAULT_FONT_NAME = "Monospaced";
                    this.DEFAULT_LEGEND_FONT_NAME = "Monospaced";
                }
            } else if ("jp".equals(Messages.getLanguage(this._context))) {
                this.DEFAULT_TITLE_FONT_NAME = this.fontlist.contains("Noto Sans JP") ? "Noto Sans JP" : (this.fontlist.contains("Noto Sans CJK JP") ? "Noto Sans CJK JP" : (this.fontlist.contains("Source Han Sans JP") ? "Source Han Sans JP" : "Dialog"));
                if (this.fontlist.contains("Noto Sans Mono JP")) {
                    this.DEFAULT_FONT_NAME = "Noto Sans Mono JP";
                    this.DEFAULT_LEGEND_FONT_NAME = "Noto Sans Mono JP";
                } else if (this.fontlist.contains("Noto Sans Mono CJK JP")) {
                    this.DEFAULT_FONT_NAME = "Noto Sans Mono CJK JP";
                    this.DEFAULT_LEGEND_FONT_NAME = "Noto Sans Mono CJK JP";
                } else {
                    this.DEFAULT_FONT_NAME = "Monospaced";
                    this.DEFAULT_LEGEND_FONT_NAME = "Monospaced";
                }
            } else if ("ko".equals(Messages.getLanguage(this._context))) {
                this.DEFAULT_TITLE_FONT_NAME = this.fontlist.contains("Noto Sans KO") ? "Noto Sans KO" : (this.fontlist.contains("Noto Sans CJK KO") ? "Noto Sans CJK KO" : (this.fontlist.contains("Source Han Sans KO") ? "Source Han Sans KO" : "Dialog"));
                if (this.fontlist.contains("Noto Sans Mono KO")) {
                    this.DEFAULT_FONT_NAME = "Noto Sans Mono KO";
                    this.DEFAULT_LEGEND_FONT_NAME = "Noto Sans Mono KO";
                } else if (this.fontlist.contains("Noto Sans Mono CJK KO")) {
                    this.DEFAULT_FONT_NAME = "Noto Sans Mono CJK KO";
                    this.DEFAULT_LEGEND_FONT_NAME = "Noto Sans Mono CJK KO";
                } else {
                    this.DEFAULT_FONT_NAME = "Monospaced";
                    this.DEFAULT_LEGEND_FONT_NAME = "Monospaced";
                }
            } else {
                this.DEFAULT_FONT_NAME = "Monospaced";
                this.DEFAULT_LEGEND_FONT_NAME = "Monospaced";
                this.DEFAULT_TITLE_FONT_NAME = "SansSerif";
            }
            String ssmall = this._context.getProperty(PROP_FONT_MONO, this.DEFAULT_FONT_NAME);
            String slegend = this._context.getProperty(PROP_FONT_TITLE, this.DEFAULT_TITLE_FONT_NAME);
            String stitle = this._context.getProperty(PROP_FONT_TITLE, this.DEFAULT_TITLE_FONT_NAME);
            Font small = new Font(ssmall, 0, smallSize);
            Font legnd = new Font(slegend, 0, legendSize);
            Font large = new Font(stitle, 0, largeSize);
            def.setFont(RrdGraphDef.FONTTAG_DEFAULT, small);
            def.setFont(RrdGraphDef.FONTTAG_AXIS, small);
            def.setFont(RrdGraphDef.FONTTAG_UNIT, small);
            def.setFont(RrdGraphDef.FONTTAG_LEGEND, legnd);
            def.setFont(RrdGraphDef.FONTTAG_TITLE, large);
            def.setMinValue(0.0);
            String graphTitle = name = this._listener.getRate().getRateStat().getName();
            if (name.startsWith("tunnel.participatingTunnels")) {
                graphTitle = graphTitle.replaceAll("tunnel.participatingTunnels", "[Transit] Tunnel Count");
            }
            if (name.startsWith("tunnel.participatingMessage")) {
                graphTitle = graphTitle.replaceAll("tunnel.participatingMessage", "[Transit] Message");
            } else if (name.startsWith("tunnel.participating")) {
                graphTitle = graphTitle.replaceAll("tunnel.participating", "[Transit]");
            } else if (name.startsWith("Tunnel.participating")) {
                graphTitle = graphTitle.replaceAll("Tunnel.participating", "[Transit]");
            }
            if (name.startsWith("router.")) {
                graphTitle = graphTitle.replaceAll("router.", "[Router] ");
            }
            if (name.startsWith("bw.")) {
                graphTitle = graphTitle.replaceAll("bw.", "[Router] ");
            }
            if (name.startsWith("Bandwidth usage")) {
                graphTitle = graphTitle.replaceAll("Bandwidth usage", "[Router] Bandwidth Usage");
            }
            if (name.startsWith("tunnel.buildRatio.exploratory.")) {
                graphTitle = graphTitle.replaceAll("tunnel.buildRatio.exploratory.", "[Exploratory] Build Ratio");
            }
            if (name.startsWith("tunnel.buildExploratory")) {
                graphTitle = graphTitle.replaceAll("tunnel.buildExploratory", "[Exploratory] Build");
            }
            if (name.startsWith("tunnel.buildClient")) {
                graphTitle = graphTitle.replaceAll("tunnel.buildClient", "[Tunnel] BuildClient");
            } else if (name.startsWith("tunnel.build")) {
                graphTitle = graphTitle.replaceAll("tunnel.build", "[Tunnel] Build");
            } else if (name.startsWith("tunnel.")) {
                graphTitle = graphTitle.replaceAll("tunnel.", "[Tunnel] ");
            }
            if (name.contains("MessageCountAvg")) {
                graphTitle = graphTitle.replaceAll("MessageCountAvg", "Messsage Count Average");
            }
            if (name.startsWith("netDb.")) {
                graphTitle = graphTitle.replaceAll("netDb.", "[NetDb] ");
            }
            if (name.startsWith("jobQueue.")) {
                graphTitle = graphTitle.replaceAll("jobQueue.", "[JobQueue] ");
            }
            if (name.startsWith("udp.")) {
                graphTitle = graphTitle.replaceAll("udp.", "[UDP] ");
            }
            if (name.startsWith("ntcp.")) {
                graphTitle = graphTitle.replaceAll("ntcp.", "[NTCP] ");
            }
            if (name.startsWith("transport.")) {
                graphTitle = graphTitle.replaceAll("transport.", "[Transport] ");
            }
            if (name.startsWith("client.")) {
                graphTitle = graphTitle.replaceAll("client.", "[Client] ");
            }
            if (name.startsWith("peer.")) {
                graphTitle = graphTitle.replaceAll("peer.", "[Peer] ");
            }
            if (name.startsWith("prng.")) {
                graphTitle = graphTitle.replaceAll("prng.", "[Crypto] pnrg.");
            }
            if (name.startsWith("crypto.")) {
                graphTitle = graphTitle.replaceAll("crypto.", "[Crypto] ");
            }
            if (name.startsWith("bwLimiter.")) {
                graphTitle = graphTitle.replaceAll("bwLimiter.", "[BWLimiter] ");
            }
            if (name.startsWith("pbq.")) {
                graphTitle = graphTitle.replaceAll("pbq.", "[Router] PBQ.");
            }
            if (name.startsWith("codel.")) {
                graphTitle = graphTitle.replaceAll("codel.", "[Router] CODEL.");
            }
            if (name.startsWith("SDSCache.")) {
                graphTitle = graphTitle.replaceAll("SDSCache.", "[Router] SDSCache.");
            }
            if (name.startsWith("byteCache.memory.")) {
                graphTitle = graphTitle.replaceAll("byteCache.memory.", "[Router] ByteCache:");
            }
            if (name.startsWith("stream.")) {
                graphTitle = graphTitle.replaceAll("stream.", "[Stream] ");
            }
            if (name.equals("clock.skew")) {
                graphTitle = graphTitle.replaceAll("clock.skew", "[Router] Clock Skew");
            }
            if (name.endsWith("InBps")) {
                graphTitle = graphTitle.replaceAll("InBps", "Inbound B/s");
            }
            if (name.endsWith("OutBps")) {
                graphTitle = graphTitle.replaceAll("OutBps", "Outbound B/s");
            }
            if (name.endsWith("Bps")) {
                graphTitle = graphTitle.replaceAll("Bps", "B/s");
            }
            boolean singleDecimalPlace = true;
            boolean noDecimalPlace = false;
            graphTitle = CSSHelper.StringFormatter.capitalizeWord(graphTitle);
            graphTitle = graphTitle.replace("[Tunnel] Tunnel", "[Tunnel]").replace("Tunnel.participating", "[Transit]").replace("[Tunnel] Participating Tunnels", "[Transit] Tunnel Count").replace("Cpu", "CPU").replace("CPULoad", "CPU Load").replace(" Avg", " Average").replace("[Tunnel]Build", "[Tunnel] Build");
            if (!(name.toLowerCase().indexOf("size") < 0 && name.toLowerCase().indexOf("memory") < 0 && name.toLowerCase().indexOf("b/s") < 0 && name.toLowerCase().indexOf("bps") < 0 && name.toLowerCase().indexOf("bandwidth") < 0 && name.toLowerCase().indexOf("bytecache") < 0 || showEvents)) {
                def.setBase(1024.0);
                singleDecimalPlace = false;
            }
            if (titleOverride != null) {
                def.setTitle(titleOverride);
            } else if (!hideTitle) {
                String p = IS_WIN && "zh".equals(Messages.getLanguage(this._context)) ? DataHelper.formatDuration(period) : DataHelper.formatDuration2(period).replace("&nbsp;", " ");
                if (showEvents) {
                    String string = graphTitle + ' ' + this._t("events in {0}", p);
                }
                String title = graphTitle.replaceAll("(?<=[a-z])([A-Z])", " $1");
                title = title.substring(0, 1).toUpperCase() + title.substring(1);
                title = title.replace("[Tunnel] [Tunnel]", "[Tunnel]").replace("Uild Success Avg", "Build Success Average").replace(" Avg", "Average").replace(".drop", " Drop").replace(".delay", " Delay").replace("Participating", "Transit").replace("RILookup", "RouterInfo Lookup").replace(" Per Second", "/s");
                def.setTitle(title);
            }
            String path = this._listener.getData().getPath();
            String[] dsNames = this._listener.getData().getDsNames();
            if (showEvents) {
                plotName = dsNames[1];
                descr = this._t("Events per period");
            } else {
                plotName = dsNames[0];
                descr = this._t(this._listener.getRate().getRateStat().getDescription());
            }
            def.datasource(plotName, path, plotName, GraphListener.CF, this._listener.getBackendFactory());
            if (width == 2000 && height == 160 && hideTitle && hideLegend && hideGrid) {
                def.area(plotName, AREA_COLOR_NEUTRAL);
            } else if (theme.equals(DEFAULT_THEME)) {
                if (descr.length() > 0) {
                    def.area(plotName, (Paint)AREA_COLOR_DARK, descr + "\\l");
                } else {
                    def.area(plotName, AREA_COLOR_DARK);
                }
            } else if (theme.equals("midnight")) {
                if (descr.length() > 0) {
                    def.area(plotName, (Paint)AREA_COLOR_MIDNIGHT, descr + "\\l");
                } else {
                    def.area(plotName, AREA_COLOR_MIDNIGHT);
                }
            } else if (descr.length() > 0) {
                def.area(plotName, (Paint)AREA_COLOR, descr + "\\l");
            } else {
                def.area(plotName, AREA_COLOR);
            }
            String string = noDecimalPlace ? "%.0f%s" : (numberFormat = singleDecimalPlace ? "%.1f%s" : "%.2f%s");
            if (!hideLegend) {
                Variable var = new Variable.MIN();
                def.datasource("min", plotName, var);
                def.gprint("min", " " + this._t("Min") + ": " + numberFormat);
                var = new Variable.MAX();
                def.datasource("max", plotName, var);
                def.gprint("max", " " + this._t("Max") + ": " + numberFormat);
                var = new Variable.AVERAGE();
                def.datasource("avg", plotName, var);
                def.gprint("avg", " " + this._t("Avg") + ": " + numberFormat);
                var = new Variable.LAST();
                def.datasource("last", plotName, var);
                def.gprint("last", " " + this._t("Now") + ": " + numberFormat + "\\l");
            }
            String plotName2 = null;
            if (lsnr2 != null) {
                String[] dsNames2 = lsnr2.getData().getDsNames();
                plotName2 = dsNames2[0];
                String path2 = lsnr2.getData().getPath();
                String descr2 = this._t(lsnr2.getRate().getRateStat().getDescription());
                def.datasource(plotName2, path2, plotName2, GraphListener.CF, lsnr2.getBackendFactory());
                int linewidth = 2;
                if (width == 250 && height == 50 && hideTitle && hideLegend && hideGrid) {
                    linewidth = 3;
                } else if (periodCount >= 720 || periodCount >= 480 && width <= 600) {
                    linewidth = 1;
                }
                if (theme.equals("midnight")) {
                    def.line(plotName2, (Paint)LINE_COLOR_MIDNIGHT, descr2 + "\\l", linewidth);
                } else if (theme.equals(DEFAULT_THEME)) {
                    def.line(plotName2, (Paint)LINE_COLOR_DARK, descr2 + "\\l", linewidth);
                } else {
                    def.line(plotName2, (Paint)LINE_COLOR, descr2 + "\\l", linewidth);
                }
                if (!hideLegend) {
                    Variable var = new Variable.MAX();
                    def.datasource("max2", plotName2, var);
                    def.gprint("max2", " " + this._t("Max") + ": " + numberFormat + " ");
                    var = new Variable.MIN();
                    def.datasource("min2", plotName, var);
                    def.gprint("min2", " " + this._t("Min") + ": " + numberFormat + " ");
                    var = new Variable.AVERAGE();
                    def.datasource("avg2", plotName2, var);
                    def.gprint("avg2", " " + this._t("Avg") + ": " + numberFormat + " ");
                    var = new Variable.LAST();
                    def.datasource("last2", plotName2, var);
                    def.gprint("last2", " " + this._t("Now") + ": " + numberFormat + "\\l");
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMM HH:mm");
            int count = 0;
            Color color = RESTART_COLOR = theme.equals("midnight") || theme.equals(DEFAULT_THEME) ? RESTART_BAR_COLOR_DARK : RESTART_BAR_COLOR;
            if (!hideLegend) {
                Map.Entry event;
                long started;
                SortedMap<Long, String> events = ((RouterContext)this._context).router().eventLog().getEvents("started", start);
                Object prev = null;
                Object now = null;
                Iterator iterator = events.entrySet().iterator();
                while (iterator.hasNext() && (started = ((Long)(event = iterator.next()).getKey()).longValue()) < end) {
                    String legend = count < 1 ? this._t("Router restarted") + "\\l" : null;
                    def.vrule(started / 1000L, (Paint)RESTART_COLOR, legend, 1.0f);
                    ++count;
                }
                def.comment(sdf.format(new Date(start)) + " \u2014 " + sdf.format(new Date(end)) + " UTC\\r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            } else if (hideLegend) {
                if (height > 65) {
                    def.setSignature("    " + sdf.format(new Date(end)) + " UTC");
                } else {
                    def.setSignature(sdf.format(new Date(end)) + " UTC");
                }
            }
            if (hideLegend) {
                def.setNoLegend(true);
            }
            if (hideGrid) {
                def.setDrawXGrid(false);
                def.setDrawYGrid(false);
            }
            def.setAntiAliasing(false);
            def.setTextAntiAliasing(true);
            def.setGridStroke(GRID_STROKE);
            def.setWidth(width);
            def.setHeight(height);
            def.setImageFormat("PNG");
            def.setLazy(true);
            def.setPoolUsed(true);
            def.setAltYMrtg(true);
            if (width < 400 || height < 200) {
                def.setNoMinorGrid(true);
                def.setAltYMrtg(false);
            }
            if (width == 250 && height == 50 && hideTitle && hideLegend && hideGrid || width == 2000 && height == 160 && hideTitle && hideLegend && hideGrid) {
                def.setOnlyGraph(true);
                def.setColor(0, (Paint)TRANSPARENT);
                def.setColor(1, (Paint)TRANSPARENT);
            }
            RrdGraph graph = new RrdGraph(def);
            RrdGraphInfo info = graph.getRrdGraphInfo();
            int totalWidth = info.getWidth();
            int totalHeight = info.getHeight();
            try {
                graph = new RrdGraph(def, new SVGImageWorker(totalWidth + 8, totalHeight));
            }
            catch (NullPointerException npe) {
                this._log.error("Error rendering graph", npe);
                GraphGenerator.setDisabled(this._context);
                throw new IOException("Error rendering - disabling graph generation.");
            }
            catch (Error e) {
                this._log.error("Error rendering graph", e);
                GraphGenerator.setDisabled(this._context);
                throw new IOException("Error rendering - disabling graph generation.");
            }
            out.write(graph.getRrdGraphInfo().getBytes());
            this._context.statManager().addRateData("graph.renderTime", System.currentTimeMillis() - begin);
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getLocalizedMessage());
        }
        catch (IOException ioe) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error rendering", ioe);
            }
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getLocalizedMessage());
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String _t(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    private String _t(String s, String o) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s.replace("{0}", o);
        }
        return Messages.getString(s, o, this._context);
    }
}

