/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PException;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.Outproxy;
import net.i2p.client.I2PSession;
import net.i2p.client.LookupResult;
import net.i2p.client.naming.NamingService;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.BlindData;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientRunner;
import net.i2p.i2ptunnel.I2PTunnelOutproxyRunner;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.InternalSocketRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.localServer.LocalHTTPServer;
import net.i2p.util.ConvertToHash;
import net.i2p.util.EventDispatcher;
import net.i2p.util.InternalSocket;

public class I2PTunnelHTTPClient
extends I2PTunnelHTTPClientBase
implements Runnable {
    private final ConcurrentHashMap<String, String> addressHelpers = new ConcurrentHashMap(8);
    private final String _proxyNonce = Long.toString(this._context.random().nextLong());
    public static final String AUTH_REALM = "I2P HTTP Proxy";
    private static final String UA_I2P = "User-Agent: MYOB/6.66 (AN/ON)\r\n";
    private static final String UA_CLEARNET = "User-Agent: Mozilla/5.0 (Windows NT 10.0; rv:128.0) Gecko/20100101 Firefox/128.0\r\n";
    private static final String PROP_UA_I2P = "httpclient.userAgent.i2p";
    private static final String PROP_UA_CLEARNET = "httpclient.userAgent.outproxy";
    public static final String OPT_KEEPALIVE_BROWSER = "keepalive.browser";
    public static final String OPT_KEEPALIVE_I2P = "keepalive.i2p";
    static final int BROWSER_KEEPALIVE_TIMEOUT = 120000;
    private static final boolean DEFAULT_KEEPALIVE_BROWSER = true;
    private static final boolean DEFAULT_KEEPALIVE_I2P = true;
    private static final String ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>The requested address appears to be invalid.<BR>";
    private static final String ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured. Please configure an outproxy in I2PTunnel";
    private static final String ERR_AHELPER_CONFLICT = "HTTP/1.1 409 Conflict\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: Destination key conflict</H1>The addresshelper link you followed specifies a different destination key than a host entry in your host database. Someone could be trying to impersonate another website, or people have given two websites identical names.<p>You can resolve the conflict by considering which key you trust, and either discarding the addresshelper link, discarding the host entry from your host database, or naming one of them differently.<p>";
    private static final String ERR_AHELPER_NOTFOUND = "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: Helper key not resolvable.</H1>The helper key you put for i2paddresshelper= is not resolvable. It seems to be garbage data, or a mistyped b32. Check your URL to try and fix the helper key to be either a b32 or a base64.";
    private static final String ERR_AHELPER_NEW = "HTTP/1.1 409 New Address\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>New Host Name with Address Helper</H1>The address helper link you followed is for a new host name that is not in your addressbook. You may either save the destination for this host name to your addressbook, or remember it only until your router restarts. If you save it to your addressbook, you will not see this message again. If you do not wish to visit this host, click the \"back\" button on your browser.";
    private static final String ERR_BAD_PROTOCOL = "HTTP/1.1 403 Bad Protocol\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: NON-HTTP PROTOCOL</H1>The request uses a bad protocol. The I2P HTTP Proxy supports HTTP and HTTPS requests only. Other protocols such as FTP are not allowed.<BR>";
    private static final String ERR_BAD_URI = "HTTP/1.1 403 Bad URI\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: INVALID REQUEST URI</H1>The request URI is invalid, and probably contains illegal characters. If you clicked e.g. a forum link, check the end of the URI for any characters the browser has mistakenly added on.<BR>";
    private static final String ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>";
    private static final String ERR_INTERNAL_SSL = "HTTP/1.1 403 SSL Rejected\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: SSL to I2P address rejected</H1>SSL to .i2p addresses denied by configuration.You may change the configuration in I2PTunnel";
    private InternalSocketRunner isr;
    private static final String HELPER_PARAM = "i2paddresshelper";
    public static final String LOCAL_SERVER = "proxy.i2p";
    private static final boolean DEFAULT_GZIP = true;
    public static final String PROP_REFERER = "i2ptunnel.httpclient.sendReferer";
    public static final String PROP_USER_AGENT = "i2ptunnel.httpclient.sendUserAgent";
    public static final String PROP_VIA = "i2ptunnel.httpclient.sendVia";
    public static final String PROP_JUMP_SERVERS = "i2ptunnel.httpclient.jumpServers";
    public static final String PROP_DISABLE_HELPER = "i2ptunnel.httpclient.disableAddressHelper";
    public static final String PROP_ACCEPT = "i2ptunnel.httpclient.sendAccept";
    public static final String PROP_INTERNAL_SSL = "i2ptunnel.httpclient.allowInternalSSL";
    public static final String PROP_SSL_SET = "sslManuallySet";
    public static final String DEFAULT_JUMP_SERVERS = "http://notbob.i2p/cgi-bin/jump.cgi?q=,http://reg.i2p/jump/,http://stats.i2p/cgi-bin/jump.cgi?a=";
    private static final String ERR_HELPER_DISABLED = "HTTP/1.1 403 Disabled\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nAddress helpers disabled";

    public I2PTunnelHTTPClient(int localPort, Logging l, I2PSocketManager sockMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) {
        super(localPort, l, sockMgr, tunnel, notifyThis, clientId);
        this.setName("HTTP Proxy on " + this.getTunnel().listenHost + ':' + localPort);
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    public I2PTunnelHTTPClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTP Proxy on " + tunnel.listenHost + ':' + localPort, tunnel);
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this._proxyList.add(tok.nextToken().trim());
            }
        }
        this.setName("HTTP Proxy on " + tunnel.listenHost + ':' + localPort);
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    @Override
    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "-1");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(90000L);
        }
        return opts;
    }

    @Override
    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "-1");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "-1");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(90000L);
        }
        return opts;
    }

    @Override
    public void startRunning() {
        super.startRunning();
        if (this.open) {
            this.isr = new InternalSocketRunner(this);
            this.isr.start();
            int port = this.getLocalPort();
            this._context.portMapper().register("HTTP", this.getTunnel().listenHost, port);
            this._context.portMapper().register("HTTPS", this.getTunnel().listenHost, port);
        }
    }

    @Override
    public boolean close(boolean forced) {
        int port = this.getLocalPort();
        int reg = this._context.portMapper().getPort("HTTP");
        if (reg == port) {
            this._context.portMapper().unregister("HTTP");
        }
        if ((reg = this._context.portMapper().getPort("HTTPS")) == port) {
            this._context.portMapper().unregister("HTTPS");
        }
        boolean rv = super.close(forced);
        if (this.isr != null) {
            this.isr.stopRunning();
        }
        return rv;
    }

    @Override
    protected String getRealm() {
        return AUTH_REALM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        OutputStream out = null;
        String targetRequest = null;
        boolean usingWWWProxy = false;
        boolean usingInternalOutproxy = false;
        Outproxy outproxy = null;
        boolean usingInternalServer = false;
        String internalPath = null;
        String internalRawQuery = null;
        String currentProxy = null;
        long requestId = __requestId.incrementAndGet();
        boolean shout = false;
        boolean isConnect = false;
        boolean isHead = false;
        boolean plus = false;
        Closeable i2ps = null;
        try {
            boolean keepalive;
            s.setSoTimeout(15000);
            out = s.getOutputStream();
            InputReader reader = new InputReader(s.getInputStream());
            int requestCount = 0;
            boolean bl = keepalive = this.getBooleanOption(OPT_KEEPALIVE_BROWSER, true) && !(s instanceof InternalSocket);
            do {
                I2PTunnelRunner t;
                byte[] data;
                Destination clientDest;
                String referer;
                int remotePort;
                String userAgent;
                String ahelperKey;
                boolean ahelperNew;
                boolean ahelperPresent;
                StringBuilder newRequest;
                String hostLowerCase;
                String destination;
                String method;
                block311: {
                    block327: {
                        block328: {
                            I2PSession sess;
                            int len;
                            block329: {
                                block326: {
                                    String host;
                                    block325: {
                                        I2PTunnelHTTPClientBase.AuthResult result;
                                        String line;
                                        if (requestCount > 0) {
                                            try {
                                                s.setSoTimeout(120000);
                                            }
                                            catch (IOException ioe) {
                                                if (this._log.shouldInfo()) {
                                                    this._log.info("Socket closed (timeout) before request #" + requestCount);
                                                }
                                                I2PTunnelHTTPClient.closeSocket(s);
                                                if (i2ps == null) return;
                                                try {
                                                    i2ps.close();
                                                    return;
                                                }
                                                catch (IOException iOException) {
                                                    // empty catch block
                                                }
                                                return;
                                            }
                                            if (this._log.shouldDebug()) {
                                                this._log.debug("KeepAlive, awaiting request #" + requestCount);
                                            }
                                        }
                                        method = null;
                                        String protocol = null;
                                        host = null;
                                        destination = null;
                                        hostLowerCase = null;
                                        newRequest = new StringBuilder();
                                        ahelperPresent = false;
                                        ahelperNew = false;
                                        ahelperKey = null;
                                        userAgent = null;
                                        String authorization = null;
                                        remotePort = 0;
                                        referer = null;
                                        URI origRequestURI = null;
                                        boolean preserveConnectionHeader = false;
                                        boolean allowGzip = true;
                                        while ((line = reader.readLine(method)) != null) {
                                            block319: {
                                                block310: {
                                                    String lowercaseLine;
                                                    block323: {
                                                        boolean img;
                                                        boolean css;
                                                        boolean html;
                                                        block324: {
                                                            block322: {
                                                                block321: {
                                                                    block320: {
                                                                        block312: {
                                                                            boolean isValid;
                                                                            String protocolVersion;
                                                                            URI requestURI;
                                                                            String request;
                                                                            block309: {
                                                                                block318: {
                                                                                    ClientApp op;
                                                                                    ClientAppManager mgr;
                                                                                    int port;
                                                                                    block314: {
                                                                                        String addressHelper;
                                                                                        String query;
                                                                                        String newURI;
                                                                                        block315: {
                                                                                            String header;
                                                                                            boolean ahelperConflict;
                                                                                            block316: {
                                                                                                String destB64;
                                                                                                block317: {
                                                                                                    block313: {
                                                                                                        String[] params;
                                                                                                        line = line.trim();
                                                                                                        if (this._log.shouldDebug() && line != null) {
                                                                                                            this._log.debug(this.getPrefix(requestId) + "Request header: " + line);
                                                                                                        }
                                                                                                        lowercaseLine = line.toLowerCase(Locale.US);
                                                                                                        if (method != null) break block312;
                                                                                                        if (this._log.shouldDebug()) {
                                                                                                            this._log.debug(this.getPrefix(requestId) + "Request [#" + requestCount + "] \n* First line: " + line);
                                                                                                        }
                                                                                                        if ((params = DataHelper.split(line, " ", 3)).length != 3) break;
                                                                                                        request = params[1];
                                                                                                        if (request.startsWith("/") && this.getTunnel().getClientOptions().getProperty("i2ptunnel.noproxy") != null) {
                                                                                                            request = "http://i2p" + request;
                                                                                                        } else if (request.startsWith("/eepproxy/")) {
                                                                                                            String subRequest = request.substring("/eepproxy/".length());
                                                                                                            if (subRequest.indexOf(47) == -1) {
                                                                                                                subRequest = subRequest + '/';
                                                                                                            }
                                                                                                            request = "http://" + subRequest;
                                                                                                        }
                                                                                                        method = params[0].toUpperCase(Locale.US);
                                                                                                        if (method.equals("HEAD")) {
                                                                                                            isHead = true;
                                                                                                        } else if (method.equals("CONNECT")) {
                                                                                                            request = "https://" + request + '/';
                                                                                                            isConnect = true;
                                                                                                            keepalive = false;
                                                                                                        } else if (!method.equals("GET")) {
                                                                                                            keepalive = false;
                                                                                                        }
                                                                                                        requestURI = null;
                                                                                                        try {
                                                                                                            block308: {
                                                                                                                try {
                                                                                                                    requestURI = new URI(request);
                                                                                                                }
                                                                                                                catch (URISyntaxException use) {
                                                                                                                    boolean error = true;
                                                                                                                    int idx = 0;
                                                                                                                    for (int i = 0; i < 2 && (idx = request.indexOf(47, idx)) >= 0; ++idx, ++i) {
                                                                                                                    }
                                                                                                                    if (idx > 0) {
                                                                                                                        String schemeHostPort = request.substring(0, idx);
                                                                                                                        String rest = request.substring(idx);
                                                                                                                        rest = rest.replace("[", "%5B");
                                                                                                                        rest = rest.replace("]", "%5D");
                                                                                                                        rest = rest.replace("|", "%7C");
                                                                                                                        rest = rest.replace("{", "%7B");
                                                                                                                        rest = rest.replace("}", "%7D");
                                                                                                                        String testRequest = schemeHostPort + rest;
                                                                                                                        if (!testRequest.equals(request)) {
                                                                                                                            try {
                                                                                                                                requestURI = new URI(testRequest);
                                                                                                                                request = testRequest;
                                                                                                                                error = false;
                                                                                                                            }
                                                                                                                            catch (URISyntaxException uRISyntaxException) {
                                                                                                                                // empty catch block
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (!error) break block308;
                                                                                                                    throw use;
                                                                                                                }
                                                                                                            }
                                                                                                            origRequestURI = requestURI;
                                                                                                            if (requestURI.getRawUserInfo() != null || requestURI.getRawFragment() != null) {
                                                                                                                if (this._log.shouldWarn()) {
                                                                                                                    this._log.warn(this.getPrefix(requestId) + "Removing userinfo or fragment [" + request + "]");
                                                                                                                }
                                                                                                                requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, null);
                                                                                                            }
                                                                                                            if (requestURI.getPath() == null || requestURI.getPath().length() <= 0) {
                                                                                                                if (this._log.shouldDebug()) {
                                                                                                                    this._log.debug(this.getPrefix(requestId) + "Adding / path to [" + request + "]");
                                                                                                                }
                                                                                                                requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, "/");
                                                                                                            }
                                                                                                        }
                                                                                                        catch (URISyntaxException use) {
                                                                                                            if (this._log.shouldWarn()) {
                                                                                                                this._log.warn(this.getPrefix(requestId) + "BAD request [" + request + "]", use);
                                                                                                            }
                                                                                                            try {
                                                                                                                out.write(this.getErrorPage("baduri", ERR_BAD_URI).getBytes("UTF-8"));
                                                                                                                String msg = use.getLocalizedMessage();
                                                                                                                if (msg != null) {
                                                                                                                    out.write(DataHelper.getASCII("<p>\n"));
                                                                                                                    out.write(DataHelper.getUTF8(DataHelper.escapeHTML(msg)));
                                                                                                                    out.write(DataHelper.getASCII("</p>\n"));
                                                                                                                }
                                                                                                                out.write(DataHelper.getASCII("</div>\n"));
                                                                                                                I2PTunnelHTTPClient.writeFooter(out);
                                                                                                                reader.drain();
                                                                                                            }
                                                                                                            catch (IOException msg) {
                                                                                                                // empty catch block
                                                                                                            }
                                                                                                            I2PTunnelHTTPClient.closeSocket(s);
                                                                                                            if (i2ps == null) return;
                                                                                                            try {
                                                                                                                i2ps.close();
                                                                                                                return;
                                                                                                            }
                                                                                                            catch (IOException msg) {
                                                                                                                // empty catch block
                                                                                                            }
                                                                                                            return;
                                                                                                        }
                                                                                                        protocolVersion = params[2];
                                                                                                        if (!protocolVersion.equals("HTTP/1.1")) {
                                                                                                            keepalive = false;
                                                                                                        }
                                                                                                        protocol = requestURI.getScheme();
                                                                                                        host = requestURI.getHost();
                                                                                                        if (protocol == null || host == null) {
                                                                                                            this._log.warn("[HTTPClient] Null protocol or host: " + request + ' ' + protocol + ' ' + host);
                                                                                                            method = null;
                                                                                                            break;
                                                                                                        }
                                                                                                        port = requestURI.getPort();
                                                                                                        hostLowerCase = host.toLowerCase(Locale.US);
                                                                                                        if (!hostLowerCase.equals(LOCAL_SERVER)) break block313;
                                                                                                        destination = host;
                                                                                                        usingInternalServer = true;
                                                                                                        internalPath = requestURI.getPath();
                                                                                                        internalRawQuery = requestURI.getRawQuery();
                                                                                                        break block309;
                                                                                                    }
                                                                                                    if (hostLowerCase.equals("i2p")) {
                                                                                                        String oldPath = requestURI.getPath().substring(1);
                                                                                                        int slash = oldPath.indexOf(47);
                                                                                                        if (slash < 0) {
                                                                                                            slash = oldPath.length();
                                                                                                            oldPath = oldPath + '/';
                                                                                                        }
                                                                                                        String _dest = oldPath.substring(0, slash);
                                                                                                        if (slash >= 516 && !_dest.contains(".")) {
                                                                                                            destination = _dest;
                                                                                                            host = this.getHostName(destination);
                                                                                                            targetRequest = requestURI.toASCIIString();
                                                                                                            newURI = oldPath.substring(slash);
                                                                                                            String query2 = requestURI.getRawQuery();
                                                                                                            if (query2 != null) {
                                                                                                                newURI = newURI + '?' + query2;
                                                                                                            }
                                                                                                            try {
                                                                                                                requestURI = new URI(newURI);
                                                                                                                break block309;
                                                                                                            }
                                                                                                            catch (URISyntaxException use) {
                                                                                                                this._log.warn(request, use);
                                                                                                                method = null;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        this._log.warn("[HTTPClient] Bad I2P / B64 destination: " + request);
                                                                                                        host = null;
                                                                                                        break;
                                                                                                    }
                                                                                                    if (!NamingService.isI2PHost(hostLowerCase)) break block314;
                                                                                                    destination = host;
                                                                                                    host = this.getHostName(destination);
                                                                                                    int rPort = requestURI.getPort();
                                                                                                    remotePort = rPort > 0 ? rPort : ("https".equals(protocol) || isConnect ? 443 : 80);
                                                                                                    query = requestURI.getRawQuery();
                                                                                                    if (query == null) break block315;
                                                                                                    ahelperConflict = false;
                                                                                                    String[] helperStrings = I2PTunnelHTTPClient.removeHelper(query);
                                                                                                    if (helperStrings == null || Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER))) break block316;
                                                                                                    query = helperStrings[0];
                                                                                                    if (query.equals("")) {
                                                                                                        query = null;
                                                                                                    }
                                                                                                    try {
                                                                                                        requestURI = I2PTunnelHTTPClient.replaceQuery(requestURI, query);
                                                                                                    }
                                                                                                    catch (URISyntaxException use) {
                                                                                                        this._log.warn(request, use);
                                                                                                        method = null;
                                                                                                        break;
                                                                                                    }
                                                                                                    ahelperKey = helperStrings[1];
                                                                                                    if (ahelperKey.length() <= 0) break block316;
                                                                                                    if (ahelperKey.endsWith(".i2p")) {
                                                                                                        Destination _dest = this._context.namingService().lookup(ahelperKey);
                                                                                                        if (_dest == null) {
                                                                                                            if (this._log.shouldWarn()) {
                                                                                                                this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + ahelperKey);
                                                                                                            }
                                                                                                            header = this.getErrorPage("ahelper-notfound", ERR_AHELPER_NOTFOUND);
                                                                                                            try {
                                                                                                                out.write(header.getBytes("UTF-8"));
                                                                                                                out.write(("<p>" + this._t("This seems to be a bad destination:") + " " + ahelperKey + " " + this._t("i2paddresshelper cannot help you with a destination like that!") + "</p>").getBytes("UTF-8"));
                                                                                                                I2PTunnelHTTPClient.writeFooter(out);
                                                                                                                reader.drain();
                                                                                                                return;
                                                                                                            }
                                                                                                            catch (IOException iOException) {
                                                                                                                // empty catch block
                                                                                                                return;
                                                                                                            }
                                                                                                        }
                                                                                                        ahelperKey = _dest.toBase64();
                                                                                                    }
                                                                                                    ahelperPresent = true;
                                                                                                    if (host != null && !"i2p".equals(host)) break block317;
                                                                                                    String old = this.addressHelpers.putIfAbsent(destination.toLowerCase(Locale.US), ahelperKey);
                                                                                                    boolean bl2 = ahelperNew = old == null;
                                                                                                    if (!ahelperNew && !old.replace("=", "").equals(ahelperKey.replace("=", ""))) {
                                                                                                        ahelperConflict = true;
                                                                                                        if (this._log.shouldWarn()) {
                                                                                                            this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + old + "], specified key [" + ahelperKey + "].");
                                                                                                        }
                                                                                                    }
                                                                                                    break block316;
                                                                                                }
                                                                                                Destination hostDest = this._context.namingService().lookup(destination);
                                                                                                if (hostDest != null && (destB64 = hostDest.toBase64()) != null && !destB64.equals(ahelperKey)) {
                                                                                                    ahelperConflict = true;
                                                                                                    if (this._log.shouldWarn()) {
                                                                                                        this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "] -> Trusted key [" + destB64 + "] - Specified key [" + ahelperKey + "]");
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            if (ahelperConflict) {
                                                                                                try {
                                                                                                    String alias = this.getHostName(ahelperKey);
                                                                                                    if (alias.equals("i2p")) {
                                                                                                        header = this.getErrorPage("dnfb", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                                                                                                        this.writeErrorMessage(header, out, targetRequest, false, destination);
                                                                                                    } else {
                                                                                                        URI conflictURI;
                                                                                                        String trustedURL = requestURI.toASCIIString();
                                                                                                        try {
                                                                                                            conflictURI = I2PTunnelHTTPClient.changeURI(requestURI, alias, 0, null);
                                                                                                        }
                                                                                                        catch (URISyntaxException use) {
                                                                                                            this._log.warn(request, use);
                                                                                                            method = null;
                                                                                                            break;
                                                                                                        }
                                                                                                        String conflictURL = conflictURI.toASCIIString();
                                                                                                        String header2 = this.getErrorPage("ahelper-conflict", ERR_AHELPER_CONFLICT);
                                                                                                        out.write(header2.getBytes("UTF-8"));
                                                                                                        out.write("<p>".getBytes("UTF-8"));
                                                                                                        out.write(this._t("To visit the destination in your addressbook, click <a href=\"{0}\">here</a>. To visit the conflicting addresshelper destination, click <a href=\"{1}\">here</a>.", trustedURL, conflictURL).getBytes("UTF-8"));
                                                                                                        out.write("</p>".getBytes("UTF-8"));
                                                                                                        Hash h1 = ConvertToHash.getHash(requestURI.getHost());
                                                                                                        Hash h2 = ConvertToHash.getHash(ahelperKey);
                                                                                                        if (h1 != null && h2 != null) {
                                                                                                            String conURL = this._context.portMapper().getConsoleURL();
                                                                                                            out.write(("\n<table id=destConflict><tr><th class=center><a href=\"" + trustedURL + "\">").getBytes("UTF-8"));
                                                                                                            out.write(this._t("Destination for {0} in addressbook", requestURI.getHost()).getBytes("UTF-8"));
                                                                                                            out.write(("</a></th>\n<th class=center><a href=\"" + conflictURL + "\">").getBytes("UTF-8"));
                                                                                                            out.write(this._t("Conflicting address helper destination").getBytes("UTF-8"));
                                                                                                            out.write("</a></th></tr>\n".getBytes("UTF-8"));
                                                                                                            if (this._context.portMapper().isRegistered("imagegen")) {
                                                                                                                out.write(("<tr><td class=center><a href=\"" + trustedURL + "\"><img src=\"" + conURL + "imagegen/id?s=160&amp;c=" + h1.toBase64().replace("=", "%3d") + "\" width=160 height=160></a>\n</td>\n<td class=center><a href=\"" + conflictURL + "\"><img src=\"" + conURL + "imagegen/id?s=160&amp;c=" + h2.toBase64().replace("=", "%3d") + "\" width=160 height=160></a>\n</td></tr>").getBytes("UTF-8"));
                                                                                                            }
                                                                                                            out.write("</table>".getBytes("UTF-8"));
                                                                                                        }
                                                                                                        out.write("</div>".getBytes("UTF-8"));
                                                                                                        I2PTunnelHTTPClient.writeFooter(out);
                                                                                                    }
                                                                                                    reader.drain();
                                                                                                    return;
                                                                                                }
                                                                                                catch (IOException alias) {
                                                                                                    // empty catch block
                                                                                                    return;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if ((addressHelper = this.addressHelpers.get(destination)) != null) {
                                                                                            host = this.getHostName(addressHelper);
                                                                                        }
                                                                                        targetRequest = requestURI.toASCIIString();
                                                                                        if (!isConnect) {
                                                                                            newURI = requestURI.getRawPath();
                                                                                            if (query != null) {
                                                                                                newURI = newURI + '?' + query;
                                                                                            }
                                                                                            if (newURI.contains(":80/")) {
                                                                                                newURI = newURI.replaceAll(":80/", "/");
                                                                                            }
                                                                                            try {
                                                                                                requestURI = new URI(newURI);
                                                                                                break block309;
                                                                                            }
                                                                                            catch (URISyntaxException use) {
                                                                                                this._log.warn(request, use);
                                                                                                method = null;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        break block309;
                                                                                    }
                                                                                    if (hostLowerCase.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("10.0.") || host.startsWith("172.16.") || host.startsWith("192.168.") || host.equals("[::1]")) {
                                                                                        try {
                                                                                            out.write(this.getErrorPage("localhost", ERR_LOCALHOST).getBytes("UTF-8"));
                                                                                            I2PTunnelHTTPClient.writeFooter(out);
                                                                                            reader.drain();
                                                                                            return;
                                                                                        }
                                                                                        catch (IOException rPort) {
                                                                                            // empty catch block
                                                                                            return;
                                                                                        }
                                                                                    }
                                                                                    if (!host.contains(".") && !host.startsWith("[")) break block318;
                                                                                    if (Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.useLocalOutproxy", "true")) && (mgr = this._context.clientAppManager()) != null && (op = mgr.getRegisteredApp("outproxy")) != null) {
                                                                                        outproxy = (Outproxy)((Object)op);
                                                                                        int rPort = requestURI.getPort();
                                                                                        remotePort = rPort > 0 ? rPort : ("https".equals(protocol) || isConnect ? 443 : 80);
                                                                                        usingInternalOutproxy = true;
                                                                                        targetRequest = requestURI.toASCIIString();
                                                                                        if (this._log.shouldDebug()) {
                                                                                            this._log.debug(this.getPrefix(requestId) + "via outproxy -> " + host);
                                                                                        }
                                                                                    }
                                                                                    if (!usingInternalOutproxy) {
                                                                                        String outproxyName;
                                                                                        if (port >= 0) {
                                                                                            host = host + ':' + port;
                                                                                        }
                                                                                        if (this._log.shouldDebug()) {
                                                                                            this._log.debug("[HTTPClient] Forwarding request for " + host + " to outproxy");
                                                                                        }
                                                                                        if ("https".equals(protocol) || isConnect) {
                                                                                            outproxyName = currentProxy = this.selectSSLProxy(hostLowerCase);
                                                                                            if (currentProxy != null && currentProxy.length() > 20) {
                                                                                                outproxyName = currentProxy.substring(0, 12) + "...";
                                                                                            }
                                                                                            if (this._log.shouldDebug()) {
                                                                                                this._log.debug("[HTTPClient] Selected [" + outproxyName + "] SSL outproxy for " + host);
                                                                                            }
                                                                                        } else {
                                                                                            outproxyName = currentProxy = this.selectProxy(hostLowerCase);
                                                                                            if (currentProxy != null && currentProxy.length() > 20) {
                                                                                                outproxyName = currentProxy.substring(0, 12) + "...";
                                                                                            }
                                                                                            if (this._log.shouldDebug()) {
                                                                                                this._log.debug("[HTTPClient] Selected [" + outproxyName + "] outproxy for " + host);
                                                                                            }
                                                                                        }
                                                                                        if (currentProxy == null) {
                                                                                            if (this._log.shouldWarn()) {
                                                                                                this._log.warn("[HTTPClient] Cannot connect to site; no outproxy configured \n* Request: " + requestURI);
                                                                                            }
                                                                                            try {
                                                                                                out.write(this.getErrorPage("noproxy", ERR_NO_OUTPROXY).getBytes("UTF-8"));
                                                                                                I2PTunnelHTTPClient.writeFooter(out);
                                                                                                reader.drain();
                                                                                                return;
                                                                                            }
                                                                                            catch (IOException outproxyName2) {
                                                                                                // empty catch block
                                                                                                return;
                                                                                            }
                                                                                        }
                                                                                        destination = currentProxy;
                                                                                        usingWWWProxy = true;
                                                                                        targetRequest = requestURI.toASCIIString();
                                                                                        outproxyName = destination;
                                                                                        if (destination != null && destination.length() > 20) {
                                                                                            outproxyName = destination.substring(0, 15) + "...";
                                                                                        }
                                                                                        if (this._log.shouldDebug()) {
                                                                                            this._log.debug(this.getPrefix(requestId) + " for [" + host + "] forwarded via outproxy: " + outproxyName);
                                                                                        }
                                                                                    }
                                                                                    break block309;
                                                                                }
                                                                                if (this._log.shouldWarn()) {
                                                                                    this._log.warn("[HTTPClient] Malformed hostname " + request + " - aborting...");
                                                                                }
                                                                                try {
                                                                                    out.write(this.getErrorPage("denied", ERR_REQUEST_DENIED).getBytes("UTF-8"));
                                                                                    I2PTunnelHTTPClient.writeFooter(out);
                                                                                    reader.drain();
                                                                                    return;
                                                                                }
                                                                                catch (IOException outproxyName) {
                                                                                    // empty catch block
                                                                                    return;
                                                                                }
                                                                            }
                                                                            boolean bl3 = isValid = usingInternalOutproxy || usingWWWProxy || usingInternalServer || I2PTunnelHTTPClient.isSupportedAddress(host, protocol);
                                                                            if (!isValid) {
                                                                                if (this._log.shouldInfo()) {
                                                                                    this._log.info(this.getPrefix(requestId) + "notValid(" + host + ")");
                                                                                }
                                                                                method = null;
                                                                                destination = null;
                                                                                break;
                                                                            }
                                                                            line = isConnect ? (usingInternalOutproxy || usingWWWProxy ? method + ' ' + requestURI.getHost() + ':' + requestURI.getPort() + ' ' + protocolVersion : method + ' ' + host + ':' + remotePort + ' ' + protocolVersion) : method + ' ' + requestURI.toASCIIString() + ' ' + protocolVersion;
                                                                            String outproxyName = destination;
                                                                            if (destination != null && destination.length() > 20) {
                                                                                outproxyName = destination.substring(0, 15) + "...";
                                                                            }
                                                                            if (this._log.shouldDebug()) {
                                                                                this._log.debug(this.getPrefix(requestId) + "Request: " + request);
                                                                                this._log.debug(this.getPrefix(requestId) + "Request URI: " + requestURI);
                                                                                this._log.debug(this.getPrefix(requestId) + "New request: " + line);
                                                                                this._log.debug(this.getPrefix(requestId) + "Host: " + host);
                                                                                this._log.debug(this.getPrefix(requestId) + "Remote port: " + remotePort);
                                                                                this._log.debug(this.getPrefix(requestId) + "Destination: " + destination);
                                                                            }
                                                                            break block319;
                                                                        }
                                                                        if (!lowercaseLine.startsWith("connection: ")) break block320;
                                                                        if (lowercaseLine.contains("upgrade")) {
                                                                            preserveConnectionHeader = true;
                                                                            keepalive = false;
                                                                            break block310;
                                                                        } else if (lowercaseLine.contains("keep-alive")) {
                                                                            if (!keepalive) continue;
                                                                            preserveConnectionHeader = true;
                                                                            break block310;
                                                                        } else {
                                                                            if (!lowercaseLine.contains("close")) continue;
                                                                            keepalive = false;
                                                                            continue;
                                                                        }
                                                                    }
                                                                    if (lowercaseLine.startsWith("keep-alive: ") || lowercaseLine.startsWith("proxy-connection: ")) {
                                                                        if (!lowercaseLine.contains("close")) continue;
                                                                        keepalive = false;
                                                                        continue;
                                                                    }
                                                                    if (!lowercaseLine.startsWith("host: ") || usingWWWProxy || usingInternalOutproxy) break block321;
                                                                    line = "Host: " + host;
                                                                    if (this._log.shouldDebug()) {
                                                                        this._log.info(this.getPrefix(requestId) + "Setting Host: " + host);
                                                                    }
                                                                    break block310;
                                                                }
                                                                if (!lowercaseLine.startsWith("user-agent: ")) break block322;
                                                                userAgent = lowercaseLine.substring(12);
                                                                if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT))) {
                                                                    line = null;
                                                                    continue;
                                                                }
                                                                break block310;
                                                            }
                                                            if (!lowercaseLine.startsWith("accept: ")) break block323;
                                                            if (Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_ACCEPT))) break block310;
                                                            html = lowercaseLine.indexOf("text/html") > 0;
                                                            css = lowercaseLine.indexOf("text/css") > 0;
                                                            boolean bl4 = img = lowercaseLine.indexOf("image") > 0;
                                                            if (!html || img || css) break block324;
                                                            line = "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
                                                            break block310;
                                                        }
                                                        if (img && !html && !css) {
                                                            line = "Accept: image/webp,image/apng,image/*,*/*;q=0.8";
                                                            break block310;
                                                        } else if (css && !html && !img) {
                                                            line = "Accept: text/css,*/*;q=0.1";
                                                        }
                                                        break block310;
                                                    }
                                                    if (lowercaseLine.startsWith("accept")) {
                                                        if (lowercaseLine.startsWith("accept-encoding: ")) {
                                                            allowGzip = lowercaseLine.contains("gzip");
                                                        } else if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_ACCEPT))) {
                                                            line = null;
                                                            continue;
                                                        }
                                                    } else if (lowercaseLine.startsWith("referer: ")) {
                                                        referer = line.substring(9);
                                                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_REFERER))) {
                                                            try {
                                                                URI refererURI = new URI(referer);
                                                                String origHost = origRequestURI.getHost();
                                                                String refererHost = refererURI.getHost();
                                                                if (refererHost != null) {
                                                                    if (!refererHost.equals(origHost) || refererURI.getPort() != origRequestURI.getPort() || !DataHelper.eq(refererURI.getScheme(), origRequestURI.getScheme())) {
                                                                        line = null;
                                                                        continue;
                                                                    }
                                                                    StringBuilder buf = new StringBuilder();
                                                                    buf.append("Referer: ");
                                                                    String refererPath = refererURI.getRawPath();
                                                                    buf.append(refererPath != null ? refererPath : "/");
                                                                    String refererQuery = refererURI.getRawQuery();
                                                                    if (refererQuery != null) {
                                                                        buf.append('?').append(refererQuery);
                                                                    }
                                                                    line = buf.toString();
                                                                }
                                                            }
                                                            catch (URISyntaxException use) {
                                                                line = null;
                                                                continue;
                                                            }
                                                        }
                                                    } else {
                                                        if (lowercaseLine.startsWith("via: ") && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_VIA))) {
                                                            line = null;
                                                            continue;
                                                        }
                                                        if (lowercaseLine.startsWith("from: ")) {
                                                            line = null;
                                                            continue;
                                                        }
                                                        if (lowercaseLine.startsWith("authorization: ntlm ")) {
                                                            line = null;
                                                            continue;
                                                        }
                                                        if (lowercaseLine.startsWith("proxy-authorization: ")) {
                                                            authorization = line.substring(21);
                                                            line = null;
                                                            continue;
                                                        }
                                                        if (lowercaseLine.startsWith("icy")) {
                                                            shout = true;
                                                        }
                                                    }
                                                }
                                                String origHost = origRequestURI.getHost();
                                                if (origHost != null && (origHost.startsWith("skank.i2p") || origHost.endsWith(".skank.i2p"))) {
                                                    plus = true;
                                                }
                                            }
                                            if (line.length() == 0) {
                                                String ok = this.getTunnel().getClientOptions().getProperty("i2ptunnel.gzip");
                                                boolean gzip = true;
                                                if (ok != null) {
                                                    gzip = Boolean.parseBoolean(ok);
                                                }
                                                if (gzip && !usingInternalServer && !isConnect && !usingInternalOutproxy) {
                                                    newRequest.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
                                                }
                                                if (!(shout || isConnect || Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT)))) {
                                                    String ua;
                                                    if (usingWWWProxy || usingInternalOutproxy) {
                                                        ua = this.getTunnel().getClientOptions().getProperty(PROP_UA_CLEARNET);
                                                        ua = ua != null ? "User-Agent: " + ua + "\r\n" : UA_CLEARNET;
                                                    } else {
                                                        ua = this.getTunnel().getClientOptions().getProperty(PROP_UA_I2P);
                                                        ua = plus ? "User-Agent: I2P+\r\n" : (ua != null ? "User-Agent: " + ua + "\r\n" : UA_I2P);
                                                    }
                                                    newRequest.append(ua);
                                                }
                                                if (usingWWWProxy && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("outproxyAuth"))) {
                                                    String user = this.getTunnel().getClientOptions().getProperty("outproxyUsername." + currentProxy);
                                                    String pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword." + currentProxy);
                                                    if (user == null || pw == null) {
                                                        user = this.getTunnel().getClientOptions().getProperty("outproxyUsername");
                                                        pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword");
                                                    }
                                                    if (user != null && pw != null) {
                                                        newRequest.append("Proxy-Authorization: Basic ").append(Base64.encode((user + ':' + pw).getBytes("UTF-8"), true)).append("\r\n");
                                                    }
                                                }
                                                if (preserveConnectionHeader) {
                                                    newRequest.append("\r\n");
                                                } else {
                                                    newRequest.append("Connection: close\r\n\r\n");
                                                }
                                                s.setSoTimeout(14400000);
                                                break;
                                            }
                                            newRequest.append(line).append("\r\n");
                                        }
                                        if (newRequest.length() > 0 && this._log.shouldDebug()) {
                                            this._log.debug(this.getPrefix(requestId) + "NewRequest header: [" + newRequest + ']');
                                        }
                                        if (method == null || destination == null && !usingInternalOutproxy) {
                                            if (requestCount > 0) {
                                                return;
                                            }
                                            if (this._log.shouldDebug()) {
                                                this._log.debug("No HTTP method found in the request.");
                                            }
                                            try {
                                                if (protocol != null && "http".equals(protocol.toLowerCase(Locale.US))) {
                                                    out.write(this.getErrorPage("denied", ERR_REQUEST_DENIED).getBytes("UTF-8"));
                                                } else {
                                                    out.write(this.getErrorPage("protocol", ERR_BAD_PROTOCOL).getBytes("UTF-8"));
                                                }
                                                I2PTunnelHTTPClient.writeFooter(out);
                                                return;
                                            }
                                            catch (IOException lowercaseLine) {
                                                // empty catch block
                                                return;
                                            }
                                        }
                                        if (this._log.shouldDebug()) {
                                            this._log.debug(this.getPrefix(requestId) + "Destination: " + destination);
                                        }
                                        if ((result = this.authorize(s, requestId, method, authorization)) != I2PTunnelHTTPClientBase.AuthResult.AUTH_GOOD) {
                                            if (this._log.shouldWarn()) {
                                                if (authorization != null) {
                                                    this._log.warn(this.getPrefix(requestId) + "Auth failed, sending 407 again...");
                                                } else {
                                                    this._log.warn(this.getPrefix(requestId) + "Auth required, sending 407...");
                                                }
                                            }
                                            try {
                                                out.write(this.getAuthError(result == I2PTunnelHTTPClientBase.AuthResult.AUTH_STALE).getBytes("UTF-8"));
                                                I2PTunnelHTTPClient.writeFooter(out);
                                                return;
                                            }
                                            catch (IOException ok) {
                                                // empty catch block
                                                return;
                                            }
                                        }
                                        if (usingInternalServer) {
                                            try {
                                                if (internalPath.equals("/add") && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER))) {
                                                    out.write(ERR_HELPER_DISABLED.getBytes("UTF-8"));
                                                    return;
                                                }
                                                LocalHTTPServer.serveLocalFile(this._context, this.sockMgr, out, method, internalPath, internalRawQuery, this._proxyNonce, allowGzip);
                                                return;
                                            }
                                            catch (IOException ok) {
                                                // empty catch block
                                                return;
                                            }
                                        }
                                        if (usingInternalOutproxy) {
                                            byte[] response;
                                            byte[] data2;
                                            Socket outSocket = outproxy.connect(host, remotePort);
                                            I2PTunnelHTTPClientBase.OnTimeout onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
                                            if (isConnect) {
                                                data2 = null;
                                                response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
                                            } else {
                                                data2 = newRequest.toString().getBytes("ISO-8859-1");
                                                response = null;
                                            }
                                            I2PTunnelOutproxyRunner t2 = new I2PTunnelOutproxyRunner(s, outSocket, this.sockLock, data2, response, onTimeout);
                                            t2.setPriority(10);
                                            ((Thread)t2).run();
                                            return;
                                        }
                                        clientDest = null;
                                        String addressHelper = this.addressHelpers.get(destination.toLowerCase(Locale.US));
                                        if (addressHelper == null) break block325;
                                        clientDest = this._context.namingService().lookup(addressHelper);
                                        if (clientDest == null) {
                                            this.addressHelpers.remove(destination.toLowerCase(Locale.US));
                                            if (this._log.shouldWarn()) {
                                                this._log.warn(this.getPrefix(requestId) + "[HTTPClient] Could not find destination for " + addressHelper);
                                            }
                                            String header = this.getErrorPage("ahelper-notfound", ERR_AHELPER_NOTFOUND);
                                            try {
                                                this.writeErrorMessage(header, out, targetRequest, false, destination);
                                                return;
                                            }
                                            catch (IOException response) {
                                                // empty catch block
                                                return;
                                            }
                                        }
                                        break block311;
                                    }
                                    if (!"i2p".equals(host)) break block326;
                                    clientDest = null;
                                    break block311;
                                }
                                if (!NamingService.isB32Host(destination)) break block327;
                                len = destination.length();
                                if (len < 60 || len >= 61 && len <= 63) {
                                    String header = this.getErrorPage("b32", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                                    try {
                                        this.writeErrorMessage(header, this._t("Corrupt Base32 address"), out, targetRequest, false, destination);
                                        return;
                                    }
                                    catch (IOException t2) {
                                        // empty catch block
                                        return;
                                    }
                                }
                                if (NamingService.isBlindedHost(destination)) {
                                    try {
                                        BlindData bd = Blinding.decode(this._context, destination);
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("[HTTPClient] Resolved b33: " + bd);
                                        }
                                    }
                                    catch (IllegalArgumentException iae) {
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("[HTTPClient] Unable to resolve b33: " + destination, iae);
                                        }
                                        String header = this.getErrorPage("b32", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                                        try {
                                            this.writeErrorMessage(header, iae.getMessage(), out, targetRequest, false, destination);
                                        }
                                        catch (IOException refererQuery) {
                                            // empty catch block
                                        }
                                        I2PTunnelHTTPClient.closeSocket(s);
                                        if (i2ps == null) return;
                                        try {
                                            i2ps.close();
                                            return;
                                        }
                                        catch (IOException refererQuery) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                                this.verifySocketManager();
                                sess = this.sockMgr.getSession();
                                if (sess.isClosed()) break block328;
                                if (len != 60) break block329;
                                byte[] hData = Base32.decode(destination.substring(0, 52));
                                if (hData != null) {
                                    if (this._log.shouldInfo()) {
                                        this._log.info("[HTTPClient] Looking up b32 in-session: " + destination);
                                    }
                                    Hash hash = Hash.create(hData);
                                    clientDest = sess.lookupDest(hash, 20000L);
                                    break block311;
                                } else {
                                    clientDest = null;
                                }
                                break block311;
                            }
                            if (len >= 64) {
                                if (this._log.shouldInfo()) {
                                    this._log.info("[HTTPClient] Lookup b33 in-session " + destination);
                                }
                                LookupResult lresult = sess.lookupDest2(destination, 20000L);
                                clientDest = lresult.getDestination();
                                int code = lresult.getResultCode();
                                if (code != 0) {
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("[HTTPClient] Unable to resolve b33 " + destination + " error code " + code);
                                    }
                                    if (code != 1) {
                                        this.writeB32SaveForm(out, destination, code, targetRequest);
                                        return;
                                    }
                                }
                            }
                            break block311;
                        }
                        if (this._log.shouldInfo()) {
                            this._log.info("[HTTPClient] B32 lookup out of session for: " + destination);
                        }
                        clientDest = this._context.namingService().lookup(destination);
                        break block311;
                    }
                    String destName = destination;
                    if (destination != null && destination.length() > 20) {
                        destName = destination.substring(0, 15) + "...";
                    }
                    if (this._log.shouldInfo()) {
                        this._log.info("[HTTPClient] Looking up hostname: " + destName);
                    }
                    clientDest = this._context.namingService().lookup(destination);
                }
                if (clientDest == null) {
                    String header;
                    if (this._log.shouldWarn()) {
                        String destName = destination;
                        if (destination != null && destination.length() > 20) {
                            destName = destination.substring(0, 15) + "...";
                        }
                        this._log.warn("[HTTPClient] Unable to resolve " + destName + "..." + (usingWWWProxy ? " (Outproxy)" : "") + "\n* Request: " + targetRequest);
                    }
                    String jumpServers = null;
                    String extraMessage = null;
                    if (usingWWWProxy) {
                        header = this.getErrorPage("dnfp", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                    } else if (ahelperPresent) {
                        header = this.getErrorPage("dnfb", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                    } else if (NamingService.isB32Host(destination)) {
                        header = this.getErrorPage("nols", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                        extraMessage = this._t("Destination LeaseSet not found");
                    } else {
                        header = this.getErrorPage("dnfh", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                        jumpServers = this.getTunnel().getClientOptions().getProperty(PROP_JUMP_SERVERS);
                        if (jumpServers == null) {
                            jumpServers = DEFAULT_JUMP_SERVERS;
                        }
                        int jumpDelay = 400 + this._context.random().nextInt(256);
                        try {
                            Thread.sleep(jumpDelay);
                        }
                        catch (InterruptedException outproxyName) {
                            // empty catch block
                        }
                    }
                    try {
                        this.writeErrorMessage(header, extraMessage, out, targetRequest, usingWWWProxy, destination, jumpServers);
                        return;
                    }
                    catch (IOException jumpDelay) {
                        // empty catch block
                        return;
                    }
                }
                if (isConnect && !usingWWWProxy && this.getTunnel().getClientOptions().getProperty(PROP_SSL_SET) != null && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_INTERNAL_SSL, "true"))) {
                    try {
                        this.writeErrorMessage(ERR_INTERNAL_SSL, out, targetRequest, false, destination);
                    }
                    catch (IOException header) {
                        // empty catch block
                    }
                    if (!this._log.shouldLog(30)) return;
                    this._log.warn("SSL to I2P destinations denied by configuration: " + targetRequest);
                    return;
                }
                if (ahelperNew && "GET".equals(method) && (userAgent == null || !userAgent.startsWith("Wget")) && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER))) {
                    try {
                        this.writeHelperSaveForm(out, destination, ahelperKey, targetRequest, referer);
                        return;
                    }
                    catch (IOException header) {
                        // empty catch block
                        return;
                    }
                }
                if (ahelperPresent && !"POST".equals(method) && !"PUT".equals(method)) {
                    String uri = targetRequest;
                    if (this._log.shouldDebug()) {
                        this._log.debug("[HTTPClient] Auto redirecting to " + uri);
                    }
                    try {
                        out.write(("HTTP/1.1 301 Address Helper Accepted\r\nLocation: " + uri + "\r\nConnection: close\r\n\r\n").getBytes("UTF-8"));
                        return;
                    }
                    catch (IOException jumpServers) {
                        // empty catch block
                        return;
                    }
                }
                if (i2ps == null || i2ps.isClosed() || remotePort != i2ps.getPort() || !clientDest.equals(i2ps.getPeerDestination())) {
                    I2PSocketOptions sktOpts;
                    if (i2ps != null) {
                        if (this._log.shouldInfo()) {
                            this._log.info("Old socket closed or different dest/port, opening new one");
                        }
                        try {
                            i2ps.close();
                        }
                        catch (IOException uri) {
                            // empty catch block
                        }
                    }
                    Properties opts = new Properties();
                    try {
                        sktOpts = this.getDefaultOptions(opts);
                    }
                    catch (RuntimeException re) {
                        StringBuilder buf = new StringBuilder(128);
                        buf.append("HTTP/1.1 503 Service Unavailable");
                        if (re.getMessage() != null) {
                            buf.append(" - ").append(re.getMessage());
                        }
                        buf.append("\r\n\r\n");
                        try {
                            out.write(buf.toString().getBytes("UTF-8"));
                            throw re;
                        }
                        catch (IOException outproxyName) {
                            // empty catch block
                        }
                        throw re;
                    }
                    if (remotePort > 0) {
                        sktOpts.setPort(remotePort);
                    }
                    i2ps = this.createI2PSocket(clientDest, sktOpts);
                }
                I2PTunnelHTTPClientRunner hrunner = null;
                if (isConnect) {
                    byte[] response;
                    if (usingWWWProxy) {
                        data = newRequest.toString().getBytes("ISO-8859-1");
                        response = null;
                    } else {
                        data = null;
                        response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
                    }
                    t = new I2PTunnelRunner(s, (I2PSocket)i2ps, this.sockLock, data, response, (List<I2PSocket>)this.mySockets, (I2PTunnelRunner.FailCallback)null);
                } else {
                    data = newRequest.toString().getBytes("ISO-8859-1");
                    I2PTunnelHTTPClientBase.OnTimeout onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId, hostLowerCase, isConnect);
                    boolean keepaliveI2P = keepalive && this.getBooleanOption(OPT_KEEPALIVE_I2P, true);
                    hrunner = new I2PTunnelHTTPClientRunner(s, (I2PSocket)i2ps, this.sockLock, data, this.mySockets, onTimeout, keepaliveI2P, keepalive, isHead);
                    t = hrunner;
                }
                if (usingWWWProxy) {
                    t.setSuccessCallback(new I2PTunnelHTTPClientBase.OnProxySuccess(this, currentProxy, hostLowerCase, isConnect));
                }
                String name = Thread.currentThread().getName();
                t.run();
                Thread.currentThread().setName(name);
                if (keepalive && hrunner != null && !hrunner.getKeepAliveSocket()) {
                    return;
                }
                if (hrunner != null && !hrunner.getKeepAliveI2P()) {
                    i2ps = null;
                }
                ++requestCount;
            } while (keepalive);
            return;
        }
        catch (IOException ex) {
            if (this._log.shouldInfo()) {
                this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            }
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            return;
        }
        catch (I2PException ex) {
            if (this._log.shouldInfo()) {
                this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            }
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            return;
        }
        catch (OutOfMemoryError oom) {
            IOException ex = new IOException("OOM");
            this._log.error(this.getPrefix(requestId) + "Error trying to connect", oom);
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            return;
        }
        finally {
            I2PTunnelHTTPClient.closeSocket(s);
            if (i2ps != null) {
                try {
                    i2ps.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void writeHelperSaveForm(OutputStream outs, String destination, String ahelperKey, String targetRequest, String referer) throws IOException {
        if (outs == null) {
            return;
        }
        String idn = I2PTunnelHTTPClient.decodeIDNHost(destination);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outs, "UTF-8"));
        String header = this.getErrorPage("ahelper-new", ERR_AHELPER_NEW);
        out.write(header);
        out.write("<table id=proxyNewHost>\n<tr><td class=right>" + this._t("Host") + "</td><td>" + idn + "</td></tr>\n");
        try {
            String b32 = Base32.encode(SHA256Generator.getInstance().calculateHash(Base64.decode(ahelperKey)).getData());
            out.write("<tr><td class=right>" + this._t("Base32") + "</td><td><a href=\"http://" + b32 + ".b32.i2p/\">" + b32 + ".b32.i2p</a></td></tr>");
        }
        catch (Exception b32) {
            // empty catch block
        }
        out.write("<tr><td class=right>" + this._t("Destination") + "</td><td><span id=b64 style=user-select:all>" + ahelperKey + "</span></td></tr>\n</table>\n<hr>\n<form method=GET action=\"" + targetRequest + "\">\n<hr>\n<div class=option><h4>" + this._t("Continue to {0} without saving", idn) + "</h4>\n<p>" + this._t("You can browse to the site without saving it to the addressbook. The address will be remembered until you restart your I2P router.") + "</p>\n<div class=formaction><button type=submit class=go>" + this._t("Continue without saving") + "</button></div>\n</div>\n</form>\n<form method=GET action=\"http://" + LOCAL_SERVER + "/add\">\n<input type=hidden name=\"host\" value=\"" + destination + "\">\n<input type=hidden name=\"dest\" value=\"" + ahelperKey + "\">\n<input type=hidden name=\"nonce\" value=\"" + this._proxyNonce + "\">\n<hr>\n<div class=option>\n<h4>" + this._t("Save {0} to router address book and continue to website", destination) + "</h4>\n<p>" + this._t("This address will be saved to your Router addressbook where your subscription-based addresses are stored."));
        if (this._context.namingService().getName().equals("BlockfileNamingService")) {
            out.write(" " + this._t("If you want to keep track of sites you have added manually, add to your Master or Private addressbook instead."));
        }
        String label = this._t("Save & continue").replace("&", "&amp;");
        out.write("</p>\n<div class=formaction><button type=submit class=accept name=\"router\" value=\"router\">" + label + "</button></div>\n</div>\n");
        if (this._context.namingService().getName().equals("BlockfileNamingService")) {
            out.write("<hr>\n<div class=option>\n<h4>" + this._t("Save {0} to master addressbook and continue to website", idn) + "</h4>\n<p>" + this._t("This address will be saved to your Master addressbook. Select this option for addresses you wish to keep separate from the main router address book, but don't mind publishing.") + "</p>\n<div class=formaction><button type=submit class=accept name=\"master\" value=\"master\">" + label + "</button></div>\n</div>\n");
            out.write("<hr>\n<div class=option><h4>" + this._t("Save {0} to private addressbook and continue to website", idn) + "</h4>\n<p>" + this._t("This address will be saved to your Private addressbook, ensuring it is never published.") + "</p>\n<div class=formaction><button type=submit class=accept name=\"private\" value=\"private\">" + label + "</button></div>\n</div>\n");
        }
        if (referer != null) {
            out.write("<input type=hidden name=\"referer\" value=\"" + referer + "\">\n");
        }
        out.write("<input type=hidden name=\"url\" value=\"" + targetRequest + "\">\n</form>\n</div>\n");
        I2PTunnelHTTPClient.writeFooter(out);
    }

    private void writeB32SaveForm(OutputStream outs, String destination, int code, String targetRequest) throws IOException {
        String label;
        if (outs == null) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outs, "UTF-8"));
        String header = this.getErrorPage("b32-auth", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
        out.write(header);
        out.write("<p>" + this._t("Base32") + ": <a href=\"" + destination + "\">" + destination + "</a></p>\n<hr>\n");
        String msg = code == 2 ? this._t("Base32 address requires lookup password") : (code == 3 ? this._t("Base32 address requires encryption key") : (code == 4 ? this._t("Base32 address requires encryption key and lookup password") : (code == 5 ? this._t("Base32 address decryption failure, check encryption key") : "lookup failure code " + code)));
        out.write("<p><b>" + msg + "</b></p>");
        out.write("<form method=GET action=\"http://proxy.i2p/b32\">\n<input type=hidden name=\"host\" value=\"" + destination + "\">\n<input type=hidden name=\"url\" value=\"" + targetRequest + "\">\n<input type=hidden name=\"code\" value=\"" + code + "\">\n<input type=hidden name=\"nonce\" value=\"" + this._proxyNonce + "\">\n");
        if (code == 3 || code == 4) {
            label = this._t("Generate");
            out.write("<h4>" + this._t("Encryption key") + "</h4>\n<p>" + this._t("You must either enter a PSK encryption key provided by the server operator, or generate a DH encryption key and send that to the server operator.") + ' ' + this._t("Ask the server operator for help.") + "</p>\n<p><b>PSK:</b> " + this._t("Enter PSK encryption key") + ":</p>\n<input type=text size=55 name=\"privkey\" value=\"\">\n<p><b>DH:</b> " + this._t("Generate new DH encryption key") + ":</p>\n<div class=formaction_xx><button type=submit class=accept name=action value=\"newdh\">" + label + "</button>\n</div>\n");
        }
        if (code == 2 || code == 4) {
            out.write("<h4>" + this._t("Lookup password") + "</h4>\n<p>" + this._t("You must enter the password provided by the server operator.") + "</p>\n<input type=text size=55 name=\"secret\" value=\"\">\n");
        }
        label = this._t("Save & continue").replace("&", "&amp;");
        out.write("<div class=formaction>\n<button type=submit class=accept name=action value=Save>" + label + "</button>\n</div>\n</form>\n</div>\n");
        I2PTunnelHTTPClient.writeFooter(out);
    }

    private final String getHostName(String host) {
        if (host == null) {
            return null;
        }
        if (NamingService.isB32Host(host)) {
            return host;
        }
        Destination dest = this._context.namingService().lookup(host);
        if (dest == null) {
            return "i2p";
        }
        return dest.toBase32();
    }

    private static boolean isSupportedAddress(String host, String protocol) {
        if (host == null || protocol == null) {
            return false;
        }
        String lc = protocol.toLowerCase(Locale.US);
        return lc.equals("http") || lc.equals("https");
    }

    private static URI changeURI(URI uri, String host, int port, String path) throws URISyntaxException {
        return new URI(uri.getScheme(), null, host != null ? host : uri.getHost(), port != 0 ? port : uri.getPort(), path != null ? path : uri.getPath(), uri.getQuery(), null);
    }

    private static URI replaceQuery(URI uri, String query) throws URISyntaxException {
        URI rv = uri;
        if (rv.getRawQuery() != null) {
            rv = new URI(rv.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        if (query != null) {
            String newURI = rv.toASCIIString() + '?' + query;
            rv = new URI(newURI);
        }
        return rv;
    }

    private static String[] removeHelper(String query) {
        int keystart = 0;
        int valstart = -1;
        String key = null;
        for (int i = 0; i <= query.length(); ++i) {
            int c;
            int n = c = i < query.length() ? (int)query.charAt(i) : 38;
            if (c == 59 || c == 38) {
                String decodedKey;
                if (valstart < 0) {
                    key = query.substring(keystart, i);
                }
                if ((decodedKey = LocalHTTPServer.decode(key)).equals(HELPER_PARAM)) {
                    String newQuery;
                    String string = newQuery = keystart > 0 ? query.substring(0, keystart - 1) : "";
                    if (i < query.length() - 1) {
                        newQuery = keystart > 0 ? newQuery + query.substring(i) : newQuery + query.substring(i + 1);
                    }
                    String value = valstart >= 0 ? query.substring(valstart, i) : "";
                    String helperValue = LocalHTTPServer.decode(value);
                    return new String[]{newQuery, helperValue};
                }
                keystart = i + 1;
                valstart = -1;
                continue;
            }
            if (c != 61 || valstart >= 0) continue;
            key = query.substring(keystart, i);
            valstart = i + 1;
        }
        return null;
    }

    private static class InputReader {
        InputStream _s;

        public InputReader(InputStream s) {
            this._s = s;
        }

        String readLine(String method) throws IOException {
            return DataHelper.readLine(this._s);
        }

        public void drain() {
            try {
                String line;
                while ((line = DataHelper.readLine(this._s)) != null && line.length() > 1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

