/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLException;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.ConnThrottler;
import net.i2p.i2ptunnel.HTTPResponseOutputStream;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class I2PTunnelHTTPServer
extends I2PTunnelServer {
    public static final int DEFAULT_POST_BAN_TIME = 900;
    public static final int DEFAULT_POST_MAX = 16;
    public static final int DEFAULT_POST_TOTAL_BAN_TIME = 600;
    public static final int DEFAULT_POST_TOTAL_MAX = 30;
    public static final int DEFAULT_POST_WINDOW = 180;
    private static final boolean DEFAULT_KEEPALIVE = true;
    public static final String OPT_POST_BAN_TIME = "postBanTime";
    public static final String OPT_POST_MAX = "maxPosts";
    public static final String OPT_POST_TOTAL_BAN_TIME = "postTotalBanTime";
    public static final String OPT_POST_TOTAL_MAX = "maxTotalPosts";
    public static final String OPT_POST_WINDOW = "postCheckTime";
    public static final String OPT_REJECT_INPROXY = "rejectInproxy";
    public static final String OPT_REJECT_REFERER = "rejectReferer";
    public static final String OPT_REJECT_USER_AGENTS = "rejectUserAgents";
    public static final String OPT_USER_AGENTS = "userAgentRejectList";
    public static final String OPT_KEEPALIVE = "keepalive.i2p";
    public static final String OPT_ADD_RESPONSE_HEADER_ALLOW = "addResponseHeaderAllow";
    public static final String OPT_ADD_RESPONSE_HEADER_CACHE_CONTROL = "addResponseHeaderCacheControl";
    public static final String OPT_ADD_RESPONSE_HEADER_NOSNIFF = "addResponseHeaderNoSniff";
    public static final String OPT_ADD_RESPONSE_HEADER_REFERRER_POLICY = "addResponseHeaderReferrerPolicy";
    private String _spoofHost;
    private static final String HASH_HEADER = "X-I2P-DestHash";
    private static final String DEST64_HEADER = "X-I2P-DestB64";
    private static final String DEST32_HEADER = "X-I2P-DestB32";
    private static final String PROXY_CONN_HEADER = "proxy-connection";
    private static final String PRIORITY_HEADER = "Priority";
    private static final String SEC_GPC_HEADER = "Sec-GPC";
    private static final String X_FORWARDED_HEADER = "X-Forwarded-For";
    private static final String X_REAL_IP_HEADER = "X-Real-Ip";
    private static final String[] CLIENT_SKIPHEADERS = new String[]{"X-I2P-DestHash".toLowerCase(Locale.US), "X-I2P-DestB64".toLowerCase(Locale.US), "X-I2P-DestB32".toLowerCase(Locale.US), "Priority".toLowerCase(Locale.US), "proxy-connection", "Sec-GPC".toLowerCase(Locale.US), "X-Real-Ip".toLowerCase(Locale.US)};
    private static final String AGE_HEADER = "age";
    private static final String ALT_SVC_HEADER = "alt-svc";
    private static final String DATE_HEADER = "date";
    private static final String EXPIRES_HEADER = "expires";
    private static final String PRAGMA_HEADER = "pragma";
    private static final String REFERER_HEADER = "referer";
    private static final String SERVER_HEADER = "server";
    private static final String STRICT_TRANSPORT_SECURITY_HEADER = "strict-transport-security";
    private static final String VIA_HEADER = "via";
    private static final String X_CACHE_HEADER = "x-cache";
    private static final String X_CACHE_HITS_HEADER = "x-cache-hits";
    private static final String X_CLOUD_TRACE_CONTEXT_HEADER = "x-cloud-trace-context";
    private static final String X_CONTEXTID_HEADER = "x-contextid";
    private static final String X_GOOG_GENERATION_HEADER = "x-goog-generation";
    private static final String X_GOOG_HASH_HEADER = "x-goog-hash";
    private static final String X_GUPLOADER_UPLOADID_HEADER = "x-guploader-uploadid";
    private static final String X_HACKER_HEADER = "x-hacker";
    private static final String X_NANANANA_HEADER = "x-nananana";
    private static final String X_PANTHEON_STYX_HOSTNAME_HEADER = "x-pantheon-styx-hostname";
    private static final String X_POWERED_BY_HEADER = "x-powered-by";
    private static final String X_RUNTIME_HEADER = "x-runtime";
    private static final String X_SERVED_BY_HEADER = "x-served-by";
    private static final String X_STYX_REQ_ID_HEADER = "x-styx-req-id";
    private static final String X_TIMER_HEADER = "x-timer";
    private static final String PROXY_HEADER = "proxy";
    private static final String[] SERVER_SKIPHEADERS = new String[]{"age", "alt-svc", "date", "expires", "pragma", "proxy-connection", "proxy", "referer", "server", "strict-transport-security", "via", "x-cache", "x-cache-hits", "x-cloud-trace-context", "x-contextid", "x-goog-generation", "x-goog-hash", "x-guploader-uploadid", "x-hacker", "x-nananana", "x-pantheon-styx-hostname", "x-powered-by", "x-runtime", "x-served-by", "x-styx-req-id"};
    private static final long HEADER_TIMEOUT = 45000L;
    private static final long HEADER_FINISH_TIMEOUT = 45000L;
    private static final long START_INTERVAL = 180000L;
    private static final int MAX_LINE_LENGTH = 8192;
    private static final int MAX_HEADERS = 60;
    private static final int MAX_TOTAL_HEADER_SIZE = 32768;
    private static final long DEFAULT_HTTP_READ_TIMEOUT = -1L;
    private static final int SERVER_READ_TIMEOUT_GET = 90000;
    private static final int SERVER_READ_TIMEOUT_MEDIUM = 300000;
    private static final int SERVER_READ_TIMEOUT_POST = 14400000;
    private long _startedOn = 0L;
    private ConnThrottler _postThrottler;
    private static final String ERR_NOT_FOUND = "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>404 Not Found</title><meta name=color-scheme content=\"light dark\"></head>\n<body>\n<center><h1>404 Not Found</h1></center>\n<hr>\n</body>\n</html>";
    private static final String ERR_UNAVAILABLE = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>503 Service Temporarily Unavailable</title><meta name=color-scheme content=\"light dark\"></head>\n<body>\n<center><h1>503 Service Temporarily Unavailable</h1></center>\n<hr>\n</body>\n</html>";
    private static final String ERR_DENIED = "HTTP/1.1 429 Too Many Requests\r\nContent-Type: text/html; charset=utf-8\r\nRetry-After: 600\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>429 Too Many Requests</title><meta name=color-scheme content=\"light dark\"></head>\n<body>\n<center><h1>429 Too Many Requests</h1></center>\n<hr>\n</body>\n</html>";
    private static final String ERR_FORBIDDEN = "HTTP/1.1 403 Denied\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>403 Forbidden</title><meta name=color-scheme content=\"light dark\"></head>\n<body>\n<center><h1>403 Forbidden</h1></center>\n<hr>\n</body>\n</html>";
    private static final String ERR_REQUEST_URI_TOO_LONG = "HTTP/1.1 414 Request URI too long\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>414 Request URI Too Long</title><meta name=color-scheme content=\"light dark\"></head>\n<center><h1>414 Request URI too long</h1></center>\n<hr>\n</body>\n</html>";
    private static final String ERR_HEADERS_TOO_LARGE = "HTTP/1.1 431 Request header fields too large\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>431 Request Header Fields Too Large</title><meta name=color-scheme content=\"light dark\"></head>\n<center><h1>431 Request header fields too large</h1></center>\n<hr>\n</body>\n</html>";
    protected static final String ERR_REQUEST_TIMEOUT = "HTTP/1.1 408 Request timeout\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><meta http-equiv=\"refresh\" content=\"5\"></head>\n</html>";
    private static final String ERR_BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Type: text/html; charset=utf-8\r\nCache-Control: no-cache\r\nConnection: close\r\n\r\n<html>\n<head><title>400 Bad Request</title><meta name=color-scheme content=\"light dark\"></head>\n<center><h1>400 Bad request (malformed datastream)</h1></center>\n<hr>\n</body>\n</html>";
    private static final int MIN_TO_COMPRESS = 1024;
    String HTTP_BLOCKLIST = "http_blocklist.txt";
    String HTTP_BLOCKLIST_CLIENTS = "http_blocklist_clients.txt";
    private int HTTP_BLOCKLIST_CLIENT_LIMIT = 512;
    private Pattern regexPattern = null;
    private long blocklistLastModified;
    private List<String> clientBlockList = new ArrayList<String>();
    private static long blocklistClientsLastModified;
    private static int cachedClientBlockListSize;
    File blocklistFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.HTTP_BLOCKLIST);
    File blocklistClients = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.HTTP_BLOCKLIST_CLIENTS);

    public I2PTunnelHTTPServer(InetAddress host, int port, String privData, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, File privkey, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privkey, privkeyname, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, InputStream privData, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, privkeyname, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    private void setupI2PTunnelHTTPServer(String spoofHost) {
        this._spoofHost = spoofHost != null && spoofHost.trim().length() > 0 ? spoofHost.trim() : null;
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpserver.blockingHandleTime", "How long the blocking handle takes to complete", "Tunnels [HTTPServer]", new long[]{60000L, 600000L, 10800000L});
        this.readTimeout = -1L;
    }

    @Override
    public void startRunning() {
        super.startRunning();
        this._startedOn = this.getTunnel().getContext().clock().now();
        this.setupPostThrottle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPostThrottle() {
        int pp = this.getIntOption(OPT_POST_MAX, 0);
        int pt = this.getIntOption(OPT_POST_TOTAL_MAX, 0);
        I2PTunnelHTTPServer i2PTunnelHTTPServer = this;
        synchronized (i2PTunnelHTTPServer) {
            if (pp != 0 || pt != 0 || this._postThrottler != null) {
                long pw = 1000L * (long)this.getIntOption(OPT_POST_WINDOW, 180);
                long pb = 1000L * (long)this.getIntOption(OPT_POST_BAN_TIME, 900);
                long px = 1000L * (long)this.getIntOption(OPT_POST_TOTAL_BAN_TIME, 600);
                if (this._postThrottler == null) {
                    this._postThrottler = new ConnThrottler(pp, pt, pw, pb, px, "POST/PUT", this._log);
                } else {
                    this._postThrottler.updateLimits(pp, pt, pw, pb, px);
                }
                this._postThrottler.start();
            }
        }
    }

    private int getIntOption(String opt, int dflt) {
        Properties opts = this.getTunnel().getClientOptions();
        String o = opts.getProperty(opt);
        if (o != null) {
            try {
                return Integer.parseInt(o);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dflt;
    }

    private final boolean shouldAddResponseHeaderAllow() {
        Properties opts = this.getTunnel().getClientOptions();
        boolean addAllowHeader = Boolean.parseBoolean(opts.getProperty(OPT_ADD_RESPONSE_HEADER_ALLOW));
        return addAllowHeader;
    }

    private final boolean shouldAddResponseHeaderCacheControl() {
        Properties opts = this.getTunnel().getClientOptions();
        boolean addCacheControlHeader = Boolean.parseBoolean(opts.getProperty(OPT_ADD_RESPONSE_HEADER_CACHE_CONTROL));
        return addCacheControlHeader;
    }

    private final boolean shouldAddResponseHeaderReferrerPolicy() {
        Properties opts = this.getTunnel().getClientOptions();
        boolean addReferrerPolicyHeader = Boolean.parseBoolean(opts.getProperty(OPT_ADD_RESPONSE_HEADER_REFERRER_POLICY));
        return addReferrerPolicyHeader;
    }

    private final boolean shouldAddResponseHeaderNoSniff() {
        Properties opts = this.getTunnel().getClientOptions();
        boolean addNoSniffPolicyHeader = Boolean.parseBoolean(opts.getProperty(OPT_ADD_RESPONSE_HEADER_NOSNIFF));
        return addNoSniffPolicyHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean forced) {
        I2PTunnelHTTPServer i2PTunnelHTTPServer = this;
        synchronized (i2PTunnelHTTPServer) {
            if (this._postThrottler != null) {
                this._postThrottler.stop();
            }
        }
        return super.close(forced);
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        if (this.getTunnel() != tunnel) {
            return;
        }
        this.setupPostThrottle();
        Properties props = tunnel.getClientOptions();
        String spoofHost = props.getProperty("spoofedHost");
        this._spoofHost = spoofHost != null && spoofHost.trim().length() > 0 ? spoofHost.trim() : null;
        super.optionsUpdated(tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blockingHandle(I2PSocket socket) {
        block172: {
            Hash peerHash = socket.getPeerDestination().calculateHash();
            String peerB32 = socket.getPeerDestination().toBase32();
            if (this._log.shouldDebug()) {
                this._log.debug("[HTTPServer] Incoming connection to " + this.toString().replace("/", "") + " (Port " + socket.getLocalPort() + ")\n* From: " + peerB32 + " on port " + socket.getPort());
            }
            try {
                if (socket.getLocalPort() == 443) {
                    if (this.getTunnel().getClientOptions().getProperty("targetForPort.443") == null) {
                        try {
                            socket.reset();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    socket.setReadTimeout(14400000L);
                    Socket s = this.getSocket(socket.getPeerDestination().calculateHash(), 443);
                    I2PTunnelRunner t = new I2PTunnelRunner(s, socket, this.slock, null, null, null, (I2PTunnelRunner.FailCallback)null);
                    this.executeInPool(t);
                    return;
                }
                long afterAccept = this.getTunnel().getContext().clock().now();
                int requestCount = 0;
                boolean keepalive = this.getBooleanOption(OPT_KEEPALIVE, true);
                do {
                    boolean useGZIP;
                    String cmd;
                    boolean isGetOrHead;
                    String portSpoof;
                    String referer;
                    List<String> h;
                    int port;
                    Map<String, List<String>> headers;
                    if (requestCount > 0 && this._log.shouldDebug()) {
                        this._log.debug("[HTTPServer] KeepAlive, awaiting request [#" + requestCount + "]");
                    }
                    StringBuilder command = new StringBuilder(128);
                    try {
                        long timeout = requestCount > 0 ? 130000L : 45000L;
                        headers = I2PTunnelHTTPServer.readHeaders(socket, null, command, CLIENT_SKIPHEADERS, this.getTunnel().getContext(), timeout);
                    }
                    catch (SocketTimeoutException ste) {
                        if (requestCount > 0) {
                            if (this._log.shouldDebug()) {
                                this._log.debug("[HTTPServer] Timeout reached awaiting request [#" + requestCount + "]");
                            }
                        } else {
                            try {
                                I2PTunnelHTTPServer.sendError(socket, ERR_REQUEST_TIMEOUT);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (this._log.shouldWarn() && ste.getMessage() != null) {
                                this._log.warn("[HTTPServer] Request error: " + ste.getMessage() + " \n* Client: " + peerB32);
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (EOFException eofe) {
                        if (requestCount > 0) {
                            if (this._log.shouldDebug()) {
                                this._log.debug("[HTTPServer] Client closed awaiting request [#" + requestCount + "]");
                            }
                        } else {
                            try {
                                I2PTunnelHTTPServer.sendError(socket, ERR_BAD_REQUEST);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (this._log.shouldWarn() && eofe.getMessage() != null) {
                                this._log.warn("[HTTPServer] Request error: " + eofe.getMessage() + " \n* Client: " + peerB32);
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (LineTooLongException ltle) {
                        try {
                            I2PTunnelHTTPServer.sendError(socket, ERR_HEADERS_TOO_LARGE);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (this._log.shouldWarn()) {
                            this._log.warn("[HTTPServer] Request error: Headers too large \n* Client: " + peerB32);
                        }
                        return;
                    }
                    catch (RequestTooLongException rtle) {
                        try {
                            I2PTunnelHTTPServer.sendError(socket, ERR_REQUEST_URI_TOO_LONG);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (this._log.shouldWarn()) {
                            this._log.warn("[HTTPServer] Request error: URI too long \n* Client: " + peerB32);
                        }
                        return;
                    }
                    catch (BadRequestException bre) {
                        try {
                            I2PTunnelHTTPServer.sendError(socket, ERR_BAD_REQUEST);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (this._log.shouldDebug() && bre.getMessage() != null) {
                            this._log.warn("[HTTPServer] Request error: " + bre.getMessage() + " \n* Client: " + peerB32);
                        }
                        return;
                    }
                    String hostname = null;
                    boolean isValidRequest = true;
                    boolean isPossibleExploit = false;
                    List<String> host = headers.get("Host");
                    if (peerB32.length() != 60) {
                        this._log.warn("[HTTPServer] Invalid B32 (expected 60 characters, got " + peerB32.length() + ") -> Denying request to [" + hostname + "]\n* Client: " + peerB32);
                        isValidRequest = false;
                        isPossibleExploit = false;
                    }
                    if (host != null && (port = (hostname = host.get(0)).indexOf(":")) != -1) {
                        hostname = hostname.substring(0, port);
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("[HTTPServer] Incoming request for: " + hostname + "\n* Client: " + peerB32);
                    }
                    if (hostname != null && !hostname.endsWith(".i2p") && !hostname.endsWith(".onion")) {
                        InetAddress address = InetAddress.getByName(hostname);
                        if (address != null) {
                            if (address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isSiteLocalAddress()) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("[HTTPServer] WARNING! Attempt to access localhost or loopback address via [" + hostname + "] -> Adding dest to clients blocklist file \n* Client: " + peerB32);
                                }
                                this.logBlockedDestination(peerB32);
                                isValidRequest = false;
                                isPossibleExploit = true;
                            } else if (address.isAnyLocalAddress()) {
                                if (!hostname.equals("::") || !hostname.equals("0.0.0.0")) {
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("[HTTPServer] DNS server appears to be blocking requests to " + hostname + " -> Sending Error 403 \n* Client: " + peerB32);
                                    }
                                    I2PTunnelHTTPServer.sendError(socket, ERR_FORBIDDEN);
                                    isValidRequest = false;
                                    isPossibleExploit = false;
                                } else {
                                    I2PTunnelHTTPServer.sendError(socket, ERR_FORBIDDEN);
                                    isValidRequest = false;
                                    isPossibleExploit = true;
                                }
                            } else {
                                if (this._log.shouldInfo() && !hostname.equals(address.getHostAddress())) {
                                    this._log.info("[HTTPServer] Hostname " + hostname + " validated -> Resolves to: " + address.getHostAddress());
                                }
                                isPossibleExploit = false;
                            }
                        } else {
                            if (this._log.shouldWarn()) {
                                this._log.warn("[HTTPServer] Could not resolve " + hostname + " to IP address -> Sending Error 404 \n* Client: " + peerB32);
                            }
                            I2PTunnelHTTPServer.sendError(socket, ERR_NOT_FOUND);
                            isValidRequest = false;
                            isPossibleExploit = false;
                        }
                        if (isPossibleExploit) {
                            this.logBlockedDestination(peerB32);
                            if (this._log.shouldWarn()) {
                                this._log.warn("[HTTPServer] Client attempted to access private or wildcard address " + hostname + " -> Sending Error 403 and adding to blocklist \n* Client: " + peerB32);
                            }
                        }
                        if (!isValidRequest && socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    long afterHeaders = this.getTunnel().getContext().clock().now();
                    Properties opts = this.getTunnel().getClientOptions();
                    if (Boolean.parseBoolean(opts.getProperty(OPT_REJECT_INPROXY)) && (headers.containsKey(X_FORWARDED_HEADER) || headers.containsKey("X-Forwarded-Server") || headers.containsKey("Forwarded") || headers.containsKey("X-Forwarded-Host"))) {
                        if (this._log.shouldWarn()) {
                            StringBuilder buf = new StringBuilder();
                            buf.append("[HTTPServer] Refusing Inproxy access \n* Client: ").append(peerB32);
                            List<String> h2 = headers.get(X_FORWARDED_HEADER);
                            if (h2 != null) {
                                buf.append("\n* X-Forwarded-For: ").append(h2.get(0));
                            }
                            if ((h2 = headers.get("X-Forwarded-Server")) != null) {
                                buf.append("\n* X-Forwarded-Server: ").append(h2.get(0));
                            }
                            if ((h2 = headers.get("X-Forwarded-Host")) != null) {
                                buf.append("\n* X-Forwarded-Host: ").append(h2.get(0));
                            }
                            if ((h2 = headers.get("Forwarded")) != null) {
                                buf.append("\n* Forwarded: ").append(h2.get(0));
                            }
                            this._log.warn(buf.toString());
                        }
                        try {
                            I2PTunnelHTTPServer.sendError(socket, ERR_FORBIDDEN);
                        }
                        catch (IOException buf) {
                            // empty catch block
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException buf) {
                            // empty catch block
                        }
                        return;
                    }
                    if (Boolean.parseBoolean(opts.getProperty(OPT_REJECT_REFERER)) && (h = headers.get("Referer")) != null && (referer = h.get(0)).length() > 9 && ((referer = referer.substring(9)).startsWith("http://") || referer.startsWith("https://"))) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("[HTTPServer] Refusing access (Bad referer) \n* Client: " + peerB32 + "\n* Referer: " + referer);
                        }
                        try {
                            I2PTunnelHTTPServer.sendError(socket, ERR_FORBIDDEN);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    if (Boolean.parseBoolean(opts.getProperty(OPT_REJECT_USER_AGENTS))) {
                        if (headers != null && headers.containsKey("User-Agent")) {
                            String blockAgents;
                            String ua = headers.get("User-Agent").get(0);
                            if (!ua.startsWith("MYOB") && (blockAgents = opts.getProperty(OPT_USER_AGENTS)) != null) {
                                String[] agents = DataHelper.split(blockAgents, ",");
                                for (int i = 0; i < agents.length; ++i) {
                                    String ag2 = agents[i].trim();
                                    if (ag2.equals("none") || ag2.length() <= 0 || !ua.contains(ag2)) continue;
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("[HTTPServer] Refusing access: Blacklisted User Agent (" + ua + ") \n* Client: " + peerB32);
                                    }
                                    try {
                                        I2PTunnelHTTPServer.sendError(socket, ERR_FORBIDDEN);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                        } else {
                            String blockAgents = opts.getProperty(OPT_USER_AGENTS);
                            if (blockAgents != null) {
                                String[] agents = DataHelper.split(blockAgents, ",");
                                for (int i = 0; i < agents.length; ++i) {
                                    String ag = agents[i].trim();
                                    if (!ag.equals("none")) continue;
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("[HTTPServer] Refusing access: User Agent header is blank \n* Client: " + peerB32);
                                    }
                                    try {
                                        I2PTunnelHTTPServer.sendError(socket, ERR_FORBIDDEN);
                                    }
                                    catch (IOException ag2) {
                                        // empty catch block
                                    }
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException ag2) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                        }
                    }
                    if (this._postThrottler != null && command.length() >= 5 && (command.substring(0, 5).toUpperCase(Locale.US).equals("POST ") || command.substring(0, 4).toUpperCase(Locale.US).equals("PUT ")) && this._postThrottler.shouldThrottle(peerHash)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("[HTTPServer] Refusing POST/PUT since peer is throttled \n* Client: " + peerB32);
                        }
                        try {
                            I2PTunnelHTTPServer.sendError(socket, ERR_DENIED);
                        }
                        catch (IOException blockAgents) {
                            // empty catch block
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException blockAgents) {
                            // empty catch block
                        }
                        return;
                    }
                    I2PTunnelHTTPServer.addEntry(headers, HASH_HEADER, peerHash.toBase64());
                    I2PTunnelHTTPServer.addEntry(headers, DEST32_HEADER, peerB32);
                    I2PTunnelHTTPServer.addEntry(headers, DEST64_HEADER, socket.getPeerDestination().toBase64());
                    int ourPort = socket.getLocalPort();
                    String spoofHost = ourPort != 80 && ourPort > 0 && ourPort <= 65535 ? ((portSpoof = opts.getProperty("spoofedHost." + ourPort)) != null ? portSpoof.trim() : this._spoofHost) : this._spoofHost;
                    if (spoofHost != null) {
                        I2PTunnelHTTPServer.setEntry(headers, "Host", spoofHost);
                    }
                    boolean upgrade = false;
                    String conn = I2PTunnelHTTPServer.getEntryOrNull(headers, "Connection");
                    if (conn == null) {
                        I2PTunnelHTTPServer.setEntry(headers, "Connection", "close");
                    } else {
                        String connlc = conn.toLowerCase(Locale.US);
                        if (connlc.contains("upgrade")) {
                            upgrade = true;
                            keepalive = false;
                        } else {
                            if (!connlc.contains("keep-alive")) {
                                keepalive = false;
                            }
                            I2PTunnelHTTPServer.setEntry(headers, "Connection", "close");
                        }
                    }
                    if (command.length() > 0) {
                        this.processBlocklist(socket, command);
                    }
                    boolean bl = isGetOrHead = (cmd = command.toString().trim()).startsWith("GET ") || cmd.startsWith("HEAD ");
                    if (!cmd.endsWith(" HTTP/1.1") || !isGetOrHead) {
                        keepalive = false;
                    }
                    String enc = I2PTunnelHTTPServer.getEntryOrNull(headers, "Accept-Encoding");
                    String altEnc = I2PTunnelHTTPServer.getEntryOrNull(headers, "X-Accept-Encoding");
                    socket.setReadTimeout(this.readTimeout);
                    Socket s = this.getSocket(socket.getPeerDestination().calculateHash(), socket.getLocalPort());
                    long afterSocket = this.getTunnel().getContext().clock().now();
                    boolean allowGZIP = true;
                    String val = opts.getProperty("i2ptunnel.gzip");
                    if (val != null && !Boolean.parseBoolean(val)) {
                        allowGZIP = false;
                    }
                    if (this._log.shouldDebug() && (enc != null || altEnc != null)) {
                        this._log.debug("[HTTPServer] Encoding header: " + enc + "/" + altEnc);
                    }
                    boolean alt = altEnc != null && altEnc.indexOf("x-i2p-gzip") >= 0;
                    boolean bl2 = useGZIP = alt || enc != null && enc.indexOf("x-i2p-gzip") >= 0;
                    if (alt) {
                        headers.remove("X-Accept-Encoding");
                    }
                    String modifiedHeader = I2PTunnelHTTPServer.formatHeaders(headers, command);
                    if (this._log.shouldDebug()) {
                        this._log.debug("[HTTPServer] Modified headers\n\t" + modifiedHeader);
                    } else if (this._log.shouldInfo() && !command.toString().toLowerCase().contains("head")) {
                        String compactHeaders = I2PTunnelHTTPServer.formatHeadersCompact(headers, command);
                        this._log.info("[HTTPServer] Received request headers" + compactHeaders);
                    }
                    boolean compress = allowGZIP && useGZIP;
                    AtomicInteger waiter = keepalive ? new AtomicInteger() : null;
                    CompressedRequestor t = new CompressedRequestor(s, socket, modifiedHeader, this.getTunnel().getContext(), this._log, compress, upgrade, this._clientExecutor, keepalive, waiter);
                    if (keepalive || isGetOrHead) {
                        t.run();
                    } else {
                        this.executeInPool(t);
                    }
                    long afterHandle = this.getTunnel().getContext().clock().now();
                    if (requestCount == 0) {
                        long timeToHandle = afterHandle - afterAccept;
                        this.getTunnel().getContext().statManager().addRateData("i2ptunnel.httpserver.blockingHandleTime", timeToHandle);
                        if (timeToHandle > 1500L && this._log.shouldDebug()) {
                            this._log.info("[HTTPServer] Took a while (" + timeToHandle + "ms) to handle the request for " + this.remoteHost + ':' + this.remotePort + "\n* Client: " + peerB32 + "\n* Tasks: Read headers: " + (afterHeaders - afterAccept) + "ms; Socket create: " + (afterSocket - afterHeaders) + "ms; Start runners: " + (afterHandle - afterSocket) + "ms");
                        }
                    }
                    if (keepalive) {
                        if (this._log.shouldDebug()) {
                            String code;
                            long timeToWait = this.getTunnel().getContext().clock().now() - afterAccept;
                            switch (waiter.get()) {
                                case 0: {
                                    code = "Not complete";
                                    break;
                                }
                                case 1: {
                                    code = "Not KeepAlive";
                                    break;
                                }
                                case 2: {
                                    code = "KeepAlive";
                                    break;
                                }
                                default: {
                                    code = "Unknown";
                                }
                            }
                            this._log.debug("[HTTPServer] Waited " + timeToWait + "ms for response [#" + requestCount + "] to complete -> " + code);
                        }
                        if (waiter.get() != 2) break;
                    }
                    ++requestCount;
                } while (keepalive);
            }
            catch (SocketException ex) {
                int level;
                int port = socket.getLocalPort();
                try {
                    I2PTunnelHTTPServer.sendError(socket, ERR_UNAVAILABLE);
                }
                catch (IOException requestCount) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException requestCount) {
                    // empty catch block
                }
                int n = level = this.getTunnel().getContext().clock().now() - this._startedOn > 180000L ? 40 : 30;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "[HTTPServer] Error connecting to HTTP server " + this.getSocketString(port));
                }
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._log.shouldWarn()) {
                    if (ex.getMessage().indexOf("Name or service not known") >= 0) {
                        this._log.warn("[HTTPServer] Request error: DNS error (blocked?) for: " + ex.getMessage().replace(": Name or service not known", "") + " \n* Client: " + peerB32);
                    } else {
                        this._log.warn("[HTTPServer] Request error: " + ex.getMessage() + " \n* Client: " + peerB32);
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    I2PTunnelHTTPServer.sendError(socket, ERR_UNAVAILABLE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this._log.shouldError()) break block172;
                this._log.error("[HTTPServer] Out of Memory error (" + oom.getMessage() + ")");
            }
        }
    }

    private static void sendError(I2PSocket socket, String resp) throws IOException {
        if (socket.getLocalPort() == 443) {
            socket.reset();
        } else {
            socket.getOutputStream().write(resp.getBytes("UTF-8"));
        }
    }

    private static synchronized String getHostFromHeaders(String headers) {
        String[] headerLines;
        for (String headerLine : headerLines = headers.split("\r\n")) {
            if (!headerLine.startsWith("Host:")) continue;
            String hostHeader = headerLine.substring(6).trim();
            int index = hostHeader.indexOf(":");
            return index != -1 ? hostHeader.substring(0, index) : hostHeader;
        }
        return null;
    }

    protected static String formatHeaders(Map<String, List<String>> headers, StringBuilder command) {
        StringBuilder buf = new StringBuilder(command.length() + headers.size() * 64);
        buf.append(command.toString().trim()).append("\r\n");
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String name = e.getKey();
            for (String val : e.getValue()) {
                buf.append(name.trim()).append(": ").append(val.trim()).append("\r\n");
            }
        }
        buf.append("\r\n");
        return buf.toString();
    }

    protected static String formatHeadersCompact(Map<String, List<String>> headers, StringBuilder command) {
        StringBuilder buf = new StringBuilder(command.length() + headers.size() * 64);
        String request = command.toString().trim();
        if (request.contains("peer_id")) {
            int ampersand = request.indexOf("&");
            String truncatedRequest = request.substring(0, ampersand) + "...";
            if (request.endsWith("HTTP/1.1")) {
                truncatedRequest = truncatedRequest + " HTTP/1.1";
            } else if (request.endsWith("HTTP/1.0")) {
                truncatedRequest = truncatedRequest + " HTTP/1.0";
            }
            request = truncatedRequest;
        }
        if (!request.toLowerCase().contains("head")) {
            buf.append("\n* Request: " + request);
        }
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            boolean hasUA;
            String name = e.getKey();
            String lcName = name.toLowerCase().trim();
            String value = e.getValue().iterator().next().trim();
            boolean bl = hasUA = name.toLowerCase().contains("user-agent") && !value.isEmpty();
            if (request.toLowerCase().contains("head") || lcName.contains("desthash") || lcName.contains("destb64") || lcName.contains("dnt") || lcName.contains("connection") || lcName.contains("accept") || lcName.contains("cookie") || lcName.contains(PRAGMA_HEADER) || lcName.contains("cache-control") || lcName.contains(REFERER_HEADER) || lcName.contains("upgrade-insecure-requests") || lcName.equals("content-length") && value.equals("0") || lcName.contains("user-agent") && hasUA && value.contains("MYOB")) continue;
            for (String val : e.getValue()) {
                buf.append("\n* ").append(name.trim()).append(": ").append(val.trim());
            }
        }
        return buf.toString();
    }

    private static void addEntry(Map<String, List<String>> headers, String key, String value) {
        List<String> entry = headers.get(key);
        if (entry == null) {
            entry = new ArrayList<String>(1);
            headers.put(key, entry);
        }
        entry.add(value);
    }

    private static void setEntry(Map<String, List<String>> headers, String key, String value) {
        List<String> entry = headers.get(key);
        if (entry == null) {
            entry = new ArrayList<String>(1);
            headers.put(key, entry);
        } else {
            entry.clear();
        }
        entry.add(value);
    }

    private static String getEntryOrNull(Map<String, List<String>> headers, String key) {
        List<String> entries = headers.get(key);
        if (entries == null || entries.size() < 1) {
            return null;
        }
        return entries.get(0);
    }

    public static Map<String, List<String>> readHeaders(I2PSocket socket, InputStream in, StringBuilder command, String[] skipHeaders, I2PAppContext ctx, long initialTimeout) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        StringBuilder buf = new StringBuilder(128);
        long expire = ctx.clock().now() + initialTimeout + 45000L;
        if (socket != null) {
            try {
                I2PTunnelHTTPServer.readLine(socket, command, initialTimeout);
            }
            catch (LineTooLongException ltle) {
                throw new RequestTooLongException("Request too long (Max allowed: 8192)");
            }
        } else {
            boolean ok = DataHelper.readLine(in, command);
            if (!ok) {
                throw new EOFException("EOF reached before the end of the headers");
            }
        }
        int totalSize = command.length();
        int i = 0;
        while (true) {
            if (++i > 60) {
                throw new LineTooLongException("Too many header lines (Max allowed: 60)");
            }
            buf.setLength(0);
            if (socket != null) {
                I2PTunnelHTTPServer.readLine(socket, buf, expire - ctx.clock().now());
            } else {
                boolean ok = DataHelper.readLine(in, buf);
                if (!ok) {
                    throw new BadRequestException("EOF reached before the end of the headers");
                }
            }
            if (buf.length() == 0 || buf.charAt(0) == '\n' || buf.charAt(0) == '\r') {
                return headers;
            }
            if (ctx.clock().now() > expire) {
                throw new SocketTimeoutException("Timeout (" + (initialTimeout + 45L) + "s) receiving headers");
            }
            int split = buf.indexOf(":");
            if (split <= 0) {
                throw new BadRequestException("Invalid HTTP header, missing colon: \"" + buf + "\" request: \"" + command + '\"');
            }
            if ((totalSize += buf.length()) > 32768) {
                throw new LineTooLongException("Request + headers too big");
            }
            String name = buf.substring(0, split).trim();
            String value = null;
            value = buf.length() > split + 1 ? buf.substring(split + 1).trim() : "";
            String lcName = name.toLowerCase(Locale.US);
            if ("accept-encoding".equals(lcName)) {
                name = "Accept-Encoding";
            } else if ("x-accept-encoding".equals(lcName)) {
                name = "X-Accept-Encoding";
            } else if ("x-forwarded-for".equals(lcName)) {
                name = X_FORWARDED_HEADER;
            } else if ("x-forwarded-server".equals(lcName)) {
                name = "X-Forwarded-Server";
            } else if ("x-forwarded-host".equals(lcName)) {
                name = "X-Forwarded-Host";
            } else if ("forwarded".equals(lcName)) {
                name = "Forwarded";
            } else if ("user-agent".equals(lcName)) {
                name = "User-Agent";
            } else if (REFERER_HEADER.equals(lcName)) {
                name = "Referer";
            } else if ("connection".equals(lcName)) {
                name = "Connection";
            } else if ("host".equals(lcName)) {
                name = "Host";
            } else if (lcName.contains("-encoding") && !lcName.contains("accept") && socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new BadRequestException("Invalid HTTP header: \"" + name + "\" -> Terminating connection...");
            }
            boolean skip = false;
            for (String skipHeader : skipHeaders) {
                if (!skipHeader.equals(lcName)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            I2PTunnelHTTPServer.addEntry(headers, name, value);
        }
    }

    private static void readLine(I2PSocket socket, StringBuilder buf, long timeout) throws IOException {
        int c;
        if (timeout <= 0L) {
            throw new SocketTimeoutException();
        }
        long expires = System.currentTimeMillis() + timeout;
        InputStream in = socket.getInputStream();
        int i = 0;
        socket.setReadTimeout(timeout);
        while ((c = in.read()) != -1) {
            if (++i > 8192) {
                throw new LineTooLongException("Line too long (Maximum characters permitted: 8192)");
            }
            if (c == 10) break;
            long newTimeout = expires - System.currentTimeMillis();
            if (newTimeout <= 0L) {
                throw new SocketTimeoutException();
            }
            buf.append((char)c);
            if (newTimeout == timeout) continue;
            timeout = newTimeout;
            socket.setReadTimeout(timeout);
        }
        if (c == -1) {
            if (System.currentTimeMillis() >= expires) {
                throw new SocketTimeoutException();
            }
            throw new EOFException();
        }
    }

    private void processBlocklist(I2PSocket socket, StringBuilder command) throws BadRequestException, IOException {
        block7: {
            String lcCommand;
            Matcher matcher;
            if (!this.blocklistFile.exists()) {
                this.regexPattern = null;
                return;
            }
            long currentLastModified = this.blocklistFile.lastModified();
            if (currentLastModified != this.blocklistLastModified || this.regexPattern == null) {
                this.regexPattern = this.compileRegexPattern(this.blocklistFile);
                this.blocklistLastModified = currentLastModified;
            }
            if ((matcher = this.regexPattern.matcher(lcCommand = command.toString().toLowerCase(Locale.US))).find()) {
                String matchedString = matcher.group();
                String peerB32 = socket.getPeerDestination().toBase32();
                this.logBlockedDestination(peerB32);
                if (socket == null) break block7;
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    this._log.error("[HTTPServer] Error closing socket (" + ioe.getMessage() + ")");
                }
                throw new BadRequestException(command.toString() + "-> Matches blocklist entry \"" + matchedString + "\"");
            }
        }
    }

    private Pattern compileRegexPattern(File blocklistFile) throws IOException {
        StringBuilder regexBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(blocklistFile)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String url = line;
                StringBuilder regex = new StringBuilder();
                regex.append("(?i)");
                regex.append(Pattern.quote(url));
                if (regexBuilder.length() > 0) {
                    regexBuilder.append("|");
                }
                regexBuilder.append((CharSequence)regex);
            }
        }
        return Pattern.compile(regexBuilder.toString());
    }

    private synchronized void logBlockedDestination(String destination) throws IOException {
        Throwable throwable;
        if (!this.blocklistClients.exists()) {
            try {
                this.blocklistClients.createNewFile();
                blocklistClientsLastModified = this.blocklistClients.lastModified();
            }
            catch (IOException e) {
                this._log.error("[HTTPServer] Error creating file for blocked destination (" + e.getMessage() + ")");
                return;
            }
        }
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.blocklistClients));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || this.clientBlockList.contains(line)) continue;
                    this.clientBlockList.add(line);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ioe) {
            this._log.error("[HTTPServer] Error logging blocked destination (" + ioe.getMessage() + ")");
        }
        if (!this.clientBlockList.contains(destination)) {
            if (this.clientBlockList.size() >= this.HTTP_BLOCKLIST_CLIENT_LIMIT) {
                this.clientBlockList.remove(0);
            }
            try {
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.blocklistClients, true));){
                    writer.write(destination);
                    writer.newLine();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException ioe) {
                this._log.error("[HTTPServer] Error logging blocked destination (" + ioe.getMessage() + ")");
            }
            blocklistClientsLastModified = this.blocklistClients.lastModified();
        }
    }

    private synchronized boolean existsInClientBlocklist(String destination) throws IOException {
        long currentLastModified = this.blocklistClients.lastModified();
        if (currentLastModified != blocklistClientsLastModified) {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.blocklistClients));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.clientBlockList.add(line);
                }
            }
            catch (IOException ioe) {
                this._log.error("[HTTPServer] Error reading client blocklist file (" + ioe.getMessage() + ")");
                throw ioe;
            }
            blocklistClientsLastModified = currentLastModified;
        }
        return this.clientBlockList.contains(destination);
    }

    static {
        cachedClientBlockListSize = -1;
    }

    private static class BadRequestException
    extends IOException {
        public BadRequestException(String s) {
            super(s);
        }
    }

    private static class RequestTooLongException
    extends IOException {
        public RequestTooLongException(String s) {
            super(s);
        }
    }

    private static class LineTooLongException
    extends IOException {
        public LineTooLongException(String s) {
            super(s);
        }
    }

    private static class InternalGZIPOutputStream
    extends GZIPOutputStream {
        public InternalGZIPOutputStream(OutputStream target) throws IOException {
            super(target);
        }

        public long getTotalRead() {
            try {
                return this.def.getTotalIn();
            }
            catch (RuntimeException e) {
                return 0L;
            }
        }

        public long getTotalCompressed() {
            try {
                return this.def.getTotalOut();
            }
            catch (RuntimeException e) {
                return 0L;
            }
        }
    }

    private static class CompressedResponseOutputStream
    extends HTTPResponseOutputStream {
        private InternalGZIPOutputStream _gzipOut;

        public CompressedResponseOutputStream(OutputStream o, boolean keepalive) {
            super(o, false, keepalive, false, null);
        }

        public void finish() throws IOException {
            if (this.getKeepAliveOut()) {
                if (this._gzipOut != null) {
                    this._gzipOut.finish();
                } else {
                    this.flush();
                }
            } else {
                this.close();
            }
        }

        @Override
        protected boolean shouldCompress() {
            return (this._dataExpected < 0L || this._dataExpected >= 1024L) && this._contentEncoding == null && (this._contentType == null || !this._contentType.startsWith("audio/") && !this._contentType.equals("image/gif") && !this._contentType.equals("image/jpeg") && !this._contentType.equals("image/jpg") && !this._contentType.equals("image/png") && !this._contentType.equals("image/tiff") && !this._contentType.equals("image/webp") && !this._contentType.equals("font/woff2") && !this._contentType.startsWith("video/") && !this._contentType.equals("application/compress") && !this._contentType.equals("application/bzip2") && !this._contentType.equals("application/gzip") && !this._contentType.equals("application/x-bzip") && !this._contentType.equals("application/x-bzip2") && !this._contentType.equals("application/x-gzip") && !this._contentType.equals("application/zip"));
        }

        @Override
        protected void finishHeaders() throws IOException {
            if (this.shouldCompress()) {
                this.out.write(DataHelper.getASCII("Content-Encoding: x-i2p-gzip\r\n"));
            }
            super.finishHeaders();
        }

        @Override
        protected void beginProcessing() throws IOException {
            if (this.shouldCompress()) {
                this._gzipOut = new InternalGZIPOutputStream(this.out);
                this.out = this._gzipOut;
            }
        }

        public long getTotalRead() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalRead();
            }
            return 0L;
        }

        public long getTotalCompressed() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalCompressed();
            }
            return 0L;
        }
    }

    private static class Sender
    implements Runnable {
        private final OutputStream _out;
        private final InputStream _in;
        private final String _name;
        private final Log _log;
        private IOException _failure;

        public Sender(OutputStream out, InputStream in, String name, Log log) {
            this._out = out;
            this._in = in;
            this._name = name;
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._log.shouldDebug()) {
                this._log.debug("[HTTPServer] Begin sending " + this._name);
            }
            try {
                DataHelper.copy(this._in, this._out);
                if (this._log.shouldDebug()) {
                    this._log.debug("[HTTPServer] Done sending " + this._name);
                }
            }
            catch (IOException ioe) {
                if (ioe.getMessage() != null) {
                    if (ioe.getMessage().indexOf("Input stream closed") >= 0 || ioe.getMessage().indexOf("Input stream error") >= 0 || ioe.getMessage().indexOf("Socket closed") >= 0) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("[HTTPServer] Error sending " + this._name + " -> " + ioe.getMessage());
                        }
                    } else if (this._log.shouldWarn()) {
                        this._log.warn("[HTTPServer] Error sending " + this._name + " -> " + ioe.getMessage());
                    }
                }
                Sender sender = this;
                synchronized (sender) {
                    this._failure = ioe;
                }
            }
        }

        public synchronized IOException getFailure() {
            return this._failure;
        }
    }

    private static class CompressedRequestor
    implements Runnable {
        private final Socket _webserver;
        private final I2PSocket _browser;
        private final String _headers;
        private final I2PAppContext _ctx;
        private final Log _log;
        private final boolean _shouldCompress;
        private final boolean _upgrade;
        private final ThreadPoolExecutor _tpe;
        private boolean _keepalive;
        private final AtomicInteger _waiter;
        private static final int BUF_SIZE = 16384;

        public CompressedRequestor(Socket webserver, I2PSocket browser, String headers, I2PAppContext ctx, Log log, boolean shouldCompress, boolean upgrade, ThreadPoolExecutor tpe, boolean keepalive, AtomicInteger waiter) {
            this._webserver = webserver;
            this._browser = browser;
            this._headers = headers;
            this._ctx = ctx;
            this._log = log;
            this._shouldCompress = shouldCompress;
            this._upgrade = upgrade;
            this._tpe = tpe;
            this._keepalive = keepalive;
            this._waiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block326: {
                String req;
                IOException ioex;
                Sender sender;
                Sender s;
                InputStream serverin;
                InputStream browserin;
                CompressedResponseOutputStream compressedout;
                OutputStream browserout;
                OutputStream serverout;
                block323: {
                    String[] requestLines;
                    serverout = null;
                    browserout = null;
                    compressedout = null;
                    browserin = null;
                    serverin = null;
                    s = null;
                    sender = null;
                    ioex = null;
                    String host = null;
                    String url = null;
                    req = null;
                    serverout = this._webserver.getOutputStream();
                    serverout.write(DataHelper.getUTF8(this._headers));
                    browserin = this._browser.getInputStream();
                    if (this._headers != null && !this._headers.isEmpty() && (requestLines = this._headers.split("\r\n")).length > 0) {
                        String requestLine = requestLines[0];
                        String[] requestParts = requestLine.split(" ");
                        String string = url = requestParts.length > 1 ? requestParts[1] : null;
                        if (url != null) {
                            String[] urlParts;
                            if (url.startsWith("http://")) {
                                url = url.replace("http://", "");
                            }
                            if (url.length() > 100) {
                                url = url.substring(0, 48) + "..." + url.substring(url.length() - 48);
                            }
                            if ((urlParts = url.split("/")).length > 0) {
                                host = urlParts[0];
                                for (int i = 1; i < urlParts.length; ++i) {
                                    if (urlParts[i].trim().isEmpty()) continue;
                                    host = host + "/" + urlParts[i];
                                }
                            }
                        }
                    }
                    if (host != null && host.contains("b32.i2p")) {
                        host = host.substring(0, 12) + "...b32.i2p";
                    }
                    req = host != null ? host : "Unknown request";
                    boolean isHead = this._headers.startsWith("HEAD ");
                    boolean isGet = this._headers.startsWith("GET ");
                    boolean isPost = this._headers.startsWith("POST ");
                    if (!isGet && !isHead || this._upgrade || browserin.available() > 0) {
                        this._browser.setReadTimeout(isPost ? 300000L : 14400000L);
                        this._keepalive = false;
                        sender = new Sender(serverout, browserin, "from Client -> Server", this._log);
                        this._tpe.execute(sender);
                    }
                    int timeout = isGet || isHead ? 90000 : 14400000;
                    this._webserver.setSoTimeout(timeout);
                    browserout = this._browser.getOutputStream();
                    try {
                        serverin = new BufferedInputStream(this._webserver.getInputStream(), 16384);
                    }
                    catch (NullPointerException npe) {
                        throw new IOException("getInputStream NPE");
                    }
                    StringBuilder command = new StringBuilder(512);
                    Map<String, List<String>> headers = I2PTunnelHTTPServer.readHeaders(null, serverin, command, SERVER_SKIPHEADERS, this._ctx, timeout);
                    List<String> cacheControlList = headers.get("Cache-Control");
                    if (cacheControlList != null && (cacheControlList.contains("none".toLowerCase()) || cacheControlList.contains("post-check".toLowerCase()))) {
                        headers.remove("Cache-Control");
                    }
                    String[] cookieStrings = new String[]{"STYXKEY", "visited=yes"};
                    List<String> setCookieList = headers.get("Set-Cookie");
                    if (setCookieList != null) {
                        ArrayList<String> newSetCookieList = new ArrayList<String>();
                        for (String setCookie : setCookieList) {
                            boolean containsString = false;
                            for (String cookieString : cookieStrings) {
                                if (!setCookie.contains(cookieString)) continue;
                                containsString = true;
                                break;
                            }
                            if (containsString) continue;
                            newSetCookieList.add(setCookie);
                        }
                        if (newSetCookieList.isEmpty()) {
                            headers.remove("Set-Cookie");
                        } else {
                            headers.put("Set-Cookie", newSetCookieList);
                        }
                    }
                    String[] customWhitelist = new String[]{"text/html", "application/xhtml+xml", "application/xml", "text/plain", "application/json"};
                    String[] immutableCacheWhitelist = new String[]{"application/pdf", "audio", "audio/midi", "audio/mpeg", "audio/ogg", "audio/wav", "audio/webm", "font", "font/woff", "font/woff2", "image", "image/apng", "image/bmp", "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "image/webp", "image/x-icon", "text/css", "video", "video/mp4", "video/ogg", "video/webm"};
                    List<String> contentTypeList = headers.get("Content-Type");
                    String mimeType = "application/octet-stream";
                    int index = url.indexOf("?");
                    if (index != -1) {
                        url = url.substring(0, index);
                    }
                    url = url.toLowerCase();
                    if (contentTypeList != null && !contentTypeList.isEmpty()) {
                        mimeType = headers.get("Content-Type").get(0);
                    } else if (url.endsWith(".3g2")) {
                        mimeType = "video/3gpp2";
                    } else if (url.endsWith(".3gp")) {
                        mimeType = "video/3gpp";
                    } else if (url.endsWith(".aac")) {
                        mimeType = "audio/aac";
                    } else if (url.endsWith(".abw")) {
                        mimeType = "application/x-abiword";
                    } else if (url.endsWith(".arc")) {
                        mimeType = "application/x-freearc";
                    } else if (url.endsWith(".avif")) {
                        mimeType = "image/avif";
                    } else if (url.endsWith(".avi")) {
                        mimeType = "video/x-msvideo";
                    } else if (url.endsWith(".azw")) {
                        mimeType = "application/vnd.amazon.ebook";
                    } else if (url.endsWith(".bin")) {
                        mimeType = "application/octet-stream";
                    } else if (url.endsWith(".bmp")) {
                        mimeType = "image/bmp";
                    } else if (url.endsWith(".bz")) {
                        mimeType = "application/x-bzip";
                    } else if (url.endsWith(".bz2")) {
                        mimeType = "application/x-bzip2";
                    } else if (url.endsWith(".cda")) {
                        mimeType = "application/x-cdf";
                    } else if (url.endsWith(".css")) {
                        mimeType = "text/css";
                    } else if (url.endsWith(".csv")) {
                        mimeType = "text/csv";
                    } else if (url.endsWith(".doc")) {
                        mimeType = "application/msword";
                    } else if (url.endsWith(".docx")) {
                        mimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                    } else if (url.endsWith(".eot")) {
                        mimeType = "application/vnd.ms-fontobject";
                    } else if (url.endsWith(".epub")) {
                        mimeType = "application/epub+zip";
                    } else if (url.endsWith(".gif")) {
                        mimeType = "image/gif";
                    } else if (url.endsWith(".gz")) {
                        mimeType = "application/gzip";
                    } else if (url.endsWith(".htm") || url.endsWith(".html")) {
                        mimeType = "text/html";
                    } else if (url.endsWith(".ico")) {
                        mimeType = "image/vnd.microsoft.icon";
                    } else if (url.endsWith(".ics")) {
                        mimeType = "text/calendar";
                    } else if (url.endsWith(".jar")) {
                        mimeType = "application/java-archive";
                    } else if (url.endsWith(".jpeg") || url.endsWith(".jpg")) {
                        mimeType = "image/jpeg";
                    } else if (url.endsWith(".json")) {
                        mimeType = "application/json";
                    } else if (url.endsWith(".jsonld")) {
                        mimeType = "application/ld+json";
                    } else if (url.endsWith(".js")) {
                        mimeType = "text/javascript";
                    } else if (url.endsWith(".mid") || url.endsWith(".midi")) {
                        mimeType = "audio/midi";
                    } else if (url.endsWith(".mjs")) {
                        mimeType = "text/javascript";
                    } else if (url.endsWith(".mp3")) {
                        mimeType = "audio/mpeg";
                    } else if (url.endsWith(".mp4")) {
                        mimeType = "video/mp4";
                    } else if (url.endsWith(".mpeg")) {
                        mimeType = "video/mpeg";
                    } else if (url.endsWith(".mpkg")) {
                        mimeType = "application/vnd.apple.installer+xml";
                    } else if (url.endsWith(".ods")) {
                        mimeType = "application/vnd.oasis.opendocument.spreadsheet";
                    } else if (url.endsWith(".odt")) {
                        mimeType = "application/vnd.oasis.opendocument.text";
                    } else if (url.endsWith(".odp")) {
                        mimeType = "application/vnd.oasis.opendocument.presentation";
                    } else if (url.endsWith(".oga")) {
                        mimeType = "audio/ogg";
                    } else if (url.endsWith(".ogv")) {
                        mimeType = "video/ogg";
                    } else if (url.endsWith(".ogx")) {
                        mimeType = "application/ogg";
                    } else if (url.endsWith(".opus")) {
                        mimeType = "audio/opus";
                    } else if (url.endsWith(".otf")) {
                        mimeType = "font/otf";
                    } else if (url.endsWith(".pdf")) {
                        mimeType = "application/pdf";
                    } else if (url.endsWith(".php")) {
                        mimeType = "application/x-httpd-php";
                    } else if (url.endsWith(".png")) {
                        mimeType = "image/png";
                    } else if (url.endsWith(".ppt")) {
                        mimeType = "application/vnd.ms-powerpoint";
                    } else if (url.endsWith(".pptx")) {
                        mimeType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
                    } else if (url.endsWith(".rar")) {
                        mimeType = "application/x-rar-compressed";
                    } else if (url.endsWith(".rtf")) {
                        mimeType = "application/rtf";
                    } else if (url.endsWith(".sh")) {
                        mimeType = "application/x-sh";
                    } else if (url.endsWith(".svg")) {
                        mimeType = "image/svg+xml";
                    } else if (url.endsWith(".tar")) {
                        mimeType = "application/x-tar";
                    } else if (url.endsWith(".tif") || url.endsWith(".tiff")) {
                        mimeType = "image/tiff";
                    } else if (url.endsWith(".ts")) {
                        mimeType = "video/mp2t";
                    } else if (url.endsWith(".txt")) {
                        mimeType = "text/plain";
                    } else if (url.endsWith(".tif") || url.endsWith(".tiff")) {
                        mimeType = "image/tiff";
                    } else if (url.endsWith(".ttf")) {
                        mimeType = "font/ttf";
                    } else if (url.endsWith(".vsd")) {
                        mimeType = "application/vnd.visio";
                    } else if (url.endsWith(".wav")) {
                        mimeType = "audio/wav";
                    } else if (url.endsWith(".weba")) {
                        mimeType = "audio/webm";
                    } else if (url.endsWith(".webm")) {
                        mimeType = "video/webm";
                    } else if (url.endsWith(".woff")) {
                        mimeType = "font/woff";
                    } else if (url.endsWith(".woff2")) {
                        mimeType = "font/woff2";
                    } else if (url.endsWith(".xhtml")) {
                        mimeType = "application/xhtml+xml";
                    } else if (url.endsWith(".xls")) {
                        mimeType = "application/vnd.ms-excel";
                    } else if (url.endsWith(".xlsx")) {
                        mimeType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                    } else if (url.endsWith(".xml")) {
                        mimeType = "application/xml";
                    } else if (url.endsWith(".xul")) {
                        mimeType = "application/vnd.mozilla.xul+xml";
                    } else if (url.endsWith(".zip")) {
                        mimeType = "application/zip";
                    }
                    boolean securityHeaders = Arrays.asList(customWhitelist).contains(mimeType);
                    if (this._headers != null && securityHeaders) {
                        boolean allow;
                        boolean rp = headers.keySet().stream().anyMatch(key -> key.equalsIgnoreCase("Referrer-Policy"));
                        if (!rp) {
                            I2PTunnelHTTPServer.setEntry(headers, "Referrer-Policy", "same-origin");
                        }
                        if (!(allow = headers.keySet().stream().anyMatch(key -> key.equalsIgnoreCase("Allow")))) {
                            I2PTunnelHTTPServer.setEntry(headers, "Allow", "GET, POST, HEAD");
                        }
                    }
                    boolean immutableCache = Arrays.stream(immutableCacheWhitelist).anyMatch(mimeType::matches);
                    if (this._headers != null) {
                        boolean cc = headers.keySet().stream().anyMatch(key -> key.equalsIgnoreCase("Cache-Control"));
                        if (cacheControlList != null) {
                            boolean hasNoCache;
                            boolean bl = hasNoCache = cc && headers.get("Cache-Control").contains("no-cache".toLowerCase());
                            if (hasNoCache && immutableCache) {
                                headers.remove("Cache-Control");
                                I2PTunnelHTTPServer.setEntry(headers, "Cache-Control", "private, max-age=31536000, immutable");
                            } else if (immutableCache && !cc) {
                                I2PTunnelHTTPServer.setEntry(headers, "Cache-Control", "private, max-age=31536000, immutable");
                            } else if (!cc) {
                                I2PTunnelHTTPServer.setEntry(headers, "Cache-Control", "private, no-cache, max-age=604800");
                            }
                        }
                    }
                    boolean xss = headers.keySet().stream().anyMatch(key -> key.equalsIgnoreCase("X-XSS-Protection"));
                    if (this._headers != null && !xss) {
                        I2PTunnelHTTPServer.setEntry(headers, "X-XSS-Protection", "1; mode=block");
                    }
                    boolean nosniff = headers.keySet().stream().anyMatch(key -> key.equalsIgnoreCase("X-Content-Type-Options"));
                    if (this._headers != null && !nosniff) {
                        I2PTunnelHTTPServer.setEntry(headers, "X-Content-Type-Options", "nosniff");
                    }
                    String modifiedHeaders = I2PTunnelHTTPServer.formatHeaders(headers, command);
                    this._webserver.setSoTimeout(90000);
                    if (this._shouldCompress) {
                        compressedout = new CompressedResponseOutputStream(browserout, this._keepalive);
                        compressedout.write(DataHelper.getUTF8(modifiedHeaders));
                        s = new Sender(compressedout, serverin, "Server -> Client (Gzip) " + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""), this._log);
                        browserout = compressedout;
                    } else {
                        browserout.write(DataHelper.getUTF8(modifiedHeaders));
                        s = new Sender(browserout, serverin, "Server -> Client " + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""), this._log);
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("[HTTPServer] Running server-to-browser Compressed? " + this._shouldCompress + " KeepAlive? " + this._keepalive + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                    }
                    s.run();
                    if (ioex == null && s != null && (ioex = s.getFailure()) == null && sender != null) {
                        ioex = sender.getFailure();
                    }
                    if (ioex == null) break block323;
                    this._keepalive = false;
                    boolean i2pReset = false;
                    if (ioex instanceof I2PSocketException) {
                        I2PSocketException ise = (I2PSocketException)ioex;
                        int status = ise.getStatus();
                        boolean bl = i2pReset = status == 512;
                        if (i2pReset) {
                            if (this._log.shouldDebug()) {
                                this._log.warn("[HTTPServer] Received I2P RESET -> Resetting socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                            }
                            try {
                                this._webserver.setSoLinger(true, 0);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!i2pReset && ioex instanceof SocketException) {
                        boolean sockReset;
                        String msg = ioex.getMessage();
                        boolean bl = sockReset = msg != null && msg.contains("reset");
                        if (sockReset) {
                            if (this._log.shouldDebug()) {
                                this._log.warn("[HTTPServer] Received socket RESET ->  Resetting I2P socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                            }
                            try {
                                this._browser.reset();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this._waiter != null) {
                    this._waiter.set(this._keepalive ? 2 : 1);
                }
                if (browserout != null) {
                    try {
                        if (this._keepalive) {
                            if (compressedout != null) {
                                compressedout.finish();
                            } else {
                                browserout.flush();
                            }
                        } else {
                            browserout.close();
                        }
                    }
                    catch (IOException i2pReset) {
                        // empty catch block
                    }
                }
                if (serverout != null) {
                    try {
                        serverout.close();
                    }
                    catch (IOException i2pReset) {
                        // empty catch block
                    }
                }
                if (!this._keepalive && browserin != null) {
                    try {
                        browserin.close();
                    }
                    catch (IOException i2pReset) {
                        // empty catch block
                    }
                }
                if (serverin != null) {
                    try {
                        serverin.close();
                    }
                    catch (IOException i2pReset) {
                        // empty catch block
                    }
                }
                try {
                    this._webserver.close();
                }
                catch (IOException i2pReset) {
                    // empty catch block
                }
                if (!this._keepalive) {
                    try {
                        this._browser.close();
                    }
                    catch (IOException i2pReset) {
                        // empty catch block
                    }
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Finished server-to-browser: Compressed? " + this._shouldCompress + " KeepAlive? " + this._keepalive + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                }
                break block326;
                catch (SSLException she) {
                    block324: {
                        if (this._log.shouldError()) {
                            this._log.error("[HTTPServer] SSL error", she);
                        }
                        try {
                            if (this._browser.getLocalPort() == 443) {
                                this._browser.reset();
                            } else {
                                if (browserout == null) {
                                    browserout = this._browser.getOutputStream();
                                }
                                browserout.write(I2PTunnelHTTPServer.ERR_UNAVAILABLE.getBytes("UTF-8"));
                            }
                        }
                        catch (IOException msg) {
                            // empty catch block
                        }
                        this._keepalive = false;
                        if (ioex == null && s != null && (ioex = s.getFailure()) == null && sender != null) {
                            ioex = sender.getFailure();
                        }
                        if (ioex == null) break block324;
                        this._keepalive = false;
                        boolean i2pReset = false;
                        if (ioex instanceof I2PSocketException) {
                            I2PSocketException ise = (I2PSocketException)ioex;
                            int status = ise.getStatus();
                            boolean bl = i2pReset = status == 512;
                            if (i2pReset) {
                                if (this._log.shouldDebug()) {
                                    this._log.warn("[HTTPServer] Received I2P RESET -> Resetting socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                }
                                try {
                                    this._webserver.setSoLinger(true, 0);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!i2pReset && ioex instanceof SocketException) {
                            boolean sockReset;
                            String msg = ioex.getMessage();
                            boolean bl = sockReset = msg != null && msg.contains("reset");
                            if (sockReset) {
                                if (this._log.shouldDebug()) {
                                    this._log.warn("[HTTPServer] Received socket RESET ->  Resetting I2P socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                }
                                try {
                                    this._browser.reset();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (this._waiter != null) {
                        this._waiter.set(this._keepalive ? 2 : 1);
                    }
                    if (browserout != null) {
                        try {
                            if (this._keepalive) {
                                if (compressedout != null) {
                                    compressedout.finish();
                                } else {
                                    browserout.flush();
                                }
                            } else {
                                browserout.close();
                            }
                        }
                        catch (IOException i2pReset) {
                            // empty catch block
                        }
                    }
                    if (serverout != null) {
                        try {
                            serverout.close();
                        }
                        catch (IOException i2pReset) {
                            // empty catch block
                        }
                    }
                    if (!this._keepalive && browserin != null) {
                        try {
                            browserin.close();
                        }
                        catch (IOException i2pReset) {
                            // empty catch block
                        }
                    }
                    if (serverin != null) {
                        try {
                            serverin.close();
                        }
                        catch (IOException i2pReset) {
                            // empty catch block
                        }
                    }
                    try {
                        this._webserver.close();
                    }
                    catch (IOException i2pReset) {
                        // empty catch block
                    }
                    if (!this._keepalive) {
                        try {
                            this._browser.close();
                        }
                        catch (IOException i2pReset) {
                            // empty catch block
                        }
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Finished server-to-browser: Compressed? " + this._shouldCompress + " KeepAlive? " + this._keepalive + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                    }
                }
                catch (IOException ioe) {
                    block325: {
                        if (this._log.shouldWarn()) {
                            this._log.warn("[HTTPServer] Error compressing -> " + ioe.getMessage() + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                        }
                        ioex = ioe;
                        this._keepalive = false;
                        if (ioex == null && s != null && (ioex = s.getFailure()) == null && sender != null) {
                            ioex = sender.getFailure();
                        }
                        if (ioex == null) break block325;
                        this._keepalive = false;
                        boolean i2pReset = false;
                        {
                            catch (Throwable throwable) {
                                if (ioex == null && s != null && (ioex = s.getFailure()) == null && sender != null) {
                                    ioex = sender.getFailure();
                                }
                                if (ioex != null) {
                                    this._keepalive = false;
                                    boolean i2pReset2 = false;
                                    if (ioex instanceof I2PSocketException) {
                                        I2PSocketException ise = (I2PSocketException)ioex;
                                        int status = ise.getStatus();
                                        boolean bl = i2pReset2 = status == 512;
                                        if (i2pReset2) {
                                            if (this._log.shouldDebug()) {
                                                this._log.warn("[HTTPServer] Received I2P RESET -> Resetting socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                            }
                                            try {
                                                this._webserver.setSoLinger(true, 0);
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (!i2pReset2 && ioex instanceof SocketException) {
                                        boolean sockReset;
                                        String msg = ioex.getMessage();
                                        boolean bl = sockReset = msg != null && msg.contains("reset");
                                        if (sockReset) {
                                            if (this._log.shouldDebug()) {
                                                this._log.warn("[HTTPServer] Received socket RESET ->  Resetting I2P socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                            }
                                            try {
                                                this._browser.reset();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                                if (this._waiter != null) {
                                    this._waiter.set(this._keepalive ? 2 : 1);
                                }
                                if (browserout != null) {
                                    try {
                                        if (this._keepalive) {
                                            if (compressedout != null) {
                                                compressedout.finish();
                                            } else {
                                                browserout.flush();
                                            }
                                        } else {
                                            browserout.close();
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (serverout != null) {
                                    try {
                                        serverout.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (!this._keepalive && browserin != null) {
                                    try {
                                        browserin.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (serverin != null) {
                                    try {
                                        serverin.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    this._webserver.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                if (!this._keepalive) {
                                    try {
                                        this._browser.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (this._log.shouldDebug()) {
                                    this._log.debug("Finished server-to-browser: Compressed? " + this._shouldCompress + " KeepAlive? " + this._keepalive + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                }
                                throw throwable;
                            }
                        }
                        if (ioex instanceof I2PSocketException) {
                            I2PSocketException ise = (I2PSocketException)ioex;
                            int status = ise.getStatus();
                            boolean bl = i2pReset = status == 512;
                            if (i2pReset) {
                                if (this._log.shouldDebug()) {
                                    this._log.warn("[HTTPServer] Received I2P RESET -> Resetting socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                }
                                try {
                                    this._webserver.setSoLinger(true, 0);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!i2pReset && ioex instanceof SocketException) {
                            boolean sockReset;
                            String msg = ioex.getMessage();
                            boolean bl = sockReset = msg != null && msg.contains("reset");
                            if (sockReset) {
                                if (this._log.shouldDebug()) {
                                    this._log.warn("[HTTPServer] Received socket RESET ->  Resetting I2P socket..." + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                                }
                                try {
                                    this._browser.reset();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (this._waiter != null) {
                        this._waiter.set(this._keepalive ? 2 : 1);
                    }
                    if (browserout != null) {
                        try {
                            if (this._keepalive) {
                                if (compressedout != null) {
                                    compressedout.finish();
                                } else {
                                    browserout.flush();
                                }
                            } else {
                                browserout.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (serverout != null) {
                        try {
                            serverout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!this._keepalive && browserin != null) {
                        try {
                            browserin.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (serverin != null) {
                        try {
                            serverin.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        this._webserver.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!this._keepalive) {
                        try {
                            this._browser.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Finished server-to-browser: Compressed? " + this._shouldCompress + " KeepAlive? " + this._keepalive + (req != null && !req.equals("") && !req.equals("Unknown request") ? "\n* URL: " + req : ""));
                    }
                }
            }
        }
    }
}

