/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.access.ExplicitFilterDefinitionElement;
import net.i2p.i2ptunnel.access.FileFilterDefinitionElement;
import net.i2p.i2ptunnel.access.FilterDefinition;
import net.i2p.i2ptunnel.access.FilterDefinitionElement;
import net.i2p.i2ptunnel.access.InvalidDefinitionException;
import net.i2p.i2ptunnel.access.Recorder;
import net.i2p.i2ptunnel.access.Threshold;

class DefinitionParser {
    DefinitionParser() {
    }

    static FilterDefinition parse(String[] definition) throws InvalidDefinitionException {
        DefinitionBuilder builder = new DefinitionBuilder();
        block6: for (String line : definition) {
            String[] split = DataHelper.split(line, "[ \t]");
            split[0] = split[0].toLowerCase();
            Threshold threshold = DefinitionParser.parseThreshold(split[0]);
            Rule rule = DefinitionParser.parseRule(split[1]);
            switch (rule) {
                case DEFAULT: {
                    builder.setDefaultThreshold(threshold);
                    continue block6;
                }
                case EXPLICIT: {
                    builder.addElement(new ExplicitFilterDefinitionElement(split[2], threshold));
                    continue block6;
                }
                case FILE: {
                    File file = DefinitionParser.parseFileName(line, split);
                    builder.addElement(new FileFilterDefinitionElement(file, threshold));
                    continue block6;
                }
                case RECORDER: {
                    File file = DefinitionParser.parseFileName(line, split);
                    builder.addRecorder(new Recorder(file, threshold));
                }
            }
        }
        return builder.build();
    }

    private static Threshold parseThreshold(String s) throws InvalidDefinitionException {
        if ("allow".equals(s)) {
            return Threshold.ALLOW;
        }
        if ("deny".equals(s)) {
            return Threshold.DENY;
        }
        String[] split = DataHelper.split(s, "/");
        if (split.length != 2) {
            throw new InvalidDefinitionException("Invalid threshold " + s);
        }
        try {
            int connections = Integer.parseInt(split[0]);
            int seconds = Integer.parseInt(split[1]);
            if (connections < 0) {
                throw new InvalidDefinitionException("Number of connections cannot be negative " + s);
            }
            if (seconds < 1) {
                throw new InvalidDefinitionException("Number of seconds must be at least 1 " + s);
            }
            return new Threshold(connections, seconds);
        }
        catch (NumberFormatException bad) {
            throw new InvalidDefinitionException("Invalid threshold", bad);
        }
    }

    private static Rule parseRule(String s) throws InvalidDefinitionException {
        if ("default".equals(s)) {
            return Rule.DEFAULT;
        }
        if ("explicit".equals(s)) {
            return Rule.EXPLICIT;
        }
        if ("file".equals(s)) {
            return Rule.FILE;
        }
        if ("record".equals(s)) {
            return Rule.RECORDER;
        }
        throw new InvalidDefinitionException("Unknown rule " + s);
    }

    private static File parseFileName(String s, String[] split) throws InvalidDefinitionException {
        if (split.length < 3) {
            throw new InvalidDefinitionException("invalid definition " + s);
        }
        int beginIndex = s.indexOf(split[1]);
        if (beginIndex < 0) {
            throw new IllegalStateException("shouldn't have gotten here " + s);
        }
        return new File(s.substring(beginIndex + split[1].length()).trim());
    }

    private static class DefinitionBuilder {
        private Threshold threshold;
        private List<FilterDefinitionElement> elements = new ArrayList<FilterDefinitionElement>();
        private List<Recorder> recorders = new ArrayList<Recorder>();

        private DefinitionBuilder() {
        }

        void setDefaultThreshold(Threshold threshold) throws InvalidDefinitionException {
            if (this.threshold != null) {
                throw new InvalidDefinitionException("default already set!");
            }
            this.threshold = threshold;
        }

        void addElement(FilterDefinitionElement element) {
            this.elements.add(element);
        }

        void addRecorder(Recorder recorder) {
            this.recorders.add(recorder);
        }

        FilterDefinition build() {
            if (this.threshold == null) {
                this.threshold = Threshold.ALLOW;
            }
            FilterDefinitionElement[] elArray = new FilterDefinitionElement[this.elements.size()];
            elArray = this.elements.toArray(elArray);
            Recorder[] rArray = new Recorder[this.recorders.size()];
            rArray = this.recorders.toArray(rArray);
            return new FilterDefinition(this.threshold, elArray, rArray);
        }
    }

    private static enum Rule {
        DEFAULT,
        EXPLICIT,
        FILE,
        RECORDER;

    }
}

