/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.irc;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;

public class I2PTunnelDCCClient
extends I2PTunnelClientBase {
    private final String _dest;
    private final int _remotePort;
    private long _expires;
    private static final long INBOUND_EXPIRE = 1800000L;
    private static final long INBOUND_STOP_EXPIRE = 1800000L;
    public static final String CONNECT_START_EVENT = "connectionStarted";
    public static final String CONNECT_STOP_EVENT = "connectionStopped";

    public I2PTunnelDCCClient(String dest, int localPort, int remotePort, Logging l, I2PSocketManager sktMgr, EventDispatcher notifyThis, I2PTunnel tunnel, long clientId) throws IllegalArgumentException {
        super(localPort, l, sktMgr, tunnel, notifyThis, clientId);
        this._dest = dest;
        this._remotePort = remotePort;
        this._expires = tunnel.getContext().clock().now() + 1800000L;
        this.setName("DCC send -> " + dest + ':' + remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        Destination dest;
        I2PSocket i2ps = null;
        if (this._log.shouldInfo()) {
            this._log.info("Opening DCC connection to " + this._dest + ':' + this._remotePort);
        }
        if ((dest = this._context.namingService().lookup(this._dest)) == null) {
            this._log.error("Could not find leaseset for DCC connection to " + this._dest + ':' + this._remotePort);
            I2PTunnelDCCClient.closeSocket(s);
            this.stop();
            this.notifyEvent(CONNECT_STOP_EVENT, this.getLocalPort());
            return;
        }
        I2PSocketOptions opts = this.sockMgr.buildOptions();
        opts.setPort(this._remotePort);
        try {
            i2ps = this.createI2PSocket(dest, opts);
            Runner t = new Runner(s, i2ps);
            ((Thread)t).run();
        }
        catch (IOException ex) {
            this._log.error("Could not make DCC connection to " + this._dest + ':' + this._remotePort, ex);
            this.notifyEvent(CONNECT_STOP_EVENT, this.getLocalPort());
        }
        catch (I2PException ex) {
            this._log.error("Could not make DCC connection to " + this._dest + ':' + this._remotePort, ex);
            this.notifyEvent(CONNECT_STOP_EVENT, this.getLocalPort());
        }
        finally {
            I2PTunnelDCCClient.closeSocket(s);
            if (i2ps != null) {
                try {
                    i2ps.close();
                }
                catch (IOException ex) {}
            }
        }
        this.stop();
    }

    public long getExpires() {
        return this._expires;
    }

    public String getDest() {
        return this._dest;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public void stop() {
        this.open = false;
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Runner
    extends I2PTunnelRunner {
        public Runner(Socket s, I2PSocket i2ps) {
            super(s, i2ps, I2PTunnelDCCClient.this.sockLock, null, null, (List<I2PSocket>)I2PTunnelDCCClient.this.mySockets, (I2PTunnelRunner.FailCallback)null);
        }

        @Override
        public void run() {
            I2PTunnelDCCClient.this._expires = I2PTunnelDCCClient.this.getTunnel().getContext().clock().now() + 1800000L;
            I2PTunnelDCCClient.this.notifyEvent(I2PTunnelDCCClient.CONNECT_START_EVENT, I2PTunnelDCCClient.this);
            super.run();
            I2PTunnelDCCClient.this._expires = I2PTunnelDCCClient.this.getTunnel().getContext().clock().now() + 1800000L;
            I2PTunnelDCCClient.this.notifyEvent(I2PTunnelDCCClient.CONNECT_STOP_EVENT, I2PTunnelDCCClient.this.getLocalPort());
        }
    }
}

