/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.localServer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.naming.NamingService;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.BlindData;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.util.FileUtil;
import net.i2p.util.PortMapper;
import net.i2p.util.Translate;

public abstract class LocalHTTPServer {
    private static final String ERR_404 = "HTTP/1.1 404 Not Found\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nHTTP Proxy local file not found";
    private static final String ERR_ADD = "HTTP/1.1 409 Bad\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nAdd to addressbook failed - bad parameters";
    private static final String ERR_B32 = "HTTP/1.1 400 Bad\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nB32 update failed - bad parameters";
    private static final String OK = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nCache-Control: no-cache, private, max-age=86400\r\nConnection: close\r\n\r\nI2P HTTP proxy OK";
    private static final String NEWKEY = "HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nReferrer-Policy: no-referrer\r\nCache-Control: no-cache, private\r\nConnection: close\r\n\r\n";
    private static final String headerLinks = "<link href=\"http://proxy.i2p/themes/console/default/proxy.css\" rel=stylesheet>\n<link rel=icon href=\"http://proxy.i2p/themes/console/default/images/favicon.svg\">\n";
    private static final String logo = "<img src=\"http://proxy.i2p/themes/console/default/images/i2plogo.png\" alt=\"I2P+ Router Console\" border=0>";
    private static final String BUNDLE_NAME = "net.i2p.i2ptunnel.proxy.messages";

    public static void serveLocalFile(I2PAppContext context, I2PSocketManager sockMgr, OutputStream out, String method, String targetRequest, String query, String proxyNonce, boolean allowGzip) throws IOException {
        Map<String, String> opts;
        if (targetRequest.equals("/")) {
            out.write(OK.getBytes("UTF-8"));
            out.flush();
            return;
        }
        if ((method.equals("GET") || method.equals("HEAD")) && targetRequest.startsWith("/themes/") && !targetRequest.contains("..")) {
            File themesDir;
            File file;
            String filename = null;
            try {
                filename = targetRequest.substring(8);
            }
            catch (IndexOutOfBoundsException ioobe) {
                return;
            }
            if (filename.startsWith("console/default/")) {
                filename = filename.replaceFirst("default", context.getProperty("routerconsole.theme", "dark"));
            }
            if ((file = new File(themesDir = new File(context.getBaseDir(), "docs/themes"), filename)).exists() && !file.isDirectory()) {
                String type = filename.endsWith(".css") ? "text/css; charset=UTF-8" : (filename.endsWith(".js") ? "text/javascript" : (filename.endsWith(".ico") ? "image/x-icon" : (filename.endsWith(".png") ? "image/png" : (filename.endsWith(".gif") ? "image/gif" : (filename.endsWith(".jpg") ? "image/jpeg" : (filename.endsWith(".webp") ? "image/webp" : (filename.endsWith(".svg") ? "image/svg+xml" : (filename.endsWith(".ttf") ? "font/ttf" : (filename.endsWith(".woff") ? "font/woff" : (filename.endsWith(".woff2") ? "font/woff2" : (filename.endsWith(".pdf") ? "application/pdf" : (filename.endsWith(".txt") ? "text/plain" : (filename.endsWith(".xhtml") ? "application/xhtml+xml" : "text/html; charset=UTF-8")))))))))))));
                StringBuilder buf = new StringBuilder(256);
                buf.append("HTTP/1.1 200 OK\r\nContent-Type: ").append(type).append("\r\n").append("Access-Control-Allow-Origin: *");
                if (filename.contains(".css") || filename.contains(".js") || filename.endsWith(".jpg") || filename.endsWith(".png") || filename.endsWith(".webp") || filename.endsWith(".ttf") || filename.endsWith(".woff2") || filename.endsWith(".svg")) {
                    buf.append("\r\nCache-Control: max-age=2628000, immutable\r\nConnection: close\r\n\r\n");
                } else {
                    buf.append("\r\nCache-Control: private, no-cache, max-age=2628000\r\nConnection: close\r\n\r\n");
                }
                out.write(buf.toString().getBytes("UTF-8"));
                FileUtil.readFile(filename, themesDir.getAbsolutePath(), out);
                return;
            }
        }
        if (targetRequest.equals("/add")) {
            if (query == null) {
                out.write(ERR_ADD.getBytes("UTF-8"));
                return;
            }
            opts = LocalHTTPServer.decodeQuery(query);
            String url = opts.get("url");
            String host = opts.get("host");
            String b64Dest = opts.get("dest");
            String nonce = opts.get("nonce");
            String referer = opts.get("referer");
            String book = "privatehosts.txt";
            if (opts.get("master") != null) {
                book = "userhosts.txt";
            } else if (opts.get("router") != null) {
                book = "hosts.txt";
            }
            Destination dest = null;
            if (b64Dest != null) {
                try {
                    dest = new Destination(b64Dest);
                }
                catch (DataFormatException dfe) {
                    System.err.println("Bad dest to save?" + b64Dest);
                }
            }
            if (proxyNonce.equals(nonce) && url != null && host != null && dest != null) {
                NamingService ns = context.namingService();
                Properties nsOptions = new Properties();
                nsOptions.setProperty("list", book);
                if (referer != null && referer.startsWith("http")) {
                    String ref = DataHelper.escapeHTML(referer);
                    String from = "<a href=\"" + ref + "\">" + ref + "</a>";
                    nsOptions.setProperty("s", LocalHTTPServer._t("Added via address helper from {0}", from));
                } else {
                    nsOptions.setProperty("s", LocalHTTPServer._t("Added via address helper"));
                }
                boolean success = ns.put(host, dest, nsOptions);
                LocalHTTPServer.writeRedirectPage(out, success, host, book, url);
                return;
            }
            out.write(ERR_ADD.getBytes("UTF-8"));
        } else if (targetRequest.equals("/b32")) {
            String secret;
            if (query == null) {
                out.write(ERR_ADD.getBytes("UTF-8"));
                return;
            }
            opts = LocalHTTPServer.decodeQuery(query);
            String err = null;
            String url = opts.get("url");
            String host = opts.get("host");
            String nonce = opts.get("nonce");
            String code = opts.get("code");
            String privkey = opts.get("privkey");
            if (privkey != null) {
                privkey = privkey.trim();
            }
            if ((secret = opts.get("secret")) != null) {
                secret = secret.trim();
            }
            String action = opts.get("action");
            if (proxyNonce.equals(nonce) && url != null && host != null && code != null) {
                boolean success = true;
                PrivateKey privateKey = null;
                PublicKey publicKey = null;
                if (!code.equals("2") && !code.equals("4")) {
                    secret = null;
                } else if (secret == null || secret.length() == 0) {
                    err = LocalHTTPServer._t("Missing lookup password");
                    success = false;
                }
                int authType = 0;
                if (!code.equals("3") && !code.equals("4")) {
                    privkey = null;
                } else if ("newdh".equals(action) || "newpsk".equals(action)) {
                    KeyPair kp = context.keyGenerator().generatePKIKeys(EncType.ECIES_X25519);
                    privateKey = kp.getPrivate();
                    publicKey = kp.getPublic();
                    authType = action.equals("newdh") ? 1 : 3;
                } else if (privkey == null || privkey.length() == 0) {
                    err = LocalHTTPServer._t("Missing private key");
                    success = false;
                } else {
                    byte[] data = Base64.decode(privkey);
                    if (data == null || data.length != 32) {
                        err = LocalHTTPServer._t("Invalid private key");
                        success = false;
                    } else {
                        privateKey = new PrivateKey(EncType.ECIES_X25519, data);
                        authType = 3;
                    }
                }
                if (success) {
                    try {
                        BlindData bd = Blinding.decode(context, host);
                        SigningPublicKey spk = bd.getUnblindedPubKey();
                        SigType bt = bd.getBlindedSigType();
                        bd = new BlindData(context, spk, bt, secret, authType, privateKey);
                        long now = context.clock().now();
                        bd.setDate(now);
                        long exp = now + (bd.getAuthRequired() || bd.getSecretRequired() ? 31536000000L : 8812800000L);
                        bd.setExpiration(exp);
                        I2PSession sess = sockMgr.getSession();
                        sess.sendBlindingInfo(bd);
                        if ("newdh".equals(action) || "newpsk".equals(action)) {
                            String key = "newdh".equals(action) ? publicKey.toBase64() : privateKey.toBase64();
                            StringBuilder buf = new StringBuilder(1024);
                            PortMapper pm = context.portMapper();
                            String conURL = pm.getConsoleURL();
                            buf.append(NEWKEY).append("<!DOCTYPE html>\n<html>\n<head>\n").append("<title>").append(LocalHTTPServer._t("Your new encryption key")).append("</title>\n").append(headerLinks).append("</head>\n<body>\n<div class=logo>\n<a href=\"").append(conURL).append("\" title=\"").append(LocalHTTPServer._t("Router Console")).append("\">").append(logo).append("</a><hr>\n");
                            if (pm.isRegistered("susidns")) {
                                buf.append("<a href=\"").append(conURL).append("susidns/index\">").append(LocalHTTPServer._t("Addressbook")).append("</a> ");
                            }
                            buf.append("<a href=\"").append(conURL).append("config\">").append(LocalHTTPServer._t("Configuration")).append("</a> ").append("<a href=\"").append(conURL).append("help/\">").append(LocalHTTPServer._t("Help")).append("</a>\n").append("</div>\n<div class=warning id=warning>\n").append("<h3>").append(LocalHTTPServer._t("Your new encryption key")).append("</h3>\n").append("<p id=key>").append(key).append("</p>\n").append("<p>").append(LocalHTTPServer._t("Copy the key and send it to the server operator.")).append(' ').append(LocalHTTPServer._t("After you are granted permission, you may proceed to the website.")).append("</p>\n").append("<p><a href=\"").append(url).append("\">").append(url).append("</a></p></div>");
                            out.write(buf.toString().getBytes("UTF-8"));
                            I2PTunnelHTTPClientBase.writeFooter(out);
                        } else {
                            LocalHTTPServer.writeB32RedirectPage(out, host, url);
                        }
                        return;
                    }
                    catch (IllegalArgumentException iae) {
                        err = iae.toString();
                    }
                    catch (I2PSessionException ise) {
                        err = ise.toString();
                    }
                }
            }
            out.write(ERR_B32.getBytes("UTF-8"));
            if (err != null) {
                out.write(("\n\n" + err + "\n\n" + LocalHTTPServer._t("Go back and fix the error")).getBytes("UTF-8"));
            }
        } else {
            out.write(ERR_404.getBytes("UTF-8"));
        }
        out.flush();
    }

    private static void writeRedirectPage(OutputStream out, boolean success, String host, String book, String url) throws IOException {
        String tbook = "hosts.txt".equals(book) ? LocalHTTPServer._t("router") : ("userhosts.txt".equals(book) ? LocalHTTPServer._t("master") : ("privatehosts.txt".equals(book) ? LocalHTTPServer._t("private") : book));
        PortMapper pm = I2PAppContext.getGlobalContext().portMapper();
        String conURL = pm.getConsoleURL();
        String idn = I2PTunnelHTTPClientBase.decodeIDNHost(host);
        out.write(("HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nReferrer-Policy: no-referrer\r\nAccess-Control-Allow-Origin: *\r\nConnection: close\r\n\r\n<!DOCTYPE html>\n<html>\n<head>\n<title>" + LocalHTTPServer._t("Redirecting to {0}", idn) + "</title>\n" + headerLinks + "<meta http-equiv=\"Refresh\" content=\"1; url=" + url + "\">\n</head>\n<body>\n<div class=logo>\n<a href=\"" + conURL + "\" title=\"" + LocalHTTPServer._t("Router Console") + "\">" + logo + "</a><hr>\n").getBytes("UTF-8"));
        if (pm.isRegistered("susidns")) {
            out.write(("<a href=\"" + conURL + "susidns/index\">" + LocalHTTPServer._t("Addressbook") + "</a> ").getBytes("UTF-8"));
        }
        out.write(("<a href=\"" + conURL + "config\">" + LocalHTTPServer._t("Configuration") + "</a> <a href=\"" + conURL + "help/\">" + LocalHTTPServer._t("Help") + "</a>\n").getBytes("UTF-8"));
        out.write(("</div>\n<div class=\"warning redirect\" id=warning>\n<h3>" + LocalHTTPServer._t("Redirection in progress") + "&hellip;</h3>\n<br>\n<p><b>" + (success ? LocalHTTPServer._t("Saved {0} to the {1} addressbook, redirecting now.", idn, tbook).replace("now.", "now&hellip;") : LocalHTTPServer._t("Failed to save {0} to the {1} addressbook, redirecting now.", idn, tbook).replace("now.", "now&hellip;")) + "</h3>\n<hr><p><a href=\"" + url + "\">" + LocalHTTPServer._t("Click here if you are not redirected automatically.") + "</a></p>\n<br></div>\n").getBytes("UTF-8"));
        I2PTunnelHTTPClientBase.writeFooter(out);
        out.flush();
    }

    private static void writeB32RedirectPage(OutputStream out, String host, String url) throws IOException {
        PortMapper pm = I2PAppContext.getGlobalContext().portMapper();
        String conURL = pm.getConsoleURL();
        String idn = I2PTunnelHTTPClientBase.decodeIDNHost(host);
        out.write(("HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nReferrer-Policy: no-referrer\r\nAccess-Control-Allow-Origin: *\r\nConnection: close\r\n\r\n<!DOCTYPE html>\n<html>\n<head>\n<title>" + LocalHTTPServer._t("Redirecting to {0}", idn) + "</title>\n" + headerLinks + "<meta http-equiv=\"Refresh\" content=\"1; url=" + url + "\">\n</head>\n<body>\n<div class=logo>\n<a href=\"" + conURL + "\" title=\"" + LocalHTTPServer._t("Router Console") + "\">" + logo + "</a><hr>\n").getBytes("UTF-8"));
        if (pm.isRegistered("susidns")) {
            out.write(("<a href=\"" + conURL + "susidns/index\">" + LocalHTTPServer._t("Addressbook") + "</a> ").getBytes("UTF-8"));
        }
        out.write(("<a href=\"" + conURL + "config\">" + LocalHTTPServer._t("Configuration") + "</a> <a href=\"" + conURL + "help/\">" + LocalHTTPServer._t("Help") + "</a>\n").getBytes("UTF-8"));
        out.write(("</div>\n<div class=\"warning redirect\" id=warning>\n<h3>" + LocalHTTPServer._t("Saved the authentication for {0}, redirecting now.", idn).replace("now.", "now&hellip;") + "</b></p>\n<hr>\n<p><a href=\"" + url + "\">" + LocalHTTPServer._t("Click here if you are not redirected automatically.") + "</a></p>\n<br>\n</div>\n").getBytes("UTF-8"));
        I2PTunnelHTTPClientBase.writeFooter(out);
        out.flush();
    }

    private static Map<String, String> decodeQuery(String query) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        int keystart = 0;
        int valstart = -1;
        String key = null;
        for (int i = 0; i <= query.length(); ++i) {
            int c;
            int n = c = i < query.length() ? (int)query.charAt(i) : 38;
            if (c == 59 || c == 38) {
                if (valstart < 0) {
                    key = query.substring(keystart, i);
                }
                if (key.length() > 0) {
                    String newQuery;
                    String decodedKey = LocalHTTPServer.decode(key);
                    String string = newQuery = keystart > 0 ? query.substring(0, keystart - 1) : "";
                    if (i < query.length() - 1) {
                        newQuery = keystart > 0 ? newQuery + query.substring(i) : newQuery + query.substring(i + 1);
                    }
                    String value = valstart >= 0 ? query.substring(valstart, i) : "";
                    String decodedValue = LocalHTTPServer.decode(value);
                    rv.put(decodedKey, decodedValue);
                }
                keystart = i + 1;
                valstart = -1;
                continue;
            }
            if (c != 61 || valstart >= 0) continue;
            key = query.substring(keystart, i);
            valstart = i + 1;
        }
        return rv;
    }

    public static String decode(String s) {
        if (!s.contains("%")) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                buf.append(c);
                continue;
            }
            try {
                buf.append((char)Integer.parseInt(s.substring(++i, ++i + 1), 16));
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                break;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        return buf.toString();
    }

    protected static String _t(String key) {
        return Translate.getString(key, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _t(String key, Object o) {
        return Translate.getString(key, o, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _t(String key, Object o, Object o2) {
        return Translate.getString(key, o, o2, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }
}

