/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.client.naming.NamingService;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSServerFactory;
import net.i2p.socks.SOCKSException;
import net.i2p.util.EventDispatcher;

public class I2PSOCKSTunnel
extends I2PTunnelClientBase {
    protected static final int INITIAL_SO_TIMEOUT = 15000;
    private final HashMap<String, List<String>> proxies;
    public static final String AUTH_REALM = "I2P SOCKS Proxy";
    public static final String PROP_OUTPROXY_TYPE = "outproxyType";
    public static final String PROP_PROXY_PREFIX = "i2ptunnel.socks.proxy.";
    public static final String DEFAULT = "default";
    public static final String PROP_PROXY_DEFAULT = "i2ptunnel.socks.proxy.default";

    public I2PSOCKSTunnel(int localPort, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) {
        super(localPort, ownDest, l, notifyThis, "SOCKS Proxy on " + tunnel.listenHost + ':' + localPort, tunnel, pkf);
        Properties opts = tunnel.getClientOptions();
        opts.setProperty("i2p.streaming.connectDelay", "150");
        opts.remove("i2p.streaming.maxWindowSize");
        this.setName("SOCKS Proxy on " + tunnel.listenHost + ':' + localPort);
        this.proxies = new HashMap(1);
        this.parseOptions();
        this.notifyEvent("openSOCKSTunnelResult", "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        Closeable destSock = null;
        try {
            try {
                s.setSoTimeout(15000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            SOCKSServer serv = SOCKSServerFactory.createSOCKSServer(this._context, s, this.getTunnel().getClientOptions());
            Socket clientSock = serv.getClientSocket();
            try {
                s.setSoTimeout(0);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            destSock = serv.getDestinationI2PSocket(this);
            I2PTunnelRunner t = new I2PTunnelRunner(clientSock, (I2PSocket)destSock, this.sockLock, null, null, (List<I2PSocket>)this.mySockets, (I2PTunnelRunner.FailCallback)null);
            ((Thread)t).run();
        }
        catch (SOCKSException e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error from SOCKS connection", e);
            }
        }
        finally {
            I2PSOCKSTunnel.closeSocket(s);
            if (destSock != null) {
                try {
                    destSock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        if (this.getTunnel() != tunnel) {
            return;
        }
        this.proxies.clear();
        this.parseOptions();
        super.optionsUpdated(tunnel);
    }

    private void parseOptions() {
        String proxyList;
        Properties opts = this.getTunnel().getClientOptions();
        if (!opts.containsKey(PROP_PROXY_DEFAULT) && (proxyList = opts.getProperty("proxyList")) != null) {
            opts.setProperty(PROP_PROXY_DEFAULT, proxyList);
        }
        for (Map.Entry<Object, Object> e : opts.entrySet()) {
            String prop = (String)e.getKey();
            if (!prop.startsWith(PROP_PROXY_PREFIX) || prop.length() <= PROP_PROXY_PREFIX.length()) continue;
            String port = prop.substring(PROP_PROXY_PREFIX.length());
            ArrayList<String> proxyList2 = new ArrayList<String>(1);
            StringTokenizer tok = new StringTokenizer((String)e.getValue(), ", \t");
            while (tok.hasMoreTokens()) {
                String proxy;
                String host = proxy = tok.nextToken().trim();
                int colon = proxy.indexOf(58);
                if (colon > 0) {
                    host = host.substring(0, colon);
                }
                if (NamingService.isI2PHost(host)) {
                    proxyList2.add(proxy);
                    continue;
                }
                String m = "Non-i2p SOCKS outproxy: " + proxy;
                this.l.log(m);
                this._log.error(m);
            }
            this.proxies.put(port, proxyList2);
        }
    }

    public HashMap<String, List<String>> getProxyMap() {
        return this.proxies;
    }

    public List<String> getProxies(int port) {
        List<String> rv = this.proxies.get(Integer.toString(port));
        if (rv == null) {
            rv = this.getDefaultProxies();
        }
        return rv;
    }

    public List<String> getDefaultProxies() {
        return this.proxies.get(DEFAULT);
    }

    public I2PSocketOptions buildOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }
}

