/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.ID3v1;
import com.mpatric.mp3agic.ID3v1Genres;
import com.mpatric.mp3agic.NoSuchTagException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ID3v1Tag
implements ID3v1 {
    public static final int TAG_LENGTH = 128;
    private static final String VERSION_0 = "0";
    private static final String VERSION_1 = "1";
    private static final String TAG = "TAG";
    private static final int TITLE_OFFSET = 3;
    private static final int TITLE_LENGTH = 30;
    private static final int ARTIST_OFFSET = 33;
    private static final int ARTIST_LENGTH = 30;
    private static final int ALBUM_OFFSET = 63;
    private static final int ALBUM_LENGTH = 30;
    private static final int YEAR_OFFSET = 93;
    private static final int YEAR_LENGTH = 4;
    private static final int COMMENT_OFFSET = 97;
    private static final int COMMENT_LENGTH_V1_0 = 30;
    private static final int COMMENT_LENGTH_V1_1 = 28;
    private static final int TRACK_MARKER_OFFSET = 125;
    private static final int TRACK_OFFSET = 126;
    private static final int GENRE_OFFSET = 127;
    private String track = null;
    private String artist = null;
    private String title = null;
    private String album = null;
    private String year = null;
    private int genre = -1;
    private String comment = null;

    public ID3v1Tag() {
    }

    public ID3v1Tag(byte[] bytes) throws NoSuchTagException {
        this.unpackTag(bytes);
    }

    private void unpackTag(byte[] bytes) throws NoSuchTagException {
        this.sanityCheckTag(bytes);
        this.title = BufferTools.trimStringRight(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 3, 30));
        this.artist = BufferTools.trimStringRight(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 33, 30));
        this.album = BufferTools.trimStringRight(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 63, 30));
        this.year = BufferTools.trimStringRight(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 93, 4));
        this.genre = bytes[127] & 0xFF;
        if (this.genre == 255) {
            this.genre = -1;
        }
        if (bytes[125] != 0) {
            this.comment = BufferTools.trimStringRight(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 97, 30));
            this.track = null;
        } else {
            this.comment = BufferTools.trimStringRight(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 97, 28));
            byte trackInt = bytes[126];
            this.track = trackInt == 0 ? "" : Integer.toString(trackInt);
        }
    }

    private void sanityCheckTag(byte[] bytes) throws NoSuchTagException {
        if (bytes.length != 128) {
            throw new NoSuchTagException("Buffer length wrong");
        }
        if (!TAG.equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, 0, TAG.length()))) {
            throw new NoSuchTagException();
        }
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[128];
        this.packTag(bytes);
        return bytes;
    }

    public void toBytes(byte[] bytes) {
        this.packTag(bytes);
    }

    public void packTag(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
        try {
            BufferTools.stringIntoByteBuffer(TAG, 0, 3, bytes, 0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.packField(bytes, this.title, 30, 3);
        this.packField(bytes, this.artist, 30, 33);
        this.packField(bytes, this.album, 30, 63);
        this.packField(bytes, this.year, 4, 93);
        bytes[127] = this.genre < 128 ? (byte)this.genre : (byte)(this.genre - 256);
        if (this.track == null) {
            this.packField(bytes, this.comment, 30, 97);
        } else {
            this.packField(bytes, this.comment, 28, 97);
            String trackTemp = this.numericsOnly(this.track);
            if (trackTemp.length() > 0) {
                int trackInt = Integer.parseInt(trackTemp);
                bytes[126] = trackInt < 128 ? (byte)trackInt : (byte)(trackInt - 256);
            }
        }
    }

    private void packField(byte[] bytes, String value, int maxLength, int offset) {
        if (value != null) {
            try {
                BufferTools.stringIntoByteBuffer(value, 0, Math.min(value.length(), maxLength), bytes, offset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private String numericsOnly(String s) {
        char ch;
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < s.length() && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
            stringBuffer.append(ch);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getVersion() {
        if (this.track == null) {
            return VERSION_0;
        }
        return VERSION_1;
    }

    @Override
    public String getTrack() {
        return this.track;
    }

    @Override
    public void setTrack(String track) {
        this.track = track;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public void setArtist(String artist) {
        this.artist = artist;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public void setAlbum(String album) {
        this.album = album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public int getGenre() {
        return this.genre;
    }

    @Override
    public void setGenre(int genre) {
        this.genre = genre;
    }

    @Override
    public String getGenreDescription() {
        try {
            return ID3v1Genres.GENRES[this.genre];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown";
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.album == null ? 0 : this.album.hashCode());
        result = 31 * result + (this.artist == null ? 0 : this.artist.hashCode());
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + this.genre;
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.track == null ? 0 : this.track.hashCode());
        result = 31 * result + (this.year == null ? 0 : this.year.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v1Tag other = (ID3v1Tag)obj;
        if (this.album == null ? other.album != null : !this.album.equals(other.album)) {
            return false;
        }
        if (this.artist == null ? other.artist != null : !this.artist.equals(other.artist)) {
            return false;
        }
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.genre != other.genre) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.track == null ? other.track != null : !this.track.equals(other.track)) {
            return false;
        }
        return !(this.year == null ? other.year != null : !this.year.equals(other.year));
    }
}

