/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.ByteBufferUtils;
import com.mpatric.mp3agic.ID3v2Frame;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.NotSupportedException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ID3v2ChapterFrameData
extends AbstractID3v2FrameData {
    protected String id;
    protected int startTime;
    protected int endTime;
    protected int startOffset;
    protected int endOffset;
    protected ArrayList<ID3v2Frame> subframes = new ArrayList();

    public ID3v2ChapterFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2ChapterFrameData(boolean unsynchronisation, String id, int startTime, int endTime, int startOffset, int endOffset) {
        super(unsynchronisation);
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public ID3v2ChapterFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        ID3v2Frame frame;
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        this.id = ByteBufferUtils.extractNullTerminatedString(bb);
        bb.position(this.id.length() + 1);
        this.startTime = bb.getInt();
        this.endTime = bb.getInt();
        this.startOffset = bb.getInt();
        this.endOffset = bb.getInt();
        for (int offset = bb.position(); offset < bytes.length; offset += frame.getLength()) {
            frame = new ID3v2Frame(bytes, offset);
            this.subframes.add(frame);
        }
    }

    public void addSubframe(String id, AbstractID3v2FrameData frame) {
        this.subframes.add(new ID3v2Frame(id, frame.toBytes()));
    }

    @Override
    protected byte[] packFrameData() {
        ByteBuffer bb = ByteBuffer.allocate(this.getLength());
        bb.put(this.id.getBytes());
        bb.put((byte)0);
        bb.putInt(this.startTime);
        bb.putInt(this.endTime);
        bb.putInt(this.startOffset);
        bb.putInt(this.endOffset);
        for (ID3v2Frame frame : this.subframes) {
            try {
                bb.put(frame.toBytes());
            }
            catch (NotSupportedException e) {
                e.printStackTrace();
            }
        }
        return bb.array();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public ArrayList<ID3v2Frame> getSubframes() {
        return this.subframes;
    }

    public void setSubframes(ArrayList<ID3v2Frame> subframes) {
        this.subframes = subframes;
    }

    @Override
    protected int getLength() {
        int length = 1;
        length += 16;
        if (this.id != null) {
            length += this.id.length();
        }
        if (this.subframes != null) {
            for (ID3v2Frame frame : this.subframes) {
                length += frame.getLength();
            }
        }
        return length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ID3v2ChapterFrameData [id=");
        builder.append(this.id);
        builder.append(", startTime=");
        builder.append(this.startTime);
        builder.append(", endTime=");
        builder.append(this.endTime);
        builder.append(", startOffset=");
        builder.append(this.startOffset);
        builder.append(", endOffset=");
        builder.append(this.endOffset);
        builder.append(", subframes=");
        builder.append(this.subframes);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endOffset;
        result = 31 * result + this.endTime;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.startOffset;
        result = 31 * result + this.startTime;
        result = 31 * result + (this.subframes == null ? 0 : this.subframes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2ChapterFrameData other = (ID3v2ChapterFrameData)obj;
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        return !(this.subframes == null ? other.subframes != null : !this.subframes.equals(other.subframes));
    }
}

