/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.InvalidDataException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ID3v2PopmFrameData
extends AbstractID3v2FrameData {
    protected static final String WMP9_ADDRESS = "Windows Media Player 9 Series";
    protected String address = "";
    protected int rating = -1;
    private static final Map<Byte, Integer> byteToRating = new HashMap<Byte, Integer>(5);
    private static final byte[] wmp9encodedRatings = new byte[]{0, 1, 64, -128, -60, -1};

    public ID3v2PopmFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    public ID3v2PopmFrameData(boolean unsynchronisation, int rating) {
        super(unsynchronisation);
        this.address = WMP9_ADDRESS;
        this.rating = rating;
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        try {
            this.address = BufferTools.byteBufferToString(bytes, 0, bytes.length - 2);
        }
        catch (UnsupportedEncodingException e) {
            this.address = "";
        }
        byte ratingByte = bytes[bytes.length - 1];
        this.rating = byteToRating.containsKey(ratingByte) ? byteToRating.get(ratingByte) : -1;
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = this.address.getBytes();
        bytes = Arrays.copyOf(bytes, this.address.length() + 2);
        bytes[bytes.length - 2] = 0;
        bytes[bytes.length - 1] = wmp9encodedRatings[this.rating];
        return bytes;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    @Override
    protected int getLength() {
        return this.address.length() + 2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.rating;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2PopmFrameData other = (ID3v2PopmFrameData)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.rating == other.rating;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            byteToRating.put(wmp9encodedRatings[i], i);
        }
    }
}

