/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketEepGet;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.Base32;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import org.klomp.snark.PeerID;
import org.klomp.snark.SnarkManager;
import org.klomp.snark.dht.DHT;
import org.klomp.snark.dht.KRPC;

public class I2PSnarkUtil
implements I2PSocketManager.DisconnectListener {
    private final I2PAppContext _context;
    private final Log _log;
    private final String _baseName;
    private boolean _shouldProxy;
    private String _proxyHost;
    private int _proxyPort;
    private String _i2cpHost;
    private int _i2cpPort;
    private final Map<String, String> _opts;
    private volatile I2PSocketManager _manager;
    private volatile boolean _connecting;
    private final Set<Hash> _banlist;
    private int _maxUploaders;
    private int _maxUpBW;
    private int _maxConnections;
    private final File _tmpDir;
    private int _startupDelay;
    private boolean _collapsePanels;
    private boolean _showStatusFilter;
    private boolean _enableLightbox;
    private boolean _enableAddCreate;
    private boolean _shouldUseOT;
    private boolean _shouldUseDHT;
    private boolean _enableRatings;
    private boolean _enableComments;
    private String _commentsName;
    private boolean _areFilesPublic;
    private boolean _shouldPreallocateFiles;
    private boolean _varyInboundHops;
    private boolean _varyOutboundHops;
    private List<String> _openTrackers;
    private DHT _dht;
    private long _startedTime;
    private final I2PSocketManager.DisconnectListener _discon;
    private int _maxFilesPerTorrent = 2000;
    private static final int EEPGET_CONNECT_TIMEOUT = 60000;
    private static final int EEPGET_CONNECT_TIMEOUT_SHORT = 15000;
    public static final int DEFAULT_STARTUP_DELAY = 3;
    public static final boolean DEFAULT_COLLAPSE_PANELS = true;
    public static final boolean DEFAULT_SHOW_STATUSFILTER = false;
    public static final boolean DEFAULT_ENABLE_LIGHTBOX = true;
    public static final boolean DEFAULT_ENABLE_ADDCREATE = false;
    public static final boolean DEFAULT_USE_OPENTRACKERS = true;
    public static final boolean DEFAULT_VARY_INBOUND_HOPS = false;
    public static final boolean DEFAULT_VARY_OUTBOUND_HOPS = false;
    public static final int MAX_CONNECTIONS = 300;
    public static final String PROP_MAX_BW = "i2cp.outboundBytesPerSecond";
    public static final boolean DEFAULT_USE_DHT = true;
    public static final String EEPGET_USER_AGENT = "I2PSnark";
    private static final List<String> HIDDEN_I2CP_OPTS = Arrays.asList("i2cp.outboundBytesPerSecond", "inbound.length", "outbound.length", "inbound.quantity", "outbound.quantity");
    private static final int BASE32_HASH_LENGTH = 52;
    private static final String BUNDLE_NAME = "org.klomp.snark.web.messages";
    private static final boolean SHOULD_SYNC = !SystemVersion.isAndroid() && !SystemVersion.isARM();
    private static final Pattern ILLEGAL_KEY = Pattern.compile("[#=\\r\\n;]");
    private static final Pattern ILLEGAL_VALUE = Pattern.compile("[\\r\\n]");

    public I2PSnarkUtil(I2PAppContext ctx) {
        this(ctx, "i2psnark", null);
    }

    public I2PSnarkUtil(I2PAppContext ctx, String baseName, I2PSocketManager.DisconnectListener discon) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(I2PSnarkUtil.class);
        this._baseName = baseName;
        this._discon = discon;
        this._opts = new HashMap<String, String>();
        this.setI2CPConfig("127.0.0.1", 7654, null);
        this._banlist = new ConcurrentHashSet<Hash>();
        this._maxUploaders = 50;
        this._maxUpBW = 1024;
        this._maxConnections = 300;
        this._startupDelay = 3;
        this._shouldUseOT = true;
        this._openTrackers = Collections.emptyList();
        this._shouldUseDHT = true;
        this._collapsePanels = true;
        this._showStatusFilter = false;
        this._enableLightbox = true;
        this._enableAddCreate = false;
        this._enableComments = true;
        this._enableRatings = true;
        this._varyInboundHops = false;
        this._varyOutboundHops = false;
        this._commentsName = "";
        this._tmpDir = new SecureDirectory(ctx.getTempDir(), baseName + '-' + ctx.random().nextInt());
        this._tmpDir.mkdirs();
    }

    public I2PAppContext getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setI2CPConfig(String i2cpHost, int i2cpPort, Map opts) {
        if (i2cpHost != null) {
            this._i2cpHost = i2cpHost;
        }
        if (i2cpPort > 0) {
            this._i2cpPort = i2cpPort;
        }
        if (this.getVaryInboundHops()) {
            this._opts.put("inbound.tunnelVariance", "1");
        } else {
            this._opts.put("inbound.tunnelVariance", "0");
        }
        if (this.getVaryOutboundHops()) {
            this._opts.put("outbound.tunnelVariance", "1");
        } else {
            this._opts.put("outbound.tunnelVariance", "0");
        }
        if (opts != null) {
            Map<String, String> map = this._opts;
            synchronized (map) {
                Iterator<String> iter = this._opts.keySet().iterator();
                while (iter.hasNext()) {
                    String k = iter.next();
                    if (HIDDEN_I2CP_OPTS.contains(k) || opts.containsKey(k)) continue;
                    iter.remove();
                }
                this._opts.putAll(opts);
            }
        }
        this.setMaxUpBW(this._maxUpBW);
    }

    public void setMaxUploaders(int limit) {
        this._maxUploaders = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxUpBW(int limit) {
        I2PSession sess;
        this._maxUpBW = limit;
        Map<String, String> map = this._opts;
        synchronized (map) {
            this._opts.put(PROP_MAX_BW, Integer.toString(limit * 1228));
        }
        if (this._manager != null && (sess = this._manager.getSession()) != null) {
            Properties newProps = new Properties();
            Map<String, String> map2 = this._opts;
            synchronized (map2) {
                newProps.putAll(this._opts);
            }
            sess.updateOptions(newProps);
        }
    }

    public void setMaxConnections(int limit) {
        this._maxConnections = limit;
    }

    public void setStartupDelay(int minutes) {
        this._startupDelay = minutes;
    }

    public String getI2CPHost() {
        return this._i2cpHost;
    }

    public int getI2CPPort() {
        return this._i2cpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getI2CPOptions() {
        Map<String, String> map = this._opts;
        synchronized (map) {
            return new HashMap<String, String>(this._opts);
        }
    }

    public String getEepProxyHost() {
        return this._proxyHost;
    }

    public int getEepProxyPort() {
        return this._proxyPort;
    }

    public boolean getEepProxySet() {
        return this._shouldProxy;
    }

    public int getMaxUploaders() {
        return this._maxUploaders;
    }

    public int getMaxUpBW() {
        return this._maxUpBW;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public int getStartupDelay() {
        return this._startupDelay;
    }

    public boolean getFilesPublic() {
        return this._areFilesPublic;
    }

    public void setFilesPublic(boolean yes) {
        this._areFilesPublic = yes;
    }

    public boolean getPreallocateFiles() {
        return this._shouldPreallocateFiles;
    }

    public void setPreallocateFiles(boolean yes) {
        this._shouldPreallocateFiles = yes;
    }

    public File getTempDir() {
        return this._tmpDir;
    }

    public int getMaxFilesPerTorrent() {
        return this._maxFilesPerTorrent;
    }

    public void setMaxFilesPerTorrent(int max) {
        this._maxFilesPerTorrent = Math.max(max, 1);
    }

    public boolean getVaryInboundHops() {
        return this._varyInboundHops;
    }

    public boolean getVaryOutboundHops() {
        return this._varyOutboundHops;
    }

    public void setVaryInboundHops(boolean yes) {
        this._varyInboundHops = yes;
    }

    public void setVaryOutboundHops(boolean yes) {
        this._varyOutboundHops = yes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean connect() {
        if (this._manager == null) {
            this._connecting = true;
            if (this._log.shouldDebug()) {
                this._log.debug("Connecting to I2P...", new Exception("I did it"));
            }
            Properties opts = this._context.getProperties();
            Map<String, String> map = this._opts;
            synchronized (map) {
                opts.putAll(this._opts);
            }
            String sin = opts.getProperty("inbound.quantity");
            String sout = opts.getProperty("outbound.quantity");
            if (sin != null) {
                int in;
                try {
                    in = Integer.parseInt(sin);
                }
                catch (NumberFormatException nfe) {
                    in = 3;
                }
                if (in > 2) {
                    opts.setProperty("inbound.quantity", "2");
                }
            }
            if (sout != null) {
                int out;
                try {
                    out = Integer.parseInt(sout);
                }
                catch (NumberFormatException nfe) {
                    out = 3;
                }
                if (out > 2) {
                    opts.setProperty("outbound.quantity", "2");
                }
            }
            if (opts.containsKey("inbound.backupQuantity")) {
                opts.setProperty("inbound.backupQuantity", "0");
            }
            if (opts.containsKey("outbound.backupQuantity")) {
                opts.setProperty("outbound.backupQuantity", "0");
            }
            if (opts.getProperty("inbound.nickname") == null) {
                opts.setProperty("inbound.nickname", this._baseName.replace("i2psnark", EEPGET_USER_AGENT));
            }
            if (opts.getProperty("outbound.nickname") == null) {
                opts.setProperty("outbound.nickname", this._baseName.replace("i2psnark", EEPGET_USER_AGENT));
            }
            if (opts.getProperty("inbound.lengthVariance") == null || !this.getVaryInboundHops()) {
                opts.setProperty("inbound.lengthVariance", "0");
            } else if (this.getVaryInboundHops()) {
                opts.setProperty("inbound.lengthVariance", "1");
            }
            if (opts.getProperty("outbound.lengthVariance") == null || !this.getVaryOutboundHops()) {
                opts.setProperty("outbound.lengthVariance", "0");
            } else if (this.getVaryOutboundHops()) {
                opts.setProperty("outbound.lengthVariance", "1");
            }
            if (opts.getProperty("i2p.streaming.connectTimeout") == null) {
                opts.setProperty("i2p.streaming.connectTimeout", "300000");
            }
            if (opts.getProperty("i2p.streaming.inactivityTimeout") == null) {
                opts.setProperty("i2p.streaming.inactivityTimeout", "180000");
            }
            if (opts.getProperty("i2p.streaming.inactivityAction") == null) {
                opts.setProperty("i2p.streaming.inactivityAction", "1");
            }
            if (opts.getProperty("i2p.streaming.initialWindowSize") == null) {
                opts.setProperty("i2p.streaming.initialWindowSize", "1");
            }
            if (opts.getProperty("i2p.streaming.slowStartGrowthRateFactor") == null) {
                opts.setProperty("i2p.streaming.slowStartGrowthRateFactor", "1");
            }
            if (opts.getProperty("i2p.streaming.maxConnsPerMinute") == null) {
                opts.setProperty("i2p.streaming.maxConnsPerMinute", "16");
            }
            if (opts.getProperty("i2p.streaming.maxTotalConnsPerMinute") == null) {
                opts.setProperty("i2p.streaming.maxTotalConnsPerMinute", "1024");
            }
            if (opts.getProperty("i2p.streaming.maxConnsPerHour") == null) {
                opts.setProperty("i2p.streaming.maxConnsPerHour", "256");
            }
            if (opts.getProperty("i2p.streaming.enforceProtocol") == null) {
                opts.setProperty("i2p.streaming.enforceProtocol", "true");
            }
            if (opts.getProperty("i2p.streaming.disableRejectLogging") == null) {
                opts.setProperty("i2p.streaming.disableRejectLogging", "false");
            }
            if (opts.getProperty("i2p.streaming.answerPings") == null) {
                opts.setProperty("i2p.streaming.answerPings", "false");
            }
            if (opts.getProperty("i2p.streaming.profile") == null) {
                opts.setProperty("i2p.streaming.profile", Integer.toString(1));
            }
            if (opts.getProperty("i2cp.destination.sigType") == null) {
                opts.setProperty("i2cp.destination.sigType", "EdDSA_SHA512_Ed25519");
            }
            if (opts.getProperty("i2cp.leaseSetEncType") == null) {
                opts.setProperty("i2cp.leaseSetEncType", "4");
            }
            if (opts.getProperty("i2cp.gzip") == null) {
                opts.setProperty("i2cp.gzip", "false");
            }
            this._manager = I2PSocketManagerFactory.createManager(this._i2cpHost, this._i2cpPort, opts);
            if (this._manager != null) {
                this._startedTime = this._context.clock().now();
                if (this._discon != null) {
                    this._manager.addDisconnectListener(this);
                }
            }
            this._connecting = false;
        }
        if (this._shouldUseDHT && this._manager != null && this._dht == null) {
            this._dht = new KRPC(this._context, this._baseName, this._manager.getSession());
        }
        return this._manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionDisconnected() {
        I2PSnarkUtil i2PSnarkUtil = this;
        synchronized (i2PSnarkUtil) {
            this._manager = null;
            this._connecting = false;
            if (this._dht != null) {
                this._dht.stop();
                this._dht = null;
            }
        }
        if (this._discon != null) {
            this._discon.sessionDisconnected();
        }
    }

    public DHT getDHT() {
        return this._dht;
    }

    public boolean connected() {
        return this._manager != null;
    }

    public boolean isConnecting() {
        return this._manager == null && this._connecting;
    }

    public I2PSocketManager getSocketManager() {
        return this._manager;
    }

    public synchronized void disconnect() {
        if (this._dht != null) {
            this._dht.stop();
            this._dht = null;
        }
        this._startedTime = 0L;
        I2PSocketManager mgr = this._manager;
        this._manager = null;
        this._banlist.clear();
        if (mgr != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Disconnecting from I2P...", new Exception("I did it"));
            }
            mgr.destroySocketManager();
        }
        FileUtil.rmdir(this._tmpDir, false);
        this._tmpDir.mkdirs();
    }

    public long getStartedTime() {
        return this._startedTime;
    }

    I2PSocket connect(PeerID peer) throws IOException {
        I2PSocketManager mgr = this._manager;
        if (mgr == null) {
            throw new IOException("No socket manager");
        }
        Destination addr = peer.getAddress();
        if (addr == null) {
            throw new IOException("Null address");
        }
        if (addr.equals(this.getMyDestination())) {
            throw new IOException("Attempt to connect to myself");
        }
        Hash dest = addr.calculateHash();
        if (this._banlist.contains(dest)) {
            throw new IOException("Not trying to contact banlisted peer [" + dest.toBase64().substring(0, 6) + "]");
        }
        try {
            I2PSocket rv = this._manager.connect(addr);
            if (rv != null) {
                this._banlist.remove(dest);
            }
            return rv;
        }
        catch (I2PException ie) {
            this._banlist.add(dest);
            this._context.simpleTimer2().addEvent(new Unbanlist(dest), 900000L);
            IOException ioe = new IOException("Unable to reach peer [" + peer + "]");
            ioe.initCause(ie);
            throw ioe;
        }
    }

    public File get(String url) {
        return this.get(url, true, 0);
    }

    public File get(String url, boolean rewrite) {
        return this.get(url, rewrite, 0);
    }

    public File get(String url, int retries) {
        return this.get(url, true, retries);
    }

    public File get(String url, boolean rewrite, int retries) {
        int timeout;
        if (this._log.shouldDebug()) {
            this._log.debug("Fetching [" + url + "] proxy=" + this._proxyHost + ":" + this._proxyPort + ": " + this._shouldProxy);
        }
        File out = null;
        try {
            out = SecureFile.createTempFile("i2psnark", null, this._tmpDir);
        }
        catch (IOException ioe) {
            this._log.error("Temp file error", ioe);
            if (out != null) {
                out.delete();
            }
            return null;
        }
        out.deleteOnExit();
        String fetchURL = url;
        if (rewrite) {
            fetchURL = this.rewriteAnnounce(url);
        }
        if (retries < 0) {
            if (!this.connected()) {
                return null;
            }
            timeout = 15000;
            retries = 10;
        } else {
            timeout = 60000;
            if (!this.connected() && !this.connect()) {
                return null;
            }
        }
        I2PSocketEepGet get = new I2PSocketEepGet(this._context, this._manager, retries, out.getAbsolutePath(), fetchURL);
        get.addHeader("User-Agent", EEPGET_USER_AGENT);
        int truncate = url.indexOf("&");
        String convertedurl = url.replace("ahsplxkbhemefwvvml7qovzl5a2b5xo5i7lyai7ntdunvcyfdtna.b32.i2p", "tracker2.postman.i2p").replace("lnQ6yoBTxQuQU8EQ1FlF395ITIQF-HGJxUeFvzETLFnoczNjQvKDbtSB7aHhn853zjVXrJBgwlB9sO57KakBDaJ50lUZgVPhjlI19TgJ-CxyHhHSCeKx5JzURdEW-ucdONMynr-b2zwhsx8VQCJwCEkARvt21YkOyQDaB9IdV8aTAmP~PUJQxRwceaTMn96FcVenwdXqleE16fI8CVFOV18jbJKrhTOYpTtcZKV4l1wNYBDwKgwPx5c0kcrRzFyw5~bjuAKO~GJ5dR7BQsL7AwBoQUS4k1lwoYrG1kOIBeDD3XF8BWb6K3GOOoyjc1umYKpur3G~FxBuqtHAsDRICkEbKUqJ9mPYQlTSujhNxiRIW-oLwMtvayCFci99oX8MvazPS7~97x0Gsm-onEK1Td9nBdmq30OqDxpRtXBimbzkLbR1IKObbg9HvrKs3L-kSyGwTUmHG9rSQSoZEvFMA-S0EXO~o4g21q1oikmxPMhkeVwQ22VHB0-LZJfmLr4SAAAA.i2p", "tracker2.postman.i2p").replace("w7tpbzncbcocrqtwwm3nezhnnsw4ozadvi2hmvzdhrqzfxfum7wa.b32.i2p", "opentracker.dg2.i2p").replace("afuuortfaqejkesne272krqvmafn65mhls6nvcwv3t7l2ic2p4kq.b32.i2p", "lyoko.i2p").replace("s5ikrdyjwbcgxmqetxb3nyheizftms7euacuub2hic7defkh3xhq.b32.i2p", "tracker.thebland.i2p").replace("nfrjvknwcw47itotkzmk6mdlxmxfxsxhbhlr5ozhlsuavcogv4hq.b32.i2p", "torrfreedom.i2p").replace("http://", "");
        if (get.fetch(timeout)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Request successful [" + convertedurl.substring(0, truncate) + "...] (Size: " + out.length() + " bytes)");
            }
            return out;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Timeout (" + timeout / 1000 + "s) requesting [" + convertedurl.substring(0, truncate) + "...]");
        }
        out.delete();
        return null;
    }

    public byte[] get(String url, boolean rewrite, int retries, int initialSize, int maxSize) {
        int timeout;
        if (this._log.shouldDebug()) {
            this._log.debug("Fetching [" + url + "] to memory");
        }
        String fetchURL = url;
        if (rewrite) {
            fetchURL = this.rewriteAnnounce(url);
        }
        if (retries < 0) {
            if (!this.connected()) {
                return null;
            }
            timeout = 15000;
            retries = 0;
        } else {
            timeout = 60000;
            if (!this.connected() && !this.connect()) {
                return null;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(initialSize);
        I2PSocketEepGet get = new I2PSocketEepGet(this._context, this._manager, retries, -1L, (long)maxSize, null, out, fetchURL);
        get.addHeader("User-Agent", EEPGET_USER_AGENT);
        int truncate = url.indexOf("&");
        String convertedurl = url.replace("ahsplxkbhemefwvvml7qovzl5a2b5xo5i7lyai7ntdunvcyfdtna.b32.i2p", "tracker2.postman.i2p").replace("lnQ6yoBTxQuQU8EQ1FlF395ITIQF-HGJxUeFvzETLFnoczNjQvKDbtSB7aHhn853zjVXrJBgwlB9sO57KakBDaJ50lUZgVPhjlI19TgJ-CxyHhHSCeKx5JzURdEW-ucdONMynr-b2zwhsx8VQCJwCEkARvt21YkOyQDaB9IdV8aTAmP~PUJQxRwceaTMn96FcVenwdXqleE16fI8CVFOV18jbJKrhTOYpTtcZKV4l1wNYBDwKgwPx5c0kcrRzFyw5~bjuAKO~GJ5dR7BQsL7AwBoQUS4k1lwoYrG1kOIBeDD3XF8BWb6K3GOOoyjc1umYKpur3G~FxBuqtHAsDRICkEbKUqJ9mPYQlTSujhNxiRIW-oLwMtvayCFci99oX8MvazPS7~97x0Gsm-onEK1Td9nBdmq30OqDxpRtXBimbzkLbR1IKObbg9HvrKs3L-kSyGwTUmHG9rSQSoZEvFMA-S0EXO~o4g21q1oikmxPMhkeVwQ22VHB0-LZJfmLr4SAAAA.i2p", "tracker2.postman.i2p").replace("w7tpbzncbcocrqtwwm3nezhnnsw4ozadvi2hmvzdhrqzfxfum7wa.b32.i2p", "opentracker.dg2.i2p").replace("afuuortfaqejkesne272krqvmafn65mhls6nvcwv3t7l2ic2p4kq.b32.i2p", "lyoko.i2p").replace("s5ikrdyjwbcgxmqetxb3nyheizftms7euacuub2hic7defkh3xhq.b32.i2p", "tracker.thebland.i2p").replace("nfrjvknwcw47itotkzmk6mdlxmxfxsxhbhlr5ozhlsuavcogv4hq.b32.i2p", "torrfreedom.i2p").replace("http://", "");
        if (get.fetch(timeout)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Request successful [" + convertedurl.substring(0, truncate) + "...] (Size: " + out.size() + " bytes)");
            }
            return out.toByteArray();
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Timeout (" + timeout / 1000 + "s) requesting [" + convertedurl.substring(0, truncate) + "...]");
        }
        return null;
    }

    public I2PServerSocket getServerSocket() {
        I2PSocketManager mgr = this._manager;
        if (mgr != null) {
            return mgr.getServerSocket();
        }
        return null;
    }

    public String getOurIPString() {
        Destination dest = this.getMyDestination();
        if (dest != null) {
            return dest.toBase64();
        }
        return "unknown";
    }

    Destination getMyDestination() {
        if (this._manager == null) {
            return null;
        }
        I2PSession sess = this._manager.getSession();
        if (sess != null) {
            return sess.getMyDestination();
        }
        return null;
    }

    static Destination getDestinationFromBase64(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            if (ip.length() < 520) {
                return null;
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    Destination getDestination(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            if (ip.length() < 520) {
                byte[] b;
                I2PSession sess;
                if (this._manager != null && ip.length() == 60 && ip.endsWith(".b32.i2p") && (sess = this._manager.getSession()) != null && (b = Base32.decode(ip.substring(0, 52))) != null) {
                    Hash h = Hash.create(b);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Using existing session for lookup of [" + ip + "]");
                    }
                    try {
                        return sess.lookupDest(h, 15000L);
                    }
                    catch (I2PSessionException i2PSessionException) {
                        // empty catch block
                    }
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Using naming service for lookup of [" + ip + "]");
                }
                return this._context.namingService().lookup(ip);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Creating Destination for [" + ip + "]");
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Creating Destination for [" + ip + "]");
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public String lookup(String name) {
        Destination dest = this.getDestination(name);
        if (dest == null) {
            return null;
        }
        return dest.toBase64();
    }

    String rewriteAnnounce(String origAnnounce) {
        int destStart = "http://".length();
        int destEnd = origAnnounce.indexOf(".i2p");
        if (destEnd < destStart + 516) {
            return origAnnounce;
        }
        int pathStart = origAnnounce.indexOf(47, destEnd);
        String rv = "http://i2p/" + origAnnounce.substring(destStart, destEnd) + origAnnounce.substring(pathStart);
        return rv;
    }

    public void setOpenTrackers(List<String> ot) {
        this._openTrackers = ot;
    }

    public List<String> getOpenTrackers() {
        if (!this.shouldUseOpenTrackers()) {
            return Collections.emptyList();
        }
        return this._openTrackers;
    }

    public boolean isKnownOpenTracker(String url) {
        try {
            URI u = new URI(url);
            String host = u.getHost();
            return host != null && SnarkManager.KNOWN_OPENTRACKERS.contains(host);
        }
        catch (URISyntaxException use) {
            return false;
        }
    }

    public List<String> getBackupTrackers() {
        return this._openTrackers;
    }

    public void setUseOpenTrackers(boolean yes) {
        this._shouldUseOT = yes;
    }

    public boolean shouldUseOpenTrackers() {
        return this._shouldUseOT;
    }

    public synchronized void setUseDHT(boolean yes) {
        this._shouldUseDHT = yes;
        if (yes && this._manager != null && this._dht == null) {
            this._dht = new KRPC(this._context, this._baseName, this._manager.getSession());
        } else if (!yes && this._dht != null) {
            this._dht.stop();
            this._dht = null;
        }
    }

    public boolean shouldUseDHT() {
        return this._shouldUseDHT;
    }

    public void setRatingsEnabled(boolean yes) {
        this._enableRatings = yes;
    }

    public boolean ratingsEnabled() {
        return this._enableRatings;
    }

    public void setCommentsEnabled(boolean yes) {
        this._enableComments = yes;
    }

    public boolean commentsEnabled() {
        return this._enableComments;
    }

    public void setCommentsName(String name) {
        this._commentsName = name;
    }

    public String getCommentsName() {
        return this._commentsName == null ? "" : this._commentsName;
    }

    public boolean utCommentsEnabled() {
        return this._enableRatings || this._enableComments;
    }

    public boolean collapsePanels() {
        return this._collapsePanels;
    }

    public void setCollapsePanels(boolean yes) {
        this._collapsePanels = yes;
    }

    public boolean showStatusFilter() {
        return this._showStatusFilter;
    }

    public void setShowStatusFilter(boolean yes) {
        this._showStatusFilter = yes;
    }

    public boolean enableLightbox() {
        return this._enableLightbox;
    }

    public void setEnableLightbox(boolean yes) {
        this._enableLightbox = yes;
    }

    public boolean enableAddCreate() {
        return this._enableAddCreate;
    }

    public void setEnableAddCreate(boolean yes) {
        this._enableAddCreate = yes;
    }

    public boolean enableVaryInboundHops() {
        return this._varyInboundHops;
    }

    public boolean enableVaryOutboundHops() {
        return this._varyOutboundHops;
    }

    public void setEnableVaryInboundHops(boolean yes) {
        this._varyInboundHops = yes;
    }

    public void setEnableVaryOutboundHops(boolean yes) {
        this._varyOutboundHops = yes;
    }

    public static String toHex(byte[] b) {
        StringBuilder buf = new StringBuilder(40);
        for (int i = 0; i < b.length; ++i) {
            int bi = b[i] & 0xFF;
            if (bi < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(bi));
        }
        return buf.toString();
    }

    public String getString(String key) {
        return Translate.getString(key, this._context, BUNDLE_NAME);
    }

    public String getString(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    public String getString(String s, Object o, Object o2) {
        return Translate.getString(s, o, o2, this._context, BUNDLE_NAME);
    }

    public String getString(int n, String s, String p) {
        return Translate.getString(n, s, p, this._context, BUNDLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadProps(Properties props, File f) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"), 1024);
            String line = null;
            while ((line = in.readLine()) != null) {
                int split;
                if (line.trim().length() <= 0 || line.charAt(0) == '#' || line.charAt(0) == ';' || (split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                String val = line.substring(split + 1).trim();
                props.setProperty(key, val);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeProps(Properties props, File file) throws IOException {
        SecureFileOutputStream fos = null;
        PrintWriter out = null;
        IOException ioe = null;
        File tmpFile = new File(file.getPath() + ".tmp");
        try {
            fos = new SecureFileOutputStream(tmpFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")));
            out.println("# NOTE: This I2P config file must use UTF-8 encoding");
            out.println("# Last saved: " + DataHelper.formatTime(System.currentTimeMillis()));
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (ILLEGAL_KEY.matcher(name).find()) {
                    if (ioe != null) continue;
                    ioe = new IOException("Invalid character (one of \"#;=\\r\\n\") in key: \"" + name + "\" = \"" + val + '\"');
                    continue;
                }
                if (ILLEGAL_VALUE.matcher(val).find()) {
                    if (ioe != null) continue;
                    ioe = new IOException("Invalid character (one of \"\\r\\n\") in value: \"" + name + "\" = \"" + val + '\"');
                    continue;
                }
                out.println(name + "=" + val);
            }
            if (SHOULD_SYNC) {
                out.flush();
                fos.getFD().sync();
            }
            out.close();
            if (out.checkError()) {
                out = null;
                tmpFile.delete();
                throw new IOException("Failed to write properties to " + tmpFile);
            }
            out = null;
            if (!FileUtil.rename(tmpFile, file)) {
                throw new IOException("Failed rename from " + tmpFile + " to " + file);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private class Unbanlist
    implements SimpleTimer.TimedEvent {
        private Hash _dest;

        public Unbanlist(Hash dest) {
            this._dest = dest;
        }

        @Override
        public void timeReached() {
            I2PSnarkUtil.this._banlist.remove(this._dest);
        }
    }
}

