/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.jfree.svg.FontMapper;
import org.jfree.svg.ImageElement;
import org.jfree.svg.MeetOrSlice;
import org.jfree.svg.PreserveAspectRatio;
import org.jfree.svg.SVGGraphicsConfiguration;
import org.jfree.svg.SVGHints;
import org.jfree.svg.SVGUnits;
import org.jfree.svg.SVGUtils;
import org.jfree.svg.StandardFontMapper;
import org.jfree.svg.ViewBox;
import org.jfree.svg.util.Args;
import org.jfree.svg.util.GradientPaintKey;
import org.jfree.svg.util.GraphicsUtils;
import org.jfree.svg.util.LinearGradientPaintKey;
import org.jfree.svg.util.RadialGradientPaintKey;
import org.jfree.svg.util.RyuDouble;

public final class SVGGraphics2D
extends Graphics2D {
    private static final String CLIP_KEY_PREFIX = "clip-";
    private final int width;
    private final int height;
    private final SVGUnits units;
    private String shapeRendering = "crispEdges";
    private String textRendering = "optimizeLegibility";
    private SVGUnits fontSizeUnits = SVGUnits.PX;
    private final RenderingHints hints;
    private boolean checkStrokeControlHint = true;
    private int transformDP = 0;
    private int geometryDP = 0;
    private final StringBuilder sb;
    private String defsKeyPrefix = "";
    private Map<GradientPaintKey, String> gradientPaints = new HashMap<GradientPaintKey, String>();
    private Map<LinearGradientPaintKey, String> linearGradientPaints = new HashMap<LinearGradientPaintKey, String>();
    private Map<RadialGradientPaintKey, String> radialGradientPaints = new HashMap<RadialGradientPaintKey, String>();
    private List<String> clipPaths = new ArrayList<String>();
    private String filePrefix = "image-";
    private String fileSuffix = ".png";
    private List<ImageElement> imageElements;
    private Shape clip;
    private String clipRef;
    private AffineTransform transform = new AffineTransform();
    private Paint paint = Color.BLACK;
    private Color color = Color.BLACK;
    private Composite composite = AlphaComposite.getInstance(3, 1.0f);
    private Stroke stroke = new BasicStroke(1.0f);
    private double zeroStrokeWidth;
    private Font font = new Font("SansSerif", 0, 12);
    private final FontRenderContext fontRenderContext = new FontRenderContext(null, false, true);
    private FontMapper fontMapper;
    private Color background = Color.BLACK;
    private BufferedImage fmImage;
    private Graphics2D fmImageG2D;
    private Line2D line;
    Rectangle2D rect;
    private RoundRectangle2D roundRect;
    private Ellipse2D oval;
    private Arc2D arc;
    private String gradientPaintRef = null;
    private GraphicsConfiguration deviceConfiguration;
    private final Set<String> elementIDs;
    private static final String DEFAULT_STROKE_CAP = "butt";
    private static final String DEFAULT_STROKE_JOIN = "miter";
    private static final float DEFAULT_MITER_LIMIT = 4.0f;

    public SVGGraphics2D(int width, int height) {
        this(width, height, null, new StringBuilder());
    }

    public SVGGraphics2D(int width, int height, SVGUnits units) {
        this(width, height, units, new StringBuilder());
    }

    public SVGGraphics2D(int width, int height, StringBuilder sb) {
        this(width, height, null, sb);
    }

    public SVGGraphics2D(int width, int height, SVGUnits units, StringBuilder sb) {
        this.width = width;
        this.height = height;
        this.units = units;
        this.imageElements = new ArrayList<ImageElement>();
        this.fontMapper = new StandardFontMapper();
        this.zeroStrokeWidth = 0.1;
        this.sb = sb;
        this.hints = new RenderingHints(SVGHints.KEY_IMAGE_HANDLING, SVGHints.VALUE_IMAGE_HANDLING_EMBED);
        this.elementIDs = new HashSet<String>();
    }

    private SVGGraphics2D(SVGGraphics2D parent) {
        this(parent.width, parent.height, parent.units, parent.sb);
        this.shapeRendering = parent.shapeRendering;
        this.textRendering = parent.textRendering;
        this.fontMapper = parent.fontMapper;
        this.getRenderingHints().add(parent.hints);
        this.checkStrokeControlHint = parent.checkStrokeControlHint;
        this.setTransformDP(parent.transformDP);
        this.setGeometryDP(parent.geometryDP);
        this.defsKeyPrefix = parent.defsKeyPrefix;
        this.gradientPaints = parent.gradientPaints;
        this.linearGradientPaints = parent.linearGradientPaints;
        this.radialGradientPaints = parent.radialGradientPaints;
        this.clipPaths = parent.clipPaths;
        this.filePrefix = parent.filePrefix;
        this.fileSuffix = parent.fileSuffix;
        this.imageElements = parent.imageElements;
        this.zeroStrokeWidth = parent.zeroStrokeWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public SVGUnits getUnits() {
        return this.units;
    }

    public String getShapeRendering() {
        return this.shapeRendering;
    }

    public void setShapeRendering(String value) {
        if (!(value.equals("auto") || value.equals("crispEdges") || value.equals("geometricPrecision") || value.equals("optimizeSpeed"))) {
            throw new IllegalArgumentException("Unrecognised value: " + value);
        }
        this.shapeRendering = value;
    }

    public String getTextRendering() {
        return this.textRendering;
    }

    public void setTextRendering(String value) {
        if (!(value.equals("auto") || value.equals("optimizeSpeed") || value.equals("optimizeLegibility") || value.equals("geometricPrecision"))) {
            throw new IllegalArgumentException("Unrecognised value: " + value);
        }
        this.textRendering = value;
    }

    public boolean getCheckStrokeControlHint() {
        return this.checkStrokeControlHint;
    }

    public void setCheckStrokeControlHint(boolean check) {
        this.checkStrokeControlHint = check;
    }

    public String getDefsKeyPrefix() {
        return this.defsKeyPrefix;
    }

    public void setDefsKeyPrefix(String prefix) {
        Args.nullNotPermitted(prefix, "prefix");
        this.defsKeyPrefix = prefix;
    }

    public int getTransformDP() {
        return this.transformDP;
    }

    public void setTransformDP(int dp) {
        this.transformDP = dp;
    }

    public int getGeometryDP() {
        return this.geometryDP;
    }

    public void setGeometryDP(int dp) {
        this.geometryDP = dp;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String prefix) {
        Args.nullNotPermitted(prefix, "prefix");
        this.filePrefix = prefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String suffix) {
        Args.nullNotPermitted(suffix, "suffix");
        this.fileSuffix = suffix;
    }

    public double getZeroStrokeWidth() {
        return this.zeroStrokeWidth;
    }

    public void setZeroStrokeWidth(double width) {
        if (width < 0.0) {
            throw new IllegalArgumentException("Width cannot be negative.");
        }
        this.zeroStrokeWidth = width;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.deviceConfiguration == null) {
            this.deviceConfiguration = new SVGGraphicsConfiguration(this.width, this.height);
        }
        return this.deviceConfiguration;
    }

    @Override
    public Graphics create() {
        SVGGraphics2D copy = new SVGGraphics2D(this);
        copy.setRenderingHints(this.getRenderingHints());
        copy.setTransform(this.getTransform());
        copy.setClip(this.getClip());
        copy.setPaint(this.getPaint());
        copy.setColor(this.getColor());
        copy.setComposite(this.getComposite());
        copy.setStroke(this.getStroke());
        copy.setFont(this.getFont());
        copy.setBackground(this.getBackground());
        copy.setFilePrefix(this.getFilePrefix());
        copy.setFileSuffix(this.getFileSuffix());
        return copy;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        RadialGradientPaint rgp;
        RadialGradientPaintKey key;
        String ref;
        if (paint == null) {
            return;
        }
        this.paint = paint;
        this.gradientPaintRef = null;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            GradientPaintKey key2 = new GradientPaintKey(gp);
            String ref2 = this.gradientPaints.get(key2);
            if (ref2 == null) {
                int count = this.gradientPaints.keySet().size();
                String id = this.defsKeyPrefix + "gp" + count;
                this.elementIDs.add(id);
                this.gradientPaints.put(key2, id);
                this.gradientPaintRef = id;
            } else {
                this.gradientPaintRef = ref2;
            }
        } else if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint lgp = (LinearGradientPaint)paint;
            LinearGradientPaintKey key3 = new LinearGradientPaintKey(lgp);
            String ref3 = this.linearGradientPaints.get(key3);
            if (ref3 == null) {
                int count = this.linearGradientPaints.keySet().size();
                String id = this.defsKeyPrefix + "lgp" + count;
                this.elementIDs.add(id);
                this.linearGradientPaints.put(key3, id);
                this.gradientPaintRef = id;
            }
        } else if (paint instanceof RadialGradientPaint && (ref = this.radialGradientPaints.get(key = new RadialGradientPaintKey(rgp = (RadialGradientPaint)paint))) == null) {
            int count = this.radialGradientPaints.keySet().size();
            String id = this.defsKeyPrefix + "rgp" + count;
            this.elementIDs.add(id);
            this.radialGradientPaints.put(key, id);
            this.gradientPaintRef = id;
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        if (c == null) {
            return;
        }
        this.color = c;
        this.paint = c;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setComposite(Composite comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Null 'comp' argument.");
        }
        this.composite = comp;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke s) {
        if (s == null) {
            throw new IllegalArgumentException("Null 's' argument.");
        }
        this.stroke = s;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (hintKey == null) {
            throw new NullPointerException("Null 'hintKey' not permitted.");
        }
        if (SVGHints.isBeginGroupKey(hintKey)) {
            String groupId = null;
            String ref = null;
            ArrayList otherKeysAndValues = null;
            if (hintValue instanceof String) {
                groupId = (String)hintValue;
            } else if (hintValue instanceof Map) {
                Map hintValueMap = (Map)hintValue;
                groupId = (String)hintValueMap.get("id");
                ref = (String)hintValueMap.get("ref");
                for (Map.Entry obj : hintValueMap.entrySet()) {
                    Map.Entry e = obj;
                    Object key = e.getKey();
                    if ("id".equals(key) || "ref".equals(key)) continue;
                    if (otherKeysAndValues == null) {
                        otherKeysAndValues = new ArrayList();
                    }
                    otherKeysAndValues.add(e);
                }
            }
            this.sb.append("<g");
            if (groupId != null) {
                if (this.elementIDs.contains(groupId)) {
                    throw new IllegalArgumentException("The group id (" + groupId + ") is not unique.");
                }
                this.sb.append(" id=\"").append(groupId).append("\"");
                this.elementIDs.add(groupId);
            }
            if (ref != null) {
                this.sb.append(" jfreesvg:ref=\"");
                this.sb.append(SVGUtils.escapeForXML(ref)).append("\"");
            }
            if (otherKeysAndValues != null) {
                for (Map.Entry entry : otherKeysAndValues) {
                    this.sb.append(" ").append(entry.getKey()).append("=\"").append(SVGUtils.escapeForXML(String.valueOf(entry.getValue()))).append("\"");
                }
            }
            this.sb.append(">");
        } else if (SVGHints.isEndGroupKey(hintKey)) {
            this.sb.append("</g>\n");
        } else if (SVGHints.isElementTitleKey(hintKey) && hintValue != null) {
            this.sb.append("<title>").append(SVGUtils.escapeForXML(String.valueOf(hintValue))).append("</title>");
        } else {
            this.hints.put(hintKey, hintValue);
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.clear();
        this.addRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    private void appendOptionalElementIDFromHint(StringBuilder sb) {
        String elementID = (String)this.hints.get(SVGHints.KEY_ELEMENT_ID);
        if (elementID != null) {
            this.hints.put(SVGHints.KEY_ELEMENT_ID, (Object)null);
            if (this.elementIDs.contains(elementID)) {
                throw new IllegalStateException("The element id " + elementID + " is already used.");
            }
            this.elementIDs.add(elementID);
            this.sb.append("id=\"").append(elementID).append("\" ");
        }
    }

    @Override
    public void draw(Shape s) {
        if (!(this.stroke instanceof BasicStroke)) {
            this.fill(this.stroke.createStrokedShape(s));
            return;
        }
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            String x1 = this.geomDP(l.getX1());
            String x2 = this.geomDP(l.getX2());
            String y1 = this.geomDP(l.getY1());
            String y2 = this.geomDP(l.getY2());
            if (!this.strokeStyle().contains("stroke-opacity:0;") && !this.strokeStyle().contains("stroke-width:0.1;")) {
                this.sb.append("<line ");
                this.appendOptionalElementIDFromHint(this.sb);
                this.sb.append("x1=\"").append(x1).append("\" y1=\"").append(y1).append("\" x2=\"").append(x2).append("\" y2=\"").append(y2).append("\" style=\"").append(this.strokeStyle()).append("\" ");
                if (!this.transform.isIdentity()) {
                    this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
                }
                this.sb.append(this.getClipPathRef()).append("/>");
            }
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (!this.strokeStyle().contains("fill-opacity:0\"")) {
                this.sb.append("<rect ");
                this.appendOptionalElementIDFromHint(this.sb);
                this.sb.append("x=\"").append(this.geomDP(r.getX())).append("\" y=\"").append(this.geomDP(r.getY())).append("\" width=\"").append(this.geomDP(r.getWidth())).append("\" height=\"").append(this.geomDP(r.getHeight())).append("\" ").append("style=\"").append(this.strokeStyle()).append("fill:none").append("\" ");
                if (!this.transform.isIdentity()) {
                    this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
                }
                this.sb.append(this.getClipPathRef());
                this.sb.append("/>");
            }
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.sb.append("<ellipse ");
            this.appendOptionalElementIDFromHint(this.sb);
            this.sb.append("cx=\"").append(this.geomDP(e.getCenterX())).append("\" cy=\"").append(this.geomDP(e.getCenterY())).append("\" rx=\"").append(this.geomDP(e.getWidth() / 2.0)).append("\" ry=\"").append(this.geomDP(e.getHeight() / 2.0)).append("\" ").append("style=\"").append(this.strokeStyle()).append("fill:none").append("\" ");
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            }
            this.sb.append(this.getClipPathRef());
            this.sb.append("/>");
        } else if (s instanceof Path2D) {
            Path2D path = (Path2D)s;
            this.sb.append("<g ");
            this.appendOptionalElementIDFromHint(this.sb);
            this.sb.append("style=\"").append(this.strokeStyle()).append("fill:none").append("\" ");
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            }
            this.sb.append(this.getClipPathRef()).append(">").append("<path ").append(this.getSVGPathData(path)).append("/>").append("</g>");
        } else {
            this.draw(new GeneralPath(s));
        }
    }

    @Override
    public void fill(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (r.isEmpty()) {
                return;
            }
            this.sb.append("<rect ");
            this.appendOptionalElementIDFromHint(this.sb);
            this.sb.append("x=\"").append(this.geomDP(r.getX())).append("\" y=\"").append(this.geomDP(r.getY())).append("\" width=\"").append(this.geomDP(r.getWidth())).append("\" height=\"").append(this.geomDP(r.getHeight())).append("\" ");
            this.sb.append("style=\"").append(this.getSVGFillStyle()).append("\" ");
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            }
            this.sb.append(this.getClipPathRef()).append("/>");
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.sb.append("<ellipse ");
            this.appendOptionalElementIDFromHint(this.sb);
            this.sb.append("cx=\"").append(this.geomDP(e.getCenterX())).append("\" cy=\"").append(this.geomDP(e.getCenterY())).append("\" rx=\"").append(this.geomDP(e.getWidth() / 2.0)).append("\" ry=\"").append(this.geomDP(e.getHeight() / 2.0)).append("\" ");
            this.sb.append("style=\"").append(this.getSVGFillStyle()).append("\" ");
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            }
            this.sb.append(this.getClipPathRef());
            this.sb.append("/>");
        } else if (s instanceof Path2D) {
            Path2D path = (Path2D)s;
            this.sb.append("<g ");
            this.appendOptionalElementIDFromHint(this.sb);
            this.sb.append("style=\"").append(this.getSVGFillStyle()).append(";stroke:none").append("\" ");
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            }
            this.sb.append(this.getClipPathRef()).append(">").append("<path ").append(this.getSVGPathData(path)).append("/>").append("</g>");
        } else {
            this.fill(new GeneralPath(s));
        }
    }

    private String getSVGPathData(Path2D path) {
        StringBuilder b = new StringBuilder("d=\"");
        float[] coords = new float[6];
        boolean first = true;
        float prevX = 0.0f;
        float prevY = 0.0f;
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (first) {
                        b.append("M").append((int)coords[0]).append(" ").append((int)coords[1]);
                        prevX = coords[0];
                        prevY = coords[1];
                        first = false;
                        break;
                    }
                    b.append("m").append((int)(coords[0] - prevX)).append(" ").append((int)(coords[1] - prevY));
                    prevX = coords[0];
                    prevY = coords[1];
                    break;
                }
                case 1: {
                    b.append("l").append((int)(coords[0] - prevX)).append(" ").append((int)(coords[1] - prevY));
                    prevX = coords[0];
                    prevY = coords[1];
                    break;
                }
                case 2: {
                    b.append("q").append((int)(coords[0] - prevX)).append(" ").append((int)(coords[1] - prevY)).append(" ").append((int)(coords[2] - coords[0])).append(" ").append((int)(coords[3] - coords[1]));
                    prevX = coords[2];
                    prevY = coords[3];
                    break;
                }
                case 3: {
                    b.append("c").append((int)(coords[0] - prevX)).append(" ").append((int)(coords[1] - prevY)).append(" ").append((int)(coords[2] - coords[0])).append(" ").append((int)(coords[3] - coords[1])).append(" ").append((int)(coords[4] - coords[2])).append(" ").append((int)(coords[5] - coords[3]));
                    prevX = coords[4];
                    prevY = coords[5];
                    break;
                }
                case 4: {
                    if (!first) {
                        b.append("L").append((int)coords[0]).append(" ").append((int)coords[1]);
                    }
                    b.append("Z");
                    break;
                }
            }
            iterator.next();
        }
        return b.append("\"").toString();
    }

    private float getAlpha() {
        float alpha = 1.0f;
        if (this.composite instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)this.composite;
            alpha = ac.getAlpha();
        }
        return alpha;
    }

    private String svgColorStr() {
        String result = "black;";
        if (this.paint instanceof Color) {
            return this.rgbColorStr((Color)this.paint);
        }
        if (this.paint instanceof GradientPaint || this.paint instanceof LinearGradientPaint || this.paint instanceof RadialGradientPaint) {
            return "url(#" + this.gradientPaintRef + ")";
        }
        return result;
    }

    private String rgbColorStr(Color c) {
        StringBuilder b = new StringBuilder("rgb(");
        b.append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue()).append(")");
        return b.toString();
    }

    private String rgbaColorStr(Color c) {
        StringBuilder b = new StringBuilder("rgba(");
        double alphaPercent = (double)c.getAlpha() / 255.0;
        b.append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue());
        b.append(",").append(this.transformDP(alphaPercent));
        b.append(")");
        return b.toString();
    }

    private String strokeStyle() {
        double strokeWidth = 1.0;
        String strokeCap = DEFAULT_STROKE_CAP;
        String strokeJoin = DEFAULT_STROKE_JOIN;
        float miterLimit = 4.0f;
        float[] dashArray = new float[]{};
        DecimalFormat df = new DecimalFormat("#.##");
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            strokeWidth = (double)bs.getLineWidth() > 0.0 ? (double)bs.getLineWidth() : this.zeroStrokeWidth;
            switch (bs.getEndCap()) {
                case 1: {
                    strokeCap = "round";
                    break;
                }
                case 2: {
                    strokeCap = "square";
                    break;
                }
            }
            switch (bs.getLineJoin()) {
                case 2: {
                    strokeJoin = "bevel";
                    break;
                }
                case 1: {
                    strokeJoin = "round";
                    break;
                }
            }
            miterLimit = bs.getMiterLimit();
            dashArray = bs.getDashArray();
        }
        StringBuilder b = new StringBuilder();
        if (strokeWidth != 1.0) {
            b.append("stroke-width:").append(strokeWidth).append(";");
        }
        if (!this.stroke.equals("rgb(0,0,0)")) {
            b.append("stroke:").append(this.svgColorStr()).append(";");
        }
        if (!df.format(this.getColorAlpha() * this.getAlpha()).equals("1")) {
            b.append("stroke-opacity:").append(df.format(this.getColorAlpha() * this.getAlpha())).append(";");
        }
        if (!strokeCap.equals(DEFAULT_STROKE_CAP)) {
            b.append("stroke-linecap:").append(strokeCap).append(";");
        }
        if (!strokeJoin.equals(DEFAULT_STROKE_JOIN)) {
            b.append("stroke-linejoin:").append(strokeJoin).append(";");
        }
        if ((double)Math.abs(4.0f - miterLimit) < 0.001) {
            b.append("stroke-miterlimit:").append(this.geomDP(miterLimit));
        }
        if (dashArray != null && dashArray.length != 0) {
            b.append("stroke-dasharray:");
            for (int i = 0; i < dashArray.length; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append(dashArray[i]);
            }
            b.append(";");
        }
        if (this.checkStrokeControlHint) {
            Object hint = this.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            if (RenderingHints.VALUE_STROKE_NORMALIZE.equals(hint) && !this.shapeRendering.equals("crispEdges")) {
                b.append("shape-rendering:crispEdges;");
            }
            if (RenderingHints.VALUE_STROKE_PURE.equals(hint) && !this.shapeRendering.equals("geometricPrecision")) {
                b.append("shape-rendering:geometricPrecision;");
            }
        }
        return b.toString();
    }

    private float getColorAlpha() {
        if (this.paint instanceof Color) {
            Color c = (Color)this.paint;
            return (float)c.getAlpha() / 255.0f;
        }
        return 1.0f;
    }

    private String getSVGFillStyle() {
        DecimalFormat df = new DecimalFormat("#.##");
        StringBuilder b = new StringBuilder();
        b.append("fill:").append(this.svgColorStr()).append(";");
        b.append("fill-opacity:").append(df.format(this.getColorAlpha() * this.getAlpha()));
        return b.toString();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
    }

    public FontMapper getFontMapper() {
        return this.fontMapper;
    }

    public void setFontMapper(FontMapper mapper) {
        Args.nullNotPermitted(mapper, "mapper");
        this.fontMapper = mapper;
    }

    public SVGUnits getFontSizeUnits() {
        return this.fontSizeUnits;
    }

    public void setFontSizeUnits(SVGUnits fontSizeUnits) {
        Args.nullNotPermitted((Object)fontSizeUnits, "fontSizeUnits");
        this.fontSizeUnits = fontSizeUnits;
    }

    private String getSVGFontStyle() {
        DecimalFormat df = new DecimalFormat("#.##");
        StringBuilder b = new StringBuilder();
        b.append("fill:").append(this.svgColorStr()).append(";");
        b.append("fill-opacity:").append(df.format(this.getColorAlpha() * this.getAlpha())).append(";");
        String fontFamily = this.fontMapper.mapFont(this.font.getFamily());
        b.append("font-family:").append(fontFamily).append(";");
        b.append("font-size:").append(this.font.getSize()).append((Object)this.fontSizeUnits).append(";");
        if (this.font.isBold()) {
            b.append(" font-weight:bold;");
        }
        if (this.font.isItalic()) {
            b.append(" font-style:italic;");
        }
        return b.toString();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        if (this.fmImage == null) {
            this.fmImage = new BufferedImage(10, 10, 1);
            this.fmImageG2D = this.fmImage.createGraphics();
            this.fmImageG2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return this.fmImageG2D.getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        if (str.isEmpty()) {
            return;
        }
        if (!SVGHints.VALUE_DRAW_STRING_TYPE_VECTOR.equals(this.hints.get(SVGHints.KEY_DRAW_STRING_TYPE))) {
            this.sb.append("<g ");
            this.appendOptionalElementIDFromHint(this.sb);
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\"");
            }
            this.sb.append("style=\"").append(this.getSVGFontStyle()).append("\"").append(" ").append(this.getClipPathRef()).append(">").append("<text ");
            if (str.endsWith("UTC")) {
                this.sb.append("id=\"date\" ");
            }
            this.sb.append("x=\"").append(this.geomDP(x)).append("\" y=\"").append(this.geomDP(y)).append("\">").append(SVGUtils.escapeForXML(str).replace("Min:", "<tspan class=\"bold\">Min:</tspan>").replace("Avg:", "<tspan class=\"bold\">Avg:</tspan>").replace("Max:", "<tspan class=\"bold\">Max:</tspan>").replace("Now:", "<tspan class=\"bold\">Now:</tspan>"));
            this.sb.append("</text>").append("</g>");
        } else {
            AttributedString as = new AttributedString(str, this.font.getAttributes());
            this.drawString(as.getIterator(), x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        Set<AttributedCharacterIterator.Attribute> s = iterator.getAllAttributeKeys();
        if (!s.isEmpty()) {
            TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
            layout.draw(this, x, y);
        } else {
            StringBuilder strb = new StringBuilder();
            iterator.first();
            for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
                strb.append(iterator.current());
                iterator.next();
            }
            this.drawString(strb.toString(), x, y);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    @Override
    public void translate(int tx, int ty) {
        this.translate((double)tx, (double)ty);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform t = this.getTransform();
        t.translate(tx, ty);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform t = this.getTransform();
        t.rotate(theta);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform t = this.getTransform();
        t.scale(sx, sy);
        this.setTransform(t);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    @Override
    public void transform(AffineTransform t) {
        AffineTransform tx = this.getTransform();
        tx.concatenate(t);
        this.setTransform(tx);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.transform = t == null ? new AffineTransform() : new AffineTransform(t);
        this.clipRef = null;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape ts = onStroke ? this.transform.createTransformedShape(this.stroke.createStrokedShape(s)) : this.transform.createTransformedShape(s);
        if (!rect.getBounds2D().intersects(ts.getBounds2D())) {
            return false;
        }
        Area a1 = new Area(rect);
        Area a2 = new Area(ts);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c) {
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        try {
            AffineTransform inv = this.transform.createInverse();
            return inv.createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = this.transform.createTransformedShape(shape);
        this.clipRef = null;
    }

    private String registerClip(Shape clip) {
        if (clip == null) {
            this.clipRef = null;
            return null;
        }
        String pathStr = this.getSVGPathData(new Path2D.Double(clip));
        int index = this.clipPaths.indexOf(pathStr);
        if (index < 0) {
            this.clipPaths.add(pathStr);
            index = this.clipPaths.size() - 1;
        }
        return CLIP_KEY_PREFIX + index;
    }

    private String transformDP(double d) {
        return RyuDouble.doubleToString(d, this.transformDP);
    }

    private String geomDP(double d) {
        return RyuDouble.doubleToString(d, this.geometryDP);
    }

    private String getSVGTransform(AffineTransform t) {
        StringBuilder b = new StringBuilder("matrix(");
        b.append(this.transformDP(t.getScaleX())).append(",").append(this.transformDP(t.getShearY())).append(",").append(this.transformDP(t.getShearX())).append(",").append(this.transformDP(t.getScaleY())).append(",").append(this.transformDP(t.getTranslateX())).append(",").append(this.transformDP(t.getTranslateY())).append(")");
        return b.toString();
    }

    @Override
    public void clip(Shape s) {
        if (s instanceof Line2D) {
            s = s.getBounds2D();
        }
        if (this.clip == null) {
            this.setClip(s);
            return;
        }
        Shape ts = this.transform.createTransformedShape(s);
        if (!ts.intersects(this.clip.getBounds2D())) {
            this.setClip(new Rectangle2D.Double());
        } else {
            Area a1 = new Area(ts);
            Area a2 = new Area(this.clip);
            a1.intersect(a2);
            this.clip = new Path2D.Double(a1);
        }
        this.clipRef = null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.clip(this.rect);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.setClip(this.rect);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.line == null) {
            this.line = new Line2D.Double(x1, y1, x2, y2);
        } else {
            this.line.setLine(x1, y1, x2, y2);
        }
        this.draw(this.line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.fill(this.rect);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() == null) {
            return;
        }
        Paint saved = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.draw(this.roundRect);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.fill(this.roundRect);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.draw(this.oval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.fill(this.oval);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.draw(this.arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.fill(this.arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, false);
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill(p);
    }

    private byte[] getPNGBytes(Image img) {
        RenderedImage ri;
        Args.nullNotPermitted(img, "img");
        if (img instanceof RenderedImage) {
            ri = (RenderedImage)((Object)img);
        } else {
            BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(img, 0, 0, null);
            ri = bi;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write(ri, "png", baos);
        }
        catch (IOException ex) {
            System.err.println("IOException while writing PNG data (" + ex.getMessage() + ")");
        }
        return baos.toByteArray();
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int w = img.getWidth(observer);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(observer);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        Object hint = this.getRenderingHint(SVGHints.KEY_IMAGE_HANDLING);
        if (SVGHints.VALUE_IMAGE_HANDLING_EMBED.equals(hint)) {
            this.sb.append("<image ");
            this.appendOptionalElementIDFromHint(this.sb);
            this.sb.append("preserveAspectRatio=\"none\" ").append("href=\"data:image/png;base64,").append(Base64.getEncoder().encodeToString(this.getPNGBytes(img))).append("\" ").append(this.getClipPathRef()).append(" ");
            if (!this.transform.isIdentity()) {
                this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            }
            this.sb.append("x=\"").append(this.geomDP(x)).append("\" y=\"").append(this.geomDP(y)).append("\" ").append("width=\"").append(this.geomDP(w)).append("\" height=\"").append(this.geomDP(h)).append("\"/>\n");
            return true;
        }
        int count = this.imageElements.size();
        String href = (String)this.hints.get(SVGHints.KEY_IMAGE_HREF);
        if (href == null) {
            href = this.filePrefix + count + this.fileSuffix;
        } else {
            this.hints.put(SVGHints.KEY_IMAGE_HREF, (Object)null);
        }
        ImageElement imageElement = new ImageElement(href, img);
        this.imageElements.add(imageElement);
        this.sb.append("<image ");
        this.appendOptionalElementIDFromHint(this.sb);
        this.sb.append("href=\"").append(href).append("\" ").append(this.getClipPathRef()).append(" ");
        if (!this.transform.isIdentity()) {
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
        }
        this.sb.append("x=\"").append(this.geomDP(x)).append("\" y=\"").append(this.geomDP(y)).append("\" ").append("width=\"").append(this.geomDP(w)).append("\" height=\"").append(this.geomDP(h)).append("\"/>\n");
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(x, y, w, h);
        this.setPaint(saved);
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int w = dx2 - dx1;
        int h = dy2 - dy1;
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics2D g2 = img2.createGraphics();
        g2.drawImage(img, 0, 0, w, h, sx1, sy1, sx2, sy2, null);
        return this.drawImage((Image)img2, dx1, dy1, null);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.setPaint(saved);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        BufferedImage bi = GraphicsUtils.convertRenderedImage(img);
        this.drawImage(bi, xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        RenderedImage ri = img.createDefaultRendering();
        this.drawRenderedImage(ri, xform);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform savedTransform = this.getTransform();
        if (xform != null) {
            this.transform(xform);
        }
        boolean result = this.drawImage(img, 0, 0, obs);
        if (xform != null) {
            this.setTransform(savedTransform);
        }
        return result;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage imageToDraw = img;
        if (op != null) {
            imageToDraw = op.filter(img, null);
        }
        this.drawImage(imageToDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void dispose() {
    }

    public String getSVGElement() {
        return this.getSVGElement(null);
    }

    public String getSVGElement(String id) {
        return this.getSVGElement(id, true, null, null, null);
    }

    public String getSVGElement(String id, boolean includeDimensions, ViewBox viewBox, PreserveAspectRatio preserveAspectRatio, MeetOrSlice meetOrSlice) {
        int axisStrokeWidth;
        StringBuilder svg = new StringBuilder("<svg ");
        String unitStr = this.units != null ? this.units.toString() : "";
        svg.append("xmlns=\"http://www.w3.org/2000/svg\" ");
        boolean isLarge = false;
        if (this.width >= 600 && this.height >= 200) {
            isLarge = true;
        }
        int n = axisStrokeWidth = isLarge ? 2 : 1;
        if (includeDimensions) {
            svg.append("width=\"").append(this.width).append(unitStr).append("\" height=\"").append(this.height).append(unitStr).append("\" ").append("viewBox=\"0 0 ").append(this.width).append(" ").append(this.height).append("\"");
        }
        svg.append(">");
        StringBuilder defs = new StringBuilder("<defs>");
        for (int i = 0; i < this.clipPaths.size(); ++i) {
            if (i == 1) continue;
            StringBuilder b = new StringBuilder("<clipPath id=\"").append(CLIP_KEY_PREFIX).append(i).append("\">");
            b.append("<path ").append(this.clipPaths.get(i)).append("/>").append("</clipPath>");
            defs.append(b.toString());
        }
        if (this.sb.indexOf("rgb(0,72,8)") != -1) {
            defs.append("<linearGradient id=\"dark\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"100%\">").append("<stop offset=\"0\" style=\"stop-color:#00660add\"/>").append("<stop offset=\"100%\" style=\"stop-color:#003d06dd\"/>").append("</linearGradient>");
        } else if (this.sb.indexOf("rgb(100,160,200)") != -1) {
            defs.append("<linearGradient id=\"light\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"100%\">").append("<stop offset=\"0\" style=\"stop-color:#a1c5ded0\"/>").append("<stop offset=\"100%\" style=\"stop-color:#7baed1d0\"/>").append("</linearGradient>");
        } else if (this.sb.indexOf("rgb(0,72,160)") != -1) {
            defs.append("<linearGradient id=\"midnight\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"100%\">").append("<stop offset=\"0\" style=\"stop-color:#338fffd0\"/>").append("<stop offset=\"100%\" style=\"stop-color:#0050b3d0\"/>").append("</linearGradient>");
        }
        defs.append("<link xmlns=\"http://www.w3.org/1999/xhtml\" rel=\"stylesheet\" type=\"text/css\" href=\"/themes/fonts/OpenSans.css\"/>");
        defs.append("<link xmlns=\"http://www.w3.org/1999/xhtml\" rel=\"stylesheet\" type=\"text/css\" href=\"/themes/fonts/FiraCode.css\"/>");
        defs.append("<style>text{font-weight:600;text-rendering:optimizeLegibility;white-space:pre}").append("line,path,rect{shape-rendering:crispEdges;vector-effect:non-scaling-stroke}").append("line,rect,text{clip-path:url(#clip-1)}").append(".axis{stroke-width:").append(axisStrokeWidth).append(";stroke-linecap:round}").append(".bg{fill:#000b}").append(".bold,.sans.s12 text,.sans.s13 text,.sans.s14 text{font-weight:700}").append(".dash{stroke-opacity:.2;stroke-linecap:round;stroke-linejoin:round;stroke-dasharray:1,1}").append(".line{stroke-opacity:.2;stroke-linecap:square}").append(".mono{font-family:FiraCode,monospace;font-weight:500}").append(".restart{stroke:#dc1030}").append(".sans{font-family:Open Sans,Segoe UI,Noto Sans,sans-serif}").append(".s10{font-size:10px}").append(".s11{font-size:11px}").append(".s12{font-size:12px}").append(".s13{font-size:13px}").append(".s14{font-size:14px}").append("#date{font-style:italic}");
        if (this.sb.indexOf("rgb(0,72,8)") != -1) {
            defs.append(".major{stroke:#f4f4be30}").append(".minor{stroke:#c8c80028}");
        } else if (this.sb.indexOf("201,206,255") != -1) {
            defs.append(".major{stroke:#d260bf30}").append(".minor{stroke:#c9ceff28}").append("#graph{stroke:#1a81ffbb}");
        }
        defs.append("</style></defs>");
        svg.append((CharSequence)defs);
        svg.append((CharSequence)this.sb);
        svg.append("</svg>");
        String svgOut = svg.toString().replace(";fill-opacity:1", "").replace("stroke-dasharray:1.0,1.0", "stroke-dasharray:1,1").replace("<g >", "<g>").replace(":0.", ":.").replace(";\"", "\"").replace(".0 ", " ").replace(".0\"", "\"").replace(";stroke-opacity:.2;stroke-linecap:round;stroke-linejoin:round;stroke-dasharray:1,1\"", "\" class=\"dash\"").replace(";stroke-opacity:.2;stroke-linecap:square\"", "\" class=\"line\"").replace("fill-opacity:0\" /><g style=\"fill", "fill-opacity:0\"/><g id=\"graph\" style=\"fill").replace("style=\"fill:rgb(0,72,8);fill-opacity:.86;stroke:none\"", "fill=\"url(#dark)\"").replace("style=\"fill:rgb(100,160,200);fill-opacity:.78;stroke:none\"", "fill=\"url(#light)\"").replace("style=\"fill:rgb(0,72,160);fill-opacity:.78;stroke:none\"", "fill=\"url(#midnight)\"").replace("stroke:rgb(0,72,8)", "stroke:#00800da0").replace("stroke:rgb(0,30,110)", "stroke:#003de6a0;fill:none").replace("stroke:rgb(100,160,200);stroke-opacity:.78;", "stroke:#4da3cb99;").replaceAll("/></g><g (style=\"stroke:.*?\").*?</g>", " $1/></g>").replace("stroke-linecap:square;fill:none", "stroke-linecap:square").replace("stroke-opacity:.86;stroke-linecap:square", "stroke-linecap:square").replace(");stroke-linecap:square", ");stroke-linecap:square;fill:none").replace("stroke-width:3.0", "stroke-width:3;fill:none").replaceAll(" style=\"stroke-width:5.*?\"", " class=\"axis\"").replace("stroke:rgb(100,200,160);stroke-linecap:square", "stroke:#64c8a0cc;stroke-linecap:square;fill:none").replace("stroke:#00800da0;stroke-linecap:square\" /></g><g style=\"stroke-width:3", "stroke:none;stroke-linecap:square\"/></g><g style=\"stroke-width:3").replace("<rect x=\"0\" y=\"0\" width=\"250\" height=\"50\" style=\"fill:rgb(0,0,0);fill-opacity:0\" />", "").replace(";stroke-linecap:square", "").replace("fill:rgb(0,0,0);fill-opacity:0;stroke:none", "opacity:0").replace("fill:none;fill:none", "fill:none").replace(" style=\"stroke:rgb(0,0,0);stroke-opacity:0\"", "").replace(";stroke-linecap:round;stroke-linejoin:round;stroke-dasharray:1,1\"", "\" class=\"dash\"").replace("style=\"stroke:rgb(220,16,48);fill:none\"", "class=\"restart\"").replace(" clip-path=\"url(#clip-2)\"", "").replace(" L ", "L");
        if (svgOut.indexOf("80,80,80") != -1) {
            svgOut = svgOut.replace(".axis{", ".axis{stroke:#33333f;").replace(".dash{", ".dash{stroke:#444;").replace(".line{", ".line{stroke:#444;").replace("text{", "text{fill:#33333f;").replace("style=\"stroke:rgb(80,80,80)\" ", "").replace("fill:rgb(51,51,63);", "");
        } else if (svgOut.indexOf("244,244,190") != -1) {
            svgOut = svgOut.replace(".axis{", ".axis{stroke:#beca95;").replace(".dash{", ".dash{stroke:#f4f4be;").replace(".line{", ".line{stroke:#f4f4be;").replace("text{", "text{fill:#f4f4be;").replace("style=\"stroke:rgb(244,244,190)\" ", "").replace("fill:rgb(244,244,190);", "").replaceAll("<g style=\"opacity:0\".*?</g>", "").replace(" clip-path=\"url(#clip-1)\"", "").replace(" style=\"stroke:rgb(244,244,190);stroke-opacity:.12\" class=\"dash\"", " class=\"dash minor\"").replace(" style=\"stroke:rgb(200,200,0)\" class=\"dash\"", " class=\"dash major\"").replace("fill:rgb(0,0,0);fill-opacity:0\"", "opacity:0\"").replace("style=\"fill:rgb(0,0,0);fill-opacity:.75\"", "class=\"bg\"").replace("style=\"stroke:rgb(244,244,190);stroke-opacity:.78\"", "class=\"axis\"").replace("stroke:#f4f4be;stroke-opacity:.2", "stroke:#f4f4be30");
        } else if (svgOut.indexOf("201,206,255") != -1) {
            svgOut = svgOut.replace(".axis{", ".axis{stroke:#a6b3e8;").replace("</style>", "#path2{stroke-width:2;stroke:#5af2f2aa;fill:none}</style>").replace(" style=\"stroke:rgb(0,72,160);stroke-opacity:.78\"", "").replace(" style=\"stroke-width:2.0;stroke:rgb(128,180,212);fill:none\"", " id=\"path2\"").replace(" style=\"stroke:rgb(201,206,255)\" class=\"dash\"", " class=\"dash minor\"").replace(" style=\"stroke:rgb(240,32,192);stroke-opacity:.43\" class=\"dash\"", " class=\"dash major\"");
        }
        if (svgOut.indexOf("font-family:monospace") != -1) {
            svgOut = svgOut.replace("style=\"font-family:monospace;", "class=\"mono\" style=\"");
            svgOut = svgOut.replace(" class=\"mono\" style=\"font-size:10px\"", " class=\"mono s10\"");
            svgOut = svgOut.replace(" class=\"mono\" style=\"font-size:11px\"", " class=\"mono s11\"");
            svgOut = svgOut.replace("</text></g><g class=\"mono s11\"><text", "</text><text");
        }
        if (svgOut.indexOf("font-family:sans-serif") != -1) {
            svgOut = svgOut.replace(" style=\"font-family:sans-serif;font-size:11px\"", " class=\"sans s11\"");
            svgOut = svgOut.replace(" style=\"font-family:sans-serif;font-size:12px\"", " class=\"sans s12\"");
            svgOut = svgOut.replace(" style=\"font-family:sans-serif;font-size:13px\"", " class=\"sans s13\"");
            svgOut = svgOut.replace(" style=\"font-family:sans-serif;font-size:14px\"", " class=\"sans s14\"");
            svgOut = svgOut.replace("</text></g><g class=\"sans s11\"><text", "</text><text");
        }
        svgOut = svgOut.replace("</text></g><g class=\"mono s11\" clip-path=\"url(#clip-2)\"><text", "</text><text").replace("</text></g><g class=\"sans s11\" clip-path=\"url(#clip-2)\"><text", "</text><text").replace("</text></g><g class=\"sans s12\" clip-path=\"url(#clip-2)\"><text", "</text><text").replace("</text></g><g class=\"mono s10\"><text", "</text><text").replace("</text></g><g class=\"mono s11\"><text", "</text><text").replace("</text></g><g class=\"sans s11\"><text", "</text><text").replace("</text></g><g class=\"sans s12\"><text", "</text><text");
        return svgOut;
    }

    public String getSVGDocument() {
        StringBuilder b = new StringBuilder();
        b.append(this.getSVGElement());
        return b.append("\n").toString();
    }

    public List<ImageElement> getSVGImages() {
        return this.imageElements;
    }

    public Set<String> getElementIDs() {
        return new HashSet<String>(this.elementIDs);
    }

    private String getLinearGradientElement(String id, GradientPaint paint) {
        StringBuilder b = new StringBuilder("<linearGradient id=\"").append(id).append("\" ");
        Point2D p1 = paint.getPoint1();
        Point2D p2 = paint.getPoint2();
        b.append("x1=\"").append(this.geomDP(p1.getX())).append("\" ").append("y1=\"").append(this.geomDP(p1.getY())).append("\" ").append("x2=\"").append(this.geomDP(p2.getX())).append("\" ").append("y2=\"").append(this.geomDP(p2.getY())).append("\" ").append("gradientUnits=\"userSpaceOnUse\">");
        Color c1 = paint.getColor1();
        b.append("<stop offset=\"0%\" stop-color=\"").append(this.rgbColorStr(c1)).append("\"");
        if (c1.getAlpha() < 255) {
            double alphaPercent = (double)c1.getAlpha() / 255.0;
            b.append(" stop-opacity=\"").append(this.transformDP(alphaPercent)).append("\"");
        }
        b.append("/>");
        Color c2 = paint.getColor2();
        b.append("<stop offset=\"100%\" stop-color=\"").append(this.rgbColorStr(c2)).append("\"");
        if (c2.getAlpha() < 255) {
            double alphaPercent = (double)c2.getAlpha() / 255.0;
            b.append(" stop-opacity=\"").append(this.transformDP(alphaPercent)).append("\"");
        }
        b.append("/>");
        return b.append("</linearGradient>").toString();
    }

    private String getLinearGradientElement(String id, LinearGradientPaint paint) {
        StringBuilder b = new StringBuilder("<linearGradient id=\"").append(id).append("\" ");
        Point2D p1 = paint.getStartPoint();
        Point2D p2 = paint.getEndPoint();
        b.append("x1=\"").append(this.geomDP(p1.getX())).append("\" ");
        b.append("y1=\"").append(this.geomDP(p1.getY())).append("\" ");
        b.append("x2=\"").append(this.geomDP(p2.getX())).append("\" ");
        b.append("y2=\"").append(this.geomDP(p2.getY())).append("\" ");
        if (!paint.getCycleMethod().equals((Object)MultipleGradientPaint.CycleMethod.NO_CYCLE)) {
            String sm = paint.getCycleMethod().equals((Object)MultipleGradientPaint.CycleMethod.REFLECT) ? "reflect" : "repeat";
            b.append("spreadMethod=\"").append(sm).append("\" ");
        }
        b.append("gradientUnits=\"userSpaceOnUse\">");
        for (int i = 0; i < paint.getFractions().length; ++i) {
            Color c = paint.getColors()[i];
            float fraction = paint.getFractions()[i];
            b.append("<stop offset=\"").append(this.geomDP(fraction * 100.0f)).append("%\" stop-color=\"").append(this.rgbColorStr(c)).append("\"");
            if (c.getAlpha() < 255) {
                double alphaPercent = (double)c.getAlpha() / 255.0;
                b.append(" stop-opacity=\"").append(this.transformDP(alphaPercent)).append("\"");
            }
            b.append("/>");
        }
        return b.append("</linearGradient>").toString();
    }

    private String getRadialGradientElement(String id, RadialGradientPaint rgp) {
        StringBuilder b = new StringBuilder("<radialGradient id=\"").append(id).append("\" gradientUnits=\"userSpaceOnUse\" ");
        Point2D center = rgp.getCenterPoint();
        Point2D focus = rgp.getFocusPoint();
        float radius = rgp.getRadius();
        b.append("cx=\"").append(this.geomDP(center.getX())).append("\" ").append("cy=\"").append(this.geomDP(center.getY())).append("\" ").append("r=\"").append(this.geomDP(radius)).append("\" ").append("fx=\"").append(this.geomDP(focus.getX())).append("\" ").append("fy=\"").append(this.geomDP(focus.getY())).append("\">");
        Color[] colors = rgp.getColors();
        float[] fractions = rgp.getFractions();
        for (int i = 0; i < colors.length; ++i) {
            Color c = colors[i];
            float f = fractions[i];
            b.append("<stop offset=\"").append(this.geomDP(f * 100.0f)).append("%\" ").append("stop-color=\"").append(this.rgbColorStr(c)).append("\"");
            if (c.getAlpha() < 255) {
                double alphaPercent = (double)c.getAlpha() / 255.0;
                b.append(" stop-opacity=\"").append(this.transformDP(alphaPercent)).append("\"");
            }
            b.append("/>");
        }
        return b.append("</radialGradient>").toString();
    }

    private String getClipPathRef() {
        if (this.clip == null) {
            return "";
        }
        if (this.clipRef == null) {
            this.clipRef = this.registerClip(this.getClip());
        }
        StringBuilder b = new StringBuilder();
        b.append("clip-path=\"url(#").append(this.clipRef).append(")\"");
        return b.toString();
    }

    private void setRect(int x, int y, int width, int height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double(x, y, width, height);
        } else {
            this.rect.setRect(x, y, width, height);
        }
    }

    private void setRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        } else {
            this.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    private void setArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.arc == null) {
            this.arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2);
        } else {
            this.arc.setArc(x, y, width, height, startAngle, arcAngle, 2);
        }
    }

    private void setOval(int x, int y, int width, int height) {
        if (this.oval == null) {
            this.oval = new Ellipse2D.Double(x, y, width, height);
        } else {
            this.oval.setFrame(x, y, width, height);
        }
    }
}

