/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XmlReader
extends DataImporter {
    private final Element root;
    private final Node[] dsNodes;
    private final Node[] arcNodes;

    XmlReader(String xmlFilePath) throws IOException {
        this.root = Util.Xml.getRootElement(new File(xmlFilePath));
        this.dsNodes = Util.Xml.getChildNodes(this.root, "ds");
        this.arcNodes = Util.Xml.getChildNodes(this.root, "rra");
    }

    @Override
    public String getVersion() {
        return Util.Xml.getChildValue(this.root, "version");
    }

    @Override
    public long getLastUpdateTime() {
        return Util.Xml.getChildValueAsLong(this.root, "lastupdate");
    }

    @Override
    public long getStep() {
        return Util.Xml.getChildValueAsLong(this.root, "step");
    }

    @Override
    public int getDsCount() {
        return this.dsNodes.length;
    }

    @Override
    public int getArcCount() {
        return this.arcNodes.length;
    }

    @Override
    public String getDsName(int dsIndex) {
        return Util.Xml.getChildValue(this.dsNodes[dsIndex], "name");
    }

    @Override
    public DsType getDsType(int dsIndex) {
        String dsTypeName = Util.Xml.getChildValue(this.dsNodes[dsIndex], "type");
        return DsType.valueOf(dsTypeName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public long getHeartbeat(int dsIndex) {
        return Util.Xml.getChildValueAsLong(this.dsNodes[dsIndex], "minimal_heartbeat");
    }

    @Override
    public double getMinValue(int dsIndex) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "min");
    }

    @Override
    public double getMaxValue(int dsIndex) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "max");
    }

    @Override
    public double getLastValue(int dsIndex) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "last_ds");
    }

    @Override
    public double getAccumValue(int dsIndex) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "value");
    }

    @Override
    public long getNanSeconds(int dsIndex) {
        return Util.Xml.getChildValueAsLong(this.dsNodes[dsIndex], "unknown_sec");
    }

    @Override
    public ConsolFun getConsolFun(int arcIndex) {
        return ConsolFun.valueOf(Util.Xml.getChildValue(this.arcNodes[arcIndex], "cf"));
    }

    @Override
    public double getXff(int arcIndex) {
        Node arc = this.arcNodes[arcIndex];
        Node[] params = Util.Xml.getChildNodes(arc, "params");
        if (params.length == 0) {
            return Util.Xml.getChildValueAsDouble(arc, "xff");
        }
        return Util.Xml.getChildValueAsDouble(params[0], "xff");
    }

    @Override
    public int getSteps(int arcIndex) {
        return Util.Xml.getChildValueAsInt(this.arcNodes[arcIndex], "pdp_per_row");
    }

    @Override
    public double getStateAccumValue(int arcIndex, int dsIndex) {
        Node cdpNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "cdp_prep");
        Node[] dsNodes = Util.Xml.getChildNodes(cdpNode, "ds");
        return Util.Xml.getChildValueAsDouble(dsNodes[dsIndex], "value");
    }

    @Override
    public int getStateNanSteps(int arcIndex, int dsIndex) {
        Node cdpNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "cdp_prep");
        Node[] dsNodes = Util.Xml.getChildNodes(cdpNode, "ds");
        return Util.Xml.getChildValueAsInt(dsNodes[dsIndex], "unknown_datapoints");
    }

    @Override
    public int getRows(int arcIndex) {
        Node dbNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "database");
        Node[] rows = Util.Xml.getChildNodes(dbNode, "row");
        return rows.length;
    }

    @Override
    public double[] getValues(int arcIndex, int dsIndex) {
        Node dbNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "database");
        Node[] rows = Util.Xml.getChildNodes(dbNode, "row");
        double[] values = new double[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            Node[] vNodes = Util.Xml.getChildNodes(rows[i], "v");
            Node vNode = vNodes[dsIndex];
            values[i] = Util.parseDouble(vNode.getFirstChild().getNodeValue().trim());
        }
        return values;
    }
}

