/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.rrd4j.graph.PathIterator;
import org.rrd4j.graph.RrdGraphDef;

public abstract class ImageWorker {
    private static final String DUMMY_TEXT = "Dummy";
    private static final int IMG_BUFFER_CAPACITY = 40960;
    private Graphics2D g2d;

    protected void setG2d(Graphics2D g2d) {
        if (g2d != null) {
            this.dispose();
        }
        this.g2d = g2d;
    }

    abstract void resize(int var1, int var2);

    void clip(int x, int y, int width, int height) {
        this.g2d.setClip(x, y, width, height);
    }

    void transform(int x, int y, double angle) {
        this.g2d.translate(x, y);
        this.g2d.rotate(angle);
    }

    void reset() {
        this.reset(this.g2d);
    }

    protected abstract void reset(Graphics2D var1);

    void fillRect(int x, int y, int width, int height, Paint paint) {
        this.g2d.setPaint(paint);
        this.g2d.fillRect(x, y, width, height);
    }

    void fillPolygon(double[] x, double yBottom, double[] yTop, Paint paint) {
        this.g2d.setPaint(paint);
        PathIterator path = new PathIterator(yTop);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int n = end - start;
            int[] xDev = new int[n + 2];
            int[] yDev = new int[n + 2];
            int c = 0;
            for (int i = start; i < end; ++i) {
                int cx = (int)x[i];
                int cy = (int)yTop[i];
                if (c != 0 && cx == xDev[c - 1] && cy == yDev[c - 1]) continue;
                if (c >= 2 && cy == yDev[c - 1] && cy == yDev[c - 2]) {
                    xDev[c - 1] = cx;
                    continue;
                }
                if (c >= 2 && cx == xDev[c - 1] && cx == xDev[c - 2]) {
                    yDev[c - 1] = cy;
                    continue;
                }
                xDev[c] = cx;
                yDev[c++] = cy;
            }
            xDev[c] = xDev[c - 1];
            xDev[c + 1] = xDev[0];
            int n2 = (int)yBottom;
            yDev[c + 1] = n2;
            yDev[c] = n2;
            this.g2d.fillPolygon(xDev, yDev, c + 2);
            this.g2d.drawPolygon(xDev, yDev, c + 2);
            pos = path.getNextPath();
        }
    }

    void fillPolygon(double[] x, double[] yBottom, double[] yTop, Paint paint) {
        this.g2d.setPaint(paint);
        PathIterator path = new PathIterator(yTop);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int cy;
            int cx;
            int i;
            int start = pos[0];
            int end = pos[1];
            int n = end - start;
            int[] xDev = new int[n * 2];
            int[] yDev = new int[n * 2];
            int c = 0;
            for (i = start; i < end; ++i) {
                cx = (int)x[i];
                cy = (int)yTop[i];
                if (c != 0 && cx == xDev[c - 1] && cy == yDev[c - 1]) continue;
                if (c >= 2 && cy == yDev[c - 1] && cy == yDev[c - 2]) {
                    xDev[c - 1] = cx;
                    continue;
                }
                if (c >= 2 && cx == xDev[c - 1] && cx == xDev[c - 2]) {
                    yDev[c - 1] = cy;
                    continue;
                }
                xDev[c] = cx;
                yDev[c++] = cy;
            }
            for (i = end - 1; i >= start; --i) {
                cx = (int)x[i];
                cy = (int)yBottom[i];
                if (c != 0 && cx == xDev[c - 1] && cy == yDev[c - 1]) continue;
                if (c >= 2 && cy == yDev[c - 1] && cy == yDev[c - 2]) {
                    xDev[c - 1] = cx;
                    continue;
                }
                if (c >= 2 && cx == xDev[c - 1] && cx == xDev[c - 2]) {
                    yDev[c - 1] = cy;
                    continue;
                }
                xDev[c] = cx;
                yDev[c++] = cy;
            }
            this.g2d.fillPolygon(xDev, yDev, c);
            pos = path.getNextPath();
        }
    }

    void drawLine(int x1, int y1, int x2, int y2, Paint paint, Stroke stroke) {
        this.g2d.setStroke(stroke);
        this.g2d.setPaint(paint);
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    void drawPolyline(double[] x, double[] y, Paint paint, Stroke stroke) {
        this.g2d.setPaint(paint);
        this.g2d.setStroke(stroke);
        PathIterator path = new PathIterator(y);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int[] xDev = new int[end - start];
            int[] yDev = new int[end - start];
            int c = 0;
            for (int i = start; i < end; ++i) {
                int cx = (int)x[i];
                int cy = (int)y[i];
                if (c != 0 && cx == xDev[c - 1] && cy == yDev[c - 1]) continue;
                if (c >= 2 && cy == yDev[c - 1] && cy == yDev[c - 2]) {
                    xDev[c - 1] = cx;
                    continue;
                }
                if (c >= 2 && cx == xDev[c - 1] && cx == xDev[c - 2]) {
                    yDev[c - 1] = cy;
                    continue;
                }
                xDev[c] = cx;
                yDev[c++] = cy;
            }
            this.g2d.drawPolyline(xDev, yDev, c);
            pos = path.getNextPath();
        }
    }

    void drawString(String text, int x, int y, Font font, Paint paint) {
        this.g2d.setFont(font);
        this.g2d.setPaint(paint);
        this.g2d.drawString(text, x, y);
    }

    double getFontAscent(Font font) {
        LineMetrics lm = font.getLineMetrics(DUMMY_TEXT, this.g2d.getFontRenderContext());
        return lm.getAscent();
    }

    double getFontHeight(Font font) {
        LineMetrics lm = font.getLineMetrics(DUMMY_TEXT, this.g2d.getFontRenderContext());
        return lm.getAscent() + lm.getDescent();
    }

    double getStringWidth(String text, Font font) {
        return font.getStringBounds(text, 0, text.length(), this.g2d.getFontRenderContext()).getBounds().getWidth();
    }

    void setAntiAliasing(boolean enable) {
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, enable ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    void setTextAntiAliasing(boolean enable) {
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, enable ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    void loadImage(RrdGraphDef.ImageSource imageSource, int x, int y, int w, int h) throws IOException {
        BufferedImage wpImage = imageSource.apply(w, h).getSubimage(0, 0, w, h);
        this.g2d.drawImage(wpImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    void dispose() {
        if (this.g2d != null) {
            this.g2d.dispose();
        }
    }

    void makeImage(Path path) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.makeImage(os);
        }
    }

    abstract void makeImage(OutputStream var1) throws IOException;

    void saveImage(String path) throws IOException {
        this.makeImage(Paths.get(path, new String[0]));
    }

    byte[] getImageBytes() throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream(40960);){
            this.makeImage(stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }
}

