/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jfree.svg.SVGGraphics2D;
import org.rrd4j.graph.ImageWorker;

public class SVGImageWorker
extends ImageWorker {
    private SVGGraphics2D g2d;
    private int imgWidth;
    private int imgHeight;

    public SVGImageWorker(int width, int height) {
        this.initGraphics(width, height);
    }

    private void initGraphics(int width, int height) {
        this.imgWidth = width;
        this.imgHeight = height;
        this.g2d = new SVGGraphics2D(this.imgWidth, this.imgHeight);
        this.setG2d(this.g2d);
    }

    @Override
    void resize(int width, int height) {
        if (width != this.imgWidth || height != this.imgHeight) {
            this.initGraphics(width, height);
        }
    }

    @Override
    protected void reset(Graphics2D g2d) {
        g2d.setClip(0, 0, this.imgWidth, this.imgHeight);
    }

    @Override
    void makeImage(OutputStream os) throws IOException {
        byte[] svgBytes = this.g2d.getSVGElement().getBytes(StandardCharsets.UTF_8);
        os.write(svgBytes);
    }

    @Override
    void drawString(String text, int x, int y, Font font, Paint paint) {
        super.drawString(text.trim(), x, y, font, paint);
    }

    @Override
    double getStringWidth(String text, Font font) {
        return super.getStringWidth(text.trim(), font);
    }
}

