/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import org.rrd4j.core.Util;
import org.rrd4j.graph.Axis;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphGenerator;

class ValueAxisMrtg
extends Axis {
    private final ImageParameters im;
    private final ImageWorker worker;
    private final RrdGraphDef gdef;

    ValueAxisMrtg(RrdGraph rrdGraph, ImageWorker worker) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = worker;
    }

    ValueAxisMrtg(RrdGraphGenerator generator) {
        this.im = generator.im;
        this.gdef = generator.gdef;
        this.worker = generator.worker;
    }

    @Override
    boolean draw() {
        Font font = this.gdef.getFont(FONTTAG_AXIS);
        Paint mGridColor = this.gdef.getColor(ElementsNames.mgrid);
        Paint fontColor = this.gdef.getColor(ElementsNames.font);
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        if (Double.isNaN((this.im.maxval - this.im.minval) / this.im.magfact)) {
            return false;
        }
        int xLeft = this.im.xorigin;
        int xRight = this.im.xorigin + this.im.xsize;
        String labfmt = this.im.scaledstep / this.im.magfact * (double)Math.max(Math.abs(this.im.quadrant), Math.abs(4 - this.im.quadrant)) <= 1.0 ? "%5.2f" : Util.sprintf(this.gdef.locale, "%%4.%df", 1 - (this.im.scaledstep / this.im.magfact > 10.0 || Math.ceil(this.im.scaledstep / this.im.magfact) == this.im.scaledstep / this.im.magfact ? 1 : 0));
        if (this.im.symbol != ' ' || this.gdef.unit != null) {
            labfmt = labfmt + " ";
        }
        if (this.im.symbol != ' ') {
            labfmt = labfmt + Character.toString(this.im.symbol);
        }
        if (this.gdef.unit != null) {
            labfmt = labfmt + this.gdef.unit;
        }
        for (int i = 0; i <= 4; ++i) {
            int y = this.im.yorigin - this.im.ysize * i / 4;
            if (y < this.im.yorigin - this.im.ysize || y > this.im.yorigin) continue;
            String graph_label = Util.sprintf(this.gdef.locale, labfmt, this.im.scaledstep / this.im.magfact * (double)(i - this.im.quadrant));
            int length = (int)this.worker.getStringWidth(graph_label, font);
            this.worker.drawString(graph_label, xLeft - length - 8, y + labelOffset, font, fontColor);
            if (this.gdef.drawTicks()) {
                this.worker.drawLine(xLeft - 2, y, xLeft + 2, y, mGridColor, this.gdef.tickStroke);
                this.worker.drawLine(xRight - 2, y, xRight + 2, y, mGridColor, this.gdef.tickStroke);
            }
            this.worker.drawLine(xLeft, y, xRight, y, mGridColor, this.gdef.gridStroke);
        }
        return true;
    }
}

